from pydantic import BaseModel
from sqlalchemy import Column, Integer, ForeignKey, String
from sqlalchemy.orm import relationship

from ..base import Base


class ThreadCallstack(Base):
    __tablename__ = 'thread_callstack'
    id = Column(Integer, primary_key=True, index=True)
    callstack_index = Column(Integer)
    count = Column(Integer)
    type = Column(String)
    thread_trace = Column(String)

    region_thread_id = Column(Integer, ForeignKey('region_thread.id'))
    region_thread = relationship('RegionThread', back_populates='thread_callstack')


class ThreadCallstackInDB(BaseModel):
    id: int
    callstack_index: int
    count: int
    type: str

    thread_trace: str

    class Config:
        from_attributes = True


class ThreadCallstackCreate(BaseModel):
    callstack_index: int
    count: int
    type: str

    thread_trace: str

    class Config:
        from_attributes = True
