/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogSingleCommitAction<Repo extends Repository>
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (selection == null) {
            return;
        }
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)selection.getCommits());
        assert (commit != null);
        Repo repository = this.getRepositoryForRoot(project, commit.getRoot());
        assert (repository != null);
        this.actionPerformed(repository, commit.getHash());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (project == null || selection == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = selection.getCommits();
        if (commits.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)commits);
        assert (commit != null);
        Repo repository = this.getRepositoryForRoot(project, commit.getRoot());
        if (repository == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(this.isVisible(project, repository, commit.getHash()));
        e.getPresentation().setEnabled(commits.size() == 1 && this.isEnabled(repository, commit.getHash()));
    }

    protected abstract void actionPerformed(@NotNull Repo var1, @NotNull Hash var2);

    protected boolean isEnabled(@NotNull Repo repository, @NotNull Hash commit) {
        if (repository == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(3);
        }
        if (commit == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected boolean isVisible(@NotNull Project project, @NotNull Repo repository, @NotNull Hash hash) {
        if (project == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(5);
        }
        if (repository == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(6);
        }
        if (hash == null) {
            VcsLogSingleCommitAction.$$$reportNull$$$0(7);
        }
        return !this.getRepositoryManager(project).isExternal(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/VcsLogSingleCommitAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/VcsLogSingleCommitAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

