/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\f"}, d2={"evaluatedInPlace", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getEvaluatedInPlace", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "nearestNonInPlaceGraph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "requiresInitialization", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isForInitialization", "checkers"})
public final class FirPropertyInitializationAnalyzerKt {
    public static final boolean getEvaluatedInPlace(@NotNull FirDeclaration $this$evaluatedInPlace) {
        Intrinsics.checkNotNullParameter((Object)$this$evaluatedInPlace, (String)"<this>");
        return FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace($this$evaluatedInPlace.getSymbol());
    }

    public static final boolean getEvaluatedInPlace(@NotNull FirBasedSymbol<?> $this$evaluatedInPlace) {
        Intrinsics.checkNotNullParameter($this$evaluatedInPlace, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$evaluatedInPlace;
        return firBasedSymbol instanceof FirAnonymousFunctionSymbol ? EventOccurrencesRangeKt.isInPlace((EventOccurrencesRange)((FirAnonymousFunctionSymbol)$this$evaluatedInPlace).getInvocationKind()) : (firBasedSymbol instanceof FirAnonymousObjectSymbol ? ((FirAnonymousObjectSymbol)$this$evaluatedInPlace).getClassKind() != ClassKind.ENUM_ENTRY : (firBasedSymbol instanceof FirConstructorSymbol ? true : !(firBasedSymbol instanceof FirFunctionSymbol) && !(firBasedSymbol instanceof FirClassSymbol)));
    }

    @NotNull
    public static final ControlFlowGraph nearestNonInPlaceGraph(@NotNull ControlFlowGraph $this$nearestNonInPlaceGraph) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$nearestNonInPlaceGraph, (String)"<this>");
        FirDeclaration firDeclaration = $this$nearestNonInPlaceGraph.getDeclaration();
        boolean bl = firDeclaration != null ? FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(firDeclaration) : false;
        if (bl) {
            object = (CFGNode)CollectionsKt.firstOrNull($this$nearestNonInPlaceGraph.getEnterNode().getPreviousNodes());
            if (object == null || (object = ((CFGNode)object).getOwner()) == null || (object = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph((ControlFlowGraph)object)) == null) {
                object = $this$nearestNonInPlaceGraph;
            }
        } else {
            object = $this$nearestNonInPlaceGraph;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean requiresInitialization(@NotNull FirPropertySymbol $this$requiresInitialization, boolean isForInitialization) {
        Intrinsics.checkNotNullParameter((Object)$this$requiresInitialization, (String)"<this>");
        if ($this$requiresInitialization instanceof FirSyntheticPropertySymbol) {
            return false;
        }
        if (isForInitialization) {
            if ($this$requiresInitialization.getHasDelegate()) return true;
            if (!DeclarationAttributesKt.getHasBackingField($this$requiresInitialization)) return false;
            return true;
        }
        if (!DeclarationAttributesKt.getHasBackingField($this$requiresInitialization)) return false;
        if ($this$requiresInitialization.getHasInitializer()) return false;
        FirBackingFieldSymbol firBackingFieldSymbol = $this$requiresInitialization.getBackingFieldSymbol();
        if ((firBackingFieldSymbol != null ? firBackingFieldSymbol.getResolvedInitializer() : null) != null) return false;
        if (Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter((FirProperty)$this$requiresInitialization.getFir()), (Object)true)) return false;
        return true;
    }
}

