/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinValue;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0004R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"checkSinceKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinAccessibility;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinAccessibility;", "getOwnSinceKotlinVersion", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "loadWasExperimentalMarkerClasses", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSinceKotlinHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSinceKotlinHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinHelpersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class FirSinceKotlinHelpersKt {
    @NotNull
    public static final FirSinceKotlinAccessibility checkSinceKotlinVersionAccessibility(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$checkSinceKotlinVersionAccessibility) {
        FirSinceKotlinValue value;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$checkSinceKotlinVersionAccessibility, (String)"<this>");
        FirSinceKotlinValue firSinceKotlinValue = value = FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion($this$checkSinceKotlinVersionAccessibility, context2.getSession());
        ApiVersion version = firSinceKotlinValue != null ? firSinceKotlinValue.getApiVersion() : null;
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (version == null || version.compareTo(languageVersionSettings.getApiVersion()) <= 0) {
            return FirSinceKotlinAccessibility.Accessible.INSTANCE;
        }
        List<FirRegularClassSymbol> wasExperimentalFqNames = value.getWasExperimentalMarkerClasses();
        if (!((Collection)wasExperimentalFqNames).isEmpty()) {
            return new FirSinceKotlinAccessibility.NotAccessibleButWasExperimental(version, wasExperimentalFqNames);
        }
        return new FirSinceKotlinAccessibility.NotAccessible(version);
    }

    private static final FirSinceKotlinValue getOwnSinceKotlinVersion(FirBasedSymbol<?> $this$getOwnSinceKotlinVersion, FirSession session2) {
        ApiVersion apiVersion;
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationWithResolvedArgumentsByClassId($this$getOwnSinceKotlinVersion, StandardClassIds.Annotations.INSTANCE.getSinceKotlin(), session2);
        FirExpression sinceKotlinSingleArgument = firAnnotation != null ? FirAnnotationUtilsKt.findArgumentByName$default(firAnnotation, StandardClassIds.Annotations.ParameterNames.INSTANCE.getSinceKotlinVersion(), false, 2, null) : null;
        FirLiteralExpression firLiteralExpression = sinceKotlinSingleArgument instanceof FirLiteralExpression ? (FirLiteralExpression)sinceKotlinSingleArgument : null;
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String string = object instanceof String ? (String)object : null;
        if (string != null) {
            object = string;
            ApiVersion.Companion companion = ApiVersion.Companion;
            Object p0 = object;
            boolean bl = false;
            apiVersion = companion.parse((String)p0);
        } else {
            apiVersion = null;
        }
        ApiVersion apiVersion2 = apiVersion;
        return apiVersion2 != null ? new FirSinceKotlinValue(apiVersion2, FirSinceKotlinHelpersKt.loadWasExperimentalMarkerClasses($this$getOwnSinceKotlinVersion, session2)) : null;
    }

    private static final List<FirRegularClassSymbol> loadWasExperimentalMarkerClasses(FirBasedSymbol<?> $this$loadWasExperimentalMarkerClasses, FirSession session2) {
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationWithResolvedArgumentsByClassId($this$loadWasExperimentalMarkerClasses, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID(), session2);
        if (firAnnotation == null) {
            return CollectionsKt.emptyList();
        }
        FirAnnotation wasExperimental = firAnnotation;
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(wasExperimental, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_ANNOTATION_CLASS(), false, 2, null);
        if (firExpression == null) {
            return CollectionsKt.emptyList();
        }
        FirExpression annotationClasses = firExpression;
        return FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses, session2);
    }
}

