/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.experimental;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/experimental/RedundantInterpolationPrefixCheckerLiteral;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLiteralExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;)V", "checkers"})
public final class RedundantInterpolationPrefixCheckerLiteral
extends FirExpressionChecker<FirLiteralExpression> {
    @NotNull
    public static final RedundantInterpolationPrefixCheckerLiteral INSTANCE = new RedundantInterpolationPrefixCheckerLiteral();

    private RedundantInterpolationPrefixCheckerLiteral() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirLiteralExpression expression) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String prefix2 = expression.getPrefix();
        if (Intrinsics.areEqual((Object)expression.getKind(), (Object)ConstantValueKind.String.INSTANCE) && !((charSequence = (CharSequence)prefix2) == null || charSequence.length() == 0)) {
            CharSequence charSequence2 = KtSourceElementKt.getText((KtSourceElement)expression.getSource());
            if (charSequence2 == null || (charSequence2 = StringsKt.drop((CharSequence)charSequence2, (int)prefix2.length())) == null) {
                return;
            }
            CharSequence value = charSequence2;
            if (!new Regex("[^\\\\]\\$(\\w|\\{|`[^`])").containsMatchIn(value)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getREDUNDANT_INTERPOLATION_PREFIX(), null, (int)8, null);
            }
        }
    }
}

