/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeCapturedTypeConstructor;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J-\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lkotlin/Comparator;", "<init>", "()V", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)I", "compare", "a", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "b", "", "([Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)I", "compareNullability", "tree"})
public final class ConeKotlinTypeComparator
implements Comparator<ConeKotlinType> {
    @NotNull
    public static final ConeKotlinTypeComparator INSTANCE = new ConeKotlinTypeComparator();

    private ConeKotlinTypeComparator() {
    }

    private final int getPriority(ConeKotlinType $this$priority) {
        ConeKotlinType coneKotlinType = $this$priority;
        return coneKotlinType instanceof ConeErrorType ? 9 : (coneKotlinType instanceof ConeLookupTagBasedType ? 8 : (coneKotlinType instanceof ConeFlexibleType ? 7 : (coneKotlinType instanceof ConeCapturedType ? 6 : (coneKotlinType instanceof ConeDefinitelyNotNullType ? 5 : (coneKotlinType instanceof ConeIntersectionType ? 4 : (coneKotlinType instanceof ConeStubType ? 3 : (coneKotlinType instanceof ConeIntegerLiteralConstantType ? 2 : (coneKotlinType instanceof ConeIntegerConstantOperatorType ? 1 : 0))))))));
    }

    @Override
    private final int compare(ConeTypeProjection a, ConeTypeProjection b) {
        boolean bl;
        int kindDiff = a.getKind().ordinal() - b.getKind().ordinal();
        if (kindDiff != 0) {
            return kindDiff;
        }
        ConeTypeProjection coneTypeProjection = a;
        if (coneTypeProjection instanceof ConeStarProjection) {
            return 0;
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            if (!(b instanceof ConeKotlinTypeProjectionIn)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$32 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$32 = "ordinal is inconsistent: " + a + " v.s. " + b;
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$32.toString());
            }
            return this.compare(((ConeKotlinTypeProjectionIn)a).getType(), ((ConeKotlinTypeProjectionIn)b).getType());
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            if (!(b instanceof ConeKotlinTypeProjectionOut)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$42 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$42 = "ordinal is inconsistent: " + a + " v.s. " + b;
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$42.toString());
            }
            return this.compare(((ConeKotlinTypeProjectionOut)a).getType(), ((ConeKotlinTypeProjectionOut)b).getType());
        }
        boolean bl2 = bl = a instanceof ConeKotlinType && b instanceof ConeKotlinType;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expect INVARIANT: " + a + " v.s. " + b;
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)a, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        ConeKotlinType coneKotlinType = (ConeKotlinType)a;
        Intrinsics.checkNotNull((Object)b, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        return this.compare(coneKotlinType, (ConeKotlinType)b);
    }

    @Override
    private final int compare(ConeTypeProjection[] a, ConeTypeProjection[] b) {
        int sizeDiff = a.length - b.length;
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        for (Pair pair : ArraysKt.zip((Object[])a, (Object[])b)) {
            ConeTypeProjection bTypeProjection;
            ConeTypeProjection aTypeProjection = (ConeTypeProjection)pair.component1();
            int typeProjectionDiff = this.compare(aTypeProjection, bTypeProjection = (ConeTypeProjection)pair.component2());
            if (typeProjectionDiff == 0) continue;
            return typeProjectionDiff;
        }
        return 0;
    }

    private final int compareNullability(ConeKotlinType a, ConeKotlinType b) {
        return Boolean.compare(ConeTypeUtilsKt.isMarkedNullable(b), ConeTypeUtilsKt.isMarkedNullable(a));
    }

    @Override
    public int compare(@NotNull ConeKotlinType a, @NotNull ConeKotlinType b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int priorityDiff = this.getPriority(a) - this.getPriority(b);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        ConeKotlinType coneKotlinType = a;
        if (coneKotlinType instanceof ConeErrorType) {
            if (!(b instanceof ConeErrorType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$122 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$122 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$122.toString());
            }
            return ((ConeErrorType)a).hashCode() - ((ConeErrorType)b).hashCode();
        }
        if (coneKotlinType instanceof ConeLookupTagBasedType) {
            if (!(b instanceof ConeLookupTagBasedType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$132 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$132 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$132.toString());
            }
            int nameDiff = ((ConeLookupTagBasedType)a).getLookupTag().getName().compareTo(((ConeLookupTagBasedType)b).getLookupTag().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            int nullabilityDiff = this.compareNullability(a, b);
            if (nullabilityDiff != 0) {
                return nullabilityDiff;
            }
            return this.compare(a.getTypeArguments(), b.getTypeArguments());
        }
        if (coneKotlinType instanceof ConeFlexibleType) {
            if (!(b instanceof ConeFlexibleType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$142 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$142 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$142.toString());
            }
            int lowerBoundDiff = this.compare(((ConeFlexibleType)a).getLowerBound(), ((ConeFlexibleType)b).getLowerBound());
            if (lowerBoundDiff != 0) {
                return lowerBoundDiff;
            }
            return this.compare(((ConeFlexibleType)a).getUpperBound(), ((ConeFlexibleType)b).getUpperBound());
        }
        if (coneKotlinType instanceof ConeCapturedType) {
            int nullabilityDiff;
            ConeCapturedTypeConstructor bConstructor;
            int bHasLowerType;
            if (!(b instanceof ConeCapturedType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$152 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$152 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$152.toString());
            }
            ConeCapturedTypeConstructor aConstructor = ((ConeCapturedType)a).getConstructor();
            int aHasLowerType = aConstructor.getLowerType() != null ? 1 : 0;
            int hasLowerTypeDiff = aHasLowerType - (bHasLowerType = (bConstructor = ((ConeCapturedType)b).getConstructor()).getLowerType() != null ? 1 : 0);
            if (hasLowerTypeDiff != 0) {
                return hasLowerTypeDiff;
            }
            if (aConstructor.getLowerType() != null) {
                if (!(bConstructor.getLowerType() != null)) {
                    throw new IllegalStateException("Check failed.");
                }
                ConeKotlinType coneKotlinType2 = aConstructor.getLowerType();
                Intrinsics.checkNotNull((Object)coneKotlinType2);
                ConeKotlinType coneKotlinType3 = bConstructor.getLowerType();
                Intrinsics.checkNotNull((Object)coneKotlinType3);
                int lowerTypeDiff = this.compare(coneKotlinType2, coneKotlinType3);
                if (lowerTypeDiff != 0) {
                    return lowerTypeDiff;
                }
            }
            if ((nullabilityDiff = this.compareNullability(a, b)) != 0) {
                return nullabilityDiff;
            }
            return aConstructor.hashCode() - bConstructor.hashCode();
        }
        if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            if (!(b instanceof ConeDefinitelyNotNullType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$162 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$162 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$162.toString());
            }
            return this.compare(((ConeDefinitelyNotNullType)a).getOriginal(), ((ConeDefinitelyNotNullType)b).getOriginal());
        }
        if (coneKotlinType instanceof ConeIntersectionType) {
            if (!(b instanceof ConeIntersectionType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$172 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$172 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$172.toString());
            }
            int sizeDiff = ((ConeIntersectionType)a).getIntersectedTypes().size() - ((ConeIntersectionType)b).getIntersectedTypes().size();
            if (sizeDiff != 0) {
                return sizeDiff;
            }
            return ((ConeIntersectionType)a).hashCode() - ((ConeIntersectionType)b).hashCode();
        }
        if (coneKotlinType instanceof ConeStubType) {
            if (!(b instanceof ConeStubType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$182 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$182 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$182.toString());
            }
            int nameDiff = ((ConeStubType)a).getConstructor().getVariable().getTypeConstructor().getName().compareTo(((ConeStubType)b).getConstructor().getVariable().getTypeConstructor().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            return this.compareNullability(a, b);
        }
        if (coneKotlinType instanceof ConeIntegerLiteralConstantType) {
            if (!(b instanceof ConeIntegerLiteralConstantType)) {
                boolean bl = false;
                String string = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b);
                throw new IllegalArgumentException(string.toString());
            }
            long valueDiff = ((ConeIntegerLiteralConstantType)a).getValue() - ((ConeIntegerLiteralConstantType)b).getValue();
            if (valueDiff != 0L) {
                return (int)valueDiff;
            }
            int nullabilityDiff = this.compareNullability(a, b);
            if (nullabilityDiff != 0) {
                return nullabilityDiff;
            }
            return ((ConeIntegerLiteralConstantType)a).hashCode() - ((ConeIntegerLiteralConstantType)b).hashCode();
        }
        if (coneKotlinType instanceof ConeIntegerConstantOperatorType) {
            return this.compareNullability(a, b);
        }
        throw new IllegalStateException(("Unsupported type comparison: " + ConeTypeUtilsKt.renderForDebugging(a) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b)).toString());
    }
}

