/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.base.analysis.LibraryDependencyCandidatesAndSdkInfos;
import org.jetbrains.kotlin.idea.base.analysis.LibraryDependencyCandidatesAndSdkInfosBuilder;
import org.jetbrains.kotlin.idea.base.analysis.libraries.LibraryDependencyCandidate;
import org.jetbrains.kotlin.idea.base.projectStructure.IdeBuiltInsLoadingState;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinStdlibCache;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinStdlibCacheKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryUsageIndex;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfoKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfoKt;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.ModuleEntityChangeListener;
import org.jetbrains.kotlin.idea.base.util.caching.SdkEntityChangeListener;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.WorkspaceEntityChangeListenerKt;
import org.jetbrains.kotlin.idea.caches.project.DefaultLibraryDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.LibraryDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.LibraryDependenciesFilterKt;
import org.jetbrains.kotlin.idea.caches.project.SharedNativeLibraryToNativeInteropFallbackDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.StrictEqualityForPlatformSpecificCandidatesFilter;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptDependencyAware;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@K1ModeProjectStructureApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache;", "moduleDependenciesCache", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache;", "getLibraryDependencies", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache$LibraryDependencies;", "library", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "dispose", "", "getCacheContentForTests", "", "computeLibrariesAndSdksUsedWith", "libraryInfo", "stdlibJvmDependencies", "", "allDependencyCandidates", "", "Lorg/jetbrains/kotlin/idea/base/analysis/libraries/LibraryDependencyCandidate;", "computeLibrariesAndSdksUsedWithNoFilter", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependencyCandidatesAndSdkInfos;", "filterForBuiltins", "", "dependencyLibraries", "Companion", "LibraryDependenciesInnerCache", "ModuleDependenciesCache", "intellij.kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,566:1\n1374#2:567\n1460#2,5:568\n1374#2:573\n1460#2,2:574\n774#2:576\n865#2,2:577\n1462#2,3:579\n865#2:585\n1761#2,3:586\n866#2:589\n30#3,2:582\n1#4:584\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl\n*L\n142#1:567\n142#1:568,5\n165#1:573\n165#1:574,2\n166#1:576\n166#1:577,2\n165#1:579,3\n211#1:585\n212#1:586,3\n211#1:589\n174#1:582,2\n*E\n"})
public final class LibraryDependenciesCacheImpl
implements LibraryDependenciesCache,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LibraryDependenciesInnerCache cache;
    @NotNull
    private final ModuleDependenciesCache moduleDependenciesCache;

    public LibraryDependenciesCacheImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = new LibraryDependenciesInnerCache();
        this.moduleDependenciesCache = new ModuleDependenciesCache();
        Disposer.register((Disposable)this, (Disposable)this.cache);
        Disposer.register((Disposable)this, (Disposable)this.moduleDependenciesCache);
    }

    @Override
    @NotNull
    public LibraryDependenciesCache.LibraryDependencies getLibraryDependencies(@NotNull LibraryInfo library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return (LibraryDependenciesCache.LibraryDependencies)this.cache.get(library);
    }

    public void dispose() {
    }

    @TestOnly
    @NotNull
    public final Map<LibraryInfo, LibraryDependenciesCache.LibraryDependencies> getCacheContentForTests() {
        return MapsKt.toMap(this.cache.getCacheContentForTests());
    }

    /*
     * WARNING - void declaration
     */
    private final LibraryDependenciesCache.LibraryDependencies computeLibrariesAndSdksUsedWith(LibraryInfo libraryInfo) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        LibraryDependencyCandidatesAndSdkInfos libraryDependencyCandidatesAndSdkInfos = this.computeLibrariesAndSdksUsedWithNoFilter(libraryInfo);
        List<LibraryInfo> additionalDependenciesForLibrarySources = null;
        LibraryDependenciesFilter libraryDependenciesFilter = null;
        if (BuildSystemTypeKt.isMavenized(this.project)) {
            libraryDependenciesFilter = StrictEqualityForPlatformSpecificCandidatesFilter.INSTANCE;
            additionalDependenciesForLibrarySources = this.stdlibJvmDependencies(libraryInfo, libraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
        } else {
            libraryDependenciesFilter = LibraryDependenciesFilterKt.union(DefaultLibraryDependenciesFilter.INSTANCE, SharedNativeLibraryToNativeInteropFallbackDependenciesFilter.INSTANCE);
            additionalDependenciesForLibrarySources = CollectionsKt.emptyList();
        }
        Iterable iterable = libraryDependenciesFilter.invoke(libraryInfo.getPlatform(), libraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
        boolean $i$f$flatMap = false;
        void var8_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LibraryDependencyCandidate it = (LibraryDependencyCandidate)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLibraries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List libraries = (List)destination$iv$iv;
        return new LibraryDependenciesCache.LibraryDependencies(libraryInfo, libraries, CollectionsKt.toList((Iterable)libraryDependencyCandidatesAndSdkInfos.getSdkInfos()), additionalDependenciesForLibrarySources);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryInfo> stdlibJvmDependencies(LibraryInfo libraryInfo, Collection<? extends LibraryDependencyCandidate> allDependencyCandidates) {
        void $this$flatMapTo$iv$iv;
        if (!JvmPlatformKt.isJvm((TargetPlatform)libraryInfo.getPlatform())) {
            return CollectionsKt.emptyList();
        }
        KotlinStdlibCache stdlibCache = KotlinStdlibCache.Companion.getInstance(libraryInfo.getProject());
        if (!stdlibCache.isStdlib(libraryInfo)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = allDependencyCandidates;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            LibraryDependencyCandidate candidate = (LibraryDependencyCandidate)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = candidate.getLibraries();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                LibraryInfo library = (LibraryInfo)element$iv$iv2;
                boolean bl2 = false;
                if (!stdlibCache.isStdlibDependency(library)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final LibraryDependencyCandidatesAndSdkInfos computeLibrariesAndSdksUsedWithNoFilter(LibraryInfo libraryInfo) {
        Set<LibraryDependencyCandidate> filteredLibraries;
        LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfos;
        block4: {
            Collection collection;
            libraryDependencyCandidatesAndSdkInfos = new LibraryDependencyCandidatesAndSdkInfosBuilder(null, null, 3, null);
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<LibraryUsageIndex> serviceClass$iv = LibraryUsageIndex.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Sequence<Module> modulesLibraryIsUsedIn = ((LibraryUsageIndex)object).getDependentModules(libraryInfo);
            for (Module module : modulesLibraryIsUsedIn) {
                ProgressManager.checkCanceled();
                libraryDependencyCandidatesAndSdkInfos.plusAssign(this.moduleDependenciesCache.get(module));
            }
            filteredLibraries = this.filterForBuiltins(libraryInfo, (Set<LibraryDependencyCandidate>)libraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
            Collection it = collection = libraryDependencyCandidatesAndSdkInfos.getSdkInfos();
            boolean bl = false;
            Collection collection2 = it.isEmpty() ? collection : null;
            if (collection2 == null) break block4;
            Collection $this$computeLibrariesAndSdksUsedWithNoFilter_u24lambda_u241 = collection = collection2;
            boolean bl2 = false;
            ScriptDependencyAware scriptConfigurationManager = ScriptDependencyAware.Companion.getInstance(this.project);
            VirtualFile virtualFile = scriptConfigurationManager.getScriptDependingOn(libraryInfo.getLibraryRoots());
            if (virtualFile != null) {
                VirtualFile script = virtualFile;
                boolean bl3 = false;
                Sdk sdk2 = scriptConfigurationManager.getScriptSdk(script);
                if (sdk2 != null) {
                    Sdk sdk3 = sdk2;
                    boolean bl4 = false;
                    $this$computeLibrariesAndSdksUsedWithNoFilter_u24lambda_u241.add(new SdkInfo(this.project, sdk3));
                }
            }
        }
        return new LibraryDependencyCandidatesAndSdkInfos((Collection<? extends LibraryDependencyCandidate>)filteredLibraries, libraryDependencyCandidatesAndSdkInfos.getSdkInfos());
    }

    /*
     * WARNING - void declaration
     */
    private final Set<LibraryDependencyCandidate> filterForBuiltins(LibraryInfo libraryInfo, Set<LibraryDependencyCandidate> dependencyLibraries) {
        Set set;
        if (Companion.isSpecialKotlinCoreLibrary(libraryInfo, this.project)) {
            void destination$iv;
            void $this$filterTo$iv;
            Iterable iterable = dependencyLibraries;
            Collection collection = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                boolean bl;
                block6: {
                    LibraryDependencyCandidate dep = (LibraryDependencyCandidate)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = dep.getLibraries();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            LibraryInfo it = (LibraryInfo)element$iv2;
                            boolean bl3 = false;
                            if (!KotlinStdlibCacheKt.isCoreKotlinLibrary(it, this.project)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv.add(element$iv);
            }
            set = (Set)destination$iv;
        } else {
            set = dependencyLibraries;
        }
        return set;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache;", "project", "Lcom/intellij/openapi/project/Project;", "isSpecialKotlinCoreLibrary", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "intellij.kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,566:1\n30#2,2:567\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$Companion\n*L\n89#1:567,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryDependenciesCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LibraryDependenciesCache> serviceClass$iv = LibraryDependenciesCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LibraryDependenciesCache)object;
        }

        @ApiStatus.Internal
        public final boolean isSpecialKotlinCoreLibrary(@NotNull LibraryInfo $this$isSpecialKotlinCoreLibrary, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)$this$isSpecialKotlinCoreLibrary, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return !IdeBuiltInsLoadingState.INSTANCE.isFromClassLoader() && KotlinStdlibCacheKt.isCoreKotlinLibrary($this$isSpecialKotlinCoreLibrary, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u0005:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0016H\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache$LibraryDependencies;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl;)V", "subscribe", "", "libraryInfosRemoved", "libraryInfos", "", "calculate", "key", "checkKeyValidity", "checkValueValidity", "value", "rootsChanged", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "getCacheContentForTests", "", "ModelChangeListener", "SdkChangeListener", "intellij.kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,566:1\n1761#2,3:567\n1761#2,3:570\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache\n*L\n234#1:567,3\n256#1:570,3\n*E\n"})
    private final class LibraryDependenciesInnerCache
    extends SynchronizedFineGrainedEntityCache<LibraryInfo, LibraryDependenciesCache.LibraryDependencies>
    implements LibraryInfoListener,
    ModuleRootListener {
        public LibraryDependenciesInnerCache() {
            super(LibraryDependenciesCacheImpl.this.project, false, true);
        }

        @Override
        protected void subscribe() {
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            connection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
            connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new ModelChangeListener());
            connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new SdkChangeListener());
            Topic topic = ModuleRootListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)this);
        }

        @Override
        public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
            Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
            FineGrainedEntityCache.invalidateEntries$default(this, (arg_0, arg_1) -> LibraryDependenciesInnerCache.libraryInfosRemoved$lambda$2(libraryInfos, arg_0, arg_1), null, 2, null);
        }

        @Override
        @NotNull
        public LibraryDependenciesCache.LibraryDependencies calculate(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return LibraryDependenciesCacheImpl.this.computeLibrariesAndSdksUsedWith(key);
        }

        @Override
        protected void checkKeyValidity(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            key.checkValidity();
        }

        @Override
        protected void checkValueValidity(@NotNull LibraryDependenciesCache.LibraryDependencies value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            value.checkValidity();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCausedByWorkspaceModelChangesOnly()) {
                return;
            }
            Set sdks = SdkInfoKt.allSdks$default(this.getProject(), null, 1, null);
            this.invalidateEntries((arg_0, arg_1) -> LibraryDependenciesInnerCache.rootsChanged$lambda$0(sdks, arg_0, arg_1), null);
        }

        @TestOnly
        @NotNull
        public final Map<LibraryInfo, LibraryDependenciesCache.LibraryDependencies> getCacheContentForTests() {
            return this.getCache();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean libraryInfosRemoved$haveOutdatedLibraries(LibraryDependenciesCache.LibraryDependencies $this$libraryInfosRemoved_u24haveOutdatedLibraries, Collection<? extends LibraryInfo> $libraryInfos) {
            LibraryInfo it;
            boolean bl;
            Iterable $this$any$iv = $this$libraryInfosRemoved_u24haveOutdatedLibraries.getLibraries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (LibraryInfo)element$iv;
                    boolean bl2 = false;
                    if (!$libraryInfos.contains(it)) continue;
                    return true;
                }
                bl = false;
            }
            if (bl) return true;
            $this$any$iv = $this$libraryInfosRemoved_u24haveOutdatedLibraries.getSourcesOnlyDependencies();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                Object element$iv;
                if (!iterator2.hasNext()) return false;
                element$iv = iterator2.next();
                it = (LibraryInfo)element$iv;
                boolean bl3 = false;
            } while (!$libraryInfos.contains(it));
            return true;
        }

        private static final boolean libraryInfosRemoved$lambda$2(Collection $libraryInfos, LibraryInfo k, LibraryDependenciesCache.LibraryDependencies v) {
            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return $libraryInfos.contains(k) || LibraryDependenciesInnerCache.libraryInfosRemoved$haveOutdatedLibraries(v, $libraryInfos);
        }

        private static final boolean rootsChanged$lambda$0(Set $sdks, LibraryInfo libraryInfo, LibraryDependenciesCache.LibraryDependencies value) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Iterable $this$any$iv = value.getSdk();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SdkInfo it = (SdkInfo)element$iv;
                        boolean bl2 = false;
                        if (!(!$sdks.contains(it.getSdk()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache$ModelChangeListener;", "Lorg/jetbrains/kotlin/idea/base/util/caching/ModuleEntityChangeListener;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache;)V", "entitiesChanged", "", "outdated", "", "Lcom/intellij/openapi/module/Module;", "intellij.kotlin.base.analysis"})
        public final class ModelChangeListener
        extends ModuleEntityChangeListener {
            public ModelChangeListener() {
                super(LibraryDependenciesInnerCache.this.getProject(), false, 2, null);
            }

            @Override
            protected void entitiesChanged(@NotNull List<? extends Module> outdated2) {
                Intrinsics.checkNotNullParameter(outdated2, (String)"outdated");
                LibraryDependenciesInnerCache.this.invalidate(true);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache$SdkChangeListener;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SdkEntityChangeListener;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache;)V", "entitiesChanged", "", "outdated", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.kotlin.base.analysis"})
        @SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache$SdkChangeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,566:1\n1761#2,3:567\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache$SdkChangeListener\n*L\n271#1:567,3\n*E\n"})
        public final class SdkChangeListener
        extends SdkEntityChangeListener {
            public SdkChangeListener() {
                super(LibraryDependenciesInnerCache.this.getProject(), false, 2, null);
            }

            @Override
            protected void entitiesChanged(@NotNull List<? extends Sdk> outdated2) {
                Intrinsics.checkNotNullParameter(outdated2, (String)"outdated");
                LibraryDependenciesInnerCache.this.invalidateEntries((arg_0, arg_1) -> SdkChangeListener.entitiesChanged$lambda$0(outdated2, arg_0, arg_1), null);
            }

            private static final boolean entitiesChanged$lambda$0(List $outdated, LibraryInfo libraryInfo, LibraryDependenciesCache.LibraryDependencies value) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"<unused var>");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Iterable $this$any$iv = value.getSdk();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SdkInfo it = (SdkInfo)element$iv;
                            boolean bl2 = false;
                            if (!$outdated.contains(it.getSdk())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u00052\u00020\u0006B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0097\u0002JV\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u000fH\u0002J`\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u000fH\u0002JV\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0003H\u0014J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\"H\u0016J&\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)H\u0002J\u0016\u0010*\u001a\u00020\n2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependencyCandidatesAndSdkInfos;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl;)V", "subscribe", "", "get", "key", "internalGet", "tmpResults", "", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependencyCandidatesAndSdkInfosBuilder;", "trace", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "loops", "", "dumpLoopsIfPossible", "newValue", "computeLibrariesAndSdksUsedIn", "module", "calculate", "checkKeyValidity", "checkValueValidity", "value", "rootsChanged", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "beforeChanged", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "collectOutdatedModules", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "outdatedModules", "", "libraryInfosRemoved", "libraryInfos", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "intellij.kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 WorkspaceEntityChangeListener.kt\norg/jetbrains/kotlin/idea/base/util/caching/WorkspaceEntityChangeListenerKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,566:1\n1#2:567\n1869#3,2:568\n1761#3,3:574\n1761#3,3:577\n1761#3,3:580\n111#4:570\n111#4:571\n1321#5,2:572\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache\n*L\n497#1:568,2\n507#1:574,3\n537#1:577,3\n558#1:580,3\n515#1:570\n516#1:571\n549#1:572,2\n*E\n"})
    private final class ModuleDependenciesCache
    extends SynchronizedFineGrainedEntityCache<Module, LibraryDependencyCandidatesAndSdkInfos>
    implements WorkspaceModelChangeListener,
    LibraryInfoListener,
    ModuleRootListener {
        public ModuleDependenciesCache() {
            super(LibraryDependenciesCacheImpl.this.project, false, false, 4, null);
        }

        @Override
        protected void subscribe() {
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)this);
            connection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
            Topic topic = ModuleRootListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)this);
        }

        @Override
        @RequiresReadLock
        @NotNull
        public LibraryDependencyCandidatesAndSdkInfos get(@NotNull Module key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ThreadingAssertions.softAssertReadAccess();
            return this.internalGet(key, new HashMap(), new LinkedHashSet<Module>(), new HashMap());
        }

        private final LibraryDependencyCandidatesAndSdkInfos internalGet(Module key, Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> tmpResults, LinkedHashSet<Module> trace, Map<Module, Set<Module>> loops) {
            LibraryDependencyCandidatesAndSdkInfos existedValue;
            LibraryDependencyCandidatesAndSdkInfos libraryDependencyCandidatesAndSdkInfos;
            this.checkKeyAndDisposeIllegalEntry(key);
            LibraryDependencyCandidatesAndSdkInfos libraryDependencyCandidatesAndSdkInfos2 = (LibraryDependencyCandidatesAndSdkInfos)this.useCache(arg_0 -> ModuleDependenciesCache.internalGet$lambda$0(this, key, arg_0));
            if (libraryDependencyCandidatesAndSdkInfos2 != null) {
                LibraryDependencyCandidatesAndSdkInfos it = libraryDependencyCandidatesAndSdkInfos2;
                boolean bl = false;
                return it;
            }
            ProgressManager.checkCanceled();
            LibraryDependencyCandidatesAndSdkInfos newValue = this.computeLibrariesAndSdksUsedIn(key, tmpResults, trace, loops).build();
            if (FineGrainedEntityCache.Companion.isValidityChecksEnabled()) {
                this.checkValueValidity(newValue);
            }
            if ((libraryDependencyCandidatesAndSdkInfos = (existedValue = !((Collection)trace).isEmpty() ? this.dumpLoopsIfPossible(key, newValue, tmpResults, trace, loops) : (LibraryDependencyCandidatesAndSdkInfos)this.useCache(arg_0 -> ModuleDependenciesCache.internalGet$lambda$2(key, newValue, tmpResults, arg_0)))) == null) {
                libraryDependencyCandidatesAndSdkInfos = newValue;
            }
            return libraryDependencyCandidatesAndSdkInfos;
        }

        private final LibraryDependencyCandidatesAndSdkInfos dumpLoopsIfPossible(Module key, LibraryDependencyCandidatesAndSdkInfos newValue, Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> tmpResults, LinkedHashSet<Module> trace, Map<Module, Set<Module>> loops) {
            Set<Module> set = loops.get(key);
            if (set == null) {
                return null;
            }
            Set<Module> currentLoop = set;
            if (loops.containsKey(CollectionsKt.last((Iterable)trace))) {
                return null;
            }
            return (LibraryDependencyCandidatesAndSdkInfos)this.useCache(arg_0 -> ModuleDependenciesCache.dumpLoopsIfPossible$lambda$0(key, newValue, tmpResults, currentLoop, loops, arg_0));
        }

        private final LibraryDependencyCandidatesAndSdkInfosBuilder computeLibrariesAndSdksUsedIn(Module module, Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> tmpResults, LinkedHashSet<Module> trace, Map<Module, Set<Module>> loops) {
            Module moduleToVisit;
            ProgressManager.checkCanceled();
            if (!trace.add(module)) {
                boolean $i$a$-check-LibraryDependenciesCacheImpl$ModuleDependenciesCache$computeLibrariesAndSdksUsedIn$22 = false;
                String $i$a$-check-LibraryDependenciesCacheImpl$ModuleDependenciesCache$computeLibrariesAndSdksUsedIn$22 = "recursion detected";
                throw new IllegalStateException($i$a$-check-LibraryDependenciesCacheImpl$ModuleDependenciesCache$computeLibrariesAndSdksUsedIn$22.toString());
            }
            LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfos = new LibraryDependencyCandidatesAndSdkInfosBuilder(null, null, 3, null);
            tmpResults.put(module, libraryDependencyCandidatesAndSdkInfos);
            HashSet<Module> modulesToVisit = new HashSet<Module>();
            LibraryInfoCache infoCache = LibraryInfoCache.Companion.getInstance(this.getProject());
            ModuleRootManager.getInstance((Module)module).orderEntries().process((RootPolicy)new RootPolicy<Unit>(modulesToVisit, infoCache, libraryDependencyCandidatesAndSdkInfos, this){
                final /* synthetic */ HashSet<Module> $modulesToVisit;
                final /* synthetic */ LibraryInfoCache $infoCache;
                final /* synthetic */ LibraryDependencyCandidatesAndSdkInfosBuilder $libraryDependencyCandidatesAndSdkInfos;
                final /* synthetic */ ModuleDependenciesCache this$0;
                {
                    this.$modulesToVisit = $modulesToVisit;
                    this.$infoCache = $infoCache;
                    this.$libraryDependencyCandidatesAndSdkInfos = $libraryDependencyCandidatesAndSdkInfos;
                    this.this$0 = $receiver;
                }

                public void visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Unit value) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)moduleOrderEntry, (String)"moduleOrderEntry");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Module module = moduleOrderEntry.getModule();
                        if (module == null) break block0;
                        Module module2 = module;
                        HashSet<Module> hashSet = this.$modulesToVisit;
                        Module p0 = module2;
                        boolean bl = false;
                        hashSet.add(p0);
                    }
                }

                public void visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Unit value) {
                    Object object;
                    block6: {
                        block5: {
                            LibraryEx libraryEx;
                            Intrinsics.checkNotNullParameter((Object)libraryOrderEntry, (String)"libraryOrderEntry");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            ProgressManager.checkCanceled();
                            Library $this$safeAs$iv = libraryOrderEntry.getLibrary();
                            boolean $i$f$safeAs = false;
                            Library library = $this$safeAs$iv;
                            if (!(library instanceof LibraryEx)) {
                                library = null;
                            }
                            if ((object = (LibraryEx)library) == null) break block5;
                            LibraryEx it = libraryEx = object;
                            boolean bl = false;
                            object = !it.isDisposed() ? libraryEx : null;
                            if (object != null) break block6;
                        }
                        return;
                    }
                    LibraryEx libraryEx = object;
                    LibraryDependencyCandidate libraryDependencyCandidate = LibraryDependencyCandidate.Companion.fromLibraryOrNull(this.$infoCache.get((Library)libraryEx));
                    if (libraryDependencyCandidate == null) {
                        return;
                    }
                    LibraryDependencyCandidate candidate = libraryDependencyCandidate;
                    this.$libraryDependencyCandidatesAndSdkInfos.plusAssign(candidate);
                }

                public void visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, Unit value) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)jdkOrderEntry, (String)"jdkOrderEntry");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        ProgressManager.checkCanceled();
                        Sdk sdk2 = jdkOrderEntry.getJdk();
                        if (sdk2 == null) break block0;
                        Sdk sdk3 = sdk2;
                        LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfosBuilder = this.$libraryDependencyCandidatesAndSdkInfos;
                        ModuleDependenciesCache moduleDependenciesCache = this.this$0;
                        Sdk jdk = sdk3;
                        boolean bl = false;
                        libraryDependencyCandidatesAndSdkInfosBuilder.plusAssign(new SdkInfo(ModuleDependenciesCache.access$getProject(moduleDependenciesCache), jdk));
                    }
                }
            }, (Object)Unit.INSTANCE);
            Iterator<Module> iterator2 = modulesToVisit.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Module> iterator3 = iterator2;
            block0: while (iterator3.hasNext()) {
                LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfosBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                ProgressManager.checkCanceled();
                if (Intrinsics.areEqual((Object)moduleToVisit, (Object)module) || !trace.contains(moduleToVisit)) continue;
                List reversedTrace = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)trace));
                ModuleDependenciesCache $this$computeLibrariesAndSdksUsedIn_u24lambda_u241 = this;
                boolean bl = false;
                LibraryDependencyCandidatesAndSdkInfosBuilder shared = null;
                HashSet loop = new HashSet();
                HashSet<LibraryDependencyCandidatesAndSdkInfosBuilder> duplicates = new HashSet<LibraryDependencyCandidatesAndSdkInfosBuilder>();
                for (Module traceModule : reversedTrace) {
                    ((Collection)loop).add(traceModule);
                    if (loops.get(traceModule) != null) {
                        Set<Module> it;
                        boolean bl2 = false;
                        CollectionsKt.addAll((Collection)loop, (Iterable)it);
                    }
                    loops.put(traceModule, loop);
                    LibraryDependencyCandidatesAndSdkInfosBuilder traceModuleLibraryDependencyCandidatesAndSdkInfos = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)traceModule);
                    if (shared == null && !duplicates.add(traceModuleLibraryDependencyCandidatesAndSdkInfos)) {
                        shared = traceModuleLibraryDependencyCandidatesAndSdkInfos;
                    }
                    if (traceModule != moduleToVisit) continue;
                }
                if ((libraryDependencyCandidatesAndSdkInfosBuilder = shared) == null) {
                    libraryDependencyCandidatesAndSdkInfosBuilder = (LibraryDependencyCandidatesAndSdkInfosBuilder)CollectionsKt.first((Iterable)duplicates);
                }
                LibraryDependencyCandidatesAndSdkInfosBuilder sharedLibraryDependencyCandidatesAndSdkInfos = libraryDependencyCandidatesAndSdkInfosBuilder;
                sharedLibraryDependencyCandidatesAndSdkInfos.plusAssign(libraryDependencyCandidatesAndSdkInfos);
                for (Module traceModule : reversedTrace) {
                    LibraryDependencyCandidatesAndSdkInfosBuilder traceModuleLibraryDependencyCandidatesAndSdkInfos = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)traceModule);
                    if (traceModuleLibraryDependencyCandidatesAndSdkInfos == sharedLibraryDependencyCandidatesAndSdkInfos) {
                        if (traceModule != moduleToVisit) continue;
                        continue block0;
                    }
                    sharedLibraryDependencyCandidatesAndSdkInfos.plusAssign(traceModuleLibraryDependencyCandidatesAndSdkInfos);
                    tmpResults.put(traceModule, sharedLibraryDependencyCandidatesAndSdkInfos);
                    if (loops.get(traceModule) != null) {
                        Set<Module> loop2;
                        boolean bl3 = false;
                        for (Module loopModule : loop2) {
                            LibraryDependencyCandidatesAndSdkInfosBuilder value;
                            if (Intrinsics.areEqual((Object)loopModule, (Object)traceModule) || (value = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)loopModule)) == sharedLibraryDependencyCandidatesAndSdkInfos) continue;
                            sharedLibraryDependencyCandidatesAndSdkInfos.plusAssign(value);
                            tmpResults.put(loopModule, sharedLibraryDependencyCandidatesAndSdkInfos);
                        }
                    }
                    if (traceModule != moduleToVisit) continue;
                    continue block0;
                }
            }
            Iterator<Module> iterator4 = modulesToVisit.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            iterator3 = iterator4;
            while (iterator3.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                ProgressManager.checkCanceled();
                if (Intrinsics.areEqual((Object)moduleToVisit, (Object)module) || trace.contains(moduleToVisit)) continue;
                LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfosBuilder = tmpResults.get(moduleToVisit);
                LibraryDependencyCandidatesAndSdkInfos moduleToVisitLibraryDependencyCandidatesAndSdkInfos = libraryDependencyCandidatesAndSdkInfosBuilder != null ? (LibraryDependencyCandidatesAndSdkInfos)libraryDependencyCandidatesAndSdkInfosBuilder : this.internalGet(moduleToVisit, tmpResults, trace, loops);
                LibraryDependencyCandidatesAndSdkInfosBuilder moduleLibraryDependencyCandidatesAndSdkInfos = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)module);
                CollectionsKt.addAll((Collection)moduleLibraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates(), (Iterable)moduleToVisitLibraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
            }
            trace.remove(module);
            return (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)module);
        }

        @Override
        @NotNull
        public LibraryDependencyCandidatesAndSdkInfos calculate(@NotNull Module key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            throw new UnsupportedOperationException("calculate(Module) should not be invoked due to custom impl of get()");
        }

        @Override
        protected void checkKeyValidity(@NotNull Module key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ModuleSourceInfoKt.checkValidity(key);
        }

        @Override
        protected void checkValueValidity(@NotNull LibraryDependencyCandidatesAndSdkInfos value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Iterable $this$forEach$iv = value.getLibraryDependencyCandidates();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryDependencyCandidate it = (LibraryDependencyCandidate)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = it.getLibraries();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    LibraryInfo libraryInfo = (LibraryInfo)element$iv2;
                    boolean bl2 = false;
                    libraryInfo.checkValidity();
                }
            }
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCausedByWorkspaceModelChangesOnly()) {
                return;
            }
            Set sdks = SdkInfoKt.allSdks$default(this.getProject(), null, 1, null);
            this.invalidateEntries((arg_0, arg_1) -> ModuleDependenciesCache.rootsChanged$lambda$0(sdks, arg_0, arg_1), null);
        }

        public void beforeChanged(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ImmutableEntityStorage storageBefore = event.getStorageBefore();
            VersionedStorageChange $this$getChanges$iv = event;
            boolean $i$f$getChanges = false;
            List moduleChanges = $this$getChanges$iv.getChanges(ModuleEntity.class);
            VersionedStorageChange $this$getChanges$iv2 = event;
            boolean $i$f$getChanges2 = false;
            List sdkChanges = $this$getChanges$iv2.getChanges(SdkEntity.class);
            if (moduleChanges.isEmpty() && sdkChanges.isEmpty()) {
                return;
            }
            Set outdatedModules = new LinkedHashSet();
            for (EntityChange change : moduleChanges) {
                ModuleEntity moduleEntity;
                if ((ModuleEntity)change.getOldEntity() == null) continue;
                this.collectOutdatedModules(moduleEntity, (EntityStorage)storageBefore, outdatedModules);
            }
            Set outdatedSdks = new LinkedHashSet();
            for (EntityChange sdkChange : sdkChanges) {
                SdkEntity sdkEntity = (SdkEntity)sdkChange.getOldEntity();
                Sdk sdk2 = sdkEntity != null ? WorkspaceEntityChangeListenerKt.findSdkBridge(sdkEntity, (EntityStorage)storageBefore) : null;
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)outdatedSdks, (Object)sdk2);
            }
            if (!((Collection)outdatedModules).isEmpty()) {
                FineGrainedEntityCache.invalidateKeys$default(this, outdatedModules, null, 2, null);
            }
            if (!((Collection)outdatedSdks).isEmpty()) {
                this.invalidateEntries((arg_0, arg_1) -> ModuleDependenciesCache.beforeChanged$lambda$0(outdatedSdks, arg_0, arg_1), null);
            }
        }

        private final void collectOutdatedModules(ModuleEntity moduleEntity, EntityStorage storage, Set<Module> outdatedModules) {
            ModuleBridge moduleBridge = ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)storage);
            if (moduleBridge == null) {
                return;
            }
            ModuleBridge module = moduleBridge;
            if (!outdatedModules.add((Module)module)) {
                return;
            }
            Sequence $this$forEach$iv = storage.referrers((SymbolicEntityId)moduleEntity.getSymbolicId(), ModuleEntity.class);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleEntity it = (ModuleEntity)element$iv;
                boolean bl = false;
                this.collectOutdatedModules(it, storage, outdatedModules);
            }
        }

        @Override
        public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
            Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
            HashSet infos = CollectionsKt.toHashSet((Iterable)libraryInfos);
            this.invalidateEntries((arg_0, arg_1) -> ModuleDependenciesCache.libraryInfosRemoved$lambda$0(infos, arg_0, arg_1), null);
        }

        private static final LibraryDependencyCandidatesAndSdkInfos internalGet$lambda$0(ModuleDependenciesCache this$0, Module $key, Map cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            this$0.checkEntitiesIfRequired(cache2);
            return (LibraryDependencyCandidatesAndSdkInfos)cache2.get($key);
        }

        private static final LibraryDependencyCandidatesAndSdkInfos internalGet$lambda$2(Module $key, LibraryDependencyCandidatesAndSdkInfos $newValue, Map $tmpResults, Map cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            LibraryDependencyCandidatesAndSdkInfos existedValue = cache2.putIfAbsent($key, $newValue);
            for (Map.Entry entry : $tmpResults.entrySet()) {
                cache2.putIfAbsent(entry.getKey(), ((LibraryDependencyCandidatesAndSdkInfosBuilder)entry.getValue()).build());
            }
            return existedValue;
        }

        private static final LibraryDependencyCandidatesAndSdkInfos dumpLoopsIfPossible$lambda$0(Module $key, LibraryDependencyCandidatesAndSdkInfos $newValue, Map $tmpResults, Set $currentLoop, Map $loops, Map cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            LibraryDependencyCandidatesAndSdkInfos existedValue = cache2.putIfAbsent($key, $newValue);
            $tmpResults.remove($key);
            for (Module loopModule : $currentLoop) {
                if ((LibraryDependencyCandidatesAndSdkInfosBuilder)$tmpResults.remove(loopModule) != null) {
                    LibraryDependencyCandidatesAndSdkInfosBuilder it;
                    boolean bl = false;
                    cache2.putIfAbsent(loopModule, it.build());
                }
                $loops.remove(loopModule);
            }
            return existedValue;
        }

        private static final boolean rootsChanged$lambda$0(Set $sdks, Module module, LibraryDependencyCandidatesAndSdkInfos candidates2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)candidates2, (String)"candidates");
                Iterable $this$any$iv = candidates2.getSdkInfos();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SdkInfo it = (SdkInfo)element$iv;
                        boolean bl2 = false;
                        if (!(!$sdks.contains(it.getSdk()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final boolean beforeChanged$lambda$0(Set $outdatedSdks, Module module, LibraryDependencyCandidatesAndSdkInfos candidates2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)candidates2, (String)"candidates");
                Iterable $this$any$iv = candidates2.getSdkInfos();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SdkInfo it = (SdkInfo)element$iv;
                        boolean bl2 = false;
                        if (!$outdatedSdks.contains(it.getSdk())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final boolean libraryInfosRemoved$lambda$0(HashSet $infos, Module module, LibraryDependencyCandidatesAndSdkInfos v) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Iterable $this$any$iv = v.getLibraryDependencyCandidates();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            LibraryDependencyCandidate candidate = (LibraryDependencyCandidate)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = candidate.getLibraries();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    LibraryInfo it = (LibraryInfo)element$iv2;
                                    boolean bl4 = false;
                                    if (!$infos.contains(it)) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public static final /* synthetic */ Project access$getProject(ModuleDependenciesCache $this) {
            return $this.getProject();
        }
    }
}

