/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.NameWithTypeLookupElementDecoratorInsertHandler$;
import org.jetbrains.kotlin.idea.completion.api.serialization.SerializableInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 %2\u00020\u0001:\u0002$%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB7\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c2\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/completion/NameWithTypeLookupElementDecoratorInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/api/serialization/SerializableInsertHandler;", "parameterName", "", "typeIdString", "shouldInsertType", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$kotlin_completion_impl_shared", "$serializer", "Companion", "kotlin.completion.impl.shared"})
public final class NameWithTypeLookupElementDecoratorInsertHandler
implements SerializableInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String parameterName;
    @NotNull
    private final String typeIdString;
    private final boolean shouldInsertType;

    public NameWithTypeLookupElementDecoratorInsertHandler(@NotNull String parameterName2, @NotNull String typeIdString, boolean shouldInsertType) {
        Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
        Intrinsics.checkNotNullParameter((Object)typeIdString, (String)"typeIdString");
        this.parameterName = parameterName2;
        this.typeIdString = typeIdString;
        this.shouldInsertType = shouldInsertType;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (context2.getCompletionChar() == '\t') {
            int tailOffset = context2.getTailOffset();
            CharSequence charSequence = context2.getDocument().getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence chars = charSequence;
            int offset = HandlerUtilsKt.skipSpaces(chars, tailOffset);
            if (HandlerUtilsKt.isCharAt(chars, offset, ',')) {
                ++offset;
                offset = HandlerUtilsKt.skipSpaces(chars, offset);
                Editor editor = context2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                GenerateUtilsKt.moveCaret$default(editor, offset, null, 2, null);
            }
        }
        PsiFile psiFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        KotlinCodeStyleSettings settings2 = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)psiFile);
        String spaceBefore = settings2.SPACE_BEFORE_TYPE_COLON ? " " : "";
        String spaceAfter = settings2.SPACE_AFTER_TYPE_COLON ? " " : "";
        int startOffset = context2.getStartOffset();
        if (this.shouldInsertType) {
            String text = this.parameterName + spaceBefore + ":" + spaceAfter;
            context2.getDocument().insertString(startOffset, (CharSequence)text);
            context2.commitDocument();
            context2.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + text.length());
            item.handleInsert(context2);
        } else {
            context2.getDocument().replaceString(startOffset, context2.getTailOffset(), (CharSequence)this.parameterName);
            context2.commitDocument();
        }
    }

    private final String component1() {
        return this.parameterName;
    }

    private final String component2() {
        return this.typeIdString;
    }

    private final boolean component3() {
        return this.shouldInsertType;
    }

    @NotNull
    public final NameWithTypeLookupElementDecoratorInsertHandler copy(@NotNull String parameterName2, @NotNull String typeIdString, boolean shouldInsertType) {
        Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
        Intrinsics.checkNotNullParameter((Object)typeIdString, (String)"typeIdString");
        return new NameWithTypeLookupElementDecoratorInsertHandler(parameterName2, typeIdString, shouldInsertType);
    }

    public static /* synthetic */ NameWithTypeLookupElementDecoratorInsertHandler copy$default(NameWithTypeLookupElementDecoratorInsertHandler nameWithTypeLookupElementDecoratorInsertHandler, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = nameWithTypeLookupElementDecoratorInsertHandler.parameterName;
        }
        if ((n & 2) != 0) {
            string2 = nameWithTypeLookupElementDecoratorInsertHandler.typeIdString;
        }
        if ((n & 4) != 0) {
            bl = nameWithTypeLookupElementDecoratorInsertHandler.shouldInsertType;
        }
        return nameWithTypeLookupElementDecoratorInsertHandler.copy(string, string2, bl);
    }

    @NotNull
    public String toString() {
        return "NameWithTypeLookupElementDecoratorInsertHandler(parameterName=" + this.parameterName + ", typeIdString=" + this.typeIdString + ", shouldInsertType=" + this.shouldInsertType + ")";
    }

    public int hashCode() {
        int result2 = this.parameterName.hashCode();
        result2 = result2 * 31 + this.typeIdString.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.shouldInsertType);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NameWithTypeLookupElementDecoratorInsertHandler)) {
            return false;
        }
        NameWithTypeLookupElementDecoratorInsertHandler nameWithTypeLookupElementDecoratorInsertHandler = (NameWithTypeLookupElementDecoratorInsertHandler)other;
        if (!Intrinsics.areEqual((Object)this.parameterName, (Object)nameWithTypeLookupElementDecoratorInsertHandler.parameterName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.typeIdString, (Object)nameWithTypeLookupElementDecoratorInsertHandler.typeIdString)) {
            return false;
        }
        return this.shouldInsertType == nameWithTypeLookupElementDecoratorInsertHandler.shouldInsertType;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$kotlin_completion_impl_shared(NameWithTypeLookupElementDecoratorInsertHandler self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.parameterName);
        output.encodeStringElement(serialDesc, 1, self.typeIdString);
        output.encodeBooleanElement(serialDesc, 2, self.shouldInsertType);
    }

    public /* synthetic */ NameWithTypeLookupElementDecoratorInsertHandler(int seen0, String parameterName2, String typeIdString, boolean shouldInsertType, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.parameterName = parameterName2;
        this.typeIdString = typeIdString;
        this.shouldInsertType = shouldInsertType;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/completion/NameWithTypeLookupElementDecoratorInsertHandler$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/kotlin/idea/completion/NameWithTypeLookupElementDecoratorInsertHandler;", "kotlin.completion.impl.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<NameWithTypeLookupElementDecoratorInsertHandler> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

