/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.api.serialization.lookup;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.command.CommandCompletionLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.keyFMap.KeyFMap;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.api.serialization.SerializableInsertHandler;
import org.jetbrains.kotlin.idea.completion.api.serialization.SerializableInsertHandlerKt;
import org.jetbrains.kotlin.idea.completion.api.serialization.SerializableLookupObject;
import org.jetbrains.kotlin.idea.completion.api.serialization.lookup.LookupElementDecoratorWithDelegateInsertHandler;
import org.jetbrains.kotlin.idea.completion.api.serialization.lookup.model.LookupElementModel;
import org.jetbrains.kotlin.idea.completion.api.serialization.lookup.model.LookupObjectModel;
import org.jetbrains.kotlin.idea.completion.api.serialization.lookup.model.PsiElementModel;
import org.jetbrains.kotlin.idea.completion.api.serialization.lookup.model.UserDataValueModel;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0007H\u0002J\u0014\u0010\u001f\u001a\u00020 *\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/completion/api/serialization/lookup/LookupModelConverter;", "", "<init>", "()V", "serializeLookupElementForInsertion", "Lorg/jetbrains/kotlin/idea/completion/api/serialization/lookup/model/LookupElementModel;", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "config", "Lorg/jetbrains/kotlin/idea/completion/api/serialization/lookup/LookupModelConverter$Config;", "deserializeLookupElementForInsertion", "model", "project", "Lcom/intellij/openapi/project/Project;", "serializeUserData", "", "", "Lorg/jetbrains/kotlin/idea/completion/api/serialization/lookup/model/UserDataValueModel;", "data", "Lcom/intellij/openapi/util/UserDataHolderBase;", "keysToIgnore", "", "deserializeUserData", "isIgnored", "", "ignoredLookupElementClasses", "Ljava/lang/Class;", "getIgnoredLookupElementClasses", "()Ljava/util/Set;", "ignoredLookupElementClasses$delegate", "Lkotlin/Lazy;", "throwOrLog", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Config", "intellij.kotlin.completion.api"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLookupModelConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupModelConverter.kt\norg/jetbrains/kotlin/idea/completion/api/serialization/lookup/LookupModelConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,218:1\n1#2:219\n1634#3,3:220\n13#4:223\n*S KotlinDebug\n*F\n+ 1 LookupModelConverter.kt\norg/jetbrains/kotlin/idea/completion/api/serialization/lookup/LookupModelConverter\n*L\n195#1:220,3\n208#1:223\n*E\n"})
public final class LookupModelConverter {
    @NotNull
    public static final LookupModelConverter INSTANCE = new LookupModelConverter();
    @NotNull
    private static final Set<String> keysToIgnore;
    @NotNull
    private static final Lazy ignoredLookupElementClasses$delegate;
    @NotNull
    private static final Logger LOG;

    private LookupModelConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LookupElementModel serializeLookupElementForInsertion(@NotNull LookupElement lookupElement2, @NotNull Config config2) {
        LookupElementModel lookupElementModel;
        Intrinsics.checkNotNullParameter((Object)lookupElement2, (String)"lookupElement");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (this.isIgnored(lookupElement2)) {
            return null;
        }
        LookupElement lookupElement3 = lookupElement2;
        if (lookupElement3 instanceof CommandCompletionLookupElement) {
            lookupElementModel = null;
        } else if (lookupElement3 instanceof LookupElementDecorator) {
            LookupElement lookupElement4 = ((LookupElementDecorator)lookupElement2).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement4, (String)"getDelegate(...)");
            LookupElementModel lookupElementModel2 = this.serializeLookupElementForInsertion(lookupElement4, config2);
            if (lookupElementModel2 == null) {
                return null;
            }
            InsertHandler insertHandler = ((LookupElementDecorator)lookupElement2).getDecoratorInsertHandler();
            InsertHandler insertHandler2 = ((LookupElementDecorator)lookupElement2).getDelegateInsertHandler();
            lookupElementModel = new LookupElementModel.LookupElementDecoratorModel(lookupElementModel2, insertHandler != null ? SerializableInsertHandlerKt.ensureSerializable((InsertHandler<? extends LookupElement>)insertHandler) : null, insertHandler2 != null ? SerializableInsertHandlerKt.ensureSerializable((InsertHandler<? extends LookupElement>)insertHandler2) : null);
        } else {
            if (lookupElement3 instanceof LookupElementBuilder) {
                PsiElementModel psiElementModel;
                LookupObjectModel lookupObjectModel;
                String string = ((LookupElementBuilder)lookupElement2).getLookupString();
                String string2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
                Object object = ((LookupElementBuilder)lookupElement2).getObject();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
                Object lookupObject = object;
                if (lookupObject instanceof SerializableLookupObject) {
                    lookupObjectModel = new LookupObjectModel.SerializableLookupObjectModel((SerializableLookupObject)lookupObject);
                } else if (lookupObject instanceof PsiElement) {
                    lookupObjectModel = new LookupObjectModel.PsiLookupObjectModel(PsiElementModel.Companion.create((PsiElement)lookupObject));
                } else if (lookupObject instanceof String) {
                    lookupObjectModel = new LookupObjectModel.StringLookupObjectModel((String)lookupObject);
                } else {
                    throw new AssertionError((Object)("Unexpected lookup object type: " + lookupObject.getClass()));
                }
                PsiElement psiElement = ((LookupElementBuilder)lookupElement2).getPsiElement();
                if (psiElement != null) {
                    void it;
                    PsiElement psiElement2 = psiElement;
                    LookupObjectModel lookupObjectModel2 = lookupObjectModel;
                    String string3 = string2;
                    boolean bl = false;
                    PsiElementModel psiElementModel2 = PsiElementModel.Companion.create((PsiElement)it);
                    string2 = string3;
                    lookupObjectModel = lookupObjectModel2;
                    psiElementModel = psiElementModel2;
                } else {
                    psiElementModel = null;
                }
                InsertHandler insertHandler = ((LookupElementBuilder)lookupElement2).getInsertHandler();
                Map<String, UserDataValueModel> map2 = this.serializeUserData((UserDataHolderBase)lookupElement2, config2);
                SerializableInsertHandler serializableInsertHandler = insertHandler != null ? SerializableInsertHandlerKt.ensureSerializable((InsertHandler<? extends LookupElement>)insertHandler) : null;
                PsiElementModel psiElementModel3 = psiElementModel;
                LookupObjectModel lookupObjectModel3 = lookupObjectModel;
                String string4 = string2;
                return new LookupElementModel.LookupElementBuilderModel(string4, lookupObjectModel3, psiElementModel3, serializableInsertHandler, map2);
            }
            if (lookupElement3 instanceof PostfixTemplateLookupElement) {
                lookupElementModel = null;
            } else {
                this.throwOrLog((Throwable)((Object)new AssertionError((Object)("Unexpected lookup element type: " + lookupElement2.getClass()))), config2);
                lookupElementModel = null;
            }
        }
        return lookupElementModel;
    }

    @NotNull
    public final LookupElement deserializeLookupElementForInsertion(@NotNull LookupElementModel model2, @NotNull Project project) {
        LookupElement lookupElement2;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LookupElementModel lookupElementModel = model2;
        if (lookupElementModel instanceof LookupElementModel.LookupElementDecoratorModel) {
            lookupElement2 = (LookupElement)new LookupElementDecoratorWithDelegateInsertHandler(this.deserializeLookupElementForInsertion(((LookupElementModel.LookupElementDecoratorModel)model2).getDelegate(), project), (InsertHandler<LookupElement>)((InsertHandler)((LookupElementModel.LookupElementDecoratorModel)model2).getDelegateInsertHandler()));
        } else if (lookupElementModel instanceof LookupElementModel.LookupElementBuilderModel) {
            LookupElementBuilder lookupElementBuilder;
            Object object;
            LookupObjectModel lookupObject = ((LookupElementModel.LookupElementBuilderModel)model2).getLookupObject();
            if (lookupObject instanceof LookupObjectModel.SerializableLookupObjectModel) {
                object = ((LookupObjectModel.SerializableLookupObjectModel)lookupObject).getLookupObject();
            } else if (lookupObject instanceof LookupObjectModel.StringLookupObjectModel) {
                object = ((LookupObjectModel.StringLookupObjectModel)lookupObject).getString();
            } else if (lookupObject instanceof LookupObjectModel.PsiLookupObjectModel) {
                object = ((LookupObjectModel.PsiLookupObjectModel)lookupObject).getPsiElement().restore(project);
                if (object == null) {
                    PsiElementModel psiElementModel = ((LookupElementModel.LookupElementBuilderModel)model2).getPsiElement();
                    object = new AssertionError((Object)("Cannot restore psi element for " + ((LookupElementModel.LookupElementBuilderModel)model2).getLookupElementString() + ", element is " + (psiElementModel != null ? psiElementModel.getElementClass() : null)));
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            PsiElementModel psiElementModel = ((LookupElementModel.LookupElementBuilderModel)model2).getPsiElement();
            LookupElementBuilder $this$deserializeLookupElementForInsertion_u24lambda_u240 = lookupElementBuilder = LookupElementBuilder.create((Object)object, (String)((LookupElementModel.LookupElementBuilderModel)model2).getLookupElementString()).withPsiElement((PsiElement)(psiElementModel != null ? psiElementModel.restore(project) : null)).withInsertHandler((InsertHandler)((LookupElementModel.LookupElementBuilderModel)model2).getInsertHandler());
            boolean bl = false;
            UserDataHolderBase userData = INSTANCE.deserializeUserData(((LookupElementModel.LookupElementBuilderModel)model2).getUserdata(), project);
            userData.copyUserDataTo((UserDataHolderBase)$this$deserializeLookupElementForInsertion_u24lambda_u240);
            LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder;
            Intrinsics.checkNotNull((Object)lookupElementBuilder2);
            lookupElement2 = (LookupElement)lookupElementBuilder2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lookupElement2;
    }

    private final Map<String, UserDataValueModel> serializeUserData(UserDataHolderBase data, Config config2) {
        Map map2;
        KeyFMap keyFMap = data.getUserMap();
        Intrinsics.checkNotNullExpressionValue((Object)keyFMap, (String)"getUserMap(...)");
        KeyFMap map3 = keyFMap;
        if (map3.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map $this$serializeUserData_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        Key[] keyArray = map3.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)keyArray, (String)"getKeys(...)");
        for (Key key : keyArray) {
            UserDataValueModel userDataValueModel;
            Object value;
            String keyName;
            Intrinsics.checkNotNull((Object)key);
            Key key2 = key;
            Intrinsics.checkNotNullExpressionValue((Object)key2.toString(), (String)"toString(...)");
            if (keysToIgnore.contains(keyName)) continue;
            Intrinsics.checkNotNull((Object)map3.get(key2));
            Object object = value;
            if (object instanceof Boolean) {
                userDataValueModel = new UserDataValueModel.BooleanModel((Boolean)value);
            } else if (object instanceof String) {
                userDataValueModel = new UserDataValueModel.StringModel((String)value);
            } else if (object instanceof Enum) {
                int n = ((Enum)value).ordinal();
                String string = value.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                userDataValueModel = new UserDataValueModel.EnumModel(n, string);
            } else if (object instanceof Class) {
                String string = ((Class)value).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                userDataValueModel = new UserDataValueModel.ClassModel(string);
            } else if (object instanceof Integer) {
                userDataValueModel = new UserDataValueModel.IntModel(((Number)value).intValue());
            } else if (object instanceof Long) {
                userDataValueModel = new UserDataValueModel.LongModel(((Number)value).longValue());
            } else if (object instanceof Float) {
                userDataValueModel = new UserDataValueModel.FloatModel(((Number)value).floatValue());
            } else if (object instanceof Double) {
                userDataValueModel = new UserDataValueModel.DoubleModel(((Number)value).doubleValue());
            } else if (object instanceof Name) {
                userDataValueModel = new UserDataValueModel.NameModel((Name)value);
            } else if (object instanceof PsiReference) {
                userDataValueModel = UserDataValueModel.PsiReferenceModel.Companion.create((PsiReference)value);
            } else {
                INSTANCE.throwOrLog((Throwable)((Object)new AssertionError((Object)("Unexpected user data value type: `" + value.getClass() + "` for key `" + key2 + "`"))), config2);
                continue;
            }
            $this$serializeUserData_u24lambda_u240.put(keyName, userDataValueModel);
        }
        return MapsKt.build((Map)map2);
    }

    private final UserDataHolderBase deserializeUserData(Map<String, ? extends UserDataValueModel> data, Project project) {
        UserDataHolderBase result2 = new UserDataHolderBase();
        for (Map.Entry<String, ? extends UserDataValueModel> entry : data.entrySet()) {
            Key key;
            Constable constable;
            String k = entry.getKey();
            UserDataValueModel v = entry.getValue();
            Intrinsics.checkNotNull((Object)Key.findKeyByName((String)k), (String)"null cannot be cast to non-null type com.intellij.openapi.util.Key<kotlin.Any>");
            UserDataValueModel userDataValueModel = v;
            if (userDataValueModel instanceof UserDataValueModel.BooleanModel) {
                constable = ((UserDataValueModel.BooleanModel)v).getValue();
            } else if (userDataValueModel instanceof UserDataValueModel.StringModel) {
                constable = ((UserDataValueModel.StringModel)v).getValue();
            } else if (userDataValueModel instanceof UserDataValueModel.EnumModel) {
                constable = Class.forName(((UserDataValueModel.EnumModel)v).getEnumClass()).getEnumConstants()[((UserDataValueModel.EnumModel)v).getOrdinal()];
            } else if (userDataValueModel instanceof UserDataValueModel.ClassModel) {
                constable = Class.forName(((UserDataValueModel.ClassModel)v).getClassName());
            } else if (userDataValueModel instanceof UserDataValueModel.IntModel) {
                constable = ((UserDataValueModel.IntModel)v).getValue();
            } else if (userDataValueModel instanceof UserDataValueModel.LongModel) {
                constable = ((UserDataValueModel.LongModel)v).getValue();
            } else if (userDataValueModel instanceof UserDataValueModel.FloatModel) {
                constable = Float.valueOf(((UserDataValueModel.FloatModel)v).getValue());
            } else if (userDataValueModel instanceof UserDataValueModel.DoubleModel) {
                constable = ((UserDataValueModel.DoubleModel)v).getValue();
            } else if (userDataValueModel instanceof UserDataValueModel.NameModel) {
                constable = ((UserDataValueModel.NameModel)v).getName();
            } else if (userDataValueModel instanceof UserDataValueModel.PsiReferenceModel) {
                constable = ((UserDataValueModel.PsiReferenceModel)v).restore(project);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Boolean value = constable;
            result2.putUserData(key, (Object)value);
        }
        return result2;
    }

    private final boolean isIgnored(LookupElement $this$isIgnored) {
        return this.getIgnoredLookupElementClasses().contains($this$isIgnored.getClass());
    }

    private final Set<Class<?>> getIgnoredLookupElementClasses() {
        Lazy lazy = ignoredLookupElementClasses$delegate;
        return (Set)lazy.getValue();
    }

    private final void throwOrLog(Throwable $this$throwOrLog, Config config2) {
        if (!config2.getSafeMode()) {
            throw $this$throwOrLog;
        }
        LOG.error($this$throwOrLog);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set ignoredLookupElementClasses_delegate$lambda$0() {
        void var1_1;
        void $this$mapTo$iv;
        Iterable iterable = CollectionsKt.listOf((Object)"org.jetbrains.kotlin.idea.completion.OverridesCompletionLookupElementDecorator");
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(Class.forName((String)it));
        }
        return (Set)var1_1;
    }

    static {
        Object[] objectArray = new String[9];
        objectArray[0] = "KOTLIN_CLASSIFIER_WEIGHT";
        objectArray[1] = "KOTLIN_CALLABlE_WEIGHT";
        objectArray[2] = "LookupArrangerMatcher";
        objectArray[3] = "LAST_COMPUTED_PRESENTATION";
        objectArray[4] = "SORTER_KEY";
        objectArray[5] = "Base statistics info";
        Intrinsics.checkNotNullExpressionValue((Object)BaseCompletionService.LOOKUP_ELEMENT_CONTRIBUTOR.toString(), (String)"toString(...)");
        objectArray[7] = "PRESENTATION_INVARIANT";
        objectArray[8] = "SHORTEN_COMMAND";
        keysToIgnore = SetsKt.setOf((Object[])objectArray);
        ignoredLookupElementClasses$delegate = LazyKt.lazy(LookupModelConverter::ignoredLookupElementClasses_delegate$lambda$0);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LookupModelConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/completion/api/serialization/lookup/LookupModelConverter$Config;", "", "safeMode", "", "<init>", "(Z)V", "getSafeMode", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.kotlin.completion.api"})
    public static final class Config {
        private final boolean safeMode;

        public Config(boolean safeMode) {
            this.safeMode = safeMode;
        }

        public final boolean getSafeMode() {
            return this.safeMode;
        }

        public final boolean component1() {
            return this.safeMode;
        }

        @NotNull
        public final Config copy(boolean safeMode) {
            return new Config(safeMode);
        }

        public static /* synthetic */ Config copy$default(Config config2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = config2.safeMode;
            }
            return config2.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Config(safeMode=" + this.safeMode + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.safeMode);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config2 = (Config)other;
            return this.safeMode == config2.safeMode;
        }
    }
}

