/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J,\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0014\u0010\u0010\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u0011H\u0014J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightReceiverUsagesHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "receiverInfo", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "allowUsagesFromOtherHandlers", "", "<init>", "(Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;Lcom/intellij/openapi/editor/Editor;Z)V", "getTargets", "", "selectTargets", "", "targets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "computeUsages", "highlightReferences", "kotlin.highlighting.k1"})
public final class KotlinHighlightReceiverUsagesHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    @NotNull
    private final ReceiverInfo receiverInfo;
    private final boolean allowUsagesFromOtherHandlers;

    public KotlinHighlightReceiverUsagesHandler(@NotNull ReceiverInfo receiverInfo, @NotNull Editor editor, boolean allowUsagesFromOtherHandlers) {
        Intrinsics.checkNotNullParameter((Object)receiverInfo, (String)"receiverInfo");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(editor, receiverInfo.getPsi().getContainingFile());
        this.receiverInfo = receiverInfo;
        this.allowUsagesFromOtherHandlers = allowUsagesFromOtherHandlers;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        return CollectionsKt.listOf((Object)this.receiverInfo.getPsi());
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this.receiverInfo.collectReceiverUsages((Function1<? super TextRange, Unit>)((Function1)arg_0 -> KotlinHighlightReceiverUsagesHandler.computeUsages$lambda$0(this, arg_0)));
    }

    public boolean highlightReferences() {
        return this.allowUsagesFromOtherHandlers;
    }

    private static final Unit computeUsages$lambda$0(KotlinHighlightReceiverUsagesHandler this$0, TextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list2 = this$0.myReadUsages;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myReadUsages");
        ((Collection)list2).add(it);
        return Unit.INSTANCE;
    }
}

