/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/KotlinRefsHolder;", "", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getContainingFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "localRefs", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "registerLocalRef", "", "declaration", "Lcom/intellij/psi/PsiElement;", "isUsedLocally", "", "intellij.kotlin.highlighting"})
@SourceDebugExtension(value={"SMAP\nKotlinUnusedHighlightingProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinUnusedHighlightingProcessor.kt\norg/jetbrains/kotlin/idea/highlighting/KotlinRefsHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1#2:293\n1761#3,3:294\n*S KotlinDebug\n*F\n+ 1 KotlinUnusedHighlightingProcessor.kt\norg/jetbrains/kotlin/idea/highlighting/KotlinRefsHolder\n*L\n254#1:294,3\n*E\n"})
public final class KotlinRefsHolder {
    @NotNull
    private final KtFile containingFile;
    @NotNull
    private final Set<KtDeclaration> localRefs;

    public KotlinRefsHolder(@NotNull KtFile containingFile) {
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        this.containingFile = containingFile;
        this.localRefs = new LinkedHashSet();
    }

    @NotNull
    public final KtFile getContainingFile() {
        return this.containingFile;
    }

    public final void registerLocalRef(@Nullable PsiElement declaration) {
        if (declaration instanceof KtDeclaration && Intrinsics.areEqual((Object)((KtDeclaration)declaration).getContainingFile(), (Object)this.containingFile)) {
            ((Collection)this.localRefs).add(declaration);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUsedLocally(@NotNull KtDeclaration declaration) {
        KtSecondaryConstructor it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.localRefs.contains(declaration)) {
            return true;
        }
        if (!(declaration instanceof KtClass)) return false;
        KtPrimaryConstructor ktPrimaryConstructor = ((KtClass)declaration).getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            KtPrimaryConstructor it2 = ktPrimaryConstructor;
            boolean bl2 = false;
            if (this.localRefs.contains(it2)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        Iterable $this$any$iv = ((KtClass)declaration).getSecondaryConstructors();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KtSecondaryConstructor)element$iv;
            boolean bl3 = false;
        } while (!this.localRefs.contains(it));
        return true;
    }
}

