/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight;

import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.SuperDeclaration;
import org.jetbrains.kotlin.idea.codeInsight.SuperDeclarationProvider;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler;", "Lcom/intellij/codeInsight/generation/actions/PresentableCodeInsightActionHandler;", "<init>", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "update", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "startInWriteAction", "", "Companion", "HandlerResult", "intellij.kotlin.codeInsight"})
public final class KotlinGoToSuperDeclarationsHandler
implements PresentableCodeInsightActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!(file instanceof KtFile)) {
                return;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
            KtDeclaration ktDeclaration = Companion.findTargetDeclaration(file, editor);
            if (ktDeclaration == null) {
                return;
            }
            KtDeclaration targetDeclaration = ktDeclaration;
            JBPopup jBPopup = Companion.gotoSuperDeclarations(targetDeclaration);
            if (jBPopup == null) break block2;
            jBPopup.showInBestPositionFor(editor);
        }
    }

    public void update(@NotNull Editor editor, @NotNull PsiFile file, @Nullable Presentation presentation) {
        block8: {
            String string;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!(file instanceof KtFile)) {
                return;
            }
            KtDeclaration ktDeclaration = Companion.findTargetDeclaration(file, editor);
            if (ktDeclaration == null) {
                return;
            }
            KtDeclaration targetDeclaration = ktDeclaration;
            Presentation presentation2 = presentation;
            if (presentation2 == null) break block8;
            KtDeclaration ktDeclaration2 = targetDeclaration;
            if (ktDeclaration2 instanceof KtClassOrObject || ktDeclaration2 instanceof PsiClass) {
                string = KotlinBundle.message((String)"action.GotoSuperClass.MainMenu.text", (Object[])new Object[0]);
            } else if (ktDeclaration2 instanceof KtFunction || ktDeclaration2 instanceof PsiMethod) {
                string = ActionsBundle.actionText((String)"GotoSuperMethod.MainMenu");
            } else if (ktDeclaration2 instanceof KtProperty || ktDeclaration2 instanceof KtParameter) {
                string = KotlinBundle.message((String)"action.GotoSuperProperty.MainMenu.text", (Object[])new Object[0]);
            } else {
                throw new IllegalStateException(("Unexpected declaration " + targetDeclaration).toString());
            }
            presentation2.setText(string);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$Companion;", "", "<init>", "()V", "findTargetDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findSuperDeclarations", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult;", "targetDeclaration", "gotoSuperDeclarations", "Lcom/intellij/openapi/ui/popup/JBPopup;", "intellij.kotlin.codeInsight"})
    @SourceDebugExtension(value={"SMAP\nKotlinGoToSuperDeclarationsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGoToSuperDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,108:1\n1#2:109\n1#2:120\n1617#3,9:110\n1869#3:119\n1870#3:121\n1626#3:122\n37#4,2:123\n*S KotlinDebug\n*F\n+ 1 KotlinGoToSuperDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$Companion\n*L\n59#1:120\n59#1:110,9\n59#1:119\n59#1:121\n59#1:122\n60#1:123,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KtDeclaration findTargetDeclaration(@NotNull PsiFile file, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            return SuperDeclarationProvider.INSTANCE.findDeclaration(element);
        }

        @Nullable
        public final HandlerResult findSuperDeclarations(@NotNull KtDeclaration targetDeclaration) {
            String string;
            KtDeclaration ktDeclaration;
            Intrinsics.checkNotNullParameter((Object)targetDeclaration, (String)"targetDeclaration");
            KtDeclaration it = ktDeclaration = SuperDeclarationProvider.INSTANCE.findSuperDeclarations(targetDeclaration);
            boolean bl = false;
            Object object = !((Collection)it).isEmpty() ? ktDeclaration : null;
            if (object == null) {
                return null;
            }
            KtDeclaration superDeclarations = object;
            if (superDeclarations.size() == 1) {
                return new HandlerResult.Single((SuperDeclaration)CollectionsKt.single((List)superDeclarations));
            }
            ktDeclaration = targetDeclaration;
            if (ktDeclaration instanceof KtClassOrObject || ktDeclaration instanceof PsiClass) {
                string = KotlinBundle.message((String)"goto.super.chooser.class.title", (Object[])new Object[0]);
            } else if (ktDeclaration instanceof KtFunction || ktDeclaration instanceof PsiMethod) {
                string = KotlinBundle.message((String)"goto.super.chooser.function.title", (Object[])new Object[0]);
            } else if (ktDeclaration instanceof KtProperty || ktDeclaration instanceof KtParameter) {
                string = KotlinBundle.message((String)"goto.super.chooser.property.title", (Object[])new Object[0]);
            } else {
                throw new IllegalStateException(("Unexpected declaration " + targetDeclaration).toString());
            }
            String title = string;
            return new HandlerResult.Multiple(title, (List<? extends SuperDeclaration>)superDeclarations);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final JBPopup gotoSuperDeclarations(@NotNull KtDeclaration targetDeclaration) {
            Intrinsics.checkNotNullParameter((Object)targetDeclaration, (String)"targetDeclaration");
            HandlerResult result2 = this.findSuperDeclarations(targetDeclaration);
            if (result2 instanceof HandlerResult.Single) {
                Navigatable navigatable = ((HandlerResult.Single)result2).getItem().getDescriptor();
                if (navigatable != null) {
                    Navigatable navigatable2;
                    Navigatable navigatable3;
                    Navigatable it = navigatable3 = navigatable;
                    boolean bl = false;
                    Object object = navigatable2 = it.canNavigate() ? navigatable3 : null;
                    if (navigatable2 != null) {
                        navigatable2.navigate(true);
                    }
                }
            } else if (result2 instanceof HandlerResult.Multiple) {
                void $this$toTypedArray$iv;
                void $this$mapNotNullTo$iv$iv;
                Collection $this$mapNotNull$iv;
                Iterable iterable = ((HandlerResult.Multiple)result2).getItems();
                boolean $i$f$mapNotNull = false;
                void it = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiElement it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    SuperDeclaration it2 = (SuperDeclaration)element$iv$iv;
                    boolean bl2 = false;
                    if (it2.getDeclaration().getElement() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                PsiElement[] superDeclarationsArray = thisCollection$iv.toArray(new PsiElement[0]);
                if (!(superDeclarationsArray.length == 0)) {
                    return NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (String)((HandlerResult.Multiple)result2).getTitle());
                }
            } else if (result2 != null) {
                throw new NoWhenBranchMatchedException();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult;", "", "<init>", "()V", "items", "", "Lorg/jetbrains/kotlin/idea/codeInsight/SuperDeclaration;", "getItems", "()Ljava/util/List;", "Single", "Multiple", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult$Multiple;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult$Single;", "intellij.kotlin.codeInsight"})
    public static abstract sealed class HandlerResult {
        private HandlerResult() {
        }

        @NotNull
        public abstract List<SuperDeclaration> getItems();

        public /* synthetic */ HandlerResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\"\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult$Multiple;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$PopupTitle;", "items", "", "Lorg/jetbrains/kotlin/idea/codeInsight/SuperDeclaration;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getTitle", "()Ljava/lang/String;", "getItems", "()Ljava/util/List;", "intellij.kotlin.codeInsight"})
        public static final class Multiple
        extends HandlerResult {
            @NotNull
            private final String title;
            @NotNull
            private final List<SuperDeclaration> items;

            public Multiple(@NotNull String title, @NotNull List<? extends SuperDeclaration> items) {
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(items, (String)"items");
                super(null);
                this.title = title;
                this.items = items;
            }

            @NotNull
            public final String getTitle() {
                return this.title;
            }

            @Override
            @NotNull
            public List<SuperDeclaration> getItems() {
                return this.items;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult$Single;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/KotlinGoToSuperDeclarationsHandler$HandlerResult;", "item", "Lorg/jetbrains/kotlin/idea/codeInsight/SuperDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/idea/codeInsight/SuperDeclaration;)V", "getItem", "()Lorg/jetbrains/kotlin/idea/codeInsight/SuperDeclaration;", "items", "", "getItems", "()Ljava/util/List;", "intellij.kotlin.codeInsight"})
        public static final class Single
        extends HandlerResult {
            @NotNull
            private final SuperDeclaration item;

            public Single(@NotNull SuperDeclaration item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                super(null);
                this.item = item;
            }

            @NotNull
            public final SuperDeclaration getItem() {
                return this.item;
            }

            @Override
            @NotNull
            public List<SuperDeclaration> getItems() {
                return CollectionsKt.listOf((Object)this.item);
            }
        }
    }
}

