/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.processor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveConflictUtilKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUsageUtilKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CopyablePsiUserDataProperty;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016JI\u0010\u001d\u001a\u00020\u00122\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0#2\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#2\u0006\u0010%\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010&J,\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u001a2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*H\u0016J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J*\u0010,\u001a\u00020\u00122\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0.H\u0016R3\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2MoveFilesHandler;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFileHandler;", "<init>", "()V", "<set-?>", "", "packageNeedsUpdate", "Lorg/jetbrains/kotlin/psi/KtFile;", "getPackageNeedsUpdate", "(Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/lang/Boolean;", "setPackageNeedsUpdate", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/Boolean;)V", "packageNeedsUpdate$delegate", "Lorg/jetbrains/kotlin/psi/CopyablePsiUserDataProperty;", "canProcessElement", "element", "Lcom/intellij/psi/PsiFile;", "markRequiresUpdate", "", "file", "needsUpdate", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "psiFile", "newParent", "Lcom/intellij/psi/PsiDirectory;", "searchInComments", "searchInNonJavaFiles", "detectConflicts", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "elementsToMove", "", "usages", "targetDirectory", "(Lcom/intellij/util/containers/MultiMap;[Lcom/intellij/psi/PsiElement;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/psi/PsiDirectory;)V", "prepareMovedFile", "moveDestination", "oldToNewMap", "", "updateMovedFile", "retargetUsages", "usageInfos", "", "intellij.kotlin.refactorings.move"})
@SourceDebugExtension(value={"SMAP\nK2MoveFilesOrDirectoriesRefactoringProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveFilesOrDirectoriesRefactoringProcessor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2MoveFilesHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n*L\n1#1,143:1\n1#2:144\n4225#3,11:145\n4225#3,11:156\n1869#4,2:167\n41#5,8:169\n*S KotlinDebug\n*F\n+ 1 K2MoveFilesOrDirectoriesRefactoringProcessor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2MoveFilesHandler\n*L\n117#1:145,11\n120#1:156,11\n133#1:167,2\n139#1:169,8\n*E\n"})
public final class K2MoveFilesHandler
extends MoveFileHandler {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final CopyablePsiUserDataProperty packageNeedsUpdate$delegate;

    public K2MoveFilesHandler() {
        Key key = Key.create((String)"PACKAGE_NEEDS_UPDATE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.packageNeedsUpdate$delegate = new CopyablePsiUserDataProperty(key);
    }

    private final Boolean getPackageNeedsUpdate(KtFile $this$packageNeedsUpdate) {
        return (Boolean)this.packageNeedsUpdate$delegate.getValue((PsiElement)$this$packageNeedsUpdate, $$delegatedProperties[0]);
    }

    private final void setPackageNeedsUpdate(KtFile $this$packageNeedsUpdate, Boolean bl) {
        this.packageNeedsUpdate$delegate.setValue((PsiElement)$this$packageNeedsUpdate, $$delegatedProperties[0], (Object)bl);
    }

    public boolean canProcessElement(@NotNull PsiFile element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtFile;
    }

    public final void markRequiresUpdate(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.setPackageNeedsUpdate(file, true);
    }

    public final boolean needsUpdate(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiDirectory psiDirectory = file.getContainingDirectory();
        return Intrinsics.areEqual((Object)(psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null), (Object)file.getPackageFqName());
    }

    @NotNull
    public List<UsageInfo> findUsages(@NotNull PsiFile psiFile, @NotNull PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        List<UsageInfo> list2;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        if (!(psiFile instanceof KtFile)) {
            boolean bl = false;
            String string = "Can only find usages from Kotlin files";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.needsUpdate((KtFile)psiFile) && ProjectFileIndex.getInstance((Project)((KtFile)psiFile).getProject()).isInSourceContent(newParent.getVirtualFile())) {
            this.markRequiresUpdate((KtFile)psiFile);
            FqName newPkgName = MoveUtilKt.getPossiblyForcedPackageFqName(newParent);
            list2 = MoveUsageUtilKt.findUsages((KtFile)psiFile, searchInComments, searchInNonJavaFiles, newPkgName);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public void detectConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull PsiElement[] elementsToMove, @NotNull UsageInfo[] usages2, @NotNull PsiDirectory targetDirectory) {
        UsageInfo[] $this$filterIsInstanceTo$iv$iv;
        UsageInfo[] $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Intrinsics.checkNotNullParameter((Object)elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        FqName targetPkgFqn = MoveUtilKt.getPossiblyForcedPackageFqName(targetDirectory);
        PsiElement[] psiElementArray = elementsToMove;
        MultiMap<PsiElement, String> multiMap = conflicts;
        boolean $i$f$filterIsInstance = false;
        void var8_9 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (UsageInfo element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = usages2;
        FqName fqName2 = targetPkgFqn;
        PsiDirectory psiDirectory = targetDirectory;
        Iterable iterable = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (UsageInfo element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MoveRenameUsageInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        multiMap.putAllValues(MoveConflictUtilKt.findAllMoveConflicts(iterable, psiDirectory, fqName2, list2));
    }

    public void prepareMovedFile(@NotNull PsiFile file, @NotNull PsiDirectory moveDestination, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)moveDestination, (String)"moveDestination");
        Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
        if (!(file instanceof KtFile)) {
            boolean $i$a$-require-K2MoveFilesHandler$prepareMovedFile$22 = false;
            String $i$a$-require-K2MoveFilesHandler$prepareMovedFile$22 = "Can only prepare Kotlin files";
            throw new IllegalArgumentException($i$a$-require-K2MoveFilesHandler$prepareMovedFile$22.toString());
        }
        FqName destinationPackage = MoveUtilKt.getPossiblyForcedPackageFqName(moveDestination);
        if (Intrinsics.areEqual((Object)this.getPackageNeedsUpdate((KtFile)file), (Object)true) && !Intrinsics.areEqual((Object)((KtFile)file).getPackageFqName(), (Object)destinationPackage)) {
            MoveUtilKt.updatePackageDirective((KtFile)file, destinationPackage);
        }
        this.setPackageNeedsUpdate((KtFile)file, null);
        oldToNewMap.put((PsiElement)file, (PsiElement)file);
        List<KtNamedDeclaration> declarations2 = MoveUsageUtilKt.getAllDeclarationsToUpdate((KtDeclarationContainer)file);
        Iterable $this$forEach$iv = declarations2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl = false;
            oldToNewMap.put((PsiElement)it, (PsiElement)it);
        }
    }

    public void updateMovedFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retargetUsages(@NotNull List<? extends UsageInfo> usageInfos, @NotNull Map<PsiElement, ? extends PsiElement> oldToNewMap) {
        Intrinsics.checkNotNullParameter(usageInfos, (String)"usageInfos");
        Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
        boolean $i$f$allowAnalysisOnEdt = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
            boolean bl = false;
            MoveUsageUtilKt.retargetUsagesAfterMove(CollectionsKt.toList((Iterable)usageInfos), oldToNewMap);
        } else {
            permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
            try {
                boolean bl = false;
                MoveUsageUtilKt.retargetUsagesAfterMove(CollectionsKt.toList((Iterable)usageInfos), oldToNewMap);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
            }
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(K2MoveFilesHandler.class, "packageNeedsUpdate", "getPackageNeedsUpdate(Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/lang/Boolean;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

