/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.codeInspection.localCanBeFinal.LocalCanBeFinal;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.MathUtil;
import com.siyeh.ig.psiutils.FinalUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.MutabilityUtilsKt;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKFieldAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKKtAssignmentStatement;
import org.jetbrains.kotlin.nj2k.tree.JKOperatorExpression;
import org.jetbrains.kotlin.nj2k.tree.JKOperatorToken;
import org.jetbrains.kotlin.nj2k.tree.JKParenthesizedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.tree.JKUnaryExpression;
import org.jetbrains.kotlin.nj2k.tree.JKVariable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001aL\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00140\u0013H\u0002\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001aH\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001aH\u0002\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001aH\u0002\u001a\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 *\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002\u001a\u001a\u0010&\u001a\u00020\u0006*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\"\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"getImmutableLocalVariablesInBlock", "", "Lcom/intellij/psi/PsiVariable;", "body", "Lcom/intellij/psi/PsiCodeBlock;", "canBeImmutable", "", "variable", "fieldConstructionImpliesMutable", "field", "Lcom/intellij/psi/PsiField;", "isValidThisMethodInConstructor", "constructor", "Lcom/intellij/psi/PsiMethod;", "checkIfElementViolatesImmutability", "checkElementDoesNotViolateImmutability", "e", "Lcom/intellij/psi/PsiElement;", "uninitializedVarProblems", "", "", "Lcom/intellij/psi/PsiReferenceExpression;", "finalVarProblems", "Lcom/intellij/psi/controlFlow/ControlFlowUtil$VariableInfo;", "asAssignmentFromTarget", "Lorg/jetbrains/kotlin/nj2k/tree/JKKtAssignmentStatement;", "Lorg/jetbrains/kotlin/nj2k/tree/JKFieldAccessExpression;", "asParenthesizedAssignmentFromTarget", "Lorg/jetbrains/kotlin/nj2k/tree/JKParenthesizedExpression;", "asQualifiedAssignmentFromTarget", "Lorg/jetbrains/kotlin/nj2k/tree/JKQualifiedExpression;", "findWritableUsages", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKVariable;", "scope", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "context", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "hasWritableUsages", "MUTABLE_ANNOTATIONS", "", "getMUTABLE_ANNOTATIONS", "()Ljava/util/Set;", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nmutabilityUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 mutabilityUtils.kt\norg/jetbrains/kotlin/nj2k/MutabilityUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n4225#2,11:288\n1374#3:299\n1460#3,5:300\n774#3:310\n865#3,2:311\n125#4:305\n125#4:307\n125#4:308\n125#4:309\n1#5:306\n*S KotlinDebug\n*F\n+ 1 mutabilityUtils.kt\norg/jetbrains/kotlin/nj2k/MutabilityUtilsKt\n*L\n206#1:288,11\n206#1:299\n206#1:300,5\n276#1:310\n276#1:311,2\n263#1:305\n266#1:307\n269#1:308\n270#1:309\n*E\n"})
public final class MutabilityUtilsKt {
    @NotNull
    private static final Set<String> MUTABLE_ANNOTATIONS;

    @Nullable
    public static final Set<PsiVariable> getImmutableLocalVariablesInBlock(@Nullable PsiCodeBlock body2) {
        if (body2 == null) {
            return null;
        }
        ControlFlow controlFlow = LocalCanBeFinal.getControlFlow((PsiCodeBlock)body2);
        if (controlFlow == null) {
            return null;
        }
        ControlFlow flow = controlFlow;
        int start2 = flow.getStartOffset((PsiElement)body2);
        int end = flow.getEndOffset((PsiElement)body2);
        Collection collection = ControlFlowUtil.getWrittenVariables((ControlFlow)flow, (int)start2, (int)end, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getWrittenVariables(...)");
        Collection writtenVariables = collection;
        HashSet<PsiVariable> result2 = new HashSet<PsiVariable>();
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(body2, result2, flow, writtenVariables){
            final /* synthetic */ PsiCodeBlock $body;
            final /* synthetic */ HashSet<PsiVariable> $result;
            final /* synthetic */ ControlFlow $flow;
            final /* synthetic */ Collection<PsiVariable> $writtenVariables;
            {
                this.$body = $body;
                this.$result = $result;
                this.$flow = $flow;
                this.$writtenVariables = $writtenVariables;
            }

            public void visitCodeBlock(PsiCodeBlock block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                if (block.getParent() instanceof PsiLambdaExpression && block != this.$body) {
                    Set<PsiVariable> descriptors = MutabilityUtilsKt.getImmutableLocalVariablesInBlock(block);
                    if (descriptors != null) {
                        this.$result.addAll((Collection<PsiVariable>)descriptors);
                    }
                    return;
                }
                super.visitCodeBlock(block);
                Set<PsiVariable> declared = this.getDeclaredVariables(block);
                if (declared.isEmpty()) {
                    return;
                }
                PsiElement anchor = (PsiElement)block;
                if (block.getParent() instanceof PsiSwitchBlock) {
                    PsiElement psiElement = block.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                    anchor = psiElement;
                    Set set = ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)block)).filter(PsiReferenceExpression.class).filter(arg_0 -> getImmutableLocalVariablesInBlock.1.visitCodeBlock$lambda$1(getImmutableLocalVariablesInBlock.1::visitCodeBlock$lambda$0, arg_0)).toSet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
                    Set writeRefs = set;
                    for (PsiReferenceExpression ref : writeRefs) {
                        PsiElement resolve2 = ref.resolve();
                        if (!(resolve2 instanceof PsiVariable) || !declared.contains(resolve2) || !((PsiVariable)resolve2).hasInitializer()) continue;
                        declared.remove(resolve2);
                    }
                }
                int from = this.$flow.getStartOffset(anchor);
                int codeBlockEnd = this.$flow.getEndOffset(anchor);
                List list2 = ControlFlowUtil.getSSAVariables((ControlFlow)this.$flow, (int)from, (int)codeBlockEnd, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSSAVariables(...)");
                List ssa = list2;
                for (PsiVariable psiVariable : ssa) {
                    if (!declared.contains(psiVariable) || psiVariable.hasInitializer() && VariableAccessUtils.variableIsAssigned((PsiVariable)psiVariable, (PsiElement)((PsiElement)block))) continue;
                    this.$result.add(psiVariable);
                }
            }

            public void visitResourceVariable(PsiResourceVariable variable) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)variable), PsiClass.class) != PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)this.$body), PsiClass.class)) {
                    return;
                }
                this.$result.add((PsiVariable)variable);
            }

            public void visitPatternVariable(PsiPatternVariable variable) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                super.visitPatternVariable(variable);
                if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)variable), PsiClass.class) != PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)this.$body), PsiClass.class)) {
                    return;
                }
                Class[] classArray = new Class[]{PsiInstanceOfExpression.class, PsiSwitchLabelStatementBase.class, PsiForeachPatternStatement.class, PsiForeachStatement.class};
                PsiElement context2 = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)variable), (Class[])classArray);
                int from = 0;
                int patternVarEnd = 0;
                PsiElement psiElement = context2;
                if (psiElement instanceof PsiInstanceOfExpression) {
                    from = this.$flow.getEndOffset(context2);
                    patternVarEnd = this.$flow.getEndOffset((PsiElement)this.$body);
                } else if (psiElement instanceof PsiSwitchLabelStatementBase) {
                    PsiExpression guardExpression = ((PsiSwitchLabelStatementBase)context2).getGuardExpression();
                    from = guardExpression != null ? this.$flow.getStartOffset((PsiElement)guardExpression) : this.$flow.getEndOffset(context2);
                    patternVarEnd = this.$flow.getEndOffset((PsiElement)this.$body);
                } else if (psiElement instanceof PsiForeachPatternStatement) {
                    PsiStatement psiStatement = ((PsiForeachPatternStatement)context2).getBody();
                    if (psiStatement == null) {
                        return;
                    }
                    PsiStatement contextBody = psiStatement;
                    from = this.$flow.getStartOffset((PsiElement)contextBody);
                    patternVarEnd = this.$flow.getEndOffset((PsiElement)contextBody);
                } else {
                    return;
                }
                from = MathUtil.clamp((int)from, (int)0, (int)this.$flow.getInstructions().size());
                patternVarEnd = MathUtil.clamp((int)patternVarEnd, (int)from, (int)this.$flow.getInstructions().size());
                if (!ControlFlowUtil.getWrittenVariables((ControlFlow)this.$flow, (int)from, (int)patternVarEnd, (boolean)false).contains(variable)) {
                    this.$writtenVariables.remove(variable);
                    this.$result.add((PsiVariable)variable);
                }
            }

            private final Set<PsiVariable> getDeclaredVariables(PsiCodeBlock block) {
                HashSet<PsiVariable> declaredResult = new HashSet<PsiVariable>();
                PsiElement[] psiElementArray = block.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                for (PsiElement child : psiElementArray) {
                    child.accept((PsiElementVisitor)new JavaElementVisitor(declaredResult){
                        final /* synthetic */ HashSet<PsiVariable> $declaredResult;
                        {
                            this.$declaredResult = $declaredResult;
                        }

                        public void visitReferenceExpression(PsiReferenceExpression expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
                        }

                        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                            PsiElement[] psiElementArray = statement.getDeclaredElements();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getDeclaredElements(...)");
                            for (PsiElement declaredElement : psiElementArray) {
                                if (!(declaredElement instanceof PsiVariable)) continue;
                                this.$declaredResult.add((PsiVariable)declaredElement);
                            }
                        }

                        public void visitForStatement(PsiForStatement statement) {
                            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                            super.visitForStatement(statement);
                            PsiStatement psiStatement = statement.getInitialization();
                            PsiDeclarationStatement psiDeclarationStatement = psiStatement instanceof PsiDeclarationStatement ? (PsiDeclarationStatement)psiStatement : null;
                            if (psiDeclarationStatement == null) {
                                return;
                            }
                            PsiDeclarationStatement initialization = psiDeclarationStatement;
                            PsiElement[] psiElementArray = initialization.getDeclaredElements();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getDeclaredElements(...)");
                            for (PsiElement declaredElement : psiElementArray) {
                                if (!(declaredElement instanceof PsiVariable)) continue;
                                this.$declaredResult.add((PsiVariable)declaredElement);
                            }
                        }
                    });
                }
                return declaredResult;
            }

            private static final boolean visitCodeBlock$lambda$0(PsiReferenceExpression ref) {
                return PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)ref));
            }

            private static final boolean visitCodeBlock$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        });
        return new HashSet(result2);
    }

    public static final boolean canBeImmutable(@NotNull PsiVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (variable.getInitializer() != null || variable instanceof PsiParameter) {
            return !VariableAccessUtils.variableIsAssigned((PsiVariable)variable);
        }
        return variable instanceof PsiField && MutabilityUtilsKt.fieldConstructionImpliesMutable((PsiField)variable) ? false : MutabilityUtilsKt.checkIfElementViolatesImmutability(variable);
    }

    private static final boolean fieldConstructionImpliesMutable(PsiField field2) {
        PsiClass psiClass = field2.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass aClass = psiClass;
        PsiMethod[] psiMethodArray = aClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
        PsiMethod[] constructors2 = psiMethodArray;
        List usefulConstructors = new ArrayList();
        int n = constructors2.length;
        for (int j = 0; j < n; ++j) {
            PsiCodeBlock ctrBody;
            List redirectedConstructors;
            PsiMethod constructor = constructors2[j];
            if (constructor.getBody() == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)JavaPsiConstructorUtil.getChainedConstructors((PsiMethod)constructor), (String)"getChainedConstructors(...)");
            List usefulRedirectedConstructors = new ArrayList();
            for (PsiMethod redirectedConstructor : redirectedConstructors) {
                PsiCodeBlock body2 = redirectedConstructor.getBody();
                if (body2 == null) continue;
                if (!ControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)((PsiVariable)field2), (PsiElement)((PsiElement)body2))) {
                    Intrinsics.checkNotNull((Object)redirectedConstructor);
                    if (!MutabilityUtilsKt.isValidThisMethodInConstructor(redirectedConstructor)) continue;
                }
                Intrinsics.checkNotNull((Object)redirectedConstructor);
                usefulRedirectedConstructors.add(redirectedConstructor);
            }
            if (!((Collection)usefulRedirectedConstructors).isEmpty() && usefulRedirectedConstructors.size() != redirectedConstructors.size()) {
                return true;
            }
            if (!ctrBody.isValid()) continue;
            if (!ControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)((PsiVariable)field2), (PsiElement)((PsiElement)ctrBody))) {
                Intrinsics.checkNotNull((Object)constructor);
                if (!MutabilityUtilsKt.isValidThisMethodInConstructor(constructor)) continue;
            }
            Intrinsics.checkNotNull((Object)constructor);
            usefulConstructors.add(constructor);
        }
        return !((Collection)usefulConstructors).isEmpty() && usefulConstructors.size() != constructors2.length;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isValidThisMethodInConstructor(PsiMethod constructor) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        PsiElement[] psiElementArray = constructor.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiCodeBlock)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiCodeBlock it = (PsiCodeBlock)element$iv$iv;
            boolean bl = false;
            PsiElement[] psiElementArray2 = it.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])psiElementArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List children = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        while (!((Collection)children).isEmpty()) {
            Object e = children.removeFirst();
            Intrinsics.checkNotNullExpressionValue(e, (String)"removeFirst(...)");
            PsiElement child = (PsiElement)e;
            if (!(child instanceof PsiMethodCallExpression)) {
                Collection collection = children;
                PsiElement[] psiElementArray3 = child.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"getChildren(...)");
                CollectionsKt.addAll((Collection)collection, (Object[])psiElementArray3);
                continue;
            }
            if (!Intrinsics.areEqual((Object)((PsiMethodCallExpression)child).getMethodExpression().getQualifiedName(), (Object)"this")) continue;
            return true;
        }
        return false;
    }

    private static final boolean checkIfElementViolatesImmutability(PsiVariable variable) {
        PsiElement psiElement = variable instanceof PsiField ? (PsiElement)PsiUtil.getTopLevelClass((PsiElement)((PsiElement)variable)) : PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (psiElement == null) {
            return false;
        }
        PsiElement scope = psiElement;
        Map finalVarProblems = new HashMap();
        Map uninitializedVarProblems = new HashMap();
        PsiElementProcessor elementDoesNotViolateFinality = arg_0 -> MutabilityUtilsKt.checkIfElementViolatesImmutability$lambda$0(variable, uninitializedVarProblems, finalVarProblems, arg_0);
        return PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)elementDoesNotViolateFinality);
    }

    private static final boolean checkElementDoesNotViolateImmutability(PsiElement e, PsiVariable variable, Map<PsiElement, ? extends Collection<? extends PsiReferenceExpression>> uninitializedVarProblems, Map<PsiElement, ? extends Collection<? extends ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (!FinalUtils.checkElementDoesNotViolateFinality((PsiElement)e, (PsiVariable)variable, uninitializedVarProblems, finalVarProblems)) {
            return false;
        }
        if (!(e instanceof PsiReferenceExpression)) {
            return true;
        }
        if (!((PsiReferenceExpression)e).isReferenceTo((PsiElement)variable)) {
            return true;
        }
        if (!(variable instanceof PsiField)) {
            return true;
        }
        PsiMember psiMember = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)e);
        if (psiMember == null) {
            return true;
        }
        PsiMember enclosingInitializer = psiMember;
        PsiElement parent = e;
        Collection conditionals = new ArrayList();
        while (parent != enclosingInitializer) {
            Intrinsics.checkNotNullExpressionValue((Object)parent.getParent(), (String)"getParent(...)");
            if (!(parent instanceof PsiIfStatement)) continue;
            conditionals.add(parent);
            break;
        }
        return conditionals.isEmpty();
    }

    private static final JKKtAssignmentStatement asAssignmentFromTarget(JKFieldAccessExpression $this$asAssignmentFromTarget) {
        JKKtAssignmentStatement jKKtAssignmentStatement;
        JKElement $this$safeAs$iv = $this$asAssignmentFromTarget.getParent();
        boolean $i$f$safeAs = false;
        JKElement jKElement = $this$safeAs$iv;
        if (!(jKElement instanceof JKKtAssignmentStatement)) {
            jKElement = null;
        }
        JKKtAssignmentStatement jKKtAssignmentStatement2 = (JKKtAssignmentStatement)jKElement;
        if (jKKtAssignmentStatement2 != null) {
            JKKtAssignmentStatement jKKtAssignmentStatement3;
            JKKtAssignmentStatement it = jKKtAssignmentStatement3 = jKKtAssignmentStatement2;
            boolean bl = false;
            jKKtAssignmentStatement = Intrinsics.areEqual((Object)it.getField(), (Object)$this$asAssignmentFromTarget) ? jKKtAssignmentStatement3 : null;
        } else {
            jKKtAssignmentStatement = null;
        }
        return jKKtAssignmentStatement;
    }

    private static final JKParenthesizedExpression asParenthesizedAssignmentFromTarget(JKFieldAccessExpression $this$asParenthesizedAssignmentFromTarget) {
        JKParenthesizedExpression jKParenthesizedExpression;
        JKElement $this$safeAs$iv = $this$asParenthesizedAssignmentFromTarget.getParent();
        boolean $i$f$safeAs = false;
        JKElement jKElement = $this$safeAs$iv;
        if (!(jKElement instanceof JKParenthesizedExpression)) {
            jKElement = null;
        }
        JKParenthesizedExpression jKParenthesizedExpression2 = (JKParenthesizedExpression)jKElement;
        if (jKParenthesizedExpression2 != null) {
            JKParenthesizedExpression jKParenthesizedExpression3;
            JKParenthesizedExpression it = jKParenthesizedExpression3 = jKParenthesizedExpression2;
            boolean bl = false;
            jKParenthesizedExpression = it.getParent() instanceof JKKtAssignmentStatement && Intrinsics.areEqual((Object)it.getExpression(), (Object)$this$asParenthesizedAssignmentFromTarget) ? jKParenthesizedExpression3 : null;
        } else {
            jKParenthesizedExpression = null;
        }
        return jKParenthesizedExpression;
    }

    private static final JKQualifiedExpression asQualifiedAssignmentFromTarget(JKFieldAccessExpression $this$asQualifiedAssignmentFromTarget) {
        JKQualifiedExpression jKQualifiedExpression;
        JKElement $this$safeAs$iv = $this$asQualifiedAssignmentFromTarget.getParent();
        boolean $i$f$safeAs = false;
        JKElement jKElement = $this$safeAs$iv;
        if (!(jKElement instanceof JKQualifiedExpression)) {
            jKElement = null;
        }
        JKQualifiedExpression jKQualifiedExpression2 = (JKQualifiedExpression)jKElement;
        if (jKQualifiedExpression2 != null) {
            Object object;
            JKOperatorToken operatorToken;
            JKQualifiedExpression jKQualifiedExpression3;
            JKQualifiedExpression it = jKQualifiedExpression3 = jKQualifiedExpression2;
            boolean bl = false;
            JKElement $this$safeAs$iv2 = it.getParent();
            boolean $i$f$safeAs2 = false;
            JKElement jKElement2 = $this$safeAs$iv2;
            if (!(jKElement2 instanceof JKUnaryExpression)) {
                jKElement2 = null;
            }
            JKOperatorToken jKOperatorToken = operatorToken = (object = (JKUnaryExpression)jKElement2) != null && (object = ((JKOperatorExpression)object).getOperator()) != null ? object.getToken() : null;
            jKQualifiedExpression = Intrinsics.areEqual((Object)it.getSelector(), (Object)$this$asQualifiedAssignmentFromTarget) && (it.getParent() instanceof JKKtAssignmentStatement || Intrinsics.areEqual((Object)operatorToken, (Object)JKOperatorToken.Companion.getPLUSPLUS()) || Intrinsics.areEqual((Object)operatorToken, (Object)JKOperatorToken.Companion.getMINUSMINUS())) ? jKQualifiedExpression3 : null;
        } else {
            jKQualifiedExpression = null;
        }
        return jKQualifiedExpression;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<JKFieldAccessExpression> findWritableUsages(JKVariable $this$findWritableUsages, JKTreeElement scope, ConverterContext context2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ExpressionsKt.findUsages($this$findWritableUsages, scope, context2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JKFieldAccessExpression it = (JKFieldAccessExpression)element$iv$iv;
            boolean bl = false;
            if (!(MutabilityUtilsKt.asAssignmentFromTarget(it) != null || ExpressionsKt.isInDecrementOrIncrement(it) || MutabilityUtilsKt.asQualifiedAssignmentFromTarget(it) != null || MutabilityUtilsKt.asParenthesizedAssignmentFromTarget(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    public static final boolean hasWritableUsages(@NotNull JKVariable $this$hasWritableUsages, @NotNull JKTreeElement scope, @NotNull ConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWritableUsages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !((Collection)MutabilityUtilsKt.findWritableUsages($this$hasWritableUsages, scope, context2)).isEmpty();
    }

    @NotNull
    public static final Set<String> getMUTABLE_ANNOTATIONS() {
        return MUTABLE_ANNOTATIONS;
    }

    private static final boolean checkIfElementViolatesImmutability$lambda$0(PsiVariable $variable, Map $uninitializedVarProblems, Map $finalVarProblems, PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return MutabilityUtilsKt.checkElementDoesNotViolateImmutability(e, $variable, $uninitializedVarProblems, $finalVarProblems);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.concurrent.Volatile", "javax.persistence.Column", "jakarta.persistence.Column"};
        MUTABLE_ANNOTATIONS = SetsKt.setOf((Object[])objectArray);
    }
}

