/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MavenEventType {
    SESSION_STARTED("SessionStarted"),
    SESSION_ENDED("SessionEnded"),
    PROJECT_STARTED("ProjectStarted"),
    MOJO_STARTED("MojoStarted"),
    MOJO_SUCCEEDED("MojoSucceeded"),
    MOJO_FAILED("MojoFailed"),
    MOJO_SKIPPED("MojoSkipped"),
    PROJECT_SUCCEEDED("ProjectSucceeded"),
    PROJECT_SKIPPED("ProjectSkipped"),
    PROJECT_FAILED("ProjectFailed"),
    ARTIFACT_RESOLVED("ARTIFACT_RESOLVED"),
    ARTIFACT_DOWNLOADING("ARTIFACT_DOWNLOADING"),
    IDEA_INTERNAL_MESSAGE("IDEA_INTERNAL_MESSAGE");

    public final String eventName;
    private static final Map<String, MavenEventType> eventsByName;

    private MavenEventType(String eventName) {
        this.eventName = eventName;
    }

    @Nullable
    public static MavenEventType valueByName(@NotNull String eventName) {
        if (eventName == null) {
            MavenEventType.$$$reportNull$$$0(0);
        }
        return eventsByName.get(eventName);
    }

    static {
        eventsByName = Arrays.stream(MavenEventType.values()).collect(Collectors.toMap(v -> v.eventName, Function.identity()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventName", "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenEventType", "valueByName"));
    }
}

