﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/chime-sdk-voice/model/Origination.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class PutVoiceConnectorOriginationRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API PutVoiceConnectorOriginationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "PutVoiceConnectorOrigination"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Voice Connector ID.</p>
   */
  inline const Aws::String& GetVoiceConnectorId() const { return m_voiceConnectorId; }
  inline bool VoiceConnectorIdHasBeenSet() const { return m_voiceConnectorIdHasBeenSet; }
  template <typename VoiceConnectorIdT = Aws::String>
  void SetVoiceConnectorId(VoiceConnectorIdT&& value) {
    m_voiceConnectorIdHasBeenSet = true;
    m_voiceConnectorId = std::forward<VoiceConnectorIdT>(value);
  }
  template <typename VoiceConnectorIdT = Aws::String>
  PutVoiceConnectorOriginationRequest& WithVoiceConnectorId(VoiceConnectorIdT&& value) {
    SetVoiceConnectorId(std::forward<VoiceConnectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The origination settings being updated.</p>
   */
  inline const Origination& GetOrigination() const { return m_origination; }
  inline bool OriginationHasBeenSet() const { return m_originationHasBeenSet; }
  template <typename OriginationT = Origination>
  void SetOrigination(OriginationT&& value) {
    m_originationHasBeenSet = true;
    m_origination = std::forward<OriginationT>(value);
  }
  template <typename OriginationT = Origination>
  PutVoiceConnectorOriginationRequest& WithOrigination(OriginationT&& value) {
    SetOrigination(std::forward<OriginationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceConnectorId;
  bool m_voiceConnectorIdHasBeenSet = false;

  Origination m_origination;
  bool m_originationHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
