/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.freeplane.features.attribute.NodeAttribute;

public interface AttributeSelection {
    public static final AttributeSelection EMPTY = new AttributeSelection(){

        @Override
        public List<SelectedAttribute> getSelectedAttributes() {
            return Collections.emptyList();
        }
    };

    public List<SelectedAttribute> getSelectedAttributes();

    default public boolean isEmpty() {
        return this.getSelectedAttributes().isEmpty();
    }

    default public Stream<NodeAttribute> nodeAttributeStream() {
        return this.getSelectedAttributes().stream().map(SelectedAttribute::getSelectedAttribute);
    }

    public static class SelectedAttribute {
        private final NodeAttribute selectedAttribute;
        private final SelectedPart selectedPart;

        public SelectedAttribute(NodeAttribute selectedAttribute, SelectedPart selectedPart) {
            this.selectedAttribute = selectedAttribute;
            this.selectedPart = selectedPart;
        }

        public NodeAttribute getSelectedAttribute() {
            return this.selectedAttribute;
        }

        public SelectedPart getSelectedPart() {
            return this.selectedPart;
        }

        public String toStringContent() {
            switch (this.selectedPart.ordinal()) {
                case 0: {
                    return this.selectedAttribute.name();
                }
                case 1: {
                    return String.valueOf(this.selectedAttribute.value());
                }
            }
            return this.selectedAttribute.name() + '\t' + String.valueOf(this.selectedAttribute.value());
        }

        public static enum SelectedPart {
            NAME,
            VALUE,
            BOTH;

        }
    }
}

