/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;
import sun.jvm.hotspot.utilities.GenericArray;
import sun.jvm.hotspot.utilities.HeapProgressThunk;
import sun.jvm.hotspot.utilities.MethodArray;
import sun.jvm.hotspot.utilities.ReversePtrs;
import sun.jvm.hotspot.utilities.ReversePtrsAnalysis;

public class ClassLoaderStats
extends Tool {
    boolean verbose = true;

    public ClassLoaderStats() {
    }

    public ClassLoaderStats(JVMDebugger d) {
        super(d);
    }

    public static void main(String[] args) {
        ClassLoaderStats cls = new ClassLoaderStats();
        cls.execute(args);
    }

    @Override
    public void run() {
        this.printClassLoaderStatistics();
    }

    private void printClassLoaderStatistics() {
        LoaderData bootstrapLoaderData;
        HashMap loaderMap;
        PrintStream out;
        block13: {
            out = System.out;
            final PrintStream err = System.err;
            loaderMap = new HashMap();
            bootstrapLoaderData = new LoaderData();
            if (this.verbose) {
                err.print("finding class loader instances ..");
            }
            VM vm = VM.getVM();
            ObjectHeap heap = vm.getObjectHeap();
            vm.getSystemDictionary();
            InstanceKlass classLoaderKlass = SystemDictionary.getClassLoaderKlass();
            try {
                heap.iterateObjectsOfKlass(new DefaultHeapVisitor(){

                    @Override
                    public boolean doObj(Oop oop) {
                        loaderMap.put(oop, new LoaderData());
                        return false;
                    }
                }, classLoaderKlass);
            }
            catch (Exception se) {
                se.printStackTrace();
            }
            if (this.verbose) {
                err.println("done.");
                err.print("computing per loader stat ..");
            }
            SystemDictionary dict = VM.getVM().getSystemDictionary();
            dict.classesDo(new SystemDictionary.ClassVisitor(){

                @Override
                public void visit(Klass k) {
                    LoaderData ld;
                    if (!(k instanceof InstanceKlass)) {
                        return;
                    }
                    Oop loader = ((InstanceKlass)k).getClassLoader();
                    LoaderData loaderData = ld = loader != null ? (LoaderData)loaderMap.get(loader) : bootstrapLoaderData;
                    if (ld != null) {
                        ++ld.numClasses;
                        long size = ClassLoaderStats.this.computeSize((InstanceKlass)k);
                        ld.classDetail.add(new ClassData(k, size));
                        ld.classSize += size;
                    }
                }
            });
            if (this.verbose) {
                err.println("done.");
                err.print("please wait.. computing liveness");
            }
            ReversePtrsAnalysis analysis = new ReversePtrsAnalysis();
            if (this.verbose) {
                analysis.setHeapProgressThunk(new HeapProgressThunk(){

                    @Override
                    public void heapIterationFractionUpdate(double fractionOfHeapVisited) {
                        err.print('.');
                    }

                    @Override
                    public void heapIterationComplete() {
                        err.println("done.");
                    }
                });
            }
            try {
                analysis.run();
            }
            catch (Exception e) {
                if (!this.verbose) break block13;
                err.println("liveness analysis may be inaccurate ...");
            }
        }
        ReversePtrs liveness = VM.getVM().getRevPtrs();
        out.println("class_loader\tclasses\tbytes\tparent_loader\talive?\ttype");
        out.println();
        long numClassLoaders = 1L;
        long totalNumClasses = bootstrapLoaderData.numClasses;
        long totalClassSize = bootstrapLoaderData.classSize;
        long numAliveLoaders = 1L;
        long numDeadLoaders = 0L;
        out.print("<bootstrap>");
        out.print('\t');
        out.print(bootstrapLoaderData.numClasses);
        out.print('\t');
        out.print(bootstrapLoaderData.classSize);
        out.print('\t');
        out.print("  null  ");
        out.print('\t');
        out.print("live");
        out.print('\t');
        out.println("<internal>");
        for (Oop loader : loaderMap.keySet()) {
            LoaderData data = (LoaderData)loaderMap.get(loader);
            ++numClassLoaders;
            totalNumClasses += data.numClasses;
            totalClassSize += data.classSize;
            out.print(loader.getHandle());
            out.print('\t');
            out.print(data.numClasses);
            out.print('\t');
            out.print(data.classSize);
            out.print('\t');
            class ParentFinder
            extends DefaultOopVisitor {
                private Oop parent = null;

                ParentFinder() {
                }

                @Override
                public void doOop(OopField field, boolean isVMField) {
                    if (field.getID().getName().equals("parent")) {
                        this.parent = field.getValue(this.getObj());
                    }
                }

                public Oop getParent() {
                    return this.parent;
                }
            }
            ParentFinder parentFinder = new ParentFinder();
            loader.iterate(parentFinder, false);
            Oop parent = parentFinder.getParent();
            out.print(parent != null ? parent.getHandle().toString() : "  null  ");
            out.print('\t');
            boolean alive = liveness != null ? liveness.get(loader) != null : true;
            out.print(alive ? "live" : "dead");
            if (alive) {
                ++numAliveLoaders;
            } else {
                ++numDeadLoaders;
            }
            out.print('\t');
            Klass loaderKlass = loader.getKlass();
            if (loaderKlass != null) {
                out.print(loaderKlass.getName().asString());
                out.print('@');
                out.print(loader.getKlass().getAddress());
            } else {
                out.print("    null!    ");
            }
            out.println();
        }
        out.println();
        out.print("total = ");
        out.print(numClassLoaders);
        out.print('\t');
        out.print(totalNumClasses);
        out.print('\t');
        out.print(totalClassSize);
        out.print('\t');
        out.print("    N/A    ");
        out.print('\t');
        out.print("alive=");
        out.print(numAliveLoaders);
        out.print(", dead=");
        out.print(numDeadLoaders);
        out.print('\t');
        out.print("    N/A    ");
        out.println();
    }

    private static long objectSize(Oop oop) {
        return oop == null ? 0L : oop.getObjectSize();
    }

    private static long arraySize(GenericArray arr) {
        return (long)arr.getLength() != 0L ? arr.getSize() : 0L;
    }

    private long computeSize(InstanceKlass k) {
        long size = 0L;
        size += k.getSize();
        ConstantPool cp = k.getConstants();
        size += cp.getSize();
        if (cp.getCache() != null) {
            size += cp.getCache().getSize();
        }
        size += ClassLoaderStats.arraySize(cp.getTags());
        size += ClassLoaderStats.arraySize(k.getLocalInterfaces());
        size += ClassLoaderStats.arraySize(k.getTransitiveInterfaces());
        size += ClassLoaderStats.arraySize(k.getInnerClasses());
        size += ClassLoaderStats.arraySize(k.getFields());
        MethodArray methods = k.getMethods();
        int nmethods = methods.getLength();
        if ((long)nmethods != 0L) {
            size += methods.getSize();
            for (int i = 0; i < nmethods; ++i) {
                Method m = methods.at(i);
                size += m.getSize();
                size += m.getConstMethod().getSize();
            }
        }
        return size;
    }

    private static class LoaderData {
        long numClasses;
        long classSize;
        List classDetail = new ArrayList();

        private LoaderData() {
        }
    }

    private static class ClassData {
        Klass klass;
        long size;

        ClassData(Klass klass, long size) {
            this.klass = klass;
            this.size = size;
        }
    }
}

