/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.serializing;

import java.util.Map;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.serializing.SerializeUtils;

public abstract class AbstractStoreSerializer {
    protected void writeCommonStoreSubAttributes(ConfigurationWriter writer, AbstractStoreConfiguration configuration) {
    }

    protected void writeCommonStoreElements(ConfigurationWriter writer, StoreConfiguration configuration) {
        if (configuration.async().enabled()) {
            this.writeStoreWriteBehind(writer, configuration);
        }
        SerializeUtils.writeTypedProperties(writer, TypedProperties.toTypedProperties((Map)configuration.properties()));
    }

    private void writeStoreWriteBehind(ConfigurationWriter writer, StoreConfiguration configuration) {
        AttributeSet writeBehind = configuration.async().attributes();
        if (writeBehind.isModified()) {
            writer.writeStartElement((Enum)Element.WRITE_BEHIND);
            writeBehind.write(writer, AsyncStoreConfiguration.MODIFICATION_QUEUE_SIZE, (Enum)Attribute.MODIFICATION_QUEUE_SIZE);
            writeBehind.write(writer, AsyncStoreConfiguration.FAIL_SILENTLY, (Enum)Attribute.FAIL_SILENTLY);
            writer.writeEndElement();
        }
    }
}

