/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class ClassSecurityAnnotationBuildItem
extends MultiBuildItem {
    private final DotName classAnnotation;

    public ClassSecurityAnnotationBuildItem(DotName classAnnotation) {
        this.classAnnotation = Objects.requireNonNull(classAnnotation);
    }

    public DotName getClassAnnotation() {
        return this.classAnnotation;
    }

    public static Predicate<ClassInfo> useClassLevelSecurity(final List<ClassSecurityAnnotationBuildItem> items) {
        return new Predicate<ClassInfo>(){
            private final Set<String> securityAnnotationNames;
            {
                this.securityAnnotationNames = items.stream().map(ClassSecurityAnnotationBuildItem::getClassAnnotation).map(DotName::toString).collect(Collectors.toSet());
            }

            @Override
            public boolean test(ClassInfo classInfo) {
                return classInfo.declaredAnnotations().stream().map(AnnotationInstance::name).map(DotName::toString).anyMatch(this.securityAnnotationNames::contains);
            }
        };
    }
}

