/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.sql.Datum;

class PlsqlIbtBinder
extends Binder {
    Binder thePlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;

    PlsqlIbtBinder() {
        PlsqlIbtBinder.init(this);
    }

    static void init(Binder x) {
        x.type = (short)998;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        PlsqlIbtBindInfo bindInfo = stmt.parameterPlsqlIbt[rank][bindPosition];
        if (clearPriorBindValues) {
            stmt.parameterPlsqlIbt[rank][bindPosition] = null;
        }
        int offset = bindInfo.ibtValueIndex;
        switch (bindInfo.element_internal_type) {
            case 9: {
                for (int i = 0; i < bindInfo.curLen; ++i) {
                    int len = 0;
                    String s = (String)bindInfo.arrayData[i];
                    if (s != null) {
                        len = s.length();
                        if (len > bindInfo.elemMaxLen - 1) {
                            len = bindInfo.elemMaxLen - 1;
                        }
                        s.getChars(0, len, stmt.ibtBindChars, offset + 1);
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i] = 0;
                        stmt.ibtBindChars[offset] = (char)(len <<= 1);
                        stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i] = (short)(len == 0 ? 3 : (short)(len + 2));
                    } else {
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i] = -1;
                        Arrays.fill(stmt.ibtBindChars, offset, offset + bindInfo.elemMaxLen, '\u0000');
                    }
                    offset += bindInfo.elemMaxLen;
                }
                break;
            }
            case 6: 
            case 12: 
            case 180: {
                for (int i = 0; i < bindInfo.curLen; ++i) {
                    byte[] bytes = null;
                    if (bindInfo.arrayData[i] != null) {
                        bytes = ((Datum)bindInfo.arrayData[i]).getBytes();
                    }
                    if (bytes == null) {
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i] = -1;
                        stmt.ibtBindBytes[offset] = -1;
                    } else {
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i] = 0;
                        stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i] = (short)(bytes.length + 1);
                        stmt.ibtBindBytes[offset] = (byte)bytes.length;
                        System.arraycopy(bytes, 0, stmt.ibtBindBytes, offset + 1, bytes.length);
                    }
                    offset += bindInfo.elemMaxLen;
                    if (!stmt.connection.checksumMode.needToCalculateBindChecksum()) continue;
                    localCheckSum = bytes == null ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, bytes, 0, bytes.length);
                }
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
            }
        }
        return localCheckSum;
    }

    @Override
    Binder copyingBinder() {
        return this.thePlsqlIbtCopyingBinder;
    }
}

