/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.search.grouping.CollapsingDocValuesSource;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.mapper.MappedFieldType;

public final class CollapsingTopDocsCollector<T>
extends FirstPassGroupingCollector<T> {
    protected final String collapseField;
    protected final Sort sort;
    protected Scorable scorer;
    private int totalHitCount;
    private final FieldDoc after;
    private FieldComparator<?> afterComparator;
    private LeafFieldComparator leafComparator;
    private final int reverseMul;

    CollapsingTopDocsCollector(GroupSelector<T> groupSelector, String collapseField, Sort sort, int topN) {
        super(groupSelector, sort, topN);
        this.collapseField = collapseField;
        this.sort = sort;
        this.after = null;
        this.reverseMul = 1;
    }

    CollapsingTopDocsCollector(GroupSelector<T> groupSelector, String collapseField, Sort sort, int topN, FieldDoc after) {
        super(groupSelector, sort, topN);
        this.collapseField = collapseField;
        this.sort = sort;
        this.after = after;
        if (after != null) {
            if (sort.getSort().length != 1 || !sort.getSort()[0].getField().equals(collapseField)) {
                throw new IllegalArgumentException("The after parameter can only be used when the sort is based on the collapse field");
            }
            SortField field = sort.getSort()[0];
            this.afterComparator = field.getComparator(1, Pruning.NONE);
            FieldComparator<?> comparator = this.afterComparator;
            comparator.setTopValue(after.fields[0]);
            this.reverseMul = field.getReverse() ? -1 : 1;
        } else {
            this.reverseMul = 1;
        }
    }

    public CollapseTopFieldDocs getTopDocs() throws IOException {
        Collection groups = super.getTopGroups(0);
        if (groups == null) {
            TotalHits totalHits = new TotalHits((long)this.totalHitCount, TotalHits.Relation.EQUAL_TO);
            return new CollapseTopFieldDocs(this.collapseField, totalHits, new ScoreDoc[0], this.sort.getSort(), new Object[0]);
        }
        FieldDoc[] docs = new FieldDoc[groups.size()];
        Object[] collapseValues = new Object[groups.size()];
        int scorePos = -1;
        for (int index = 0; index < this.sort.getSort().length; ++index) {
            SortField sortField = this.sort.getSort()[index];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            scorePos = index;
            break;
        }
        int pos = 0;
        Iterator it = this.orderedGroups.iterator();
        for (SearchGroup group : groups) {
            assert (it.hasNext());
            CollectedSearchGroup col = (CollectedSearchGroup)it.next();
            float score = Float.NaN;
            if (scorePos != -1) {
                score = ((Float)group.sortValues[scorePos]).floatValue();
            }
            docs[pos] = new FieldDoc(col.topDoc, score, group.sortValues);
            collapseValues[pos] = group.groupValue;
            ++pos;
        }
        TotalHits totalHits = new TotalHits((long)this.totalHitCount, TotalHits.Relation.EQUAL_TO);
        return new CollapseTopFieldDocs(this.collapseField, totalHits, (ScoreDoc[])docs, this.sort.getSort(), collapseValues);
    }

    public ScoreMode scoreMode() {
        if (super.scoreMode().needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public void setScorer(Scorable scorer) throws IOException {
        super.setScorer(scorer);
        this.scorer = scorer;
    }

    public void collect(int doc) throws IOException {
        if (this.after != null && !this.isAfterDoc(doc)) {
            ++this.totalHitCount;
            return;
        }
        super.collect(doc);
        ++this.totalHitCount;
    }

    private boolean isAfterDoc(int doc) throws IOException {
        if (this.leafComparator == null) {
            return true;
        }
        int cmp = this.reverseMul * this.leafComparator.compareTop(doc);
        if (cmp != 0) {
            return cmp < 0;
        }
        return doc > this.after.doc;
    }

    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        super.doSetNextReader(readerContext);
        if (this.after != null) {
            this.leafComparator = this.afterComparator.getLeafComparator(readerContext);
        }
    }

    public static CollapsingTopDocsCollector<?> createNumeric(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN) {
        return new CollapsingTopDocsCollector<Long>(new CollapsingDocValuesSource.Numeric(collapseFieldType), collapseField, sort, topN);
    }

    public static CollapsingTopDocsCollector<?> createNumeric(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN, FieldDoc after) {
        return new CollapsingTopDocsCollector<Long>(new CollapsingDocValuesSource.Numeric(collapseFieldType), collapseField, sort, topN, after);
    }

    public static CollapsingTopDocsCollector<?> createKeyword(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN) {
        return new CollapsingTopDocsCollector<BytesRef>(new CollapsingDocValuesSource.Keyword(collapseFieldType), collapseField, sort, topN);
    }

    public static CollapsingTopDocsCollector<?> createKeyword(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN, FieldDoc after) {
        return new CollapsingTopDocsCollector<BytesRef>(new CollapsingDocValuesSource.Keyword(collapseFieldType), collapseField, sort, topN, after);
    }
}

