/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.ldap2;

import java.nio.file.Path;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ldaptive.ActivePassiveConnectionStrategy;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.CompareRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.RandomConnectionStrategy;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.RoundRobinConnectionStrategy;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.CompareValidator;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.pool.SearchValidator;
import org.ldaptive.pool.SoftLimitConnectionPool;
import org.ldaptive.pool.Validator;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.ldaptive.sasl.ExternalConfig;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;
import org.ldaptive.ssl.AllowAnyTrustManager;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.CredentialConfigFactory;
import org.ldaptive.ssl.SslConfig;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auth.ldap2.MakeJava9Happy;
import org.opensearch.security.auth.ldap2.PrivilegedProvider;
import org.opensearch.security.setting.DeprecatedSettings;
import org.opensearch.security.util.SettingsBasedSSLConfigurator;

public class LDAPConnectionFactoryFactory {
    private static final Logger log = LogManager.getLogger(LDAPConnectionFactoryFactory.class);
    private final Settings settings;
    private final SettingsBasedSSLConfigurator.SSLConfig sslConfig;

    public LDAPConnectionFactoryFactory(Settings settings, Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        this.settings = settings;
        this.sslConfig = new SettingsBasedSSLConfigurator(settings, configPath, "").buildSSLConfig();
    }

    public ConnectionFactory createConnectionFactory(ConnectionPool connectionPool) {
        if (connectionPool != null) {
            return new PooledConnectionFactory(connectionPool);
        }
        return this.createBasicConnectionFactory();
    }

    public DefaultConnectionFactory createBasicConnectionFactory() {
        DefaultConnectionFactory result = new DefaultConnectionFactory(this.getConnectionConfig());
        result.setProvider((Provider)new PrivilegedProvider((Provider<JndiProviderConfig>)result.getProvider()));
        JndiProviderConfig jndiProviderConfig = (JndiProviderConfig)result.getProvider().getProviderConfig();
        jndiProviderConfig.setClassLoader(MakeJava9Happy.getClassLoader());
        if (this.sslConfig != null) {
            this.configureSSLinConnectionFactory(result);
        }
        return result;
    }

    public ConnectionPool createConnectionPool() {
        if (!this.settings.getAsBoolean("pool.enabled", Boolean.valueOf(false)).booleanValue()) {
            return null;
        }
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setMinPoolSize(this.settings.getAsInt("pool.min_size", Integer.valueOf(3)).intValue());
        poolConfig.setMaxPoolSize(this.settings.getAsInt("pool.max_size", Integer.valueOf(10)).intValue());
        if (this.settings.getAsBoolean("validation.enabled", Boolean.valueOf(false)).booleanValue()) {
            poolConfig.setValidateOnCheckIn(this.settings.getAsBoolean("validation.on_checkin", Boolean.valueOf(false)).booleanValue());
            poolConfig.setValidateOnCheckOut(this.settings.getAsBoolean("validation.on_checkout", Boolean.valueOf(false)).booleanValue());
            poolConfig.setValidatePeriodically(this.settings.getAsBoolean("validation.periodically", Boolean.valueOf(true)).booleanValue());
            poolConfig.setValidatePeriod(Duration.ofMinutes(this.settings.getAsLong("validation.period", Long.valueOf(30L))));
            poolConfig.setValidateTimeout(Duration.ofSeconds(this.settings.getAsLong("validation.timeout", Long.valueOf(5L))));
        }
        Object result = "blocking".equals(this.settings.get("pool.type")) ? new BlockingConnectionPool(poolConfig, this.createBasicConnectionFactory()) : new SoftLimitConnectionPool(poolConfig, this.createBasicConnectionFactory());
        result.setValidator(this.getConnectionValidator());
        DeprecatedSettings.checkForDeprecatedSetting(this.settings, "pruning.period", "pool.pruning_period");
        DeprecatedSettings.checkForDeprecatedSetting(this.settings, "pruning.idleTime", "pool.idle_time");
        result.setPruneStrategy((PruneStrategy)new IdlePruneStrategy(Duration.ofMinutes(this.settings.getAsLong("pool.pruning_period", this.settings.getAsLong("pruning.period", Long.valueOf(5L)))), Duration.ofMinutes(this.settings.getAsLong("pool.idle_time", this.settings.getAsLong("pruning.idleTime", Long.valueOf(10L))))));
        result.initialize();
        return result;
    }

    private ConnectionConfig getConnectionConfig() {
        ConnectionConfig result = new ConnectionConfig(this.getLdapUrlString());
        if (this.sslConfig != null) {
            this.configureSSL(result);
        }
        result.setConnectionStrategy(this.getConnectionStrategy());
        result.setConnectionInitializer(this.getConnectionInitializer());
        long connectTimeout = this.settings.getAsLong("connect_timeout", Long.valueOf(5000L));
        long responseTimeout = this.settings.getAsLong("response_timeout", Long.valueOf(0L));
        result.setConnectTimeout(Duration.ofMillis(connectTimeout < 0L ? 0L : connectTimeout));
        result.setResponseTimeout(Duration.ofMillis(responseTimeout < 0L ? 0L : responseTimeout));
        if (log.isDebugEnabled()) {
            log.debug("LDAP connection config:\n" + String.valueOf(result));
        }
        return result;
    }

    private ConnectionInitializer getConnectionInitializer() {
        BindConnectionInitializer result = new BindConnectionInitializer();
        String bindDn = this.settings.get("bind_dn", null);
        String password = this.settings.get("password", null);
        if (password != null && password.length() == 0) {
            password = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("bindDn {}, password {}", (Object)bindDn, (Object)(password != null ? "****" : "<not set>"));
        }
        if (bindDn != null && password == null) {
            log.error("No password given for bind_dn {}. Will try to authenticate anonymously to ldap", (Object)bindDn);
        }
        boolean enableClientAuth = this.settings.getAsBoolean("enable_ssl_client_auth", Boolean.valueOf(false));
        if (bindDn != null && password != null) {
            log.debug("Will perform simple bind with bind dn");
            result.setBindDn(bindDn);
            result.setBindCredential(new Credential(password));
            if (enableClientAuth) {
                log.warn("Will perform simple bind with bind dn because to bind dn is given and overrides client cert authentication");
            }
        } else if (enableClientAuth) {
            log.debug("Will perform External SASL bind because client cert authentication is enabled");
            result.setBindSaslConfig((SaslConfig)new ExternalConfig());
        } else {
            log.debug("Will perform anonymous bind because no bind dn or password is given");
        }
        return result;
    }

    private ConnectionStrategy getConnectionStrategy() {
        switch (this.settings.get("connection_strategy", "active_passive").toLowerCase()) {
            case "round_robin": {
                return new RoundRobinConnectionStrategy();
            }
            case "random": {
                return new RandomConnectionStrategy();
            }
        }
        return new ActivePassiveConnectionStrategy();
    }

    private Validator<Connection> getConnectionValidator() {
        if (!this.settings.getAsBoolean("validation.enabled", Boolean.valueOf(false)).booleanValue()) {
            return null;
        }
        String validationStrategy = this.settings.get("validation.strategy", "search");
        CompareValidator result = null;
        if ("compare".equalsIgnoreCase(validationStrategy)) {
            result = new CompareValidator(new CompareRequest(this.settings.get("validation.compare.dn", ""), new LdapAttribute(this.settings.get("validation.compare.attribute", "objectClass"), new String[]{this.settings.get("validation.compare.value", "top")})));
        } else {
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.setBaseDn(this.settings.get("validation.search.base_dn", ""));
            searchRequest.setSearchFilter(new SearchFilter(this.settings.get("validation.search.filter", "(objectClass=*)")));
            searchRequest.setReturnAttributes(ReturnAttributes.NONE.value());
            searchRequest.setSearchScope(SearchScope.OBJECT);
            searchRequest.setSizeLimit(1L);
            result = new SearchValidator(searchRequest);
        }
        return result;
    }

    private String getLdapUrlString() {
        List ldapHosts = this.settings.getAsList("hosts", Collections.singletonList("localhost"));
        boolean enableSSL = this.settings.getAsBoolean("enable_ssl", Boolean.valueOf(false));
        StringBuilder result = new StringBuilder();
        for (String ldapHost : ldapHosts) {
            if (result.length() > 0) {
                result.append(" ");
            }
            if (ldapHost.contains("://")) {
                result.append(ldapHost);
                continue;
            }
            if (enableSSL) {
                result.append("ldaps://").append(ldapHost);
                continue;
            }
            result.append("ldap://").append(ldapHost);
        }
        return result.toString();
    }

    private void configureSSL(ConnectionConfig config) {
        if (this.sslConfig == null) {
            return;
        }
        SslConfig ldaptiveSslConfig = new SslConfig();
        CredentialConfig cc = CredentialConfigFactory.createKeyStoreCredentialConfig((KeyStore)this.sslConfig.getEffectiveTruststore(), (String[])this.sslConfig.getEffectiveTruststoreAliasesArray(), (KeyStore)this.sslConfig.getEffectiveKeystore(), (String)this.sslConfig.getEffectiveKeyPasswordString(), (String[])this.sslConfig.getEffectiveKeyAliasesArray());
        ldaptiveSslConfig.setCredentialConfig(cc);
        if (!this.sslConfig.isHostnameVerificationEnabled()) {
            ldaptiveSslConfig.setHostnameVerifier((CertificateHostnameVerifier)new AllowAnyHostnameVerifier());
            if (!Boolean.parseBoolean(System.getProperty("com.sun.jndi.ldap.object.disableEndpointIdentification"))) {
                log.warn("In order to disable host name verification for LDAP connections (verify_hostnames: true), you also need to set set the system property com.sun.jndi.ldap.object.disableEndpointIdentification to true when starting the JVM running OpenSearch. This applies for all Java versions released since July 2018.");
            }
        }
        if (this.sslConfig.getSupportedCipherSuites() != null && this.sslConfig.getSupportedCipherSuites().length > 0) {
            ldaptiveSslConfig.setEnabledCipherSuites(this.sslConfig.getSupportedCipherSuites());
        }
        ldaptiveSslConfig.setEnabledProtocols(this.sslConfig.getSupportedProtocols());
        if (this.sslConfig.isTrustAllEnabled()) {
            ldaptiveSslConfig.setTrustManagers(new TrustManager[]{new AllowAnyTrustManager()});
        }
        config.setSslConfig(ldaptiveSslConfig);
        config.setUseSSL(true);
        config.setUseStartTLS(this.sslConfig.isStartTlsEnabled());
    }

    private void configureSSLinConnectionFactory(DefaultConnectionFactory connectionFactory) {
        if (this.sslConfig == null) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.sslConfig.isStartTlsEnabled() && !this.sslConfig.isHostnameVerificationEnabled()) {
            props.put("jndi.starttls.allowAnyHostname", "true");
        }
        connectionFactory.getProvider().getProviderConfig().setProperties(props);
    }
}

