/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.brotli;

import net.sourceforge.plantuml.brotli.BrotliRuntimeException;
import net.sourceforge.plantuml.brotli.State;
import net.sourceforge.plantuml.brotli.Utils;

final class BitReader {
    private static final boolean CHECK_UNUSED_BYTES_AFTER_END = false;
    private static final int LOG_BITNESS = 6;
    private static final int BITNESS = 64;
    private static final int BYTENESS = 8;
    private static final int CAPACITY = 4096;
    private static final int SLACK = 64;
    private static final int BUFFER_SIZE = 4160;
    private static final int SAFEGUARD = 36;
    private static final int WATERLINE = 4060;
    private static final int HALF_BITNESS = 32;
    private static final int HALF_SIZE = 4;
    private static final int HALVES_CAPACITY = 1024;
    private static final int HALF_BUFFER_SIZE = 1040;
    private static final int HALF_WATERLINE = 1015;
    private static final int LOG_HALF_SIZE = 2;

    BitReader() {
    }

    static void readMoreInput(State s) {
        if (s.halfOffset > 1015) {
            BitReader.doReadMoreInput(s);
        }
    }

    static void doReadMoreInput(State s) {
        int bytesInBuffer;
        int len;
        if (s.endOfStreamReached != 0) {
            if (BitReader.halfAvailable(s) >= -2) {
                return;
            }
            throw new BrotliRuntimeException("No more input");
        }
        int readOffset = s.halfOffset << 2;
        Utils.copyBytesWithin(s.byteBuffer, 0, readOffset, 4096);
        s.halfOffset = 0;
        for (bytesInBuffer = 4096 - readOffset; bytesInBuffer < 4096; bytesInBuffer += len) {
            int spaceLeft = 4096 - bytesInBuffer;
            len = Utils.readInput(s.input, s.byteBuffer, bytesInBuffer, spaceLeft);
            if (len > 0) continue;
            s.endOfStreamReached = 1;
            s.tailBytes = bytesInBuffer;
            bytesInBuffer += 3;
            break;
        }
        BitReader.bytesToNibbles(s, bytesInBuffer);
    }

    static void checkHealth(State s, int endOfStream) {
        if (s.endOfStreamReached == 0) {
            return;
        }
        int byteOffset = (s.halfOffset << 2) + (s.bitOffset + 7 >> 3) - 8;
        if (byteOffset > s.tailBytes) {
            throw new BrotliRuntimeException("Read after end");
        }
    }

    static void fillBitWindow(State s) {
        if (s.bitOffset >= 32) {
            s.accumulator64 = (long)s.intBuffer[s.halfOffset++] << 32 | s.accumulator64 >>> 32;
            s.bitOffset -= 32;
        }
    }

    private static void doFillBitWindow(State s) {
        s.accumulator64 = (long)s.intBuffer[s.halfOffset++] << 32 | s.accumulator64 >>> 32;
        s.bitOffset -= 32;
    }

    static int peekBits(State s) {
        return (int)(s.accumulator64 >>> s.bitOffset);
    }

    static int readFewBits(State s, int n) {
        int val = BitReader.peekBits(s) & (1 << n) - 1;
        s.bitOffset += n;
        return val;
    }

    static int readBits(State s, int n) {
        return BitReader.readFewBits(s, n);
    }

    private static int readManyBits(State s, int n) {
        int low = BitReader.readFewBits(s, 16);
        BitReader.doFillBitWindow(s);
        return low | BitReader.readFewBits(s, n - 16) << 16;
    }

    static void initBitReader(State s) {
        s.byteBuffer = new byte[4160];
        s.accumulator64 = 0L;
        s.intBuffer = new int[1040];
        s.bitOffset = 64;
        s.halfOffset = 1024;
        s.endOfStreamReached = 0;
        BitReader.prepare(s);
    }

    private static void prepare(State s) {
        BitReader.readMoreInput(s);
        BitReader.checkHealth(s, 0);
        BitReader.doFillBitWindow(s);
        BitReader.doFillBitWindow(s);
    }

    static void reload(State s) {
        if (s.bitOffset == 64) {
            BitReader.prepare(s);
        }
    }

    static void jumpToByteBoundary(State s) {
        int paddingBits;
        int padding = 64 - s.bitOffset & 7;
        if (padding != 0 && (paddingBits = BitReader.readFewBits(s, padding)) != 0) {
            throw new BrotliRuntimeException("Corrupted padding bits");
        }
    }

    static int halfAvailable(State s) {
        int limit = 1024;
        if (s.endOfStreamReached != 0) {
            limit = s.tailBytes + 3 >> 2;
        }
        return limit - s.halfOffset;
    }

    static void copyBytes(State s, byte[] data, int offset, int length) {
        if ((s.bitOffset & 7) != 0) {
            throw new BrotliRuntimeException("Unaligned copyBytes");
        }
        while (s.bitOffset != 64 && length != 0) {
            data[offset++] = (byte)BitReader.peekBits(s);
            s.bitOffset += 8;
            --length;
        }
        if (length == 0) {
            return;
        }
        int copyNibbles = Math.min(BitReader.halfAvailable(s), length >> 2);
        if (copyNibbles > 0) {
            int readOffset = s.halfOffset << 2;
            int delta = copyNibbles << 2;
            System.arraycopy(s.byteBuffer, readOffset, data, offset, delta);
            offset += delta;
            length -= delta;
            s.halfOffset += copyNibbles;
        }
        if (length == 0) {
            return;
        }
        if (BitReader.halfAvailable(s) > 0) {
            BitReader.fillBitWindow(s);
            while (length != 0) {
                data[offset++] = (byte)BitReader.peekBits(s);
                s.bitOffset += 8;
                --length;
            }
            BitReader.checkHealth(s, 0);
            return;
        }
        while (length > 0) {
            int len = Utils.readInput(s.input, data, offset, length);
            if (len == -1) {
                throw new BrotliRuntimeException("Unexpected end of input");
            }
            offset += len;
            length -= len;
        }
    }

    static void bytesToNibbles(State s, int byteLen) {
        byte[] byteBuffer = s.byteBuffer;
        int halfLen = byteLen >> 2;
        int[] intBuffer = s.intBuffer;
        for (int i = 0; i < halfLen; ++i) {
            intBuffer[i] = byteBuffer[i * 4] & 0xFF | (byteBuffer[i * 4 + 1] & 0xFF) << 8 | (byteBuffer[i * 4 + 2] & 0xFF) << 16 | (byteBuffer[i * 4 + 3] & 0xFF) << 24;
        }
    }
}

