// components/printing/common/print.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/printing/common/print.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace printing::mojom {
class PreviewIdsDataView;

class RequestPrintPreviewParamsDataView;

class PrintFrameContentParamsDataView;

class OptionsFromDocumentParamsDataView;

class DidPrintContentParamsDataView;

class DidStartPreviewParamsDataView;

class DidPreviewPageParamsDataView;

class DidPreviewDocumentParamsDataView;

class PrintParamsDataView;

class PrintPagesParamsDataView;

class DidPrintDocumentParamsDataView;

class ScriptedPrintParamsDataView;

class PrintWithParamsResultDataDataView;

class PrintWithParamsResultDataView;


}  // printing::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PreviewIdsDataView> {
  using Data = ::printing::mojom::internal::PreviewIds_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::RequestPrintPreviewParamsDataView> {
  using Data = ::printing::mojom::internal::RequestPrintPreviewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintFrameContentParamsDataView> {
  using Data = ::printing::mojom::internal::PrintFrameContentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::OptionsFromDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::OptionsFromDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPrintContentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPrintContentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidStartPreviewParamsDataView> {
  using Data = ::printing::mojom::internal::DidStartPreviewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPreviewPageParamsDataView> {
  using Data = ::printing::mojom::internal::DidPreviewPageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPreviewDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPreviewDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintParamsDataView> {
  using Data = ::printing::mojom::internal::PrintParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintPagesParamsDataView> {
  using Data = ::printing::mojom::internal::PrintPagesParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPrintDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPrintDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::ScriptedPrintParamsDataView> {
  using Data = ::printing::mojom::internal::ScriptedPrintParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintWithParamsResultDataDataView> {
  using Data = ::printing::mojom::internal::PrintWithParamsResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintWithParamsResultDataView> {
  using Data = ::printing::mojom::internal::PrintWithParamsResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


enum class PrintFailureReason : int32_t {
  
  kGeneralFailure = 0,
  
  kInvalidPageRange = 1,
  
  kPrintingInProgress = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PrintFailureReason value);
inline bool IsKnownEnumValue(PrintFailureReason value) {
  return internal::PrintFailureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PrintPreviewUIInterfaceBase {};

using PrintPreviewUIPtrDataView =
    mojo::InterfacePtrDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIRequestDataView =
    mojo::InterfaceRequestDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintPreviewUIInterfaceBase>;
class PrintRenderFrameInterfaceBase {};

using PrintRenderFramePtrDataView =
    mojo::InterfacePtrDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameRequestDataView =
    mojo::InterfaceRequestDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintRenderFrameInterfaceBase>;
class PrintManagerHostInterfaceBase {};

using PrintManagerHostPtrDataView =
    mojo::InterfacePtrDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostRequestDataView =
    mojo::InterfaceRequestDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintManagerHostInterfaceBase>;


class PreviewIdsDataView {
 public:
  PreviewIdsDataView() = default;

  PreviewIdsDataView(
      internal::PreviewIds_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  int32_t ui_id() const {
    return data_->ui_id;
  }
 private:
  internal::PreviewIds_Data* data_ = nullptr;
};


class RequestPrintPreviewParamsDataView {
 public:
  RequestPrintPreviewParamsDataView() = default;

  RequestPrintPreviewParamsDataView(
      internal::RequestPrintPreviewParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_modifiable() const {
    return data_->is_modifiable;
  }
  bool webnode_only() const {
    return data_->webnode_only;
  }
  bool has_selection() const {
    return data_->has_selection;
  }
  bool selection_only() const {
    return data_->selection_only;
  }
 private:
  internal::RequestPrintPreviewParams_Data* data_ = nullptr;
};


class PrintFrameContentParamsDataView {
 public:
  PrintFrameContentParamsDataView() = default;

  PrintFrameContentParamsDataView(
      internal::PrintFrameContentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
 private:
  internal::PrintFrameContentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OptionsFromDocumentParamsDataView {
 public:
  OptionsFromDocumentParamsDataView() = default;

  OptionsFromDocumentParamsDataView(
      internal::OptionsFromDocumentParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_scaling_disabled() const {
    return data_->is_scaling_disabled;
  }
  int32_t copies() const {
    return data_->copies;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDuplex(UserType* output) const {
    auto data_value = data_->duplex;
    return mojo::internal::Deserialize<::printing::mojom::DuplexMode>(
        data_value, output);
  }
  ::printing::mojom::DuplexMode duplex() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::DuplexMode>(data_->duplex));
  }
 private:
  internal::OptionsFromDocumentParams_Data* data_ = nullptr;
};


class DidPrintContentParamsDataView {
 public:
  DidPrintContentParamsDataView() = default;

  DidPrintContentParamsDataView(
      internal::DidPrintContentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetafileDataRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetafileDataRegion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `metafile_data_region` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetafileDataRegion` instead "
    "of `ReadMetafileDataRegion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->metafile_data_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetSubframeContentInfoDataView(
      mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframeContentInfo(UserType* output) {
    
    auto* pointer = data_->subframe_content_info.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DidPrintContentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidStartPreviewParamsDataView {
 public:
  DidStartPreviewParamsDataView() = default;

  DidStartPreviewParamsDataView(
      internal::DidStartPreviewParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t page_count() const {
    return data_->page_count;
  }
  inline void GetPagesToRenderDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPagesToRender(UserType* output) {
    
    auto* pointer = data_->pages_to_render.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  int32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  int32_t fit_to_page_scaling() const {
    return data_->fit_to_page_scaling;
  }
 private:
  internal::DidStartPreviewParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidPreviewPageParamsDataView {
 public:
  DidPreviewPageParamsDataView() = default;

  DidPreviewPageParamsDataView(
      internal::DidPreviewPageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, message_);
  }
  uint32_t page_index() const {
    return data_->page_index;
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
 private:
  internal::DidPreviewPageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidPreviewDocumentParamsDataView {
 public:
  DidPreviewDocumentParamsDataView() = default;

  DidPreviewDocumentParamsDataView(
      internal::DidPreviewDocumentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, message_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  uint32_t expected_pages_count() const {
    return data_->expected_pages_count;
  }
 private:
  internal::DidPreviewDocumentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintParamsDataView {
 public:
  PrintParamsDataView() = default;

  PrintParamsDataView(
      internal::PrintParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  inline void GetContentSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSize(UserType* output) {
    
    auto* pointer = data_->content_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, message_);
  }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  float margin_top() const {
    return data_->margin_top;
  }
  float margin_left() const {
    return data_->margin_left;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPageOrientation(UserType* output) const {
    auto data_value = data_->page_orientation;
    return mojo::internal::Deserialize<::printing::mojom::PageOrientation>(
        data_value, output);
  }
  ::printing::mojom::PageOrientation page_orientation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PageOrientation>(data_->page_orientation));
  }
  inline void GetDpiDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDpi(UserType* output) {
    
    auto* pointer = data_->dpi.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  double scale_factor() const {
    return data_->scale_factor;
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  bool selection_only() const {
    return data_->selection_only;
  }
  int32_t preview_ui_id() const {
    return data_->preview_ui_id;
  }
  int32_t preview_request_id() const {
    return data_->preview_request_id;
  }
  bool is_first_request() const {
    return data_->is_first_request;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintScalingOption(UserType* output) const {
    auto data_value = data_->print_scaling_option;
    return mojo::internal::Deserialize<::printing::mojom::PrintScalingOption>(
        data_value, output);
  }
  ::printing::mojom::PrintScalingOption print_scaling_option() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PrintScalingOption>(data_->print_scaling_option));
  }
  bool print_to_pdf() const {
    return data_->print_to_pdf;
  }
  bool display_header_footer() const {
    return data_->display_header_footer;
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetHeaderTemplateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaderTemplate(UserType* output) {
    
    auto* pointer = data_->header_template.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetFooterTemplateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFooterTemplate(UserType* output) {
    
    auto* pointer = data_->footer_template.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool rasterize_pdf() const {
    return data_->rasterize_pdf;
  }
  int32_t rasterize_pdf_dpi() const {
    return data_->rasterize_pdf_dpi;
  }
  bool should_print_backgrounds() const {
    return data_->should_print_backgrounds;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrintedDocType(UserType* output) const {
    auto data_value = data_->printed_doc_type;
    return mojo::internal::Deserialize<::printing::mojom::SkiaDocumentType>(
        data_value, output);
  }
  ::printing::mojom::SkiaDocumentType printed_doc_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::SkiaDocumentType>(data_->printed_doc_type));
  }
  bool prefer_css_page_size() const {
    return data_->prefer_css_page_size;
  }
  uint32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  std::optional<bool> generate_tagged_pdf() const {

    return data_->generate_tagged_pdf_$flag
        ? std::make_optional(!!data_->generate_tagged_pdf_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGenerateDocumentOutline(UserType* output) const {
    auto data_value = data_->generate_document_outline;
    return mojo::internal::Deserialize<::printing::mojom::GenerateDocumentOutline>(
        data_value, output);
  }
  ::printing::mojom::GenerateDocumentOutline generate_document_outline() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::GenerateDocumentOutline>(data_->generate_document_outline));
  }
 private:
  internal::PrintParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintPagesParamsDataView {
 public:
  PrintPagesParamsDataView() = default;

  PrintPagesParamsDataView(
      internal::PrintPagesParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      PrintParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::PrintParamsDataView>(
        pointer, output, message_);
  }
  inline void GetPagesDataView(
      mojo::ArrayDataView<::printing::mojom::PageRangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPages(UserType* output) {
    
    auto* pointer = data_->pages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::PageRangeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PrintPagesParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DidPrintDocumentParamsDataView {
 public:
  DidPrintDocumentParamsDataView() = default;

  DidPrintDocumentParamsDataView(
      internal::DidPrintDocumentParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, message_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetContentAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentArea(UserType* output) {
    
    auto* pointer = data_->content_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetPhysicalOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhysicalOffsets(UserType* output) {
    
    auto* pointer = data_->physical_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
 private:
  internal::DidPrintDocumentParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScriptedPrintParamsDataView {
 public:
  ScriptedPrintParamsDataView() = default;

  ScriptedPrintParamsDataView(
      internal::ScriptedPrintParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t cookie() const {
    return data_->cookie;
  }
  uint32_t expected_pages_count() const {
    return data_->expected_pages_count;
  }
  bool has_selection() const {
    return data_->has_selection;
  }
  bool is_scripted() const {
    return data_->is_scripted;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMarginType(UserType* output) const {
    auto data_value = data_->margin_type;
    return mojo::internal::Deserialize<::printing::mojom::MarginType>(
        data_value, output);
  }
  ::printing::mojom::MarginType margin_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::MarginType>(data_->margin_type));
  }
 private:
  internal::ScriptedPrintParams_Data* data_ = nullptr;
};


class PrintWithParamsResultDataDataView {
 public:
  PrintWithParamsResultDataDataView() = default;

  PrintWithParamsResultDataDataView(
      internal::PrintWithParamsResultData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      DidPrintDocumentParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintDocumentParamsDataView>(
        pointer, output, message_);
  }
  inline void GetAccessibilityTreeDataView(
      ::ax::mojom::AXTreeUpdateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessibilityTree(UserType* output) {
    
    auto* pointer = data_->accessibility_tree.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXTreeUpdateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGenerateDocumentOutline(UserType* output) const {
    auto data_value = data_->generate_document_outline;
    return mojo::internal::Deserialize<::printing::mojom::GenerateDocumentOutline>(
        data_value, output);
  }
  ::printing::mojom::GenerateDocumentOutline generate_document_outline() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::GenerateDocumentOutline>(data_->generate_document_outline));
  }
 private:
  internal::PrintWithParamsResultData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintWithParamsResultDataView {
 public:
  using Tag = internal::PrintWithParamsResult_Data::PrintWithParamsResult_Tag;

  PrintWithParamsResultDataView() = default;

  PrintWithParamsResultDataView(
      internal::PrintWithParamsResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_data() const { return data_->tag == Tag::kData; }
  inline void GetDataDataView(
      PrintWithParamsResultDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) const {
    
    CHECK(is_data());
    return mojo::internal::Deserialize<::printing::mojom::PrintWithParamsResultDataDataView>(
        data_->data.f_data.Get(), output, message_);
  }
  bool is_failure_reason() const { return data_->tag == Tag::kFailureReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    CHECK(is_failure_reason());
    return mojo::internal::Deserialize<::printing::mojom::PrintFailureReason>(
        data_->data.f_failure_reason, output);
  }
  PrintFailureReason failure_reason() const {
    CHECK(is_failure_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PrintFailureReason>(data_->data.f_failure_reason));
  }

 private:
  internal::PrintWithParamsResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // printing::mojom

namespace std {

template <>
struct hash<::printing::mojom::PrintFailureReason>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PrintFailureReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintFailureReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PrintFailureReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PrintFailureReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PreviewIdsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PreviewIdsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PreviewIds_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->request_id = Traits::request_id(input);
    fragment->ui_id = Traits::ui_id(input);
  }

  static bool Deserialize(::printing::mojom::internal::PreviewIds_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PreviewIdsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::RequestPrintPreviewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::RequestPrintPreviewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::RequestPrintPreviewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_modifiable = Traits::is_modifiable(input);
    fragment->webnode_only = Traits::webnode_only(input);
    fragment->has_selection = Traits::has_selection(input);
    fragment->selection_only = Traits::selection_only(input);
  }

  static bool Deserialize(::printing::mojom::internal::RequestPrintPreviewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::RequestPrintPreviewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintFrameContentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintFrameContentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintFrameContentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printable_area)::BaseType> printable_area_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_printable_area, printable_area_fragment);
    fragment->printable_area.Set(
        printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->printable_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printable_area in PrintFrameContentParams struct");
    fragment->document_cookie = Traits::document_cookie(input);
  }

  static bool Deserialize(::printing::mojom::internal::PrintFrameContentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintFrameContentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::OptionsFromDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::OptionsFromDocumentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::OptionsFromDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_scaling_disabled = Traits::is_scaling_disabled(input);
    fragment->copies = Traits::copies(input);
    mojo::internal::Serialize<::printing::mojom::DuplexMode>(
        Traits::duplex(input), &fragment->duplex);
  }

  static bool Deserialize(::printing::mojom::internal::OptionsFromDocumentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::OptionsFromDocumentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPrintContentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintContentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPrintContentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::metafile_data_region(input)) in_metafile_data_region = Traits::metafile_data_region(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metafile_data_region)::BaseType> metafile_data_region_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        in_metafile_data_region, metafile_data_region_fragment);
    fragment->metafile_data_region.Set(
        metafile_data_region_fragment.is_null() ? nullptr : metafile_data_region_fragment.data());
    decltype(Traits::subframe_content_info(input)) in_subframe_content_info = Traits::subframe_content_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subframe_content_info)::BaseType>
        subframe_content_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        in_subframe_content_info, subframe_content_info_fragment, &subframe_content_info_validate_params);
    fragment->subframe_content_info.Set(
        subframe_content_info_fragment.is_null() ? nullptr : subframe_content_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->subframe_content_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframe_content_info in DidPrintContentParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::DidPrintContentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPrintContentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidStartPreviewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidStartPreviewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidStartPreviewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->page_count = Traits::page_count(input);
    decltype(Traits::pages_to_render(input)) in_pages_to_render = Traits::pages_to_render(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pages_to_render)::BaseType>
        pages_to_render_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pages_to_render_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_pages_to_render, pages_to_render_fragment, &pages_to_render_validate_params);
    fragment->pages_to_render.Set(
        pages_to_render_fragment.is_null() ? nullptr : pages_to_render_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pages_to_render.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pages_to_render in DidStartPreviewParams struct");
    fragment->pages_per_sheet = Traits::pages_per_sheet(input);
    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_size)::BaseType> page_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_page_size, page_size_fragment);
    fragment->page_size.Set(
        page_size_fragment.is_null() ? nullptr : page_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->page_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in DidStartPreviewParams struct");
    fragment->fit_to_page_scaling = Traits::fit_to_page_scaling(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidStartPreviewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidStartPreviewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPreviewPageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewPageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPreviewPageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType> content_fragment(
            fragment.message());
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
        in_content, content_fragment);
    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPreviewPageParams struct");
    fragment->page_index = Traits::page_index(input);
    fragment->document_cookie = Traits::document_cookie(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidPreviewPageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPreviewPageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPreviewDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewDocumentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPreviewDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType> content_fragment(
            fragment.message());
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
        in_content, content_fragment);
    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPreviewDocumentParams struct");
    fragment->document_cookie = Traits::document_cookie(input);
    fragment->expected_pages_count = Traits::expected_pages_count(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidPreviewDocumentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPreviewDocumentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_size)::BaseType> page_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_page_size, page_size_fragment);
    fragment->page_size.Set(
        page_size_fragment.is_null() ? nullptr : page_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->page_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in PrintParams struct");
    decltype(Traits::content_size(input)) in_content_size = Traits::content_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_size)::BaseType> content_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_content_size, content_size_fragment);
    fragment->content_size.Set(
        content_size_fragment.is_null() ? nullptr : content_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_size in PrintParams struct");
    decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printable_area)::BaseType> printable_area_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_printable_area, printable_area_fragment);
    fragment->printable_area.Set(
        printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->printable_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printable_area in PrintParams struct");
    fragment->margin_top = Traits::margin_top(input);
    fragment->margin_left = Traits::margin_left(input);
    mojo::internal::Serialize<::printing::mojom::PageOrientation>(
        Traits::page_orientation(input), &fragment->page_orientation);
    decltype(Traits::dpi(input)) in_dpi = Traits::dpi(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dpi)::BaseType> dpi_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_dpi, dpi_fragment);
    fragment->dpi.Set(
        dpi_fragment.is_null() ? nullptr : dpi_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->dpi.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dpi in PrintParams struct");
    fragment->scale_factor = Traits::scale_factor(input);
    fragment->document_cookie = Traits::document_cookie(input);
    fragment->selection_only = Traits::selection_only(input);
    fragment->preview_ui_id = Traits::preview_ui_id(input);
    fragment->preview_request_id = Traits::preview_request_id(input);
    fragment->is_first_request = Traits::is_first_request(input);
    mojo::internal::Serialize<::printing::mojom::PrintScalingOption>(
        Traits::print_scaling_option(input), &fragment->print_scaling_option);
    fragment->print_to_pdf = Traits::print_to_pdf(input);
    fragment->display_header_footer = Traits::display_header_footer(input);
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in PrintParams struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PrintParams struct");
    decltype(Traits::header_template(input)) in_header_template = Traits::header_template(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header_template)::BaseType> header_template_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_header_template, header_template_fragment);
    fragment->header_template.Set(
        header_template_fragment.is_null() ? nullptr : header_template_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->header_template.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_template in PrintParams struct");
    decltype(Traits::footer_template(input)) in_footer_template = Traits::footer_template(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->footer_template)::BaseType> footer_template_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_footer_template, footer_template_fragment);
    fragment->footer_template.Set(
        footer_template_fragment.is_null() ? nullptr : footer_template_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->footer_template.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null footer_template in PrintParams struct");
    fragment->rasterize_pdf = Traits::rasterize_pdf(input);
    fragment->rasterize_pdf_dpi = Traits::rasterize_pdf_dpi(input);
    fragment->should_print_backgrounds = Traits::should_print_backgrounds(input);
    mojo::internal::Serialize<::printing::mojom::SkiaDocumentType>(
        Traits::printed_doc_type(input), &fragment->printed_doc_type);
    fragment->prefer_css_page_size = Traits::prefer_css_page_size(input);
    fragment->pages_per_sheet = Traits::pages_per_sheet(input);
    fragment->generate_tagged_pdf_$flag = Traits::generate_tagged_pdf(input).has_value();
    if (Traits::generate_tagged_pdf(input).has_value()) {
      fragment->generate_tagged_pdf_$value = Traits::generate_tagged_pdf(input).value();
    }
    mojo::internal::Serialize<::printing::mojom::GenerateDocumentOutline>(
        Traits::generate_document_outline(input), &fragment->generate_document_outline);
  }

  static bool Deserialize(::printing::mojom::internal::PrintParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintPagesParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintPagesParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintPagesParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    mojo::internal::Serialize<::printing::mojom::PrintParamsDataView>(
        in_params, params_fragment);
    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in PrintPagesParams struct");
    decltype(Traits::pages(input)) in_pages = Traits::pages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pages)::BaseType>
        pages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pages_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PageRangeDataView>>(
        in_pages, pages_fragment, &pages_validate_params);
    fragment->pages.Set(
        pages_fragment.is_null() ? nullptr : pages_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pages.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pages in PrintPagesParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::PrintPagesParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintPagesParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPrintDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintDocumentParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::DidPrintDocumentParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType> content_fragment(
            fragment.message());
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
        in_content, content_fragment);
    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPrintDocumentParams struct");
    fragment->document_cookie = Traits::document_cookie(input);
    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_size)::BaseType> page_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_page_size, page_size_fragment);
    fragment->page_size.Set(
        page_size_fragment.is_null() ? nullptr : page_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->page_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in DidPrintDocumentParams struct");
    decltype(Traits::content_area(input)) in_content_area = Traits::content_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_area)::BaseType> content_area_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_content_area, content_area_fragment);
    fragment->content_area.Set(
        content_area_fragment.is_null() ? nullptr : content_area_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_area in DidPrintDocumentParams struct");
    decltype(Traits::physical_offsets(input)) in_physical_offsets = Traits::physical_offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->physical_offsets)::BaseType> physical_offsets_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_physical_offsets, physical_offsets_fragment);
    fragment->physical_offsets.Set(
        physical_offsets_fragment.is_null() ? nullptr : physical_offsets_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->physical_offsets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null physical_offsets in DidPrintDocumentParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::DidPrintDocumentParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPrintDocumentParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::ScriptedPrintParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::ScriptedPrintParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::ScriptedPrintParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->cookie = Traits::cookie(input);
    fragment->expected_pages_count = Traits::expected_pages_count(input);
    fragment->has_selection = Traits::has_selection(input);
    fragment->is_scripted = Traits::is_scripted(input);
    mojo::internal::Serialize<::printing::mojom::MarginType>(
        Traits::margin_type(input), &fragment->margin_type);
  }

  static bool Deserialize(::printing::mojom::internal::ScriptedPrintParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::ScriptedPrintParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintWithParamsResultDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintWithParamsResultDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrintWithParamsResultData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    mojo::internal::Serialize<::printing::mojom::DidPrintDocumentParamsDataView>(
        in_params, params_fragment);
    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in PrintWithParamsResultData struct");
    decltype(Traits::accessibility_tree(input)) in_accessibility_tree = Traits::accessibility_tree(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accessibility_tree)::BaseType> accessibility_tree_fragment(
            fragment.message());
    mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
        in_accessibility_tree, accessibility_tree_fragment);
    fragment->accessibility_tree.Set(
        accessibility_tree_fragment.is_null() ? nullptr : accessibility_tree_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->accessibility_tree.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accessibility_tree in PrintWithParamsResultData struct");
    mojo::internal::Serialize<::printing::mojom::GenerateDocumentOutline>(
        Traits::generate_document_outline(input), &fragment->generate_document_outline);
  }

  static bool Deserialize(::printing::mojom::internal::PrintWithParamsResultData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintWithParamsResultDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintWithParamsResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintWithParamsResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintWithParamsResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::printing::mojom::PrintWithParamsResultDataView::Tag::kData: {
        decltype(Traits::data(input))
            in_data = Traits::data(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_data)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::printing::mojom::PrintWithParamsResultDataDataView>(
            in_data, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null data in PrintWithParamsResult union");
        fragment->data.f_data.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::printing::mojom::PrintWithParamsResultDataView::Tag::kFailureReason: {
        decltype(Traits::failure_reason(input))
            in_failure_reason = Traits::failure_reason(input);
        mojo::internal::Serialize<::printing::mojom::PrintFailureReason>(
            in_failure_reason, &fragment->data.f_failure_reason);
        break;
      }
    }
  }

  static bool Deserialize(::printing::mojom::internal::PrintWithParamsResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintWithParamsResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing::mojom {





inline void PrintFrameContentParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}




inline void DidPrintContentParamsDataView::GetMetafileDataRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->metafile_data_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void DidPrintContentParamsDataView::GetSubframeContentInfoDataView(
    mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->subframe_content_info.Get();
  *output = mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, message_);
}


inline void DidStartPreviewParamsDataView::GetPagesToRenderDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->pages_to_render.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void DidStartPreviewParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}


inline void DidPreviewPageParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, message_);
}


inline void DidPreviewDocumentParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, message_);
}


inline void PrintParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}
inline void PrintParamsDataView::GetContentSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->content_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}
inline void PrintParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void PrintParamsDataView::GetDpiDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->dpi.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PrintParamsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintParamsDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintParamsDataView::GetHeaderTemplateDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_template.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void PrintParamsDataView::GetFooterTemplateDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->footer_template.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void PrintPagesParamsDataView::GetParamsDataView(
    PrintParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = PrintParamsDataView(pointer, message_);
}
inline void PrintPagesParamsDataView::GetPagesDataView(
    mojo::ArrayDataView<::printing::mojom::PageRangeDataView>* output) {
  auto pointer = data_->pages.Get();
  *output = mojo::ArrayDataView<::printing::mojom::PageRangeDataView>(pointer, message_);
}


inline void DidPrintDocumentParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, message_);
}
inline void DidPrintDocumentParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void DidPrintDocumentParamsDataView::GetContentAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->content_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void DidPrintDocumentParamsDataView::GetPhysicalOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->physical_offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}




inline void PrintWithParamsResultDataDataView::GetParamsDataView(
    DidPrintDocumentParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = DidPrintDocumentParamsDataView(pointer, message_);
}
inline void PrintWithParamsResultDataDataView::GetAccessibilityTreeDataView(
    ::ax::mojom::AXTreeUpdateDataView* output) {
  auto pointer = data_->accessibility_tree.Get();
  *output = ::ax::mojom::AXTreeUpdateDataView(pointer, message_);
}


inline void PrintWithParamsResultDataView::GetDataDataView(
    PrintWithParamsResultDataDataView* output) const {
  CHECK(is_data());
  *output = PrintWithParamsResultDataDataView(data_->data.f_data.Get(), message_);
}


}  // printing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::PrintFailureReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::PrintFailureReason value);
};

} // namespace perfetto

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_