// components/printing/common/print.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/printing/common/print.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/printing/common/print.mojom-params-data.h"
#include "components/printing/common/print.mojom-shared-message-ids.h"

#include "components/printing/common/print.mojom-import-headers.h"
#include "components/printing/common/print.mojom-test-utils.h"


namespace printing::mojom {
PreviewIds::PreviewIds()
    : request_id(-1),
      ui_id(-1) {}

PreviewIds::PreviewIds(
    int32_t request_id_in,
    int32_t ui_id_in)
    : request_id(std::move(request_id_in)),
      ui_id(std::move(ui_id_in)) {}

PreviewIds::~PreviewIds() = default;
size_t PreviewIds::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->request_id);
  seed = mojo::internal::Hash(seed, this->ui_id);
  return seed;
}

void PreviewIds::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ui_id"), this->ui_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PreviewIds::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestPrintPreviewParams::RequestPrintPreviewParams()
    : is_modifiable(false),
      webnode_only(false),
      has_selection(false),
      selection_only(false) {}

RequestPrintPreviewParams::RequestPrintPreviewParams(
    bool is_modifiable_in,
    bool webnode_only_in,
    bool has_selection_in,
    bool selection_only_in)
    : is_modifiable(std::move(is_modifiable_in)),
      webnode_only(std::move(webnode_only_in)),
      has_selection(std::move(has_selection_in)),
      selection_only(std::move(selection_only_in)) {}

RequestPrintPreviewParams::~RequestPrintPreviewParams() = default;
size_t RequestPrintPreviewParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_modifiable);
  seed = mojo::internal::Hash(seed, this->webnode_only);
  seed = mojo::internal::Hash(seed, this->has_selection);
  seed = mojo::internal::Hash(seed, this->selection_only);
  return seed;
}

void RequestPrintPreviewParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_modifiable"), this->is_modifiable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webnode_only"), this->webnode_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_selection"), this->has_selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_only"), this->selection_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestPrintPreviewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintFrameContentParams::PrintFrameContentParams()
    : printable_area(),
      document_cookie() {}

PrintFrameContentParams::PrintFrameContentParams(
    const ::gfx::Rect& printable_area_in,
    int32_t document_cookie_in)
    : printable_area(std::move(printable_area_in)),
      document_cookie(std::move(document_cookie_in)) {}

PrintFrameContentParams::~PrintFrameContentParams() = default;

void PrintFrameContentParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printable_area"), this->printable_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintFrameContentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OptionsFromDocumentParams::OptionsFromDocumentParams()
    : is_scaling_disabled(),
      copies(),
      duplex() {}

OptionsFromDocumentParams::OptionsFromDocumentParams(
    bool is_scaling_disabled_in,
    int32_t copies_in,
    ::printing::mojom::DuplexMode duplex_in)
    : is_scaling_disabled(std::move(is_scaling_disabled_in)),
      copies(std::move(copies_in)),
      duplex(std::move(duplex_in)) {}

OptionsFromDocumentParams::~OptionsFromDocumentParams() = default;
size_t OptionsFromDocumentParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_scaling_disabled);
  seed = mojo::internal::Hash(seed, this->copies);
  seed = mojo::internal::Hash(seed, this->duplex);
  return seed;
}

void OptionsFromDocumentParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_scaling_disabled"), this->is_scaling_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copies"), this->copies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplex"), this->duplex,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::DuplexMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OptionsFromDocumentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPrintContentParams::DidPrintContentParams()
    : metafile_data_region(),
      subframe_content_info() {}

DidPrintContentParams::DidPrintContentParams(
    ::base::ReadOnlySharedMemoryRegion metafile_data_region_in,
    const base::flat_map<uint32_t, ::base::UnguessableToken>& subframe_content_info_in)
    : metafile_data_region(std::move(metafile_data_region_in)),
      subframe_content_info(std::move(subframe_content_info_in)) {}

DidPrintContentParams::~DidPrintContentParams() = default;

void DidPrintContentParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metafile_data_region"), this->metafile_data_region,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ReadOnlySharedMemoryRegion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframe_content_info"), this->subframe_content_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint32_t, ::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPrintContentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidStartPreviewParams::DidStartPreviewParams()
    : page_count(),
      pages_to_render(),
      pages_per_sheet(),
      page_size(),
      fit_to_page_scaling() {}

DidStartPreviewParams::DidStartPreviewParams(
    uint32_t page_count_in,
    std::vector<uint32_t> pages_to_render_in,
    int32_t pages_per_sheet_in,
    const ::gfx::SizeF& page_size_in,
    int32_t fit_to_page_scaling_in)
    : page_count(std::move(page_count_in)),
      pages_to_render(std::move(pages_to_render_in)),
      pages_per_sheet(std::move(pages_per_sheet_in)),
      page_size(std::move(page_size_in)),
      fit_to_page_scaling(std::move(fit_to_page_scaling_in)) {}

DidStartPreviewParams::~DidStartPreviewParams() = default;

void DidStartPreviewParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_count"), this->page_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_to_render"), this->pages_to_render,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_per_sheet"), this->pages_per_sheet,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_size"), this->page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::SizeF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fit_to_page_scaling"), this->fit_to_page_scaling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidStartPreviewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPreviewPageParams::DidPreviewPageParams()
    : content(),
      page_index(),
      document_cookie() {}

DidPreviewPageParams::DidPreviewPageParams(
    DidPrintContentParamsPtr content_in,
    uint32_t page_index_in,
    int32_t document_cookie_in)
    : content(std::move(content_in)),
      page_index(std::move(page_index_in)),
      document_cookie(std::move(document_cookie_in)) {}

DidPreviewPageParams::~DidPreviewPageParams() = default;

void DidPreviewPageParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DidPrintContentParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_index"), this->page_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPreviewPageParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPreviewDocumentParams::DidPreviewDocumentParams()
    : content(),
      document_cookie(),
      expected_pages_count() {}

DidPreviewDocumentParams::DidPreviewDocumentParams(
    DidPrintContentParamsPtr content_in,
    int32_t document_cookie_in,
    uint32_t expected_pages_count_in)
    : content(std::move(content_in)),
      document_cookie(std::move(document_cookie_in)),
      expected_pages_count(std::move(expected_pages_count_in)) {}

DidPreviewDocumentParams::~DidPreviewDocumentParams() = default;

void DidPreviewDocumentParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DidPrintContentParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_pages_count"), this->expected_pages_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPreviewDocumentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintParams::PrintParams()
    : page_size(),
      content_size(),
      printable_area(),
      margin_top(0),
      margin_left(0),
      page_orientation(::printing::mojom::PageOrientation::kUpright),
      dpi(),
      scale_factor(1.0),
      document_cookie(0),
      selection_only(false),
      preview_ui_id(-1),
      preview_request_id(0),
      is_first_request(false),
      print_scaling_option(::printing::mojom::PrintScalingOption::kSourceSize),
      print_to_pdf(false),
      display_header_footer(false),
      title(),
      url(),
      header_template(),
      footer_template(),
      rasterize_pdf(false),
      rasterize_pdf_dpi(0),
      should_print_backgrounds(false),
      printed_doc_type(::printing::mojom::SkiaDocumentType::kPDF),
      prefer_css_page_size(false),
      pages_per_sheet(1U),
      generate_tagged_pdf(),
      generate_document_outline(::printing::mojom::GenerateDocumentOutline::kNone) {}

PrintParams::PrintParams(
    const ::gfx::SizeF& page_size_in,
    const ::gfx::SizeF& content_size_in,
    const ::gfx::RectF& printable_area_in,
    float margin_top_in,
    float margin_left_in,
    ::printing::mojom::PageOrientation page_orientation_in,
    const ::gfx::Size& dpi_in,
    double scale_factor_in,
    int32_t document_cookie_in,
    bool selection_only_in,
    int32_t preview_ui_id_in,
    int32_t preview_request_id_in,
    bool is_first_request_in,
    ::printing::mojom::PrintScalingOption print_scaling_option_in,
    bool print_to_pdf_in,
    bool display_header_footer_in,
    const ::std::u16string& title_in,
    const ::std::u16string& url_in,
    const ::std::u16string& header_template_in,
    const ::std::u16string& footer_template_in,
    bool rasterize_pdf_in,
    int32_t rasterize_pdf_dpi_in,
    bool should_print_backgrounds_in,
    ::printing::mojom::SkiaDocumentType printed_doc_type_in,
    bool prefer_css_page_size_in,
    uint32_t pages_per_sheet_in,
    std::optional<bool> generate_tagged_pdf_in,
    ::printing::mojom::GenerateDocumentOutline generate_document_outline_in)
    : page_size(std::move(page_size_in)),
      content_size(std::move(content_size_in)),
      printable_area(std::move(printable_area_in)),
      margin_top(std::move(margin_top_in)),
      margin_left(std::move(margin_left_in)),
      page_orientation(std::move(page_orientation_in)),
      dpi(std::move(dpi_in)),
      scale_factor(std::move(scale_factor_in)),
      document_cookie(std::move(document_cookie_in)),
      selection_only(std::move(selection_only_in)),
      preview_ui_id(std::move(preview_ui_id_in)),
      preview_request_id(std::move(preview_request_id_in)),
      is_first_request(std::move(is_first_request_in)),
      print_scaling_option(std::move(print_scaling_option_in)),
      print_to_pdf(std::move(print_to_pdf_in)),
      display_header_footer(std::move(display_header_footer_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      header_template(std::move(header_template_in)),
      footer_template(std::move(footer_template_in)),
      rasterize_pdf(std::move(rasterize_pdf_in)),
      rasterize_pdf_dpi(std::move(rasterize_pdf_dpi_in)),
      should_print_backgrounds(std::move(should_print_backgrounds_in)),
      printed_doc_type(std::move(printed_doc_type_in)),
      prefer_css_page_size(std::move(prefer_css_page_size_in)),
      pages_per_sheet(std::move(pages_per_sheet_in)),
      generate_tagged_pdf(std::move(generate_tagged_pdf_in)),
      generate_document_outline(std::move(generate_document_outline_in)) {}

PrintParams::~PrintParams() = default;

void PrintParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_size"), this->page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::SizeF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_size"), this->content_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::SizeF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printable_area"), this->printable_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "margin_top"), this->margin_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "margin_left"), this->margin_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_orientation"), this->page_orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::PageOrientation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dpi"), this->dpi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_factor"), this->scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_only"), this->selection_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preview_ui_id"), this->preview_ui_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preview_request_id"), this->preview_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_first_request"), this->is_first_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_scaling_option"), this->print_scaling_option,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::PrintScalingOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_to_pdf"), this->print_to_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_header_footer"), this->display_header_footer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_template"), this->header_template,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "footer_template"), this->footer_template,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rasterize_pdf"), this->rasterize_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rasterize_pdf_dpi"), this->rasterize_pdf_dpi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_print_backgrounds"), this->should_print_backgrounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printed_doc_type"), this->printed_doc_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::SkiaDocumentType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefer_css_page_size"), this->prefer_css_page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_per_sheet"), this->pages_per_sheet,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generate_tagged_pdf"), this->generate_tagged_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generate_document_outline"), this->generate_document_outline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::GenerateDocumentOutline>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintPagesParams::PrintPagesParams()
    : params(),
      pages() {}

PrintPagesParams::PrintPagesParams(
    PrintParamsPtr params_in,
    std::vector<::printing::PageRange> pages_in)
    : params(std::move(params_in)),
      pages(std::move(pages_in)) {}

PrintPagesParams::~PrintPagesParams() = default;

void PrintPagesParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PrintParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages"), this->pages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::printing::PageRange>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintPagesParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidPrintDocumentParams::DidPrintDocumentParams()
    : content(),
      document_cookie(),
      page_size(),
      content_area(),
      physical_offsets() {}

DidPrintDocumentParams::DidPrintDocumentParams(
    DidPrintContentParamsPtr content_in,
    int32_t document_cookie_in,
    const ::gfx::Size& page_size_in,
    const ::gfx::Rect& content_area_in,
    const ::gfx::Point& physical_offsets_in)
    : content(std::move(content_in)),
      document_cookie(std::move(document_cookie_in)),
      page_size(std::move(page_size_in)),
      content_area(std::move(content_area_in)),
      physical_offsets(std::move(physical_offsets_in)) {}

DidPrintDocumentParams::~DidPrintDocumentParams() = default;

void DidPrintDocumentParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DidPrintContentParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_cookie"), this->document_cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_size"), this->page_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_area"), this->content_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_offsets"), this->physical_offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidPrintDocumentParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScriptedPrintParams::ScriptedPrintParams()
    : cookie(),
      expected_pages_count(),
      has_selection(),
      is_scripted(),
      margin_type() {}

ScriptedPrintParams::ScriptedPrintParams(
    int32_t cookie_in,
    uint32_t expected_pages_count_in,
    bool has_selection_in,
    bool is_scripted_in,
    ::printing::mojom::MarginType margin_type_in)
    : cookie(std::move(cookie_in)),
      expected_pages_count(std::move(expected_pages_count_in)),
      has_selection(std::move(has_selection_in)),
      is_scripted(std::move(is_scripted_in)),
      margin_type(std::move(margin_type_in)) {}

ScriptedPrintParams::~ScriptedPrintParams() = default;
size_t ScriptedPrintParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->cookie);
  seed = mojo::internal::Hash(seed, this->expected_pages_count);
  seed = mojo::internal::Hash(seed, this->has_selection);
  seed = mojo::internal::Hash(seed, this->is_scripted);
  seed = mojo::internal::Hash(seed, this->margin_type);
  return seed;
}

void ScriptedPrintParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_pages_count"), this->expected_pages_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_selection"), this->has_selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_scripted"), this->is_scripted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "margin_type"), this->margin_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::MarginType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScriptedPrintParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintWithParamsResultData::PrintWithParamsResultData()
    : params(),
      accessibility_tree(),
      generate_document_outline(::printing::mojom::GenerateDocumentOutline::kNone) {}

PrintWithParamsResultData::PrintWithParamsResultData(
    DidPrintDocumentParamsPtr params_in,
    const ::ui::AXTreeUpdate& accessibility_tree_in,
    ::printing::mojom::GenerateDocumentOutline generate_document_outline_in)
    : params(std::move(params_in)),
      accessibility_tree(std::move(accessibility_tree_in)),
      generate_document_outline(std::move(generate_document_outline_in)) {}

PrintWithParamsResultData::~PrintWithParamsResultData() = default;

void PrintWithParamsResultData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DidPrintDocumentParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accessibility_tree"), this->accessibility_tree,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::AXTreeUpdate&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generate_document_outline"), this->generate_document_outline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::GenerateDocumentOutline>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrintWithParamsResultData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrintWithParamsResult::PrintWithParamsResult() : tag_(Tag::kData) {
  data_.data = new PrintWithParamsResultDataPtr;
}

PrintWithParamsResult::~PrintWithParamsResult() {
  DestroyActive();
}


void PrintWithParamsResult::set_data(
    PrintWithParamsResultDataPtr data) {
  if (tag_ == Tag::kData) {
    *(data_.data) = std::move(data);
  } else {
    DestroyActive();
    tag_ = Tag::kData;
    data_.data = new PrintWithParamsResultDataPtr(
        std::move(data));
  }
}
void PrintWithParamsResult::set_failure_reason(
    PrintFailureReason failure_reason) {
  if (tag_ != Tag::kFailureReason) {
    DestroyActive();
    tag_ = Tag::kFailureReason;
  }
  data_.failure_reason = failure_reason;
}

void PrintWithParamsResult::DestroyActive() {
  switch (tag_) {

    case Tag::kData:

      delete data_.data;
      break;
    case Tag::kFailureReason:

      break;
  }
}

bool PrintWithParamsResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char PrintPreviewUI::Name_[] = "printing.mojom.PrintPreviewUI";

PrintPreviewUI::IPCStableHashFunction PrintPreviewUI::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrintPreviewUI>(message.name())) {
    case messages::PrintPreviewUI::kSetOptionsFromDocument: {
      return &PrintPreviewUI::SetOptionsFromDocument_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kDidPrepareDocumentForPreview: {
      return &PrintPreviewUI::DidPrepareDocumentForPreview_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kDidPreviewPage: {
      return &PrintPreviewUI::DidPreviewPage_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kMetafileReadyForPrinting: {
      return &PrintPreviewUI::MetafileReadyForPrinting_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kPrintPreviewFailed: {
      return &PrintPreviewUI::PrintPreviewFailed_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kPrintPreviewCancelled: {
      return &PrintPreviewUI::PrintPreviewCancelled_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kPrinterSettingsInvalid: {
      return &PrintPreviewUI::PrinterSettingsInvalid_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kDidGetDefaultPageLayout: {
      return &PrintPreviewUI::DidGetDefaultPageLayout_Sym::IPCStableHash;
    }
    case messages::PrintPreviewUI::kDidStartPreview: {
      return &PrintPreviewUI::DidStartPreview_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrintPreviewUI::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrintPreviewUI>(message.name())) {
      case messages::PrintPreviewUI::kSetOptionsFromDocument:
            return "Receive printing::mojom::PrintPreviewUI::SetOptionsFromDocument";
      case messages::PrintPreviewUI::kDidPrepareDocumentForPreview:
            return "Receive printing::mojom::PrintPreviewUI::DidPrepareDocumentForPreview";
      case messages::PrintPreviewUI::kDidPreviewPage:
            return "Receive printing::mojom::PrintPreviewUI::DidPreviewPage";
      case messages::PrintPreviewUI::kMetafileReadyForPrinting:
            return "Receive printing::mojom::PrintPreviewUI::MetafileReadyForPrinting";
      case messages::PrintPreviewUI::kPrintPreviewFailed:
            return "Receive printing::mojom::PrintPreviewUI::PrintPreviewFailed";
      case messages::PrintPreviewUI::kPrintPreviewCancelled:
            return "Receive printing::mojom::PrintPreviewUI::PrintPreviewCancelled";
      case messages::PrintPreviewUI::kPrinterSettingsInvalid:
            return "Receive printing::mojom::PrintPreviewUI::PrinterSettingsInvalid";
      case messages::PrintPreviewUI::kDidGetDefaultPageLayout:
            return "Receive printing::mojom::PrintPreviewUI::DidGetDefaultPageLayout";
      case messages::PrintPreviewUI::kDidStartPreview:
            return "Receive printing::mojom::PrintPreviewUI::DidStartPreview";
    }
  } else {
    switch (static_cast<messages::PrintPreviewUI>(message.name())) {
      case messages::PrintPreviewUI::kSetOptionsFromDocument:
            return "Receive reply printing::mojom::PrintPreviewUI::SetOptionsFromDocument";
      case messages::PrintPreviewUI::kDidPrepareDocumentForPreview:
            return "Receive reply printing::mojom::PrintPreviewUI::DidPrepareDocumentForPreview";
      case messages::PrintPreviewUI::kDidPreviewPage:
            return "Receive reply printing::mojom::PrintPreviewUI::DidPreviewPage";
      case messages::PrintPreviewUI::kMetafileReadyForPrinting:
            return "Receive reply printing::mojom::PrintPreviewUI::MetafileReadyForPrinting";
      case messages::PrintPreviewUI::kPrintPreviewFailed:
            return "Receive reply printing::mojom::PrintPreviewUI::PrintPreviewFailed";
      case messages::PrintPreviewUI::kPrintPreviewCancelled:
            return "Receive reply printing::mojom::PrintPreviewUI::PrintPreviewCancelled";
      case messages::PrintPreviewUI::kPrinterSettingsInvalid:
            return "Receive reply printing::mojom::PrintPreviewUI::PrinterSettingsInvalid";
      case messages::PrintPreviewUI::kDidGetDefaultPageLayout:
            return "Receive reply printing::mojom::PrintPreviewUI::DidGetDefaultPageLayout";
      case messages::PrintPreviewUI::kDidStartPreview:
            return "Receive reply printing::mojom::PrintPreviewUI::DidStartPreview";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrintPreviewUI::SetOptionsFromDocument_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::SetOptionsFromDocument");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::DidPrepareDocumentForPreview_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::DidPrepareDocumentForPreview");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::DidPreviewPage_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::DidPreviewPage");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::MetafileReadyForPrinting_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::MetafileReadyForPrinting");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::PrintPreviewFailed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::PrintPreviewFailed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::PrintPreviewCancelled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::PrintPreviewCancelled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::PrinterSettingsInvalid_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::PrinterSettingsInvalid");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::DidGetDefaultPageLayout_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::DidGetDefaultPageLayout");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintPreviewUI::DidStartPreview_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintPreviewUI::DidStartPreview");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PrintPreviewUIProxy::PrintPreviewUIProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintPreviewUIProxy::SetOptionsFromDocument(
    OptionsFromDocumentParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::SetOptionsFromDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type OptionsFromDocumentParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kSetOptionsFromDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::OptionsFromDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.SetOptionsFromDocument request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("SetOptionsFromDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::DidPrepareDocumentForPreview(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::DidPrepareDocumentForPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kDidPrepareDocumentForPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidPrepareDocumentForPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::DidPreviewPage(
    DidPreviewPageParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::DidPreviewPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPreviewPageParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kDidPreviewPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidPreviewPage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPreviewPageParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.DidPreviewPage request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidPreviewPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::MetafileReadyForPrinting(
    DidPreviewDocumentParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::MetafileReadyForPrinting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPreviewDocumentParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kMetafileReadyForPrinting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPreviewDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.MetafileReadyForPrinting request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("MetafileReadyForPrinting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::PrintPreviewFailed(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::PrintPreviewFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kPrintPreviewFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_PrintPreviewFailed_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("PrintPreviewFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::PrintPreviewCancelled(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::PrintPreviewCancelled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kPrintPreviewCancelled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("PrintPreviewCancelled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::PrinterSettingsInvalid(
    int32_t in_document_cookie, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::PrinterSettingsInvalid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kPrinterSettingsInvalid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("PrinterSettingsInvalid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::DidGetDefaultPageLayout(
    ::printing::mojom::PageSizeMarginsPtr in_page_layout_in_points, const ::gfx::RectF& in_printable_area_in_points, bool in_all_pages_have_custom_size, bool in_all_pages_have_custom_orientation, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::DidGetDefaultPageLayout", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_layout_in_points"), in_page_layout_in_points,
                        "<value of type ::printing::mojom::PageSizeMarginsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("printable_area_in_points"), in_printable_area_in_points,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("all_pages_have_custom_size"), in_all_pages_have_custom_size,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("all_pages_have_custom_orientation"), in_all_pages_have_custom_orientation,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kDidGetDefaultPageLayout), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_layout_in_points)::BaseType> page_layout_in_points_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PageSizeMarginsDataView>(
      in_page_layout_in_points, page_layout_in_points_fragment);
  params->page_layout_in_points.Set(
      page_layout_in_points_fragment.is_null() ? nullptr : page_layout_in_points_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->page_layout_in_points.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_layout_in_points in PrintPreviewUI.DidGetDefaultPageLayout request");
  mojo::internal::MessageFragment<
      typename decltype(params->printable_area_in_points)::BaseType> printable_area_in_points_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_printable_area_in_points, printable_area_in_points_fragment);
  params->printable_area_in_points.Set(
      printable_area_in_points_fragment.is_null() ? nullptr : printable_area_in_points_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->printable_area_in_points.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printable_area_in_points in PrintPreviewUI.DidGetDefaultPageLayout request");
  params->all_pages_have_custom_size = in_all_pages_have_custom_size;
  params->all_pages_have_custom_orientation = in_all_pages_have_custom_orientation;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidGetDefaultPageLayout");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintPreviewUIProxy::DidStartPreview(
    DidStartPreviewParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintPreviewUI::DidStartPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidStartPreviewParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintPreviewUI::kDidStartPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintPreviewUI_DidStartPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidStartPreviewParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintPreviewUI.DidStartPreview request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintPreviewUI::Name_);
  message.set_method_name("DidStartPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PrintPreviewUIStubDispatch::Accept(
    PrintPreviewUI* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrintPreviewUI>(message->header()->name)) {
    case messages::PrintPreviewUI::kSetOptionsFromDocument: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.0
      bool success = true;
      OptionsFromDocumentParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_SetOptionsFromDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOptionsFromDocument(        
        std::move(p_params), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kDidPrepareDocumentForPreview: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.1
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_DidPrepareDocumentForPreview_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidPrepareDocumentForPreview(        
        std::move(p_document_cookie), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kDidPreviewPage: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidPreviewPage_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidPreviewPage_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.2
      bool success = true;
      DidPreviewPageParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_DidPreviewPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidPreviewPage(        
        std::move(p_params), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kMetafileReadyForPrinting: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.3
      bool success = true;
      DidPreviewDocumentParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_MetafileReadyForPrinting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MetafileReadyForPrinting(        
        std::move(p_params), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kPrintPreviewFailed: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_PrintPreviewFailed_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_PrintPreviewFailed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.4
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_PrintPreviewFailed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintPreviewFailed(        
        std::move(p_document_cookie), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kPrintPreviewCancelled: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.5
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_PrintPreviewCancelled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintPreviewCancelled(        
        std::move(p_document_cookie), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kPrinterSettingsInvalid: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.6
      bool success = true;
      int32_t p_document_cookie{};
      int32_t p_request_id{};
      PrintPreviewUI_PrinterSettingsInvalid_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrinterSettingsInvalid(        
        std::move(p_document_cookie), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kDidGetDefaultPageLayout: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.7
      bool success = true;
      ::printing::mojom::PageSizeMarginsPtr p_page_layout_in_points{};
      ::gfx::RectF p_printable_area_in_points{};
      bool p_all_pages_have_custom_size{};
      bool p_all_pages_have_custom_orientation{};
      int32_t p_request_id{};
      PrintPreviewUI_DidGetDefaultPageLayout_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageLayoutInPoints(&p_page_layout_in_points))
        success = false;
      if (success && !input_data_view.ReadPrintableAreaInPoints(&p_printable_area_in_points))
        success = false;
      if (success)
        p_all_pages_have_custom_size = input_data_view.all_pages_have_custom_size();
      if (success)
        p_all_pages_have_custom_orientation = input_data_view.all_pages_have_custom_orientation();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGetDefaultPageLayout(        
        std::move(p_page_layout_in_points), 
        std::move(p_printable_area_in_points), 
        std::move(p_all_pages_have_custom_size), 
        std::move(p_all_pages_have_custom_orientation), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintPreviewUI::kDidStartPreview: {
      DCHECK(message->is_serialized());
      internal::PrintPreviewUI_DidStartPreview_Params_Data* params =
          reinterpret_cast<internal::PrintPreviewUI_DidStartPreview_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintPreviewUI.8
      bool success = true;
      DidStartPreviewParamsPtr p_params{};
      int32_t p_request_id{};
      PrintPreviewUI_DidStartPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintPreviewUI::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartPreview(        
        std::move(p_params), 
        std::move(p_request_id));
      return true;
    }
  }
  return false;
}

// static
bool PrintPreviewUIStubDispatch::AcceptWithResponder(
    PrintPreviewUI* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrintPreviewUI>(message->header()->name)) {
    case messages::PrintPreviewUI::kSetOptionsFromDocument: {
      break;
    }
    case messages::PrintPreviewUI::kDidPrepareDocumentForPreview: {
      break;
    }
    case messages::PrintPreviewUI::kDidPreviewPage: {
      break;
    }
    case messages::PrintPreviewUI::kMetafileReadyForPrinting: {
      break;
    }
    case messages::PrintPreviewUI::kPrintPreviewFailed: {
      break;
    }
    case messages::PrintPreviewUI::kPrintPreviewCancelled: {
      break;
    }
    case messages::PrintPreviewUI::kPrinterSettingsInvalid: {
      break;
    }
    case messages::PrintPreviewUI::kDidGetDefaultPageLayout: {
      break;
    }
    case messages::PrintPreviewUI::kDidStartPreview: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintPreviewUIValidationInfo[] = {
    {base::to_underlying(messages::PrintPreviewUI::kSetOptionsFromDocument),
     { &internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kDidPrepareDocumentForPreview),
     { &internal::PrintPreviewUI_DidPrepareDocumentForPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kDidPreviewPage),
     { &internal::PrintPreviewUI_DidPreviewPage_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kMetafileReadyForPrinting),
     { &internal::PrintPreviewUI_MetafileReadyForPrinting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kPrintPreviewFailed),
     { &internal::PrintPreviewUI_PrintPreviewFailed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kPrintPreviewCancelled),
     { &internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kPrinterSettingsInvalid),
     { &internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kDidGetDefaultPageLayout),
     { &internal::PrintPreviewUI_DidGetDefaultPageLayout_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintPreviewUI::kDidStartPreview),
     { &internal::PrintPreviewUI_DidStartPreview_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PrintPreviewUIRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintPreviewUI::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintPreviewUIValidationInfo);
}

const char PrintRenderFrame::Name_[] = "printing.mojom.PrintRenderFrame";

PrintRenderFrame::IPCStableHashFunction PrintRenderFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrintRenderFrame>(message.name())) {
    case messages::PrintRenderFrame::kPrintRequestedPages: {
      return &PrintRenderFrame::PrintRequestedPages_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kPrintWithParams: {
      return &PrintRenderFrame::PrintWithParams_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kPrintForSystemDialog: {
      return &PrintRenderFrame::PrintForSystemDialog_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kInitiatePrintPreview: {
      return &PrintRenderFrame::InitiatePrintPreview_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kSetPrintPreviewUI: {
      return &PrintRenderFrame::SetPrintPreviewUI_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kPrintPreview: {
      return &PrintRenderFrame::PrintPreview_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kOnPrintPreviewDialogClosed: {
      return &PrintRenderFrame::OnPrintPreviewDialogClosed_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kPrintFrameContent: {
      return &PrintRenderFrame::PrintFrameContent_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kConnectToPdfRenderer: {
      return &PrintRenderFrame::ConnectToPdfRenderer_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kPrintingDone: {
      return &PrintRenderFrame::PrintingDone_Sym::IPCStableHash;
    }
    case messages::PrintRenderFrame::kPrintNodeUnderContextMenu: {
      return &PrintRenderFrame::PrintNodeUnderContextMenu_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrintRenderFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrintRenderFrame>(message.name())) {
      case messages::PrintRenderFrame::kPrintRequestedPages:
            return "Receive printing::mojom::PrintRenderFrame::PrintRequestedPages";
      case messages::PrintRenderFrame::kPrintWithParams:
            return "Receive printing::mojom::PrintRenderFrame::PrintWithParams";
      case messages::PrintRenderFrame::kPrintForSystemDialog:
            return "Receive printing::mojom::PrintRenderFrame::PrintForSystemDialog";
      case messages::PrintRenderFrame::kInitiatePrintPreview:
            return "Receive printing::mojom::PrintRenderFrame::InitiatePrintPreview";
      case messages::PrintRenderFrame::kSetPrintPreviewUI:
            return "Receive printing::mojom::PrintRenderFrame::SetPrintPreviewUI";
      case messages::PrintRenderFrame::kPrintPreview:
            return "Receive printing::mojom::PrintRenderFrame::PrintPreview";
      case messages::PrintRenderFrame::kOnPrintPreviewDialogClosed:
            return "Receive printing::mojom::PrintRenderFrame::OnPrintPreviewDialogClosed";
      case messages::PrintRenderFrame::kPrintFrameContent:
            return "Receive printing::mojom::PrintRenderFrame::PrintFrameContent";
      case messages::PrintRenderFrame::kConnectToPdfRenderer:
            return "Receive printing::mojom::PrintRenderFrame::ConnectToPdfRenderer";
      case messages::PrintRenderFrame::kPrintingDone:
            return "Receive printing::mojom::PrintRenderFrame::PrintingDone";
      case messages::PrintRenderFrame::kPrintNodeUnderContextMenu:
            return "Receive printing::mojom::PrintRenderFrame::PrintNodeUnderContextMenu";
    }
  } else {
    switch (static_cast<messages::PrintRenderFrame>(message.name())) {
      case messages::PrintRenderFrame::kPrintRequestedPages:
            return "Receive reply printing::mojom::PrintRenderFrame::PrintRequestedPages";
      case messages::PrintRenderFrame::kPrintWithParams:
            return "Receive reply printing::mojom::PrintRenderFrame::PrintWithParams";
      case messages::PrintRenderFrame::kPrintForSystemDialog:
            return "Receive reply printing::mojom::PrintRenderFrame::PrintForSystemDialog";
      case messages::PrintRenderFrame::kInitiatePrintPreview:
            return "Receive reply printing::mojom::PrintRenderFrame::InitiatePrintPreview";
      case messages::PrintRenderFrame::kSetPrintPreviewUI:
            return "Receive reply printing::mojom::PrintRenderFrame::SetPrintPreviewUI";
      case messages::PrintRenderFrame::kPrintPreview:
            return "Receive reply printing::mojom::PrintRenderFrame::PrintPreview";
      case messages::PrintRenderFrame::kOnPrintPreviewDialogClosed:
            return "Receive reply printing::mojom::PrintRenderFrame::OnPrintPreviewDialogClosed";
      case messages::PrintRenderFrame::kPrintFrameContent:
            return "Receive reply printing::mojom::PrintRenderFrame::PrintFrameContent";
      case messages::PrintRenderFrame::kConnectToPdfRenderer:
            return "Receive reply printing::mojom::PrintRenderFrame::ConnectToPdfRenderer";
      case messages::PrintRenderFrame::kPrintingDone:
            return "Receive reply printing::mojom::PrintRenderFrame::PrintingDone";
      case messages::PrintRenderFrame::kPrintNodeUnderContextMenu:
            return "Receive reply printing::mojom::PrintRenderFrame::PrintNodeUnderContextMenu";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrintRenderFrame::PrintRequestedPages_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::PrintRequestedPages");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::PrintWithParams_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::PrintWithParams");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::PrintForSystemDialog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::PrintForSystemDialog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::InitiatePrintPreview_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::InitiatePrintPreview");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::SetPrintPreviewUI_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::SetPrintPreviewUI");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::PrintPreview_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::PrintPreview");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::OnPrintPreviewDialogClosed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::OnPrintPreviewDialogClosed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::PrintFrameContent_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::PrintFrameContent");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::ConnectToPdfRenderer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::ConnectToPdfRenderer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::PrintingDone_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::PrintingDone");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintRenderFrame::PrintNodeUnderContextMenu_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintRenderFrame::PrintNodeUnderContextMenu");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PrintRenderFrame_PrintWithParams_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintRenderFrame_PrintWithParams_ForwardToCallback(
      PrintRenderFrame::PrintWithParamsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintRenderFrame_PrintWithParams_ForwardToCallback(const PrintRenderFrame_PrintWithParams_ForwardToCallback&) = delete;
  PrintRenderFrame_PrintWithParams_ForwardToCallback& operator=(const PrintRenderFrame_PrintWithParams_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintRenderFrame::PrintWithParamsCallback callback_;
};

class PrintRenderFrame_PrintFrameContent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintRenderFrame_PrintFrameContent_ForwardToCallback(
      PrintRenderFrame::PrintFrameContentCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintRenderFrame_PrintFrameContent_ForwardToCallback(const PrintRenderFrame_PrintFrameContent_ForwardToCallback&) = delete;
  PrintRenderFrame_PrintFrameContent_ForwardToCallback& operator=(const PrintRenderFrame_PrintFrameContent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintRenderFrame::PrintFrameContentCallback callback_;
};

PrintRenderFrameProxy::PrintRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintRenderFrameProxy::PrintRequestedPages(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintRenderFrame::PrintRequestedPages");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintRequestedPages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintRequestedPages_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintRequestedPages");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::PrintWithParams(
    PrintPagesParamsPtr in_params, PrintWithParamsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintRenderFrame::PrintWithParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type PrintPagesParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintWithParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintWithParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintPagesParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintRenderFrame.PrintWithParams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintWithParams");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintRenderFrame_PrintWithParams_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintRenderFrameProxy::PrintForSystemDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintRenderFrame::PrintForSystemDialog");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintForSystemDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintForSystemDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintForSystemDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::InitiatePrintPreview(
    bool in_has_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintRenderFrame::InitiatePrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_selection"), in_has_selection,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kInitiatePrintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_InitiatePrintPreview_Params_Data> params(
          message);
  params.Allocate();
  params->has_selection = in_has_selection;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("InitiatePrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::SetPrintPreviewUI(
    ::mojo::PendingAssociatedRemote<PrintPreviewUI> in_preview) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintRenderFrame::SetPrintPreviewUI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview"), in_preview,
                        "<value of type ::mojo::PendingAssociatedRemote<PrintPreviewUI>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kSetPrintPreviewUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::printing::mojom::PrintPreviewUIAssociatedPtrInfoDataView>(
      in_preview, &params->preview, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->preview),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid preview in PrintRenderFrame.SetPrintPreviewUI request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("SetPrintPreviewUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::PrintPreview(
    ::base::Value::Dict in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintRenderFrame::PrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_settings, settings_fragment);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in PrintRenderFrame.PrintPreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::OnPrintPreviewDialogClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintRenderFrame::OnPrintPreviewDialogClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kOnPrintPreviewDialogClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("OnPrintPreviewDialogClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::PrintFrameContent(
    PrintFrameContentParamsPtr in_params, PrintFrameContentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintRenderFrame::PrintFrameContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type PrintFrameContentParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintFrameContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintFrameContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintFrameContentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintRenderFrame.PrintFrameContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintFrameContent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintRenderFrame_PrintFrameContent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintRenderFrameProxy::ConnectToPdfRenderer(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintRenderFrame::ConnectToPdfRenderer");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kConnectToPdfRenderer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_ConnectToPdfRenderer_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("ConnectToPdfRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::PrintingDone(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintRenderFrame::PrintingDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintingDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintingDone_Params_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintingDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintRenderFrameProxy::PrintNodeUnderContextMenu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintRenderFrame::PrintNodeUnderContextMenu");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintNodeUnderContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintNodeUnderContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PrintRenderFrame_PrintWithParams_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintRenderFrame::PrintWithParamsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintRenderFrame_PrintWithParams_ProxyToResponder> proxy(
        new PrintRenderFrame_PrintWithParams_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintRenderFrame_PrintWithParams_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintRenderFrame_PrintWithParams_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintRenderFrame_PrintWithParams_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintRenderFrame::PrintWithParamsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintWithParamsResultPtr in_result);
};

bool PrintRenderFrame_PrintWithParams_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintRenderFrame_PrintWithParams_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintRenderFrame_PrintWithParams_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintRenderFrame.1
  bool success = true;
  PrintWithParamsResultPtr p_result{};
  PrintRenderFrame_PrintWithParams_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintRenderFrame::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void PrintRenderFrame_PrintWithParams_ProxyToResponder::Run(
    PrintWithParamsResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintRenderFrame::PrintWithParams", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PrintWithParamsResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintWithParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintWithParams_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::printing::mojom::PrintWithParamsResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintWithParams");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintRenderFrame_PrintFrameContent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintRenderFrame::PrintFrameContentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintRenderFrame_PrintFrameContent_ProxyToResponder> proxy(
        new PrintRenderFrame_PrintFrameContent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintRenderFrame_PrintFrameContent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintRenderFrame_PrintFrameContent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintRenderFrame_PrintFrameContent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintRenderFrame::PrintFrameContentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_document_cookie, DidPrintContentParamsPtr in_params);
};

bool PrintRenderFrame_PrintFrameContent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintRenderFrame.7
  bool success = true;
  int32_t p_document_cookie{};
  DidPrintContentParamsPtr p_params{};
  PrintRenderFrame_PrintFrameContent_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_document_cookie = input_data_view.document_cookie();
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintRenderFrame::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_document_cookie), 
std::move(p_params));
  return true;
}

void PrintRenderFrame_PrintFrameContent_ProxyToResponder::Run(
    int32_t in_document_cookie, DidPrintContentParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintRenderFrame::PrintFrameContent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPrintContentParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintRenderFrame::kPrintFrameContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->document_cookie = in_document_cookie;
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintRenderFrame::Name_);
  message.set_method_name("PrintFrameContent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PrintRenderFrameStubDispatch::Accept(
    PrintRenderFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrintRenderFrame>(message->header()->name)) {
    case messages::PrintRenderFrame::kPrintRequestedPages: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintRequestedPages_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintRequestedPages_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.0
      bool success = true;
      PrintRenderFrame_PrintRequestedPages_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintRequestedPages(        );
      return true;
    }
    case messages::PrintRenderFrame::kPrintWithParams: {
      break;
    }
    case messages::PrintRenderFrame::kPrintForSystemDialog: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintForSystemDialog_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintForSystemDialog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.2
      bool success = true;
      PrintRenderFrame_PrintForSystemDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintForSystemDialog(        );
      return true;
    }
    case messages::PrintRenderFrame::kInitiatePrintPreview: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_InitiatePrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_InitiatePrintPreview_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.3
      bool success = true;
      bool p_has_selection{};
      PrintRenderFrame_InitiatePrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_selection = input_data_view.has_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitiatePrintPreview(        
        std::move(p_has_selection));
      return true;
    }
    case messages::PrintRenderFrame::kSetPrintPreviewUI: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.4
      bool success = true;
      ::mojo::PendingAssociatedRemote<PrintPreviewUI> p_preview{};
      PrintRenderFrame_SetPrintPreviewUI_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_preview =
            input_data_view.TakePreview<decltype(p_preview)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPrintPreviewUI(        
        std::move(p_preview));
      return true;
    }
    case messages::PrintRenderFrame::kPrintPreview: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintPreview_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.5
      bool success = true;
      ::base::Value::Dict p_settings{};
      PrintRenderFrame_PrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintPreview(        
        std::move(p_settings));
      return true;
    }
    case messages::PrintRenderFrame::kOnPrintPreviewDialogClosed: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.6
      bool success = true;
      PrintRenderFrame_OnPrintPreviewDialogClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrintPreviewDialogClosed(        );
      return true;
    }
    case messages::PrintRenderFrame::kPrintFrameContent: {
      break;
    }
    case messages::PrintRenderFrame::kConnectToPdfRenderer: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_ConnectToPdfRenderer_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_ConnectToPdfRenderer_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.8
      bool success = true;
      PrintRenderFrame_ConnectToPdfRenderer_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToPdfRenderer(        );
      return true;
    }
    case messages::PrintRenderFrame::kPrintingDone: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintingDone_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintingDone_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.9
      bool success = true;
      bool p_success{};
      PrintRenderFrame_PrintingDone_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintingDone(        
        std::move(p_success));
      return true;
    }
    case messages::PrintRenderFrame::kPrintNodeUnderContextMenu: {
      DCHECK(message->is_serialized());
      internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data* params =
          reinterpret_cast<internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.10
      bool success = true;
      PrintRenderFrame_PrintNodeUnderContextMenu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintNodeUnderContextMenu(        );
      return true;
    }
  }
  return false;
}

// static
bool PrintRenderFrameStubDispatch::AcceptWithResponder(
    PrintRenderFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrintRenderFrame>(message->header()->name)) {
    case messages::PrintRenderFrame::kPrintRequestedPages: {
      break;
    }
    case messages::PrintRenderFrame::kPrintWithParams: {
      internal::PrintRenderFrame_PrintWithParams_Params_Data* params =
          reinterpret_cast<
              internal::PrintRenderFrame_PrintWithParams_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.1
      bool success = true;
      PrintPagesParamsPtr p_params{};
      PrintRenderFrame_PrintWithParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 1, false);
        return false;
      }
      PrintRenderFrame::PrintWithParamsCallback callback =
          PrintRenderFrame_PrintWithParams_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintWithParams(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::PrintRenderFrame::kPrintForSystemDialog: {
      break;
    }
    case messages::PrintRenderFrame::kInitiatePrintPreview: {
      break;
    }
    case messages::PrintRenderFrame::kSetPrintPreviewUI: {
      break;
    }
    case messages::PrintRenderFrame::kPrintPreview: {
      break;
    }
    case messages::PrintRenderFrame::kOnPrintPreviewDialogClosed: {
      break;
    }
    case messages::PrintRenderFrame::kPrintFrameContent: {
      internal::PrintRenderFrame_PrintFrameContent_Params_Data* params =
          reinterpret_cast<
              internal::PrintRenderFrame_PrintFrameContent_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintRenderFrame.7
      bool success = true;
      PrintFrameContentParamsPtr p_params{};
      PrintRenderFrame_PrintFrameContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintRenderFrame::Name_, 7, false);
        return false;
      }
      PrintRenderFrame::PrintFrameContentCallback callback =
          PrintRenderFrame_PrintFrameContent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintFrameContent(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::PrintRenderFrame::kConnectToPdfRenderer: {
      break;
    }
    case messages::PrintRenderFrame::kPrintingDone: {
      break;
    }
    case messages::PrintRenderFrame::kPrintNodeUnderContextMenu: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintRenderFrameValidationInfo[] = {
    {base::to_underlying(messages::PrintRenderFrame::kPrintRequestedPages),
     { &internal::PrintRenderFrame_PrintRequestedPages_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kPrintWithParams),
     { &internal::PrintRenderFrame_PrintWithParams_Params_Data::Validate,
      &internal::PrintRenderFrame_PrintWithParams_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintRenderFrame::kPrintForSystemDialog),
     { &internal::PrintRenderFrame_PrintForSystemDialog_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kInitiatePrintPreview),
     { &internal::PrintRenderFrame_InitiatePrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kSetPrintPreviewUI),
     { &internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kPrintPreview),
     { &internal::PrintRenderFrame_PrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kOnPrintPreviewDialogClosed),
     { &internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kPrintFrameContent),
     { &internal::PrintRenderFrame_PrintFrameContent_Params_Data::Validate,
      &internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintRenderFrame::kConnectToPdfRenderer),
     { &internal::PrintRenderFrame_ConnectToPdfRenderer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kPrintingDone),
     { &internal::PrintRenderFrame_PrintingDone_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintRenderFrame::kPrintNodeUnderContextMenu),
     { &internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PrintRenderFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintRenderFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintRenderFrameValidationInfo);
}

bool PrintRenderFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintRenderFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPrintRenderFrameValidationInfo);

}
const char PrintManagerHost::Name_[] = "printing.mojom.PrintManagerHost";

PrintManagerHost::IPCStableHashFunction PrintManagerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrintManagerHost>(message.name())) {
    case messages::PrintManagerHost::kDidGetPrintedPagesCount: {
      return &PrintManagerHost::DidGetPrintedPagesCount_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kGetDefaultPrintSettings: {
      return &PrintManagerHost::GetDefaultPrintSettings_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kDidShowPrintDialog: {
      return &PrintManagerHost::DidShowPrintDialog_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kDidPrintDocument: {
      return &PrintManagerHost::DidPrintDocument_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kIsPrintingEnabled: {
      return &PrintManagerHost::IsPrintingEnabled_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kScriptedPrint: {
      return &PrintManagerHost::ScriptedPrint_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kPrintingFailed: {
      return &PrintManagerHost::PrintingFailed_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kUpdatePrintSettings: {
      return &PrintManagerHost::UpdatePrintSettings_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kSetupScriptedPrintPreview: {
      return &PrintManagerHost::SetupScriptedPrintPreview_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kShowScriptedPrintPreview: {
      return &PrintManagerHost::ShowScriptedPrintPreview_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kRequestPrintPreview: {
      return &PrintManagerHost::RequestPrintPreview_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kCheckForCancel: {
      return &PrintManagerHost::CheckForCancel_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kMetafileReadyForPrinting: {
      return &PrintManagerHost::MetafileReadyForPrinting_Sym::IPCStableHash;
    }
    case messages::PrintManagerHost::kSetAccessibilityTree: {
      return &PrintManagerHost::SetAccessibilityTree_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrintManagerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrintManagerHost>(message.name())) {
      case messages::PrintManagerHost::kDidGetPrintedPagesCount:
            return "Receive printing::mojom::PrintManagerHost::DidGetPrintedPagesCount";
      case messages::PrintManagerHost::kGetDefaultPrintSettings:
            return "Receive printing::mojom::PrintManagerHost::GetDefaultPrintSettings";
      case messages::PrintManagerHost::kDidShowPrintDialog:
            return "Receive printing::mojom::PrintManagerHost::DidShowPrintDialog";
      case messages::PrintManagerHost::kDidPrintDocument:
            return "Receive printing::mojom::PrintManagerHost::DidPrintDocument";
      case messages::PrintManagerHost::kIsPrintingEnabled:
            return "Receive printing::mojom::PrintManagerHost::IsPrintingEnabled";
      case messages::PrintManagerHost::kScriptedPrint:
            return "Receive printing::mojom::PrintManagerHost::ScriptedPrint";
      case messages::PrintManagerHost::kPrintingFailed:
            return "Receive printing::mojom::PrintManagerHost::PrintingFailed";
      case messages::PrintManagerHost::kUpdatePrintSettings:
            return "Receive printing::mojom::PrintManagerHost::UpdatePrintSettings";
      case messages::PrintManagerHost::kSetupScriptedPrintPreview:
            return "Receive printing::mojom::PrintManagerHost::SetupScriptedPrintPreview";
      case messages::PrintManagerHost::kShowScriptedPrintPreview:
            return "Receive printing::mojom::PrintManagerHost::ShowScriptedPrintPreview";
      case messages::PrintManagerHost::kRequestPrintPreview:
            return "Receive printing::mojom::PrintManagerHost::RequestPrintPreview";
      case messages::PrintManagerHost::kCheckForCancel:
            return "Receive printing::mojom::PrintManagerHost::CheckForCancel";
      case messages::PrintManagerHost::kMetafileReadyForPrinting:
            return "Receive printing::mojom::PrintManagerHost::MetafileReadyForPrinting";
      case messages::PrintManagerHost::kSetAccessibilityTree:
            return "Receive printing::mojom::PrintManagerHost::SetAccessibilityTree";
    }
  } else {
    switch (static_cast<messages::PrintManagerHost>(message.name())) {
      case messages::PrintManagerHost::kDidGetPrintedPagesCount:
            return "Receive reply printing::mojom::PrintManagerHost::DidGetPrintedPagesCount";
      case messages::PrintManagerHost::kGetDefaultPrintSettings:
            return "Receive reply printing::mojom::PrintManagerHost::GetDefaultPrintSettings";
      case messages::PrintManagerHost::kDidShowPrintDialog:
            return "Receive reply printing::mojom::PrintManagerHost::DidShowPrintDialog";
      case messages::PrintManagerHost::kDidPrintDocument:
            return "Receive reply printing::mojom::PrintManagerHost::DidPrintDocument";
      case messages::PrintManagerHost::kIsPrintingEnabled:
            return "Receive reply printing::mojom::PrintManagerHost::IsPrintingEnabled";
      case messages::PrintManagerHost::kScriptedPrint:
            return "Receive reply printing::mojom::PrintManagerHost::ScriptedPrint";
      case messages::PrintManagerHost::kPrintingFailed:
            return "Receive reply printing::mojom::PrintManagerHost::PrintingFailed";
      case messages::PrintManagerHost::kUpdatePrintSettings:
            return "Receive reply printing::mojom::PrintManagerHost::UpdatePrintSettings";
      case messages::PrintManagerHost::kSetupScriptedPrintPreview:
            return "Receive reply printing::mojom::PrintManagerHost::SetupScriptedPrintPreview";
      case messages::PrintManagerHost::kShowScriptedPrintPreview:
            return "Receive reply printing::mojom::PrintManagerHost::ShowScriptedPrintPreview";
      case messages::PrintManagerHost::kRequestPrintPreview:
            return "Receive reply printing::mojom::PrintManagerHost::RequestPrintPreview";
      case messages::PrintManagerHost::kCheckForCancel:
            return "Receive reply printing::mojom::PrintManagerHost::CheckForCancel";
      case messages::PrintManagerHost::kMetafileReadyForPrinting:
            return "Receive reply printing::mojom::PrintManagerHost::MetafileReadyForPrinting";
      case messages::PrintManagerHost::kSetAccessibilityTree:
            return "Receive reply printing::mojom::PrintManagerHost::SetAccessibilityTree";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrintManagerHost::DidGetPrintedPagesCount_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::DidGetPrintedPagesCount");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::GetDefaultPrintSettings_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::GetDefaultPrintSettings");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::DidShowPrintDialog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::DidShowPrintDialog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::DidPrintDocument_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::DidPrintDocument");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::IsPrintingEnabled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::IsPrintingEnabled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::ScriptedPrint_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::ScriptedPrint");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::PrintingFailed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::PrintingFailed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::UpdatePrintSettings_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::UpdatePrintSettings");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::SetupScriptedPrintPreview_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::SetupScriptedPrintPreview");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::ShowScriptedPrintPreview_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::ShowScriptedPrintPreview");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::RequestPrintPreview_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::RequestPrintPreview");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::CheckForCancel_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::CheckForCancel");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::MetafileReadyForPrinting_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::MetafileReadyForPrinting");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PrintManagerHost::SetAccessibilityTree_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)printing::mojom::PrintManagerHost::SetAccessibilityTree");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool PrintManagerHost::GetDefaultPrintSettings(PrintParamsPtr* out_default_settings) {
  NOTREACHED();
}
bool PrintManagerHost::DidPrintDocument(DidPrintDocumentParamsPtr params, bool* out_completed) {
  NOTREACHED();
}
bool PrintManagerHost::IsPrintingEnabled(bool* out_printing_enabled) {
  NOTREACHED();
}
bool PrintManagerHost::ScriptedPrint(ScriptedPrintParamsPtr params, PrintPagesParamsPtr* out_settings) {
  NOTREACHED();
}
bool PrintManagerHost::UpdatePrintSettings(::base::Value::Dict job_settings, PrintPagesParamsPtr* out_current_settings) {
  NOTREACHED();
}
bool PrintManagerHost::CheckForCancel(int32_t preview_ui_id, int32_t request_id, bool* out_cancel) {
  NOTREACHED();
}
class PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse(
      bool* result, PrintParamsPtr* out_default_settings)
      : result_(result), out_default_settings_(out_default_settings) {
    DCHECK(!*result_);
  }

  PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse(const PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse&) = delete;
  PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse& operator=(const PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PrintParamsPtr* out_default_settings_;};

class PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback(
      PrintManagerHost::GetDefaultPrintSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback(const PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback&) = delete;
  PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback& operator=(const PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::GetDefaultPrintSettingsCallback callback_;
};
class PrintManagerHost_DidPrintDocument_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_DidPrintDocument_HandleSyncResponse(
      bool* result, bool* out_completed)
      : result_(result), out_completed_(out_completed) {
    DCHECK(!*result_);
  }

  PrintManagerHost_DidPrintDocument_HandleSyncResponse(const PrintManagerHost_DidPrintDocument_HandleSyncResponse&) = delete;
  PrintManagerHost_DidPrintDocument_HandleSyncResponse& operator=(const PrintManagerHost_DidPrintDocument_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_completed_;};

class PrintManagerHost_DidPrintDocument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_DidPrintDocument_ForwardToCallback(
      PrintManagerHost::DidPrintDocumentCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintManagerHost_DidPrintDocument_ForwardToCallback(const PrintManagerHost_DidPrintDocument_ForwardToCallback&) = delete;
  PrintManagerHost_DidPrintDocument_ForwardToCallback& operator=(const PrintManagerHost_DidPrintDocument_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::DidPrintDocumentCallback callback_;
};
class PrintManagerHost_IsPrintingEnabled_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_IsPrintingEnabled_HandleSyncResponse(
      bool* result, bool* out_printing_enabled)
      : result_(result), out_printing_enabled_(out_printing_enabled) {
    DCHECK(!*result_);
  }

  PrintManagerHost_IsPrintingEnabled_HandleSyncResponse(const PrintManagerHost_IsPrintingEnabled_HandleSyncResponse&) = delete;
  PrintManagerHost_IsPrintingEnabled_HandleSyncResponse& operator=(const PrintManagerHost_IsPrintingEnabled_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_printing_enabled_;};

class PrintManagerHost_IsPrintingEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_IsPrintingEnabled_ForwardToCallback(
      PrintManagerHost::IsPrintingEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintManagerHost_IsPrintingEnabled_ForwardToCallback(const PrintManagerHost_IsPrintingEnabled_ForwardToCallback&) = delete;
  PrintManagerHost_IsPrintingEnabled_ForwardToCallback& operator=(const PrintManagerHost_IsPrintingEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::IsPrintingEnabledCallback callback_;
};
class PrintManagerHost_ScriptedPrint_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_ScriptedPrint_HandleSyncResponse(
      bool* result, PrintPagesParamsPtr* out_settings)
      : result_(result), out_settings_(out_settings) {
    DCHECK(!*result_);
  }

  PrintManagerHost_ScriptedPrint_HandleSyncResponse(const PrintManagerHost_ScriptedPrint_HandleSyncResponse&) = delete;
  PrintManagerHost_ScriptedPrint_HandleSyncResponse& operator=(const PrintManagerHost_ScriptedPrint_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PrintPagesParamsPtr* out_settings_;};

class PrintManagerHost_ScriptedPrint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_ScriptedPrint_ForwardToCallback(
      PrintManagerHost::ScriptedPrintCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintManagerHost_ScriptedPrint_ForwardToCallback(const PrintManagerHost_ScriptedPrint_ForwardToCallback&) = delete;
  PrintManagerHost_ScriptedPrint_ForwardToCallback& operator=(const PrintManagerHost_ScriptedPrint_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::ScriptedPrintCallback callback_;
};
class PrintManagerHost_UpdatePrintSettings_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_UpdatePrintSettings_HandleSyncResponse(
      bool* result, PrintPagesParamsPtr* out_current_settings)
      : result_(result), out_current_settings_(out_current_settings) {
    DCHECK(!*result_);
  }

  PrintManagerHost_UpdatePrintSettings_HandleSyncResponse(const PrintManagerHost_UpdatePrintSettings_HandleSyncResponse&) = delete;
  PrintManagerHost_UpdatePrintSettings_HandleSyncResponse& operator=(const PrintManagerHost_UpdatePrintSettings_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PrintPagesParamsPtr* out_current_settings_;};

class PrintManagerHost_UpdatePrintSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_UpdatePrintSettings_ForwardToCallback(
      PrintManagerHost::UpdatePrintSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintManagerHost_UpdatePrintSettings_ForwardToCallback(const PrintManagerHost_UpdatePrintSettings_ForwardToCallback&) = delete;
  PrintManagerHost_UpdatePrintSettings_ForwardToCallback& operator=(const PrintManagerHost_UpdatePrintSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::UpdatePrintSettingsCallback callback_;
};

class PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback(
      PrintManagerHost::SetupScriptedPrintPreviewCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback(const PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback&) = delete;
  PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback& operator=(const PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::SetupScriptedPrintPreviewCallback callback_;
};
class PrintManagerHost_CheckForCancel_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_CheckForCancel_HandleSyncResponse(
      bool* result, bool* out_cancel)
      : result_(result), out_cancel_(out_cancel) {
    DCHECK(!*result_);
  }

  PrintManagerHost_CheckForCancel_HandleSyncResponse(const PrintManagerHost_CheckForCancel_HandleSyncResponse&) = delete;
  PrintManagerHost_CheckForCancel_HandleSyncResponse& operator=(const PrintManagerHost_CheckForCancel_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_cancel_;};

class PrintManagerHost_CheckForCancel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrintManagerHost_CheckForCancel_ForwardToCallback(
      PrintManagerHost::CheckForCancelCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrintManagerHost_CheckForCancel_ForwardToCallback(const PrintManagerHost_CheckForCancel_ForwardToCallback&) = delete;
  PrintManagerHost_CheckForCancel_ForwardToCallback& operator=(const PrintManagerHost_CheckForCancel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrintManagerHost::CheckForCancelCallback callback_;
};

PrintManagerHostProxy::PrintManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrintManagerHostProxy::DidGetPrintedPagesCount(
    int32_t in_cookie, uint32_t in_number_pages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::DidGetPrintedPagesCount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("number_pages"), in_number_pages,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kDidGetPrintedPagesCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = in_cookie;
  params->number_pages = in_number_pages;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidGetPrintedPagesCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool PrintManagerHostProxy::GetDefaultPrintSettings(
    PrintParamsPtr* out_param_default_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call printing::mojom::PrintManagerHost::GetDefaultPrintSettings (sync)");
#else
  TRACE_EVENT0("mojom", "PrintManagerHost::GetDefaultPrintSettings");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kGetDefaultPrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("GetDefaultPrintSettings");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse(
          &result, out_param_default_settings));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PrintManagerHost::GetDefaultPrintSettings", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_settings"), out_param_default_settings,
                        "<value of type PrintParamsPtr>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::GetDefaultPrintSettings(
    GetDefaultPrintSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintManagerHost::GetDefaultPrintSettings");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kGetDefaultPrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("GetDefaultPrintSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintManagerHostProxy::DidShowPrintDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintManagerHost::DidShowPrintDialog");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kDidShowPrintDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidShowPrintDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidShowPrintDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool PrintManagerHostProxy::DidPrintDocument(
    DidPrintDocumentParamsPtr param_params, bool* out_param_completed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call printing::mojom::PrintManagerHost::DidPrintDocument (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params,
                        "<value of type DidPrintDocumentParamsPtr>");
   });
#else
  TRACE_EVENT0("mojom", "PrintManagerHost::DidPrintDocument");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kDidPrintDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidPrintDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPrintDocumentParamsDataView>(
      param_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.DidPrintDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidPrintDocument");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_DidPrintDocument_HandleSyncResponse(
          &result, out_param_completed));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PrintManagerHost::DidPrintDocument", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completed"), out_param_completed,
                        "<value of type bool>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::DidPrintDocument(
    DidPrintDocumentParamsPtr in_params, DidPrintDocumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::DidPrintDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPrintDocumentParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kDidPrintDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidPrintDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPrintDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.DidPrintDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidPrintDocument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_DidPrintDocument_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool PrintManagerHostProxy::IsPrintingEnabled(
    bool* out_param_printing_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call printing::mojom::PrintManagerHost::IsPrintingEnabled (sync)");
#else
  TRACE_EVENT0("mojom", "PrintManagerHost::IsPrintingEnabled");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kIsPrintingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_IsPrintingEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("IsPrintingEnabled");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_IsPrintingEnabled_HandleSyncResponse(
          &result, out_param_printing_enabled));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PrintManagerHost::IsPrintingEnabled", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("printing_enabled"), out_param_printing_enabled,
                        "<value of type bool>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::IsPrintingEnabled(
    IsPrintingEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintManagerHost::IsPrintingEnabled");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kIsPrintingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_IsPrintingEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("IsPrintingEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_IsPrintingEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool PrintManagerHostProxy::ScriptedPrint(
    ScriptedPrintParamsPtr param_params, PrintPagesParamsPtr* out_param_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call printing::mojom::PrintManagerHost::ScriptedPrint (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), param_params,
                        "<value of type ScriptedPrintParamsPtr>");
   });
#else
  TRACE_EVENT0("mojom", "PrintManagerHost::ScriptedPrint");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kScriptedPrint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ScriptedPrint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::ScriptedPrintParamsDataView>(
      param_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.ScriptedPrint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ScriptedPrint");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_ScriptedPrint_HandleSyncResponse(
          &result, out_param_settings));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PrintManagerHost::ScriptedPrint", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), out_param_settings,
                        "<value of type PrintPagesParamsPtr>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::ScriptedPrint(
    ScriptedPrintParamsPtr in_params, ScriptedPrintCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::ScriptedPrint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ScriptedPrintParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kScriptedPrint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ScriptedPrint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::ScriptedPrintParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.ScriptedPrint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ScriptedPrint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_ScriptedPrint_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintManagerHostProxy::PrintingFailed(
    int32_t in_cookie, PrintFailureReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::PrintingFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type PrintFailureReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kPrintingFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_PrintingFailed_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = in_cookie;
  mojo::internal::Serialize<::printing::mojom::PrintFailureReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("PrintingFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool PrintManagerHostProxy::UpdatePrintSettings(
    ::base::Value::Dict param_job_settings, PrintPagesParamsPtr* out_param_current_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call printing::mojom::PrintManagerHost::UpdatePrintSettings (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("job_settings"), param_job_settings,
                        "<value of type ::base::Value::Dict>");
   });
#else
  TRACE_EVENT0("mojom", "PrintManagerHost::UpdatePrintSettings");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kUpdatePrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_UpdatePrintSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->job_settings)::BaseType> job_settings_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      param_job_settings, job_settings_fragment);
  params->job_settings.Set(
      job_settings_fragment.is_null() ? nullptr : job_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->job_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null job_settings in PrintManagerHost.UpdatePrintSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_UpdatePrintSettings_HandleSyncResponse(
          &result, out_param_current_settings));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PrintManagerHost::UpdatePrintSettings", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_settings"), out_param_current_settings,
                        "<value of type PrintPagesParamsPtr>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::UpdatePrintSettings(
    ::base::Value::Dict in_job_settings, UpdatePrintSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::UpdatePrintSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("job_settings"), in_job_settings,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kUpdatePrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_UpdatePrintSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->job_settings)::BaseType> job_settings_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_job_settings, job_settings_fragment);
  params->job_settings.Set(
      job_settings_fragment.is_null() ? nullptr : job_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->job_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null job_settings in PrintManagerHost.UpdatePrintSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_UpdatePrintSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintManagerHostProxy::SetupScriptedPrintPreview(
    SetupScriptedPrintPreviewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send printing::mojom::PrintManagerHost::SetupScriptedPrintPreview");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kSetupScriptedPrintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("SetupScriptedPrintPreview");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintManagerHostProxy::ShowScriptedPrintPreview(
    bool in_is_modifiable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::ShowScriptedPrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_modifiable"), in_is_modifiable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kShowScriptedPrintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data> params(
          message);
  params.Allocate();
  params->is_modifiable = in_is_modifiable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ShowScriptedPrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintManagerHostProxy::RequestPrintPreview(
    RequestPrintPreviewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::RequestPrintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type RequestPrintPreviewParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kRequestPrintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_RequestPrintPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::RequestPrintPreviewParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.RequestPrintPreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("RequestPrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool PrintManagerHostProxy::CheckForCancel(
    int32_t param_preview_ui_id, int32_t param_request_id, bool* out_param_cancel) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call printing::mojom::PrintManagerHost::CheckForCancel (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview_ui_id"), param_preview_ui_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), param_request_id,
                        "<value of type int32_t>");
   });
#else
  TRACE_EVENT0("mojom", "PrintManagerHost::CheckForCancel");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kCheckForCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_CheckForCancel_Params_Data> params(
          message);
  params.Allocate();
  params->preview_ui_id = param_preview_ui_id;
  params->request_id = param_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("CheckForCancel");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_CheckForCancel_HandleSyncResponse(
          &result, out_param_cancel));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PrintManagerHost::CheckForCancel", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cancel"), out_param_cancel,
                        "<value of type bool>");
   });
#endif
  return result;
}

void PrintManagerHostProxy::CheckForCancel(
    int32_t in_preview_ui_id, int32_t in_request_id, CheckForCancelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::CheckForCancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preview_ui_id"), in_preview_ui_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kCheckForCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_CheckForCancel_Params_Data> params(
          message);
  params.Allocate();
  params->preview_ui_id = in_preview_ui_id;
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("CheckForCancel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrintManagerHost_CheckForCancel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PrintManagerHostProxy::MetafileReadyForPrinting(
    DidPreviewDocumentParamsPtr in_params, int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::MetafileReadyForPrinting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidPreviewDocumentParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kMetafileReadyForPrinting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::DidPreviewDocumentParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PrintManagerHost.MetafileReadyForPrinting request");
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("MetafileReadyForPrinting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PrintManagerHostProxy::SetAccessibilityTree(
    int32_t in_cookie, const ::ui::AXTreeUpdate& in_accessibility_tree) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PrintManagerHost::SetAccessibilityTree", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accessibility_tree"), in_accessibility_tree,
                        "<value of type const ::ui::AXTreeUpdate&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kSetAccessibilityTree), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_SetAccessibilityTree_Params_Data> params(
          message);
  params.Allocate();
  params->cookie = in_cookie;
  mojo::internal::MessageFragment<
      typename decltype(params->accessibility_tree)::BaseType> accessibility_tree_fragment(
          params.message());
  mojo::internal::Serialize<::ax::mojom::AXTreeUpdateDataView>(
      in_accessibility_tree, accessibility_tree_fragment);
  params->accessibility_tree.Set(
      accessibility_tree_fragment.is_null() ? nullptr : accessibility_tree_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->accessibility_tree.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accessibility_tree in PrintManagerHost.SetAccessibilityTree request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("SetAccessibilityTree");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintManagerHost::GetDefaultPrintSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder> proxy(
        new PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::GetDefaultPrintSettingsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintParamsPtr in_default_settings);
};

bool PrintManagerHost_GetDefaultPrintSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintManagerHost.1
  bool success = true;
  PrintParamsPtr p_default_settings{};
  PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDefaultSettings(&p_default_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_default_settings));
  return true;
}

void PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder::Run(
    PrintParamsPtr in_default_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintManagerHost::GetDefaultPrintSettings", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_settings"), in_default_settings,
                        "<value of type PrintParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kGetDefaultPrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->default_settings)::BaseType> default_settings_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintParamsDataView>(
      in_default_settings, default_settings_fragment);
  params->default_settings.Set(
      default_settings_fragment.is_null() ? nullptr : default_settings_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("GetDefaultPrintSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_GetDefaultPrintSettings_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PrintManagerHost.1
  bool success = true;
  PrintParamsPtr p_default_settings{};
  PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDefaultSettings(&p_default_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 1, true);
    return false;
  }
  *out_default_settings_ = std::move(p_default_settings);
  *result_ = true;
  return true;
}
class PrintManagerHost_DidPrintDocument_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintManagerHost::DidPrintDocumentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintManagerHost_DidPrintDocument_ProxyToResponder> proxy(
        new PrintManagerHost_DidPrintDocument_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintManagerHost_DidPrintDocument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_DidPrintDocument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintManagerHost_DidPrintDocument_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::DidPrintDocumentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_completed);
};

bool PrintManagerHost_DidPrintDocument_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintManagerHost.3
  bool success = true;
  bool p_completed{};
  PrintManagerHost_DidPrintDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_completed = input_data_view.completed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_completed));
  return true;
}

void PrintManagerHost_DidPrintDocument_ProxyToResponder::Run(
    bool in_completed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintManagerHost::DidPrintDocument", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completed"), in_completed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kDidPrintDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->completed = in_completed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("DidPrintDocument");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_DidPrintDocument_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PrintManagerHost.3
  bool success = true;
  bool p_completed{};
  PrintManagerHost_DidPrintDocument_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_completed = input_data_view.completed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 3, true);
    return false;
  }
  *out_completed_ = std::move(p_completed);
  *result_ = true;
  return true;
}
class PrintManagerHost_IsPrintingEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintManagerHost::IsPrintingEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintManagerHost_IsPrintingEnabled_ProxyToResponder> proxy(
        new PrintManagerHost_IsPrintingEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintManagerHost_IsPrintingEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_IsPrintingEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintManagerHost_IsPrintingEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::IsPrintingEnabledCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_printing_enabled);
};

bool PrintManagerHost_IsPrintingEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_IsPrintingEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_IsPrintingEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintManagerHost.4
  bool success = true;
  bool p_printing_enabled{};
  PrintManagerHost_IsPrintingEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_printing_enabled = input_data_view.printing_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_printing_enabled));
  return true;
}

void PrintManagerHost_IsPrintingEnabled_ProxyToResponder::Run(
    bool in_printing_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintManagerHost::IsPrintingEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("printing_enabled"), in_printing_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kIsPrintingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_IsPrintingEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->printing_enabled = in_printing_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("IsPrintingEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_IsPrintingEnabled_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_IsPrintingEnabled_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_IsPrintingEnabled_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PrintManagerHost.4
  bool success = true;
  bool p_printing_enabled{};
  PrintManagerHost_IsPrintingEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_printing_enabled = input_data_view.printing_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 4, true);
    return false;
  }
  *out_printing_enabled_ = std::move(p_printing_enabled);
  *result_ = true;
  return true;
}
class PrintManagerHost_ScriptedPrint_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintManagerHost::ScriptedPrintCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintManagerHost_ScriptedPrint_ProxyToResponder> proxy(
        new PrintManagerHost_ScriptedPrint_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintManagerHost_ScriptedPrint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_ScriptedPrint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintManagerHost_ScriptedPrint_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::ScriptedPrintCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintPagesParamsPtr in_settings);
};

bool PrintManagerHost_ScriptedPrint_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintManagerHost.5
  bool success = true;
  PrintPagesParamsPtr p_settings{};
  PrintManagerHost_ScriptedPrint_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSettings(&p_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_settings));
  return true;
}

void PrintManagerHost_ScriptedPrint_ProxyToResponder::Run(
    PrintPagesParamsPtr in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintManagerHost::ScriptedPrint", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type PrintPagesParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kScriptedPrint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintPagesParamsDataView>(
      in_settings, settings_fragment);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("ScriptedPrint");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_ScriptedPrint_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PrintManagerHost.5
  bool success = true;
  PrintPagesParamsPtr p_settings{};
  PrintManagerHost_ScriptedPrint_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSettings(&p_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 5, true);
    return false;
  }
  *out_settings_ = std::move(p_settings);
  *result_ = true;
  return true;
}
class PrintManagerHost_UpdatePrintSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintManagerHost::UpdatePrintSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintManagerHost_UpdatePrintSettings_ProxyToResponder> proxy(
        new PrintManagerHost_UpdatePrintSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintManagerHost_UpdatePrintSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_UpdatePrintSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintManagerHost_UpdatePrintSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::UpdatePrintSettingsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PrintPagesParamsPtr in_current_settings);
};

bool PrintManagerHost_UpdatePrintSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintManagerHost.7
  bool success = true;
  PrintPagesParamsPtr p_current_settings{};
  PrintManagerHost_UpdatePrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCurrentSettings(&p_current_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_current_settings));
  return true;
}

void PrintManagerHost_UpdatePrintSettings_ProxyToResponder::Run(
    PrintPagesParamsPtr in_current_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintManagerHost::UpdatePrintSettings", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_settings"), in_current_settings,
                        "<value of type PrintPagesParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kUpdatePrintSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->current_settings)::BaseType> current_settings_fragment(
          params.message());
  mojo::internal::Serialize<::printing::mojom::PrintPagesParamsDataView>(
      in_current_settings, current_settings_fragment);
  params->current_settings.Set(
      current_settings_fragment.is_null() ? nullptr : current_settings_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("UpdatePrintSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_UpdatePrintSettings_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PrintManagerHost.7
  bool success = true;
  PrintPagesParamsPtr p_current_settings{};
  PrintManagerHost_UpdatePrintSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCurrentSettings(&p_current_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 7, true);
    return false;
  }
  *out_current_settings_ = std::move(p_current_settings);
  *result_ = true;
  return true;
}
class PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintManagerHost::SetupScriptedPrintPreviewCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder> proxy(
        new PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::SetupScriptedPrintPreviewCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PrintManagerHost_SetupScriptedPrintPreview_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintManagerHost.8
  bool success = true;
  PrintManagerHost_SetupScriptedPrintPreview_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply printing::mojom::PrintManagerHost::SetupScriptedPrintPreview");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kSetupScriptedPrintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("SetupScriptedPrintPreview");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PrintManagerHost_CheckForCancel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrintManagerHost::CheckForCancelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrintManagerHost_CheckForCancel_ProxyToResponder> proxy(
        new PrintManagerHost_CheckForCancel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrintManagerHost_CheckForCancel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrintManagerHost_CheckForCancel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrintManagerHost_CheckForCancel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PrintManagerHost::CheckForCancelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_cancel);
};

bool PrintManagerHost_CheckForCancel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_CheckForCancel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrintManagerHost_CheckForCancel_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PrintManagerHost.11
  bool success = true;
  bool p_cancel{};
  PrintManagerHost_CheckForCancel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cancel = input_data_view.cancel();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cancel));
  return true;
}

void PrintManagerHost_CheckForCancel_ProxyToResponder::Run(
    bool in_cancel) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PrintManagerHost::CheckForCancel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cancel"), in_cancel,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrintManagerHost::kCheckForCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PrintManagerHost_CheckForCancel_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->cancel = in_cancel;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrintManagerHost::Name_);
  message.set_method_name("CheckForCancel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PrintManagerHost_CheckForCancel_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrintManagerHost_CheckForCancel_ResponseParams_Data* params =
      reinterpret_cast<internal::PrintManagerHost_CheckForCancel_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PrintManagerHost.11
  bool success = true;
  bool p_cancel{};
  PrintManagerHost_CheckForCancel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cancel = input_data_view.cancel();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrintManagerHost::Name_, 11, true);
    return false;
  }
  *out_cancel_ = std::move(p_cancel);
  *result_ = true;
  return true;
}

// static
bool PrintManagerHostStubDispatch::Accept(
    PrintManagerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrintManagerHost>(message->header()->name)) {
    case messages::PrintManagerHost::kDidGetPrintedPagesCount: {
      DCHECK(message->is_serialized());
      internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintManagerHost.0
      bool success = true;
      int32_t p_cookie{};
      uint32_t p_number_pages{};
      PrintManagerHost_DidGetPrintedPagesCount_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cookie = input_data_view.cookie();
      if (success)
        p_number_pages = input_data_view.number_pages();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidGetPrintedPagesCount(        
        std::move(p_cookie), 
        std::move(p_number_pages));
      return true;
    }
    case messages::PrintManagerHost::kGetDefaultPrintSettings: {
      break;
    }
    case messages::PrintManagerHost::kDidShowPrintDialog: {
      DCHECK(message->is_serialized());
      internal::PrintManagerHost_DidShowPrintDialog_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_DidShowPrintDialog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintManagerHost.2
      bool success = true;
      PrintManagerHost_DidShowPrintDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidShowPrintDialog(        );
      return true;
    }
    case messages::PrintManagerHost::kDidPrintDocument: {
      break;
    }
    case messages::PrintManagerHost::kIsPrintingEnabled: {
      break;
    }
    case messages::PrintManagerHost::kScriptedPrint: {
      break;
    }
    case messages::PrintManagerHost::kPrintingFailed: {
      DCHECK(message->is_serialized());
      internal::PrintManagerHost_PrintingFailed_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_PrintingFailed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintManagerHost.6
      bool success = true;
      int32_t p_cookie{};
      PrintFailureReason p_reason{};
      PrintManagerHost_PrintingFailed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cookie = input_data_view.cookie();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintingFailed(        
        std::move(p_cookie), 
        std::move(p_reason));
      return true;
    }
    case messages::PrintManagerHost::kUpdatePrintSettings: {
      break;
    }
    case messages::PrintManagerHost::kSetupScriptedPrintPreview: {
      break;
    }
    case messages::PrintManagerHost::kShowScriptedPrintPreview: {
      DCHECK(message->is_serialized());
      internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintManagerHost.9
      bool success = true;
      bool p_is_modifiable{};
      PrintManagerHost_ShowScriptedPrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_modifiable = input_data_view.is_modifiable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowScriptedPrintPreview(        
        std::move(p_is_modifiable));
      return true;
    }
    case messages::PrintManagerHost::kRequestPrintPreview: {
      DCHECK(message->is_serialized());
      internal::PrintManagerHost_RequestPrintPreview_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_RequestPrintPreview_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintManagerHost.10
      bool success = true;
      RequestPrintPreviewParamsPtr p_params{};
      PrintManagerHost_RequestPrintPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPrintPreview(        
        std::move(p_params));
      return true;
    }
    case messages::PrintManagerHost::kCheckForCancel: {
      break;
    }
    case messages::PrintManagerHost::kMetafileReadyForPrinting: {
      DCHECK(message->is_serialized());
      internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintManagerHost.12
      bool success = true;
      DidPreviewDocumentParamsPtr p_params{};
      int32_t p_request_id{};
      PrintManagerHost_MetafileReadyForPrinting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MetafileReadyForPrinting(        
        std::move(p_params), 
        std::move(p_request_id));
      return true;
    }
    case messages::PrintManagerHost::kSetAccessibilityTree: {
      DCHECK(message->is_serialized());
      internal::PrintManagerHost_SetAccessibilityTree_Params_Data* params =
          reinterpret_cast<internal::PrintManagerHost_SetAccessibilityTree_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PrintManagerHost.13
      bool success = true;
      int32_t p_cookie{};
      ::ui::AXTreeUpdate p_accessibility_tree{};
      PrintManagerHost_SetAccessibilityTree_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cookie = input_data_view.cookie();
      if (success && !input_data_view.ReadAccessibilityTree(&p_accessibility_tree))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAccessibilityTree(        
        std::move(p_cookie), 
        std::move(p_accessibility_tree));
      return true;
    }
  }
  return false;
}

// static
bool PrintManagerHostStubDispatch::AcceptWithResponder(
    PrintManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrintManagerHost>(message->header()->name)) {
    case messages::PrintManagerHost::kDidGetPrintedPagesCount: {
      break;
    }
    case messages::PrintManagerHost::kGetDefaultPrintSettings: {
      internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintManagerHost.1
      bool success = true;
      PrintManagerHost_GetDefaultPrintSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 1, false);
        return false;
      }
      PrintManagerHost::GetDefaultPrintSettingsCallback callback =
          PrintManagerHost_GetDefaultPrintSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDefaultPrintSettings(std::move(callback));
      return true;
    }
    case messages::PrintManagerHost::kDidShowPrintDialog: {
      break;
    }
    case messages::PrintManagerHost::kDidPrintDocument: {
      internal::PrintManagerHost_DidPrintDocument_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_DidPrintDocument_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintManagerHost.3
      bool success = true;
      DidPrintDocumentParamsPtr p_params{};
      PrintManagerHost_DidPrintDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 3, false);
        return false;
      }
      PrintManagerHost::DidPrintDocumentCallback callback =
          PrintManagerHost_DidPrintDocument_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidPrintDocument(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::PrintManagerHost::kIsPrintingEnabled: {
      internal::PrintManagerHost_IsPrintingEnabled_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_IsPrintingEnabled_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintManagerHost.4
      bool success = true;
      PrintManagerHost_IsPrintingEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 4, false);
        return false;
      }
      PrintManagerHost::IsPrintingEnabledCallback callback =
          PrintManagerHost_IsPrintingEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsPrintingEnabled(std::move(callback));
      return true;
    }
    case messages::PrintManagerHost::kScriptedPrint: {
      internal::PrintManagerHost_ScriptedPrint_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_ScriptedPrint_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintManagerHost.5
      bool success = true;
      ScriptedPrintParamsPtr p_params{};
      PrintManagerHost_ScriptedPrint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 5, false);
        return false;
      }
      PrintManagerHost::ScriptedPrintCallback callback =
          PrintManagerHost_ScriptedPrint_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScriptedPrint(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::PrintManagerHost::kPrintingFailed: {
      break;
    }
    case messages::PrintManagerHost::kUpdatePrintSettings: {
      internal::PrintManagerHost_UpdatePrintSettings_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_UpdatePrintSettings_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintManagerHost.7
      bool success = true;
      ::base::Value::Dict p_job_settings{};
      PrintManagerHost_UpdatePrintSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJobSettings(&p_job_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 7, false);
        return false;
      }
      PrintManagerHost::UpdatePrintSettingsCallback callback =
          PrintManagerHost_UpdatePrintSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePrintSettings(        
        std::move(p_job_settings), std::move(callback));
      return true;
    }
    case messages::PrintManagerHost::kSetupScriptedPrintPreview: {
      internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintManagerHost.8
      bool success = true;
      PrintManagerHost_SetupScriptedPrintPreview_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 8, false);
        return false;
      }
      PrintManagerHost::SetupScriptedPrintPreviewCallback callback =
          PrintManagerHost_SetupScriptedPrintPreview_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupScriptedPrintPreview(std::move(callback));
      return true;
    }
    case messages::PrintManagerHost::kShowScriptedPrintPreview: {
      break;
    }
    case messages::PrintManagerHost::kRequestPrintPreview: {
      break;
    }
    case messages::PrintManagerHost::kCheckForCancel: {
      internal::PrintManagerHost_CheckForCancel_Params_Data* params =
          reinterpret_cast<
              internal::PrintManagerHost_CheckForCancel_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PrintManagerHost.11
      bool success = true;
      int32_t p_preview_ui_id{};
      int32_t p_request_id{};
      PrintManagerHost_CheckForCancel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_preview_ui_id = input_data_view.preview_ui_id();
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrintManagerHost::Name_, 11, false);
        return false;
      }
      PrintManagerHost::CheckForCancelCallback callback =
          PrintManagerHost_CheckForCancel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckForCancel(        
        std::move(p_preview_ui_id), 
        std::move(p_request_id), std::move(callback));
      return true;
    }
    case messages::PrintManagerHost::kMetafileReadyForPrinting: {
      break;
    }
    case messages::PrintManagerHost::kSetAccessibilityTree: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPrintManagerHostValidationInfo[] = {
    {base::to_underlying(messages::PrintManagerHost::kDidGetPrintedPagesCount),
     { &internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintManagerHost::kGetDefaultPrintSettings),
     { &internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data::Validate,
      &internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintManagerHost::kDidShowPrintDialog),
     { &internal::PrintManagerHost_DidShowPrintDialog_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintManagerHost::kDidPrintDocument),
     { &internal::PrintManagerHost_DidPrintDocument_Params_Data::Validate,
      &internal::PrintManagerHost_DidPrintDocument_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintManagerHost::kIsPrintingEnabled),
     { &internal::PrintManagerHost_IsPrintingEnabled_Params_Data::Validate,
      &internal::PrintManagerHost_IsPrintingEnabled_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintManagerHost::kScriptedPrint),
     { &internal::PrintManagerHost_ScriptedPrint_Params_Data::Validate,
      &internal::PrintManagerHost_ScriptedPrint_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintManagerHost::kPrintingFailed),
     { &internal::PrintManagerHost_PrintingFailed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintManagerHost::kUpdatePrintSettings),
     { &internal::PrintManagerHost_UpdatePrintSettings_Params_Data::Validate,
      &internal::PrintManagerHost_UpdatePrintSettings_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintManagerHost::kSetupScriptedPrintPreview),
     { &internal::PrintManagerHost_SetupScriptedPrintPreview_Params_Data::Validate,
      &internal::PrintManagerHost_SetupScriptedPrintPreview_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintManagerHost::kShowScriptedPrintPreview),
     { &internal::PrintManagerHost_ShowScriptedPrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintManagerHost::kRequestPrintPreview),
     { &internal::PrintManagerHost_RequestPrintPreview_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintManagerHost::kCheckForCancel),
     { &internal::PrintManagerHost_CheckForCancel_Params_Data::Validate,
      &internal::PrintManagerHost_CheckForCancel_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PrintManagerHost::kMetafileReadyForPrinting),
     { &internal::PrintManagerHost_MetafileReadyForPrinting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::PrintManagerHost::kSetAccessibilityTree),
     { &internal::PrintManagerHost_SetAccessibilityTree_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PrintManagerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintManagerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPrintManagerHostValidationInfo);
}

bool PrintManagerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::printing::mojom::PrintManagerHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPrintManagerHostValidationInfo);

}


}  // printing::mojom


namespace mojo {


// static
bool StructTraits<::printing::mojom::PreviewIds::DataView, ::printing::mojom::PreviewIdsPtr>::Read(
    ::printing::mojom::PreviewIds::DataView input,
    ::printing::mojom::PreviewIdsPtr* output) {
  bool success = true;
  ::printing::mojom::PreviewIdsPtr result(::printing::mojom::PreviewIds::New());
  
      if (success)
        result->request_id = input.request_id();
      if (success)
        result->ui_id = input.ui_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::RequestPrintPreviewParams::DataView, ::printing::mojom::RequestPrintPreviewParamsPtr>::Read(
    ::printing::mojom::RequestPrintPreviewParams::DataView input,
    ::printing::mojom::RequestPrintPreviewParamsPtr* output) {
  bool success = true;
  ::printing::mojom::RequestPrintPreviewParamsPtr result(::printing::mojom::RequestPrintPreviewParams::New());
  
      if (success)
        result->is_modifiable = input.is_modifiable();
      if (success)
        result->webnode_only = input.webnode_only();
      if (success)
        result->has_selection = input.has_selection();
      if (success)
        result->selection_only = input.selection_only();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintFrameContentParams::DataView, ::printing::mojom::PrintFrameContentParamsPtr>::Read(
    ::printing::mojom::PrintFrameContentParams::DataView input,
    ::printing::mojom::PrintFrameContentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::PrintFrameContentParamsPtr result(::printing::mojom::PrintFrameContentParams::New());
  
      if (success && !input.ReadPrintableArea(&result->printable_area))
        success = false;
      if (success)
        result->document_cookie = input.document_cookie();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::OptionsFromDocumentParams::DataView, ::printing::mojom::OptionsFromDocumentParamsPtr>::Read(
    ::printing::mojom::OptionsFromDocumentParams::DataView input,
    ::printing::mojom::OptionsFromDocumentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::OptionsFromDocumentParamsPtr result(::printing::mojom::OptionsFromDocumentParams::New());
  
      if (success)
        result->is_scaling_disabled = input.is_scaling_disabled();
      if (success)
        result->copies = input.copies();
      if (success && !input.ReadDuplex(&result->duplex))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPrintContentParams::DataView, ::printing::mojom::DidPrintContentParamsPtr>::Read(
    ::printing::mojom::DidPrintContentParams::DataView input,
    ::printing::mojom::DidPrintContentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPrintContentParamsPtr result(::printing::mojom::DidPrintContentParams::New());
  
      if (success && !input.ReadMetafileDataRegion(&result->metafile_data_region))
        success = false;
      if (success && !input.ReadSubframeContentInfo(&result->subframe_content_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidStartPreviewParams::DataView, ::printing::mojom::DidStartPreviewParamsPtr>::Read(
    ::printing::mojom::DidStartPreviewParams::DataView input,
    ::printing::mojom::DidStartPreviewParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidStartPreviewParamsPtr result(::printing::mojom::DidStartPreviewParams::New());
  
      if (success)
        result->page_count = input.page_count();
      if (success && !input.ReadPagesToRender(&result->pages_to_render))
        success = false;
      if (success)
        result->pages_per_sheet = input.pages_per_sheet();
      if (success && !input.ReadPageSize(&result->page_size))
        success = false;
      if (success)
        result->fit_to_page_scaling = input.fit_to_page_scaling();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPreviewPageParams::DataView, ::printing::mojom::DidPreviewPageParamsPtr>::Read(
    ::printing::mojom::DidPreviewPageParams::DataView input,
    ::printing::mojom::DidPreviewPageParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPreviewPageParamsPtr result(::printing::mojom::DidPreviewPageParams::New());
  
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success)
        result->page_index = input.page_index();
      if (success)
        result->document_cookie = input.document_cookie();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPreviewDocumentParams::DataView, ::printing::mojom::DidPreviewDocumentParamsPtr>::Read(
    ::printing::mojom::DidPreviewDocumentParams::DataView input,
    ::printing::mojom::DidPreviewDocumentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPreviewDocumentParamsPtr result(::printing::mojom::DidPreviewDocumentParams::New());
  
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success)
        result->document_cookie = input.document_cookie();
      if (success)
        result->expected_pages_count = input.expected_pages_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintParams::DataView, ::printing::mojom::PrintParamsPtr>::Read(
    ::printing::mojom::PrintParams::DataView input,
    ::printing::mojom::PrintParamsPtr* output) {
  bool success = true;
  ::printing::mojom::PrintParamsPtr result(::printing::mojom::PrintParams::New());
  
      if (success && !input.ReadPageSize(&result->page_size))
        success = false;
      if (success && !input.ReadContentSize(&result->content_size))
        success = false;
      if (success && !input.ReadPrintableArea(&result->printable_area))
        success = false;
      if (success)
        result->margin_top = input.margin_top();
      if (success)
        result->margin_left = input.margin_left();
      if (success && !input.ReadPageOrientation(&result->page_orientation))
        success = false;
      if (success && !input.ReadDpi(&result->dpi))
        success = false;
      if (success)
        result->scale_factor = input.scale_factor();
      if (success)
        result->document_cookie = input.document_cookie();
      if (success)
        result->selection_only = input.selection_only();
      if (success)
        result->preview_ui_id = input.preview_ui_id();
      if (success)
        result->preview_request_id = input.preview_request_id();
      if (success)
        result->is_first_request = input.is_first_request();
      if (success && !input.ReadPrintScalingOption(&result->print_scaling_option))
        success = false;
      if (success)
        result->print_to_pdf = input.print_to_pdf();
      if (success)
        result->display_header_footer = input.display_header_footer();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHeaderTemplate(&result->header_template))
        success = false;
      if (success && !input.ReadFooterTemplate(&result->footer_template))
        success = false;
      if (success)
        result->rasterize_pdf = input.rasterize_pdf();
      if (success)
        result->rasterize_pdf_dpi = input.rasterize_pdf_dpi();
      if (success)
        result->should_print_backgrounds = input.should_print_backgrounds();
      if (success && !input.ReadPrintedDocType(&result->printed_doc_type))
        success = false;
      if (success)
        result->prefer_css_page_size = input.prefer_css_page_size();
      if (success)
        result->pages_per_sheet = input.pages_per_sheet();
      if (success) {
        result->generate_tagged_pdf = input.generate_tagged_pdf();
      }
      if (success && !input.ReadGenerateDocumentOutline(&result->generate_document_outline))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintPagesParams::DataView, ::printing::mojom::PrintPagesParamsPtr>::Read(
    ::printing::mojom::PrintPagesParams::DataView input,
    ::printing::mojom::PrintPagesParamsPtr* output) {
  bool success = true;
  ::printing::mojom::PrintPagesParamsPtr result(::printing::mojom::PrintPagesParams::New());
  
      if (success && !input.ReadParams(&result->params))
        success = false;
      if (success && !input.ReadPages(&result->pages))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::DidPrintDocumentParams::DataView, ::printing::mojom::DidPrintDocumentParamsPtr>::Read(
    ::printing::mojom::DidPrintDocumentParams::DataView input,
    ::printing::mojom::DidPrintDocumentParamsPtr* output) {
  bool success = true;
  ::printing::mojom::DidPrintDocumentParamsPtr result(::printing::mojom::DidPrintDocumentParams::New());
  
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success)
        result->document_cookie = input.document_cookie();
      if (success && !input.ReadPageSize(&result->page_size))
        success = false;
      if (success && !input.ReadContentArea(&result->content_area))
        success = false;
      if (success && !input.ReadPhysicalOffsets(&result->physical_offsets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::ScriptedPrintParams::DataView, ::printing::mojom::ScriptedPrintParamsPtr>::Read(
    ::printing::mojom::ScriptedPrintParams::DataView input,
    ::printing::mojom::ScriptedPrintParamsPtr* output) {
  bool success = true;
  ::printing::mojom::ScriptedPrintParamsPtr result(::printing::mojom::ScriptedPrintParams::New());
  
      if (success)
        result->cookie = input.cookie();
      if (success)
        result->expected_pages_count = input.expected_pages_count();
      if (success)
        result->has_selection = input.has_selection();
      if (success)
        result->is_scripted = input.is_scripted();
      if (success && !input.ReadMarginType(&result->margin_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrintWithParamsResultData::DataView, ::printing::mojom::PrintWithParamsResultDataPtr>::Read(
    ::printing::mojom::PrintWithParamsResultData::DataView input,
    ::printing::mojom::PrintWithParamsResultDataPtr* output) {
  bool success = true;
  ::printing::mojom::PrintWithParamsResultDataPtr result(::printing::mojom::PrintWithParamsResultData::New());
  
      if (success && !input.ReadParams(&result->params))
        success = false;
      if (success && !input.ReadAccessibilityTree(&result->accessibility_tree))
        success = false;
      if (success && !input.ReadGenerateDocumentOutline(&result->generate_document_outline))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::printing::mojom::PrintWithParamsResult::DataView, ::printing::mojom::PrintWithParamsResultPtr>::Read(
    ::printing::mojom::PrintWithParamsResult::DataView input,
    ::printing::mojom::PrintWithParamsResultPtr* output) {
  using UnionType = ::printing::mojom::PrintWithParamsResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kData: {
      ::printing::mojom::PrintWithParamsResultDataPtr result_data;
      if (!input.ReadData(&result_data))
        return false;

      *output = UnionType::NewData(
          std::move(result_data));
      break;
    }
    case Tag::kFailureReason: {
      ::printing::mojom::PrintFailureReason result_failure_reason;
      if (!input.ReadFailureReason(&result_failure_reason))
        return false;

      *output = UnionType::NewFailureReason(result_failure_reason);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {


void PrintPreviewUIInterceptorForTesting::SetOptionsFromDocument(OptionsFromDocumentParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->SetOptionsFromDocument(
    std::move(params)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::DidPrepareDocumentForPreview(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->DidPrepareDocumentForPreview(
    std::move(document_cookie)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::DidPreviewPage(DidPreviewPageParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->DidPreviewPage(
    std::move(params)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->MetafileReadyForPrinting(
    std::move(params)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::PrintPreviewFailed(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->PrintPreviewFailed(
    std::move(document_cookie)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::PrintPreviewCancelled(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->PrintPreviewCancelled(
    std::move(document_cookie)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::PrinterSettingsInvalid(int32_t document_cookie, int32_t request_id) {
  GetForwardingInterface()->PrinterSettingsInvalid(
    std::move(document_cookie)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::DidGetDefaultPageLayout(::printing::mojom::PageSizeMarginsPtr page_layout_in_points, const ::gfx::RectF& printable_area_in_points, bool all_pages_have_custom_size, bool all_pages_have_custom_orientation, int32_t request_id) {
  GetForwardingInterface()->DidGetDefaultPageLayout(
    std::move(page_layout_in_points)
    , 
    std::move(printable_area_in_points)
    , 
    std::move(all_pages_have_custom_size)
    , 
    std::move(all_pages_have_custom_orientation)
    , 
    std::move(request_id)
    );
}
void PrintPreviewUIInterceptorForTesting::DidStartPreview(DidStartPreviewParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->DidStartPreview(
    std::move(params)
    , 
    std::move(request_id)
    );
}
PrintPreviewUIAsyncWaiter::PrintPreviewUIAsyncWaiter(
    PrintPreviewUI* proxy) : proxy_(proxy) {}

PrintPreviewUIAsyncWaiter::~PrintPreviewUIAsyncWaiter() = default;




void PrintRenderFrameInterceptorForTesting::PrintRequestedPages() {
  GetForwardingInterface()->PrintRequestedPages();
}
void PrintRenderFrameInterceptorForTesting::PrintWithParams(PrintPagesParamsPtr params, PrintWithParamsCallback callback) {
  GetForwardingInterface()->PrintWithParams(
    std::move(params)
    , std::move(callback));
}
void PrintRenderFrameInterceptorForTesting::PrintForSystemDialog() {
  GetForwardingInterface()->PrintForSystemDialog();
}
void PrintRenderFrameInterceptorForTesting::InitiatePrintPreview(bool has_selection) {
  GetForwardingInterface()->InitiatePrintPreview(
    std::move(has_selection)
    );
}
void PrintRenderFrameInterceptorForTesting::SetPrintPreviewUI(::mojo::PendingAssociatedRemote<PrintPreviewUI> preview) {
  GetForwardingInterface()->SetPrintPreviewUI(
    std::move(preview)
    );
}
void PrintRenderFrameInterceptorForTesting::PrintPreview(::base::Value::Dict settings) {
  GetForwardingInterface()->PrintPreview(
    std::move(settings)
    );
}
void PrintRenderFrameInterceptorForTesting::OnPrintPreviewDialogClosed() {
  GetForwardingInterface()->OnPrintPreviewDialogClosed();
}
void PrintRenderFrameInterceptorForTesting::PrintFrameContent(PrintFrameContentParamsPtr params, PrintFrameContentCallback callback) {
  GetForwardingInterface()->PrintFrameContent(
    std::move(params)
    , std::move(callback));
}
void PrintRenderFrameInterceptorForTesting::ConnectToPdfRenderer() {
  GetForwardingInterface()->ConnectToPdfRenderer();
}
void PrintRenderFrameInterceptorForTesting::PrintingDone(bool success) {
  GetForwardingInterface()->PrintingDone(
    std::move(success)
    );
}
void PrintRenderFrameInterceptorForTesting::PrintNodeUnderContextMenu() {
  GetForwardingInterface()->PrintNodeUnderContextMenu();
}
PrintRenderFrameAsyncWaiter::PrintRenderFrameAsyncWaiter(
    PrintRenderFrame* proxy) : proxy_(proxy) {}

PrintRenderFrameAsyncWaiter::~PrintRenderFrameAsyncWaiter() = default;

void PrintRenderFrameAsyncWaiter::PrintWithParams(
    PrintPagesParamsPtr params, PrintWithParamsResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->PrintWithParams(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintWithParamsResultPtr* out_result
,
             PrintWithParamsResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

PrintWithParamsResultPtr PrintRenderFrameAsyncWaiter::PrintWithParams(
    PrintPagesParamsPtr params) {
  PrintWithParamsResultPtr async_wait_result;
  PrintWithParams(std::move(params),&async_wait_result);
  return async_wait_result;
}

void PrintRenderFrameAsyncWaiter::PrintFrameContent(
    PrintFrameContentParamsPtr params, int32_t* out_document_cookie, DidPrintContentParamsPtr* out_params) {
  base::RunLoop loop;
  proxy_->PrintFrameContent(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_document_cookie
,
             DidPrintContentParamsPtr* out_params
,
             int32_t document_cookie,
             DidPrintContentParamsPtr params) {*out_document_cookie = std::move(document_cookie);*out_params = std::move(params);
            loop->Quit();
          },
          &loop,
          out_document_cookie,
          out_params));
  loop.Run();
}






void PrintManagerHostInterceptorForTesting::DidGetPrintedPagesCount(int32_t cookie, uint32_t number_pages) {
  GetForwardingInterface()->DidGetPrintedPagesCount(
    std::move(cookie)
    , 
    std::move(number_pages)
    );
}
void PrintManagerHostInterceptorForTesting::GetDefaultPrintSettings(GetDefaultPrintSettingsCallback callback) {
  GetForwardingInterface()->GetDefaultPrintSettings(std::move(callback));
}
void PrintManagerHostInterceptorForTesting::DidShowPrintDialog() {
  GetForwardingInterface()->DidShowPrintDialog();
}
void PrintManagerHostInterceptorForTesting::DidPrintDocument(DidPrintDocumentParamsPtr params, DidPrintDocumentCallback callback) {
  GetForwardingInterface()->DidPrintDocument(
    std::move(params)
    , std::move(callback));
}
void PrintManagerHostInterceptorForTesting::IsPrintingEnabled(IsPrintingEnabledCallback callback) {
  GetForwardingInterface()->IsPrintingEnabled(std::move(callback));
}
void PrintManagerHostInterceptorForTesting::ScriptedPrint(ScriptedPrintParamsPtr params, ScriptedPrintCallback callback) {
  GetForwardingInterface()->ScriptedPrint(
    std::move(params)
    , std::move(callback));
}
void PrintManagerHostInterceptorForTesting::PrintingFailed(int32_t cookie, PrintFailureReason reason) {
  GetForwardingInterface()->PrintingFailed(
    std::move(cookie)
    , 
    std::move(reason)
    );
}
void PrintManagerHostInterceptorForTesting::UpdatePrintSettings(::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) {
  GetForwardingInterface()->UpdatePrintSettings(
    std::move(job_settings)
    , std::move(callback));
}
void PrintManagerHostInterceptorForTesting::SetupScriptedPrintPreview(SetupScriptedPrintPreviewCallback callback) {
  GetForwardingInterface()->SetupScriptedPrintPreview(std::move(callback));
}
void PrintManagerHostInterceptorForTesting::ShowScriptedPrintPreview(bool is_modifiable) {
  GetForwardingInterface()->ShowScriptedPrintPreview(
    std::move(is_modifiable)
    );
}
void PrintManagerHostInterceptorForTesting::RequestPrintPreview(RequestPrintPreviewParamsPtr params) {
  GetForwardingInterface()->RequestPrintPreview(
    std::move(params)
    );
}
void PrintManagerHostInterceptorForTesting::CheckForCancel(int32_t preview_ui_id, int32_t request_id, CheckForCancelCallback callback) {
  GetForwardingInterface()->CheckForCancel(
    std::move(preview_ui_id)
    , 
    std::move(request_id)
    , std::move(callback));
}
void PrintManagerHostInterceptorForTesting::MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) {
  GetForwardingInterface()->MetafileReadyForPrinting(
    std::move(params)
    , 
    std::move(request_id)
    );
}
void PrintManagerHostInterceptorForTesting::SetAccessibilityTree(int32_t cookie, const ::ui::AXTreeUpdate& accessibility_tree) {
  GetForwardingInterface()->SetAccessibilityTree(
    std::move(cookie)
    , 
    std::move(accessibility_tree)
    );
}
PrintManagerHostAsyncWaiter::PrintManagerHostAsyncWaiter(
    PrintManagerHost* proxy) : proxy_(proxy) {}

PrintManagerHostAsyncWaiter::~PrintManagerHostAsyncWaiter() = default;

void PrintManagerHostAsyncWaiter::GetDefaultPrintSettings(
    PrintParamsPtr* out_default_settings) {
  base::RunLoop loop;
  proxy_->GetDefaultPrintSettings(
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintParamsPtr* out_default_settings
,
             PrintParamsPtr default_settings) {*out_default_settings = std::move(default_settings);
            loop->Quit();
          },
          &loop,
          out_default_settings));
  loop.Run();
}

PrintParamsPtr PrintManagerHostAsyncWaiter::GetDefaultPrintSettings(
    ) {
  PrintParamsPtr async_wait_result;
  GetDefaultPrintSettings(&async_wait_result);
  return async_wait_result;
}

void PrintManagerHostAsyncWaiter::DidPrintDocument(
    DidPrintDocumentParamsPtr params, bool* out_completed) {
  base::RunLoop loop;
  proxy_->DidPrintDocument(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_completed
,
             bool completed) {*out_completed = std::move(completed);
            loop->Quit();
          },
          &loop,
          out_completed));
  loop.Run();
}

bool PrintManagerHostAsyncWaiter::DidPrintDocument(
    DidPrintDocumentParamsPtr params) {
  bool async_wait_result;
  DidPrintDocument(std::move(params),&async_wait_result);
  return async_wait_result;
}

void PrintManagerHostAsyncWaiter::IsPrintingEnabled(
    bool* out_printing_enabled) {
  base::RunLoop loop;
  proxy_->IsPrintingEnabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_printing_enabled
,
             bool printing_enabled) {*out_printing_enabled = std::move(printing_enabled);
            loop->Quit();
          },
          &loop,
          out_printing_enabled));
  loop.Run();
}

bool PrintManagerHostAsyncWaiter::IsPrintingEnabled(
    ) {
  bool async_wait_result;
  IsPrintingEnabled(&async_wait_result);
  return async_wait_result;
}

void PrintManagerHostAsyncWaiter::ScriptedPrint(
    ScriptedPrintParamsPtr params, PrintPagesParamsPtr* out_settings) {
  base::RunLoop loop;
  proxy_->ScriptedPrint(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintPagesParamsPtr* out_settings
,
             PrintPagesParamsPtr settings) {*out_settings = std::move(settings);
            loop->Quit();
          },
          &loop,
          out_settings));
  loop.Run();
}

PrintPagesParamsPtr PrintManagerHostAsyncWaiter::ScriptedPrint(
    ScriptedPrintParamsPtr params) {
  PrintPagesParamsPtr async_wait_result;
  ScriptedPrint(std::move(params),&async_wait_result);
  return async_wait_result;
}

void PrintManagerHostAsyncWaiter::UpdatePrintSettings(
    ::base::Value::Dict job_settings, PrintPagesParamsPtr* out_current_settings) {
  base::RunLoop loop;
  proxy_->UpdatePrintSettings(
      std::move(job_settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             PrintPagesParamsPtr* out_current_settings
,
             PrintPagesParamsPtr current_settings) {*out_current_settings = std::move(current_settings);
            loop->Quit();
          },
          &loop,
          out_current_settings));
  loop.Run();
}

PrintPagesParamsPtr PrintManagerHostAsyncWaiter::UpdatePrintSettings(
    ::base::Value::Dict job_settings) {
  PrintPagesParamsPtr async_wait_result;
  UpdatePrintSettings(std::move(job_settings),&async_wait_result);
  return async_wait_result;
}

void PrintManagerHostAsyncWaiter::SetupScriptedPrintPreview(
    ) {
  base::RunLoop loop;
  proxy_->SetupScriptedPrintPreview(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PrintManagerHostAsyncWaiter::CheckForCancel(
    int32_t preview_ui_id, int32_t request_id, bool* out_cancel) {
  base::RunLoop loop;
  proxy_->CheckForCancel(
      std::move(preview_ui_id),
      std::move(request_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_cancel
,
             bool cancel) {*out_cancel = std::move(cancel);
            loop->Quit();
          },
          &loop,
          out_cancel));
  loop.Run();
}

bool PrintManagerHostAsyncWaiter::CheckForCancel(
    int32_t preview_ui_id, int32_t request_id) {
  bool async_wait_result;
  CheckForCancel(std::move(preview_ui_id),std::move(request_id),&async_wait_result);
  return async_wait_result;
}






}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif