// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Network_h
#define content_protocol_Network_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/runtime.h"
#include "content/browser/devtools/protocol/security.h"

namespace content {
namespace protocol {
namespace Network {
using ResourceType = String;
using LoaderId = String;
using RequestId = String;
using InterceptionId = String;
using ErrorReason = String;
using TimeSinceEpoch = double;
using MonotonicTime = double;
using Headers = Object;
using ConnectionType = String;
using CookieSameSite = String;
using CookiePriority = String;
using CookieSourceScheme = String;
class ResourceTiming;
using ResourcePriority = String;
class PostDataEntry;
class Request;
class SignedCertificateTimestamp;
class SecurityDetails;
using CertificateTransparencyCompliance = String;
using BlockedReason = String;
using CorsError = String;
class CorsErrorStatus;
using ServiceWorkerResponseSource = String;
class TrustTokenParams;
using TrustTokenOperationType = String;
using AlternateProtocolUsage = String;
using ServiceWorkerRouterSource = String;
class ServiceWorkerRouterInfo;
class Response;
class Initiator;
class CookiePartitionKey;
class Cookie;
using SetCookieBlockedReason = String;
using CookieBlockedReason = String;
using CookieExemptionReason = String;
class BlockedSetCookieWithReason;
class ExemptedSetCookieWithReason;
class AssociatedCookie;
class CookieParam;
class AuthChallenge;
class AuthChallengeResponse;
using InterceptionStage = String;
class RequestPattern;
class SignedExchangeSignature;
class SignedExchangeHeader;
using SignedExchangeErrorField = String;
class SignedExchangeError;
class SignedExchangeInfo;
using ContentEncoding = String;
using PrivateNetworkRequestPolicy = String;
using IPAddressSpace = String;
class ConnectTiming;
class ClientSecurityState;
using CrossOriginOpenerPolicyValue = String;
class CrossOriginOpenerPolicyStatus;
using CrossOriginEmbedderPolicyValue = String;
class CrossOriginEmbedderPolicyStatus;
using ContentSecurityPolicySource = String;
class ContentSecurityPolicyStatus;
class SecurityIsolationStatus;
using ReportStatus = String;
using ReportId = String;
class ReportingApiReport;
class ReportingApiEndpoint;
class LoadNetworkResourcePageResult;
class LoadNetworkResourceOptions;

// ------------- Forward and enum declarations.

namespace ResourceTypeEnum {
CONTENT_EXPORT extern const char Document[];
CONTENT_EXPORT extern const char Stylesheet[];
CONTENT_EXPORT extern const char Image[];
CONTENT_EXPORT extern const char Media[];
CONTENT_EXPORT extern const char Font[];
CONTENT_EXPORT extern const char Script[];
CONTENT_EXPORT extern const char TextTrack[];
CONTENT_EXPORT extern const char XHR[];
CONTENT_EXPORT extern const char Fetch[];
CONTENT_EXPORT extern const char Prefetch[];
CONTENT_EXPORT extern const char EventSource[];
CONTENT_EXPORT extern const char WebSocket[];
CONTENT_EXPORT extern const char Manifest[];
CONTENT_EXPORT extern const char SignedExchange[];
CONTENT_EXPORT extern const char Ping[];
CONTENT_EXPORT extern const char CSPViolationReport[];
CONTENT_EXPORT extern const char Preflight[];
CONTENT_EXPORT extern const char Other[];
} // namespace ResourceTypeEnum

namespace ErrorReasonEnum {
CONTENT_EXPORT extern const char Failed[];
CONTENT_EXPORT extern const char Aborted[];
CONTENT_EXPORT extern const char TimedOut[];
CONTENT_EXPORT extern const char AccessDenied[];
CONTENT_EXPORT extern const char ConnectionClosed[];
CONTENT_EXPORT extern const char ConnectionReset[];
CONTENT_EXPORT extern const char ConnectionRefused[];
CONTENT_EXPORT extern const char ConnectionAborted[];
CONTENT_EXPORT extern const char ConnectionFailed[];
CONTENT_EXPORT extern const char NameNotResolved[];
CONTENT_EXPORT extern const char InternetDisconnected[];
CONTENT_EXPORT extern const char AddressUnreachable[];
CONTENT_EXPORT extern const char BlockedByClient[];
CONTENT_EXPORT extern const char BlockedByResponse[];
} // namespace ErrorReasonEnum

namespace ConnectionTypeEnum {
CONTENT_EXPORT extern const char None[];
CONTENT_EXPORT extern const char Cellular2g[];
CONTENT_EXPORT extern const char Cellular3g[];
CONTENT_EXPORT extern const char Cellular4g[];
CONTENT_EXPORT extern const char Bluetooth[];
CONTENT_EXPORT extern const char Ethernet[];
CONTENT_EXPORT extern const char Wifi[];
CONTENT_EXPORT extern const char Wimax[];
CONTENT_EXPORT extern const char Other[];
} // namespace ConnectionTypeEnum

namespace CookieSameSiteEnum {
CONTENT_EXPORT extern const char Strict[];
CONTENT_EXPORT extern const char Lax[];
CONTENT_EXPORT extern const char None[];
} // namespace CookieSameSiteEnum

namespace CookiePriorityEnum {
CONTENT_EXPORT extern const char Low[];
CONTENT_EXPORT extern const char Medium[];
CONTENT_EXPORT extern const char High[];
} // namespace CookiePriorityEnum

namespace CookieSourceSchemeEnum {
CONTENT_EXPORT extern const char Unset[];
CONTENT_EXPORT extern const char NonSecure[];
CONTENT_EXPORT extern const char Secure[];
} // namespace CookieSourceSchemeEnum

namespace ResourcePriorityEnum {
CONTENT_EXPORT extern const char VeryLow[];
CONTENT_EXPORT extern const char Low[];
CONTENT_EXPORT extern const char Medium[];
CONTENT_EXPORT extern const char High[];
CONTENT_EXPORT extern const char VeryHigh[];
} // namespace ResourcePriorityEnum

namespace CertificateTransparencyComplianceEnum {
CONTENT_EXPORT extern const char Unknown[];
CONTENT_EXPORT extern const char NotCompliant[];
CONTENT_EXPORT extern const char Compliant[];
} // namespace CertificateTransparencyComplianceEnum

namespace BlockedReasonEnum {
CONTENT_EXPORT extern const char Other[];
CONTENT_EXPORT extern const char Csp[];
CONTENT_EXPORT extern const char MixedContent[];
CONTENT_EXPORT extern const char Origin[];
CONTENT_EXPORT extern const char Inspector[];
CONTENT_EXPORT extern const char SubresourceFilter[];
CONTENT_EXPORT extern const char ContentType[];
CONTENT_EXPORT extern const char CoepFrameResourceNeedsCoepHeader[];
CONTENT_EXPORT extern const char CoopSandboxedIframeCannotNavigateToCoopPage[];
CONTENT_EXPORT extern const char CorpNotSameOrigin[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[];
CONTENT_EXPORT extern const char CorpNotSameSite[];
CONTENT_EXPORT extern const char SriMessageSignatureMismatch[];
} // namespace BlockedReasonEnum

namespace CorsErrorEnum {
CONTENT_EXPORT extern const char DisallowedByMode[];
CONTENT_EXPORT extern const char InvalidResponse[];
CONTENT_EXPORT extern const char WildcardOriginNotAllowed[];
CONTENT_EXPORT extern const char MissingAllowOriginHeader[];
CONTENT_EXPORT extern const char MultipleAllowOriginValues[];
CONTENT_EXPORT extern const char InvalidAllowOriginValue[];
CONTENT_EXPORT extern const char AllowOriginMismatch[];
CONTENT_EXPORT extern const char InvalidAllowCredentials[];
CONTENT_EXPORT extern const char CorsDisabledScheme[];
CONTENT_EXPORT extern const char PreflightInvalidStatus[];
CONTENT_EXPORT extern const char PreflightDisallowedRedirect[];
CONTENT_EXPORT extern const char PreflightWildcardOriginNotAllowed[];
CONTENT_EXPORT extern const char PreflightMissingAllowOriginHeader[];
CONTENT_EXPORT extern const char PreflightMultipleAllowOriginValues[];
CONTENT_EXPORT extern const char PreflightInvalidAllowOriginValue[];
CONTENT_EXPORT extern const char PreflightAllowOriginMismatch[];
CONTENT_EXPORT extern const char PreflightInvalidAllowCredentials[];
CONTENT_EXPORT extern const char PreflightMissingAllowExternal[];
CONTENT_EXPORT extern const char PreflightInvalidAllowExternal[];
CONTENT_EXPORT extern const char PreflightMissingAllowPrivateNetwork[];
CONTENT_EXPORT extern const char PreflightInvalidAllowPrivateNetwork[];
CONTENT_EXPORT extern const char InvalidAllowMethodsPreflightResponse[];
CONTENT_EXPORT extern const char InvalidAllowHeadersPreflightResponse[];
CONTENT_EXPORT extern const char MethodDisallowedByPreflightResponse[];
CONTENT_EXPORT extern const char HeaderDisallowedByPreflightResponse[];
CONTENT_EXPORT extern const char RedirectContainsCredentials[];
CONTENT_EXPORT extern const char InsecurePrivateNetwork[];
CONTENT_EXPORT extern const char InvalidPrivateNetworkAccess[];
CONTENT_EXPORT extern const char UnexpectedPrivateNetworkAccess[];
CONTENT_EXPORT extern const char NoCorsRedirectModeNotFollow[];
CONTENT_EXPORT extern const char PreflightMissingPrivateNetworkAccessId[];
CONTENT_EXPORT extern const char PreflightMissingPrivateNetworkAccessName[];
CONTENT_EXPORT extern const char PrivateNetworkAccessPermissionUnavailable[];
CONTENT_EXPORT extern const char PrivateNetworkAccessPermissionDenied[];
} // namespace CorsErrorEnum

namespace ServiceWorkerResponseSourceEnum {
CONTENT_EXPORT extern const char CacheStorage[];
CONTENT_EXPORT extern const char HttpCache[];
CONTENT_EXPORT extern const char FallbackCode[];
CONTENT_EXPORT extern const char Network[];
} // namespace ServiceWorkerResponseSourceEnum

namespace TrustTokenOperationTypeEnum {
CONTENT_EXPORT extern const char Issuance[];
CONTENT_EXPORT extern const char Redemption[];
CONTENT_EXPORT extern const char Signing[];
} // namespace TrustTokenOperationTypeEnum

namespace AlternateProtocolUsageEnum {
CONTENT_EXPORT extern const char AlternativeJobWonWithoutRace[];
CONTENT_EXPORT extern const char AlternativeJobWonRace[];
CONTENT_EXPORT extern const char MainJobWonRace[];
CONTENT_EXPORT extern const char MappingMissing[];
CONTENT_EXPORT extern const char Broken[];
CONTENT_EXPORT extern const char DnsAlpnH3JobWonWithoutRace[];
CONTENT_EXPORT extern const char DnsAlpnH3JobWonRace[];
CONTENT_EXPORT extern const char UnspecifiedReason[];
} // namespace AlternateProtocolUsageEnum

namespace ServiceWorkerRouterSourceEnum {
CONTENT_EXPORT extern const char Network[];
CONTENT_EXPORT extern const char Cache[];
CONTENT_EXPORT extern const char FetchEvent[];
CONTENT_EXPORT extern const char RaceNetworkAndFetchHandler[];
} // namespace ServiceWorkerRouterSourceEnum

namespace SetCookieBlockedReasonEnum {
CONTENT_EXPORT extern const char SecureOnly[];
CONTENT_EXPORT extern const char SameSiteStrict[];
CONTENT_EXPORT extern const char SameSiteLax[];
CONTENT_EXPORT extern const char SameSiteUnspecifiedTreatedAsLax[];
CONTENT_EXPORT extern const char SameSiteNoneInsecure[];
CONTENT_EXPORT extern const char UserPreferences[];
CONTENT_EXPORT extern const char ThirdPartyPhaseout[];
CONTENT_EXPORT extern const char ThirdPartyBlockedInFirstPartySet[];
CONTENT_EXPORT extern const char SyntaxError[];
CONTENT_EXPORT extern const char SchemeNotSupported[];
CONTENT_EXPORT extern const char OverwriteSecure[];
CONTENT_EXPORT extern const char InvalidDomain[];
CONTENT_EXPORT extern const char InvalidPrefix[];
CONTENT_EXPORT extern const char UnknownError[];
CONTENT_EXPORT extern const char SchemefulSameSiteStrict[];
CONTENT_EXPORT extern const char SchemefulSameSiteLax[];
CONTENT_EXPORT extern const char SchemefulSameSiteUnspecifiedTreatedAsLax[];
CONTENT_EXPORT extern const char SamePartyFromCrossPartyContext[];
CONTENT_EXPORT extern const char SamePartyConflictsWithOtherAttributes[];
CONTENT_EXPORT extern const char NameValuePairExceedsMaxSize[];
CONTENT_EXPORT extern const char DisallowedCharacter[];
CONTENT_EXPORT extern const char NoCookieContent[];
} // namespace SetCookieBlockedReasonEnum

namespace CookieBlockedReasonEnum {
CONTENT_EXPORT extern const char SecureOnly[];
CONTENT_EXPORT extern const char NotOnPath[];
CONTENT_EXPORT extern const char DomainMismatch[];
CONTENT_EXPORT extern const char SameSiteStrict[];
CONTENT_EXPORT extern const char SameSiteLax[];
CONTENT_EXPORT extern const char SameSiteUnspecifiedTreatedAsLax[];
CONTENT_EXPORT extern const char SameSiteNoneInsecure[];
CONTENT_EXPORT extern const char UserPreferences[];
CONTENT_EXPORT extern const char ThirdPartyPhaseout[];
CONTENT_EXPORT extern const char ThirdPartyBlockedInFirstPartySet[];
CONTENT_EXPORT extern const char UnknownError[];
CONTENT_EXPORT extern const char SchemefulSameSiteStrict[];
CONTENT_EXPORT extern const char SchemefulSameSiteLax[];
CONTENT_EXPORT extern const char SchemefulSameSiteUnspecifiedTreatedAsLax[];
CONTENT_EXPORT extern const char SamePartyFromCrossPartyContext[];
CONTENT_EXPORT extern const char NameValuePairExceedsMaxSize[];
CONTENT_EXPORT extern const char PortMismatch[];
CONTENT_EXPORT extern const char SchemeMismatch[];
} // namespace CookieBlockedReasonEnum

namespace CookieExemptionReasonEnum {
CONTENT_EXPORT extern const char None[];
CONTENT_EXPORT extern const char UserSetting[];
CONTENT_EXPORT extern const char TPCDMetadata[];
CONTENT_EXPORT extern const char TPCDDeprecationTrial[];
CONTENT_EXPORT extern const char TopLevelTPCDDeprecationTrial[];
CONTENT_EXPORT extern const char TPCDHeuristics[];
CONTENT_EXPORT extern const char EnterprisePolicy[];
CONTENT_EXPORT extern const char StorageAccess[];
CONTENT_EXPORT extern const char TopLevelStorageAccess[];
CONTENT_EXPORT extern const char Scheme[];
CONTENT_EXPORT extern const char SameSiteNoneCookiesInSandbox[];
} // namespace CookieExemptionReasonEnum

namespace InterceptionStageEnum {
CONTENT_EXPORT extern const char Request[];
CONTENT_EXPORT extern const char HeadersReceived[];
} // namespace InterceptionStageEnum

namespace SignedExchangeErrorFieldEnum {
CONTENT_EXPORT extern const char SignatureSig[];
CONTENT_EXPORT extern const char SignatureIntegrity[];
CONTENT_EXPORT extern const char SignatureCertUrl[];
CONTENT_EXPORT extern const char SignatureCertSha256[];
CONTENT_EXPORT extern const char SignatureValidityUrl[];
CONTENT_EXPORT extern const char SignatureTimestamps[];
} // namespace SignedExchangeErrorFieldEnum

namespace ContentEncodingEnum {
CONTENT_EXPORT extern const char Deflate[];
CONTENT_EXPORT extern const char Gzip[];
CONTENT_EXPORT extern const char Br[];
CONTENT_EXPORT extern const char Zstd[];
} // namespace ContentEncodingEnum

namespace PrivateNetworkRequestPolicyEnum {
CONTENT_EXPORT extern const char Allow[];
CONTENT_EXPORT extern const char BlockFromInsecureToMorePrivate[];
CONTENT_EXPORT extern const char WarnFromInsecureToMorePrivate[];
CONTENT_EXPORT extern const char PreflightBlock[];
CONTENT_EXPORT extern const char PreflightWarn[];
} // namespace PrivateNetworkRequestPolicyEnum

namespace IPAddressSpaceEnum {
CONTENT_EXPORT extern const char Local[];
CONTENT_EXPORT extern const char Private[];
CONTENT_EXPORT extern const char Public[];
CONTENT_EXPORT extern const char Unknown[];
} // namespace IPAddressSpaceEnum

namespace CrossOriginOpenerPolicyValueEnum {
CONTENT_EXPORT extern const char SameOrigin[];
CONTENT_EXPORT extern const char SameOriginAllowPopups[];
CONTENT_EXPORT extern const char RestrictProperties[];
CONTENT_EXPORT extern const char UnsafeNone[];
CONTENT_EXPORT extern const char SameOriginPlusCoep[];
CONTENT_EXPORT extern const char RestrictPropertiesPlusCoep[];
CONTENT_EXPORT extern const char NoopenerAllowPopups[];
} // namespace CrossOriginOpenerPolicyValueEnum

namespace CrossOriginEmbedderPolicyValueEnum {
CONTENT_EXPORT extern const char None[];
CONTENT_EXPORT extern const char Credentialless[];
CONTENT_EXPORT extern const char RequireCorp[];
} // namespace CrossOriginEmbedderPolicyValueEnum

namespace ContentSecurityPolicySourceEnum {
CONTENT_EXPORT extern const char HTTP[];
CONTENT_EXPORT extern const char Meta[];
} // namespace ContentSecurityPolicySourceEnum

namespace ReportStatusEnum {
CONTENT_EXPORT extern const char Queued[];
CONTENT_EXPORT extern const char Pending[];
CONTENT_EXPORT extern const char MarkedForRemoval[];
CONTENT_EXPORT extern const char Success[];
} // namespace ReportStatusEnum

namespace TrustTokenOperationDone {
namespace StatusEnum {
CONTENT_EXPORT extern const char* Ok;
CONTENT_EXPORT extern const char* InvalidArgument;
CONTENT_EXPORT extern const char* MissingIssuerKeys;
CONTENT_EXPORT extern const char* FailedPrecondition;
CONTENT_EXPORT extern const char* ResourceExhausted;
CONTENT_EXPORT extern const char* AlreadyExists;
CONTENT_EXPORT extern const char* ResourceLimited;
CONTENT_EXPORT extern const char* Unauthorized;
CONTENT_EXPORT extern const char* BadResponse;
CONTENT_EXPORT extern const char* InternalError;
CONTENT_EXPORT extern const char* UnknownError;
CONTENT_EXPORT extern const char* FulfilledLocally;
CONTENT_EXPORT extern const char* SiteIssuerLimit;
} // StatusEnum
} // TrustTokenOperationDone

// ------------- Type and builder declarations.

class CONTENT_EXPORT ResourceTiming : public ::crdtp::ProtocolObject<ResourceTiming> {
public:
    ~ResourceTiming() override { }

    double GetRequestTime() { return m_requestTime; }
    void SetRequestTime(double value) { m_requestTime = value; }

    double GetProxyStart() { return m_proxyStart; }
    void SetProxyStart(double value) { m_proxyStart = value; }

    double GetProxyEnd() { return m_proxyEnd; }
    void SetProxyEnd(double value) { m_proxyEnd = value; }

    double GetDnsStart() { return m_dnsStart; }
    void SetDnsStart(double value) { m_dnsStart = value; }

    double GetDnsEnd() { return m_dnsEnd; }
    void SetDnsEnd(double value) { m_dnsEnd = value; }

    double GetConnectStart() { return m_connectStart; }
    void SetConnectStart(double value) { m_connectStart = value; }

    double GetConnectEnd() { return m_connectEnd; }
    void SetConnectEnd(double value) { m_connectEnd = value; }

    double GetSslStart() { return m_sslStart; }
    void SetSslStart(double value) { m_sslStart = value; }

    double GetSslEnd() { return m_sslEnd; }
    void SetSslEnd(double value) { m_sslEnd = value; }

    double GetWorkerStart() { return m_workerStart; }
    void SetWorkerStart(double value) { m_workerStart = value; }

    double GetWorkerReady() { return m_workerReady; }
    void SetWorkerReady(double value) { m_workerReady = value; }

    double GetWorkerFetchStart() { return m_workerFetchStart; }
    void SetWorkerFetchStart(double value) { m_workerFetchStart = value; }

    double GetWorkerRespondWithSettled() { return m_workerRespondWithSettled; }
    void SetWorkerRespondWithSettled(double value) { m_workerRespondWithSettled = value; }

    bool HasWorkerRouterEvaluationStart() { return !!m_workerRouterEvaluationStart; }
    double GetWorkerRouterEvaluationStart(double defaultValue) const {
       return m_workerRouterEvaluationStart.value_or(defaultValue);
    }
    const std::optional<double>& GetWorkerRouterEvaluationStart() const {
       return m_workerRouterEvaluationStart;
    }
    void SetWorkerRouterEvaluationStart(double value) { m_workerRouterEvaluationStart = value; }

    bool HasWorkerCacheLookupStart() { return !!m_workerCacheLookupStart; }
    double GetWorkerCacheLookupStart(double defaultValue) const {
       return m_workerCacheLookupStart.value_or(defaultValue);
    }
    const std::optional<double>& GetWorkerCacheLookupStart() const {
       return m_workerCacheLookupStart;
    }
    void SetWorkerCacheLookupStart(double value) { m_workerCacheLookupStart = value; }

    double GetSendStart() { return m_sendStart; }
    void SetSendStart(double value) { m_sendStart = value; }

    double GetSendEnd() { return m_sendEnd; }
    void SetSendEnd(double value) { m_sendEnd = value; }

    double GetPushStart() { return m_pushStart; }
    void SetPushStart(double value) { m_pushStart = value; }

    double GetPushEnd() { return m_pushEnd; }
    void SetPushEnd(double value) { m_pushEnd = value; }

    double GetReceiveHeadersStart() { return m_receiveHeadersStart; }
    void SetReceiveHeadersStart(double value) { m_receiveHeadersStart = value; }

    double GetReceiveHeadersEnd() { return m_receiveHeadersEnd; }
    void SetReceiveHeadersEnd(double value) { m_receiveHeadersEnd = value; }

    template<int STATE>
    class ResourceTimingBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestTimeSet = 1 << 1,
            ProxyStartSet = 1 << 2,
            ProxyEndSet = 1 << 3,
            DnsStartSet = 1 << 4,
            DnsEndSet = 1 << 5,
            ConnectStartSet = 1 << 6,
            ConnectEndSet = 1 << 7,
            SslStartSet = 1 << 8,
            SslEndSet = 1 << 9,
            WorkerStartSet = 1 << 10,
            WorkerReadySet = 1 << 11,
            WorkerFetchStartSet = 1 << 12,
            WorkerRespondWithSettledSet = 1 << 13,
            SendStartSet = 1 << 14,
            SendEndSet = 1 << 15,
            PushStartSet = 1 << 16,
            PushEndSet = 1 << 17,
            ReceiveHeadersStartSet = 1 << 18,
            ReceiveHeadersEndSet = 1 << 19,
            AllFieldsSet = (RequestTimeSet | ProxyStartSet | ProxyEndSet | DnsStartSet | DnsEndSet | ConnectStartSet | ConnectEndSet | SslStartSet | SslEndSet | WorkerStartSet | WorkerReadySet | WorkerFetchStartSet | WorkerRespondWithSettledSet | SendStartSet | SendEndSet | PushStartSet | PushEndSet | ReceiveHeadersStartSet | ReceiveHeadersEndSet | 0)};


        ResourceTimingBuilder<STATE | RequestTimeSet>& SetRequestTime(double value)
        {
            static_assert(!(STATE & RequestTimeSet), "property requestTime should not be set yet");
            m_result->SetRequestTime(value);
            return castState<RequestTimeSet>();
        }

        ResourceTimingBuilder<STATE | ProxyStartSet>& SetProxyStart(double value)
        {
            static_assert(!(STATE & ProxyStartSet), "property proxyStart should not be set yet");
            m_result->SetProxyStart(value);
            return castState<ProxyStartSet>();
        }

        ResourceTimingBuilder<STATE | ProxyEndSet>& SetProxyEnd(double value)
        {
            static_assert(!(STATE & ProxyEndSet), "property proxyEnd should not be set yet");
            m_result->SetProxyEnd(value);
            return castState<ProxyEndSet>();
        }

        ResourceTimingBuilder<STATE | DnsStartSet>& SetDnsStart(double value)
        {
            static_assert(!(STATE & DnsStartSet), "property dnsStart should not be set yet");
            m_result->SetDnsStart(value);
            return castState<DnsStartSet>();
        }

        ResourceTimingBuilder<STATE | DnsEndSet>& SetDnsEnd(double value)
        {
            static_assert(!(STATE & DnsEndSet), "property dnsEnd should not be set yet");
            m_result->SetDnsEnd(value);
            return castState<DnsEndSet>();
        }

        ResourceTimingBuilder<STATE | ConnectStartSet>& SetConnectStart(double value)
        {
            static_assert(!(STATE & ConnectStartSet), "property connectStart should not be set yet");
            m_result->SetConnectStart(value);
            return castState<ConnectStartSet>();
        }

        ResourceTimingBuilder<STATE | ConnectEndSet>& SetConnectEnd(double value)
        {
            static_assert(!(STATE & ConnectEndSet), "property connectEnd should not be set yet");
            m_result->SetConnectEnd(value);
            return castState<ConnectEndSet>();
        }

        ResourceTimingBuilder<STATE | SslStartSet>& SetSslStart(double value)
        {
            static_assert(!(STATE & SslStartSet), "property sslStart should not be set yet");
            m_result->SetSslStart(value);
            return castState<SslStartSet>();
        }

        ResourceTimingBuilder<STATE | SslEndSet>& SetSslEnd(double value)
        {
            static_assert(!(STATE & SslEndSet), "property sslEnd should not be set yet");
            m_result->SetSslEnd(value);
            return castState<SslEndSet>();
        }

        ResourceTimingBuilder<STATE | WorkerStartSet>& SetWorkerStart(double value)
        {
            static_assert(!(STATE & WorkerStartSet), "property workerStart should not be set yet");
            m_result->SetWorkerStart(value);
            return castState<WorkerStartSet>();
        }

        ResourceTimingBuilder<STATE | WorkerReadySet>& SetWorkerReady(double value)
        {
            static_assert(!(STATE & WorkerReadySet), "property workerReady should not be set yet");
            m_result->SetWorkerReady(value);
            return castState<WorkerReadySet>();
        }

        ResourceTimingBuilder<STATE | WorkerFetchStartSet>& SetWorkerFetchStart(double value)
        {
            static_assert(!(STATE & WorkerFetchStartSet), "property workerFetchStart should not be set yet");
            m_result->SetWorkerFetchStart(value);
            return castState<WorkerFetchStartSet>();
        }

        ResourceTimingBuilder<STATE | WorkerRespondWithSettledSet>& SetWorkerRespondWithSettled(double value)
        {
            static_assert(!(STATE & WorkerRespondWithSettledSet), "property workerRespondWithSettled should not be set yet");
            m_result->SetWorkerRespondWithSettled(value);
            return castState<WorkerRespondWithSettledSet>();
        }

        ResourceTimingBuilder<STATE>& SetWorkerRouterEvaluationStart(double value)
        {
            m_result->SetWorkerRouterEvaluationStart(value);
            return *this;
        }

        ResourceTimingBuilder<STATE>& SetWorkerCacheLookupStart(double value)
        {
            m_result->SetWorkerCacheLookupStart(value);
            return *this;
        }

        ResourceTimingBuilder<STATE | SendStartSet>& SetSendStart(double value)
        {
            static_assert(!(STATE & SendStartSet), "property sendStart should not be set yet");
            m_result->SetSendStart(value);
            return castState<SendStartSet>();
        }

        ResourceTimingBuilder<STATE | SendEndSet>& SetSendEnd(double value)
        {
            static_assert(!(STATE & SendEndSet), "property sendEnd should not be set yet");
            m_result->SetSendEnd(value);
            return castState<SendEndSet>();
        }

        ResourceTimingBuilder<STATE | PushStartSet>& SetPushStart(double value)
        {
            static_assert(!(STATE & PushStartSet), "property pushStart should not be set yet");
            m_result->SetPushStart(value);
            return castState<PushStartSet>();
        }

        ResourceTimingBuilder<STATE | PushEndSet>& SetPushEnd(double value)
        {
            static_assert(!(STATE & PushEndSet), "property pushEnd should not be set yet");
            m_result->SetPushEnd(value);
            return castState<PushEndSet>();
        }

        ResourceTimingBuilder<STATE | ReceiveHeadersStartSet>& SetReceiveHeadersStart(double value)
        {
            static_assert(!(STATE & ReceiveHeadersStartSet), "property receiveHeadersStart should not be set yet");
            m_result->SetReceiveHeadersStart(value);
            return castState<ReceiveHeadersStartSet>();
        }

        ResourceTimingBuilder<STATE | ReceiveHeadersEndSet>& SetReceiveHeadersEnd(double value)
        {
            static_assert(!(STATE & ReceiveHeadersEndSet), "property receiveHeadersEnd should not be set yet");
            m_result->SetReceiveHeadersEnd(value);
            return castState<ReceiveHeadersEndSet>();
        }

        std::unique_ptr<ResourceTiming> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ResourceTiming;
        ResourceTimingBuilder() : m_result(new ResourceTiming()) { }

        template<int STEP> ResourceTimingBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResourceTimingBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ResourceTiming> m_result;
    };

    static ResourceTimingBuilder<0> Create()
    {
        return ResourceTimingBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ResourceTiming()
    {
          m_requestTime = 0;
          m_proxyStart = 0;
          m_proxyEnd = 0;
          m_dnsStart = 0;
          m_dnsEnd = 0;
          m_connectStart = 0;
          m_connectEnd = 0;
          m_sslStart = 0;
          m_sslEnd = 0;
          m_workerStart = 0;
          m_workerReady = 0;
          m_workerFetchStart = 0;
          m_workerRespondWithSettled = 0;
          m_sendStart = 0;
          m_sendEnd = 0;
          m_pushStart = 0;
          m_pushEnd = 0;
          m_receiveHeadersStart = 0;
          m_receiveHeadersEnd = 0;
    }

    double m_requestTime;
    double m_proxyStart;
    double m_proxyEnd;
    double m_dnsStart;
    double m_dnsEnd;
    double m_connectStart;
    double m_connectEnd;
    double m_sslStart;
    double m_sslEnd;
    double m_workerStart;
    double m_workerReady;
    double m_workerFetchStart;
    double m_workerRespondWithSettled;
    std::optional<double> m_workerRouterEvaluationStart;
    std::optional<double> m_workerCacheLookupStart;
    double m_sendStart;
    double m_sendEnd;
    double m_pushStart;
    double m_pushEnd;
    double m_receiveHeadersStart;
    double m_receiveHeadersEnd;
};


class CONTENT_EXPORT PostDataEntry : public ::crdtp::ProtocolObject<PostDataEntry> {
public:
    ~PostDataEntry() override { }

    bool HasBytes() { return !!m_bytes; }
    Binary GetBytes(const Binary& defaultValue) const {
       return m_bytes.value_or(defaultValue);
    }
    const std::optional<Binary>& GetBytes() const {
       return m_bytes;
    }
    void SetBytes(const Binary& value) { m_bytes = value; }

    template<int STATE>
    class PostDataEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        PostDataEntryBuilder<STATE>& SetBytes(const Binary& value)
        {
            m_result->SetBytes(value);
            return *this;
        }

        std::unique_ptr<PostDataEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PostDataEntry;
        PostDataEntryBuilder() : m_result(new PostDataEntry()) { }

        template<int STEP> PostDataEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PostDataEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::PostDataEntry> m_result;
    };

    static PostDataEntryBuilder<0> Create()
    {
        return PostDataEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PostDataEntry()
    {
    }

    std::optional<Binary> m_bytes;
};


class CONTENT_EXPORT Request : public ::crdtp::ProtocolObject<Request> {
public:
    ~Request() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    bool HasUrlFragment() { return !!m_urlFragment; }
    String GetUrlFragment(const String& defaultValue) const {
       return m_urlFragment.value_or(defaultValue);
    }
    const std::optional<String>& GetUrlFragment() const {
       return m_urlFragment;
    }
    void SetUrlFragment(const String& value) { m_urlFragment = value; }

    String GetMethod() { return m_method; }
    void SetMethod(const String& value) { m_method = value; }

    protocol::Network::Headers* GetHeaders() { return m_headers.get(); }
    void SetHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    bool HasPostData() { return !!m_postData; }
    String GetPostData(const String& defaultValue) const {
       return m_postData.value_or(defaultValue);
    }
    const std::optional<String>& GetPostData() const {
       return m_postData;
    }
    void SetPostData(const String& value) { m_postData = value; }

    bool HasHasPostData() { return !!m_hasPostData; }
    bool GetHasPostData(bool defaultValue) const {
       return m_hasPostData.value_or(defaultValue);
    }
    const std::optional<bool>& GetHasPostData() const {
       return m_hasPostData;
    }
    void SetHasPostData(bool value) { m_hasPostData = value; }

    bool HasPostDataEntries() { return !!m_postDataEntries; }
    protocol::Array<protocol::Network::PostDataEntry>* GetPostDataEntries(protocol::Array<protocol::Network::PostDataEntry>* defaultValue) {
       return m_postDataEntries ? m_postDataEntries.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>>& GetPostDataEntries() const {
       return m_postDataEntries;
    }
    void SetPostDataEntries(std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>> value) { m_postDataEntries = std::move(value); }

    bool HasMixedContentType() { return !!m_mixedContentType; }
    String GetMixedContentType(const String& defaultValue) const {
       return m_mixedContentType.value_or(defaultValue);
    }
    const std::optional<String>& GetMixedContentType() const {
       return m_mixedContentType;
    }
    void SetMixedContentType(const String& value) { m_mixedContentType = value; }

    String GetInitialPriority() { return m_initialPriority; }
    void SetInitialPriority(const String& value) { m_initialPriority = value; }

    struct CONTENT_EXPORT ReferrerPolicyEnum {
        static const char* UnsafeUrl;
        static const char* NoReferrerWhenDowngrade;
        static const char* NoReferrer;
        static const char* Origin;
        static const char* OriginWhenCrossOrigin;
        static const char* SameOrigin;
        static const char* StrictOrigin;
        static const char* StrictOriginWhenCrossOrigin;
    }; // ReferrerPolicyEnum

    String GetReferrerPolicy() { return m_referrerPolicy; }
    void SetReferrerPolicy(const String& value) { m_referrerPolicy = value; }

    bool HasIsLinkPreload() { return !!m_isLinkPreload; }
    bool GetIsLinkPreload(bool defaultValue) const {
       return m_isLinkPreload.value_or(defaultValue);
    }
    const std::optional<bool>& GetIsLinkPreload() const {
       return m_isLinkPreload;
    }
    void SetIsLinkPreload(bool value) { m_isLinkPreload = value; }

    bool HasTrustTokenParams() { return !!m_trustTokenParams; }
    protocol::Network::TrustTokenParams* GetTrustTokenParams(protocol::Network::TrustTokenParams* defaultValue) {
       return m_trustTokenParams ? m_trustTokenParams.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::TrustTokenParams>& GetTrustTokenParams() const {
       return m_trustTokenParams;
    }
    void SetTrustTokenParams(std::unique_ptr<protocol::Network::TrustTokenParams> value) { m_trustTokenParams = std::move(value); }

    bool HasIsSameSite() { return !!m_isSameSite; }
    bool GetIsSameSite(bool defaultValue) const {
       return m_isSameSite.value_or(defaultValue);
    }
    const std::optional<bool>& GetIsSameSite() const {
       return m_isSameSite;
    }
    void SetIsSameSite(bool value) { m_isSameSite = value; }

    template<int STATE>
    class RequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            MethodSet = 1 << 2,
            HeadersSet = 1 << 3,
            InitialPrioritySet = 1 << 4,
            ReferrerPolicySet = 1 << 5,
            AllFieldsSet = (UrlSet | MethodSet | HeadersSet | InitialPrioritySet | ReferrerPolicySet | 0)};


        RequestBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        RequestBuilder<STATE>& SetUrlFragment(const String& value)
        {
            m_result->SetUrlFragment(value);
            return *this;
        }

        RequestBuilder<STATE | MethodSet>& SetMethod(const String& value)
        {
            static_assert(!(STATE & MethodSet), "property method should not be set yet");
            m_result->SetMethod(value);
            return castState<MethodSet>();
        }

        RequestBuilder<STATE | HeadersSet>& SetHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->SetHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        RequestBuilder<STATE>& SetPostData(const String& value)
        {
            m_result->SetPostData(value);
            return *this;
        }

        RequestBuilder<STATE>& SetHasPostData(bool value)
        {
            m_result->SetHasPostData(value);
            return *this;
        }

        RequestBuilder<STATE>& SetPostDataEntries(std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>> value)
        {
            m_result->SetPostDataEntries(std::move(value));
            return *this;
        }

        RequestBuilder<STATE>& SetMixedContentType(const String& value)
        {
            m_result->SetMixedContentType(value);
            return *this;
        }

        RequestBuilder<STATE | InitialPrioritySet>& SetInitialPriority(const String& value)
        {
            static_assert(!(STATE & InitialPrioritySet), "property initialPriority should not be set yet");
            m_result->SetInitialPriority(value);
            return castState<InitialPrioritySet>();
        }

        RequestBuilder<STATE | ReferrerPolicySet>& SetReferrerPolicy(const String& value)
        {
            static_assert(!(STATE & ReferrerPolicySet), "property referrerPolicy should not be set yet");
            m_result->SetReferrerPolicy(value);
            return castState<ReferrerPolicySet>();
        }

        RequestBuilder<STATE>& SetIsLinkPreload(bool value)
        {
            m_result->SetIsLinkPreload(value);
            return *this;
        }

        RequestBuilder<STATE>& SetTrustTokenParams(std::unique_ptr<protocol::Network::TrustTokenParams> value)
        {
            m_result->SetTrustTokenParams(std::move(value));
            return *this;
        }

        RequestBuilder<STATE>& SetIsSameSite(bool value)
        {
            m_result->SetIsSameSite(value);
            return *this;
        }

        std::unique_ptr<Request> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Request;
        RequestBuilder() : m_result(new Request()) { }

        template<int STEP> RequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Request> m_result;
    };

    static RequestBuilder<0> Create()
    {
        return RequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Request()
    {
    }

    String m_url;
    std::optional<String> m_urlFragment;
    String m_method;
    std::unique_ptr<protocol::Network::Headers> m_headers;
    std::optional<String> m_postData;
    std::optional<bool> m_hasPostData;
    std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>> m_postDataEntries;
    std::optional<String> m_mixedContentType;
    String m_initialPriority;
    String m_referrerPolicy;
    std::optional<bool> m_isLinkPreload;
    std::unique_ptr<protocol::Network::TrustTokenParams> m_trustTokenParams;
    std::optional<bool> m_isSameSite;
};


class CONTENT_EXPORT SignedCertificateTimestamp : public ::crdtp::ProtocolObject<SignedCertificateTimestamp> {
public:
    ~SignedCertificateTimestamp() override { }

    String GetStatus() { return m_status; }
    void SetStatus(const String& value) { m_status = value; }

    String GetOrigin() { return m_origin; }
    void SetOrigin(const String& value) { m_origin = value; }

    String GetLogDescription() { return m_logDescription; }
    void SetLogDescription(const String& value) { m_logDescription = value; }

    String GetLogId() { return m_logId; }
    void SetLogId(const String& value) { m_logId = value; }

    double GetTimestamp() { return m_timestamp; }
    void SetTimestamp(double value) { m_timestamp = value; }

    String GetHashAlgorithm() { return m_hashAlgorithm; }
    void SetHashAlgorithm(const String& value) { m_hashAlgorithm = value; }

    String GetSignatureAlgorithm() { return m_signatureAlgorithm; }
    void SetSignatureAlgorithm(const String& value) { m_signatureAlgorithm = value; }

    String GetSignatureData() { return m_signatureData; }
    void SetSignatureData(const String& value) { m_signatureData = value; }

    template<int STATE>
    class SignedCertificateTimestampBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StatusSet = 1 << 1,
            OriginSet = 1 << 2,
            LogDescriptionSet = 1 << 3,
            LogIdSet = 1 << 4,
            TimestampSet = 1 << 5,
            HashAlgorithmSet = 1 << 6,
            SignatureAlgorithmSet = 1 << 7,
            SignatureDataSet = 1 << 8,
            AllFieldsSet = (StatusSet | OriginSet | LogDescriptionSet | LogIdSet | TimestampSet | HashAlgorithmSet | SignatureAlgorithmSet | SignatureDataSet | 0)};


        SignedCertificateTimestampBuilder<STATE | StatusSet>& SetStatus(const String& value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->SetStatus(value);
            return castState<StatusSet>();
        }

        SignedCertificateTimestampBuilder<STATE | OriginSet>& SetOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->SetOrigin(value);
            return castState<OriginSet>();
        }

        SignedCertificateTimestampBuilder<STATE | LogDescriptionSet>& SetLogDescription(const String& value)
        {
            static_assert(!(STATE & LogDescriptionSet), "property logDescription should not be set yet");
            m_result->SetLogDescription(value);
            return castState<LogDescriptionSet>();
        }

        SignedCertificateTimestampBuilder<STATE | LogIdSet>& SetLogId(const String& value)
        {
            static_assert(!(STATE & LogIdSet), "property logId should not be set yet");
            m_result->SetLogId(value);
            return castState<LogIdSet>();
        }

        SignedCertificateTimestampBuilder<STATE | TimestampSet>& SetTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->SetTimestamp(value);
            return castState<TimestampSet>();
        }

        SignedCertificateTimestampBuilder<STATE | HashAlgorithmSet>& SetHashAlgorithm(const String& value)
        {
            static_assert(!(STATE & HashAlgorithmSet), "property hashAlgorithm should not be set yet");
            m_result->SetHashAlgorithm(value);
            return castState<HashAlgorithmSet>();
        }

        SignedCertificateTimestampBuilder<STATE | SignatureAlgorithmSet>& SetSignatureAlgorithm(const String& value)
        {
            static_assert(!(STATE & SignatureAlgorithmSet), "property signatureAlgorithm should not be set yet");
            m_result->SetSignatureAlgorithm(value);
            return castState<SignatureAlgorithmSet>();
        }

        SignedCertificateTimestampBuilder<STATE | SignatureDataSet>& SetSignatureData(const String& value)
        {
            static_assert(!(STATE & SignatureDataSet), "property signatureData should not be set yet");
            m_result->SetSignatureData(value);
            return castState<SignatureDataSet>();
        }

        std::unique_ptr<SignedCertificateTimestamp> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedCertificateTimestamp;
        SignedCertificateTimestampBuilder() : m_result(new SignedCertificateTimestamp()) { }

        template<int STEP> SignedCertificateTimestampBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedCertificateTimestampBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedCertificateTimestamp> m_result;
    };

    static SignedCertificateTimestampBuilder<0> Create()
    {
        return SignedCertificateTimestampBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedCertificateTimestamp()
    {
          m_timestamp = 0;
    }

    String m_status;
    String m_origin;
    String m_logDescription;
    String m_logId;
    double m_timestamp;
    String m_hashAlgorithm;
    String m_signatureAlgorithm;
    String m_signatureData;
};


class CONTENT_EXPORT SecurityDetails : public ::crdtp::ProtocolObject<SecurityDetails> {
public:
    ~SecurityDetails() override { }

    String GetProtocol() { return m_protocol; }
    void SetProtocol(const String& value) { m_protocol = value; }

    String GetKeyExchange() { return m_keyExchange; }
    void SetKeyExchange(const String& value) { m_keyExchange = value; }

    bool HasKeyExchangeGroup() { return !!m_keyExchangeGroup; }
    String GetKeyExchangeGroup(const String& defaultValue) const {
       return m_keyExchangeGroup.value_or(defaultValue);
    }
    const std::optional<String>& GetKeyExchangeGroup() const {
       return m_keyExchangeGroup;
    }
    void SetKeyExchangeGroup(const String& value) { m_keyExchangeGroup = value; }

    String GetCipher() { return m_cipher; }
    void SetCipher(const String& value) { m_cipher = value; }

    bool HasMac() { return !!m_mac; }
    String GetMac(const String& defaultValue) const {
       return m_mac.value_or(defaultValue);
    }
    const std::optional<String>& GetMac() const {
       return m_mac;
    }
    void SetMac(const String& value) { m_mac = value; }

    int GetCertificateId() { return m_certificateId; }
    void SetCertificateId(int value) { m_certificateId = value; }

    String GetSubjectName() { return m_subjectName; }
    void SetSubjectName(const String& value) { m_subjectName = value; }

    protocol::Array<String>* GetSanList() { return m_sanList.get(); }
    void SetSanList(std::unique_ptr<protocol::Array<String>> value) { m_sanList = std::move(value); }

    String GetIssuer() { return m_issuer; }
    void SetIssuer(const String& value) { m_issuer = value; }

    double GetValidFrom() { return m_validFrom; }
    void SetValidFrom(double value) { m_validFrom = value; }

    double GetValidTo() { return m_validTo; }
    void SetValidTo(double value) { m_validTo = value; }

    protocol::Array<protocol::Network::SignedCertificateTimestamp>* GetSignedCertificateTimestampList() { return m_signedCertificateTimestampList.get(); }
    void SetSignedCertificateTimestampList(std::unique_ptr<protocol::Array<protocol::Network::SignedCertificateTimestamp>> value) { m_signedCertificateTimestampList = std::move(value); }

    String GetCertificateTransparencyCompliance() { return m_certificateTransparencyCompliance; }
    void SetCertificateTransparencyCompliance(const String& value) { m_certificateTransparencyCompliance = value; }

    bool HasServerSignatureAlgorithm() { return !!m_serverSignatureAlgorithm; }
    int GetServerSignatureAlgorithm(int defaultValue) const {
       return m_serverSignatureAlgorithm.value_or(defaultValue);
    }
    const std::optional<int>& GetServerSignatureAlgorithm() const {
       return m_serverSignatureAlgorithm;
    }
    void SetServerSignatureAlgorithm(int value) { m_serverSignatureAlgorithm = value; }

    bool GetEncryptedClientHello() { return m_encryptedClientHello; }
    void SetEncryptedClientHello(bool value) { m_encryptedClientHello = value; }

    template<int STATE>
    class SecurityDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            KeyExchangeSet = 1 << 2,
            CipherSet = 1 << 3,
            CertificateIdSet = 1 << 4,
            SubjectNameSet = 1 << 5,
            SanListSet = 1 << 6,
            IssuerSet = 1 << 7,
            ValidFromSet = 1 << 8,
            ValidToSet = 1 << 9,
            SignedCertificateTimestampListSet = 1 << 10,
            CertificateTransparencyComplianceSet = 1 << 11,
            EncryptedClientHelloSet = 1 << 12,
            AllFieldsSet = (ProtocolSet | KeyExchangeSet | CipherSet | CertificateIdSet | SubjectNameSet | SanListSet | IssuerSet | ValidFromSet | ValidToSet | SignedCertificateTimestampListSet | CertificateTransparencyComplianceSet | EncryptedClientHelloSet | 0)};


        SecurityDetailsBuilder<STATE | ProtocolSet>& SetProtocol(const String& value)
        {
            static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
            m_result->SetProtocol(value);
            return castState<ProtocolSet>();
        }

        SecurityDetailsBuilder<STATE | KeyExchangeSet>& SetKeyExchange(const String& value)
        {
            static_assert(!(STATE & KeyExchangeSet), "property keyExchange should not be set yet");
            m_result->SetKeyExchange(value);
            return castState<KeyExchangeSet>();
        }

        SecurityDetailsBuilder<STATE>& SetKeyExchangeGroup(const String& value)
        {
            m_result->SetKeyExchangeGroup(value);
            return *this;
        }

        SecurityDetailsBuilder<STATE | CipherSet>& SetCipher(const String& value)
        {
            static_assert(!(STATE & CipherSet), "property cipher should not be set yet");
            m_result->SetCipher(value);
            return castState<CipherSet>();
        }

        SecurityDetailsBuilder<STATE>& SetMac(const String& value)
        {
            m_result->SetMac(value);
            return *this;
        }

        SecurityDetailsBuilder<STATE | CertificateIdSet>& SetCertificateId(int value)
        {
            static_assert(!(STATE & CertificateIdSet), "property certificateId should not be set yet");
            m_result->SetCertificateId(value);
            return castState<CertificateIdSet>();
        }

        SecurityDetailsBuilder<STATE | SubjectNameSet>& SetSubjectName(const String& value)
        {
            static_assert(!(STATE & SubjectNameSet), "property subjectName should not be set yet");
            m_result->SetSubjectName(value);
            return castState<SubjectNameSet>();
        }

        SecurityDetailsBuilder<STATE | SanListSet>& SetSanList(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & SanListSet), "property sanList should not be set yet");
            m_result->SetSanList(std::move(value));
            return castState<SanListSet>();
        }

        SecurityDetailsBuilder<STATE | IssuerSet>& SetIssuer(const String& value)
        {
            static_assert(!(STATE & IssuerSet), "property issuer should not be set yet");
            m_result->SetIssuer(value);
            return castState<IssuerSet>();
        }

        SecurityDetailsBuilder<STATE | ValidFromSet>& SetValidFrom(double value)
        {
            static_assert(!(STATE & ValidFromSet), "property validFrom should not be set yet");
            m_result->SetValidFrom(value);
            return castState<ValidFromSet>();
        }

        SecurityDetailsBuilder<STATE | ValidToSet>& SetValidTo(double value)
        {
            static_assert(!(STATE & ValidToSet), "property validTo should not be set yet");
            m_result->SetValidTo(value);
            return castState<ValidToSet>();
        }

        SecurityDetailsBuilder<STATE | SignedCertificateTimestampListSet>& SetSignedCertificateTimestampList(std::unique_ptr<protocol::Array<protocol::Network::SignedCertificateTimestamp>> value)
        {
            static_assert(!(STATE & SignedCertificateTimestampListSet), "property signedCertificateTimestampList should not be set yet");
            m_result->SetSignedCertificateTimestampList(std::move(value));
            return castState<SignedCertificateTimestampListSet>();
        }

        SecurityDetailsBuilder<STATE | CertificateTransparencyComplianceSet>& SetCertificateTransparencyCompliance(const String& value)
        {
            static_assert(!(STATE & CertificateTransparencyComplianceSet), "property certificateTransparencyCompliance should not be set yet");
            m_result->SetCertificateTransparencyCompliance(value);
            return castState<CertificateTransparencyComplianceSet>();
        }

        SecurityDetailsBuilder<STATE>& SetServerSignatureAlgorithm(int value)
        {
            m_result->SetServerSignatureAlgorithm(value);
            return *this;
        }

        SecurityDetailsBuilder<STATE | EncryptedClientHelloSet>& SetEncryptedClientHello(bool value)
        {
            static_assert(!(STATE & EncryptedClientHelloSet), "property encryptedClientHello should not be set yet");
            m_result->SetEncryptedClientHello(value);
            return castState<EncryptedClientHelloSet>();
        }

        std::unique_ptr<SecurityDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SecurityDetails;
        SecurityDetailsBuilder() : m_result(new SecurityDetails()) { }

        template<int STEP> SecurityDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SecurityDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SecurityDetails> m_result;
    };

    static SecurityDetailsBuilder<0> Create()
    {
        return SecurityDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SecurityDetails()
    {
          m_certificateId = 0;
          m_validFrom = 0;
          m_validTo = 0;
          m_encryptedClientHello = false;
    }

    String m_protocol;
    String m_keyExchange;
    std::optional<String> m_keyExchangeGroup;
    String m_cipher;
    std::optional<String> m_mac;
    int m_certificateId;
    String m_subjectName;
    std::unique_ptr<protocol::Array<String>> m_sanList;
    String m_issuer;
    double m_validFrom;
    double m_validTo;
    std::unique_ptr<protocol::Array<protocol::Network::SignedCertificateTimestamp>> m_signedCertificateTimestampList;
    String m_certificateTransparencyCompliance;
    std::optional<int> m_serverSignatureAlgorithm;
    bool m_encryptedClientHello;
};


class CONTENT_EXPORT CorsErrorStatus : public ::crdtp::ProtocolObject<CorsErrorStatus> {
public:
    ~CorsErrorStatus() override { }

    String GetCorsError() { return m_corsError; }
    void SetCorsError(const String& value) { m_corsError = value; }

    String GetFailedParameter() { return m_failedParameter; }
    void SetFailedParameter(const String& value) { m_failedParameter = value; }

    template<int STATE>
    class CorsErrorStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CorsErrorSet = 1 << 1,
            FailedParameterSet = 1 << 2,
            AllFieldsSet = (CorsErrorSet | FailedParameterSet | 0)};


        CorsErrorStatusBuilder<STATE | CorsErrorSet>& SetCorsError(const String& value)
        {
            static_assert(!(STATE & CorsErrorSet), "property corsError should not be set yet");
            m_result->SetCorsError(value);
            return castState<CorsErrorSet>();
        }

        CorsErrorStatusBuilder<STATE | FailedParameterSet>& SetFailedParameter(const String& value)
        {
            static_assert(!(STATE & FailedParameterSet), "property failedParameter should not be set yet");
            m_result->SetFailedParameter(value);
            return castState<FailedParameterSet>();
        }

        std::unique_ptr<CorsErrorStatus> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CorsErrorStatus;
        CorsErrorStatusBuilder() : m_result(new CorsErrorStatus()) { }

        template<int STEP> CorsErrorStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CorsErrorStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CorsErrorStatus> m_result;
    };

    static CorsErrorStatusBuilder<0> Create()
    {
        return CorsErrorStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CorsErrorStatus()
    {
    }

    String m_corsError;
    String m_failedParameter;
};


class CONTENT_EXPORT TrustTokenParams : public ::crdtp::ProtocolObject<TrustTokenParams> {
public:
    ~TrustTokenParams() override { }

    String GetOperation() { return m_operation; }
    void SetOperation(const String& value) { m_operation = value; }

    struct CONTENT_EXPORT RefreshPolicyEnum {
        static const char* UseCached;
        static const char* Refresh;
    }; // RefreshPolicyEnum

    String GetRefreshPolicy() { return m_refreshPolicy; }
    void SetRefreshPolicy(const String& value) { m_refreshPolicy = value; }

    bool HasIssuers() { return !!m_issuers; }
    protocol::Array<String>* GetIssuers(protocol::Array<String>* defaultValue) {
       return m_issuers ? m_issuers.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetIssuers() const {
       return m_issuers;
    }
    void SetIssuers(std::unique_ptr<protocol::Array<String>> value) { m_issuers = std::move(value); }

    template<int STATE>
    class TrustTokenParamsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OperationSet = 1 << 1,
            RefreshPolicySet = 1 << 2,
            AllFieldsSet = (OperationSet | RefreshPolicySet | 0)};


        TrustTokenParamsBuilder<STATE | OperationSet>& SetOperation(const String& value)
        {
            static_assert(!(STATE & OperationSet), "property operation should not be set yet");
            m_result->SetOperation(value);
            return castState<OperationSet>();
        }

        TrustTokenParamsBuilder<STATE | RefreshPolicySet>& SetRefreshPolicy(const String& value)
        {
            static_assert(!(STATE & RefreshPolicySet), "property refreshPolicy should not be set yet");
            m_result->SetRefreshPolicy(value);
            return castState<RefreshPolicySet>();
        }

        TrustTokenParamsBuilder<STATE>& SetIssuers(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetIssuers(std::move(value));
            return *this;
        }

        std::unique_ptr<TrustTokenParams> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TrustTokenParams;
        TrustTokenParamsBuilder() : m_result(new TrustTokenParams()) { }

        template<int STEP> TrustTokenParamsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TrustTokenParamsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::TrustTokenParams> m_result;
    };

    static TrustTokenParamsBuilder<0> Create()
    {
        return TrustTokenParamsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TrustTokenParams()
    {
    }

    String m_operation;
    String m_refreshPolicy;
    std::unique_ptr<protocol::Array<String>> m_issuers;
};


class CONTENT_EXPORT ServiceWorkerRouterInfo : public ::crdtp::ProtocolObject<ServiceWorkerRouterInfo> {
public:
    ~ServiceWorkerRouterInfo() override { }

    bool HasRuleIdMatched() { return !!m_ruleIdMatched; }
    int GetRuleIdMatched(int defaultValue) const {
       return m_ruleIdMatched.value_or(defaultValue);
    }
    const std::optional<int>& GetRuleIdMatched() const {
       return m_ruleIdMatched;
    }
    void SetRuleIdMatched(int value) { m_ruleIdMatched = value; }

    bool HasMatchedSourceType() { return !!m_matchedSourceType; }
    String GetMatchedSourceType(const String& defaultValue) const {
       return m_matchedSourceType.value_or(defaultValue);
    }
    const std::optional<String>& GetMatchedSourceType() const {
       return m_matchedSourceType;
    }
    void SetMatchedSourceType(const String& value) { m_matchedSourceType = value; }

    bool HasActualSourceType() { return !!m_actualSourceType; }
    String GetActualSourceType(const String& defaultValue) const {
       return m_actualSourceType.value_or(defaultValue);
    }
    const std::optional<String>& GetActualSourceType() const {
       return m_actualSourceType;
    }
    void SetActualSourceType(const String& value) { m_actualSourceType = value; }

    template<int STATE>
    class ServiceWorkerRouterInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        ServiceWorkerRouterInfoBuilder<STATE>& SetRuleIdMatched(int value)
        {
            m_result->SetRuleIdMatched(value);
            return *this;
        }

        ServiceWorkerRouterInfoBuilder<STATE>& SetMatchedSourceType(const String& value)
        {
            m_result->SetMatchedSourceType(value);
            return *this;
        }

        ServiceWorkerRouterInfoBuilder<STATE>& SetActualSourceType(const String& value)
        {
            m_result->SetActualSourceType(value);
            return *this;
        }

        std::unique_ptr<ServiceWorkerRouterInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ServiceWorkerRouterInfo;
        ServiceWorkerRouterInfoBuilder() : m_result(new ServiceWorkerRouterInfo()) { }

        template<int STEP> ServiceWorkerRouterInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ServiceWorkerRouterInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> m_result;
    };

    static ServiceWorkerRouterInfoBuilder<0> Create()
    {
        return ServiceWorkerRouterInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ServiceWorkerRouterInfo()
    {
    }

    std::optional<int> m_ruleIdMatched;
    std::optional<String> m_matchedSourceType;
    std::optional<String> m_actualSourceType;
};


class CONTENT_EXPORT Response : public ::crdtp::ProtocolObject<Response> {
public:
    ~Response() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    int GetStatus() { return m_status; }
    void SetStatus(int value) { m_status = value; }

    String GetStatusText() { return m_statusText; }
    void SetStatusText(const String& value) { m_statusText = value; }

    protocol::Network::Headers* GetHeaders() { return m_headers.get(); }
    void SetHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    bool HasHeadersText() { return !!m_headersText; }
    String GetHeadersText(const String& defaultValue) const {
       return m_headersText.value_or(defaultValue);
    }
    const std::optional<String>& GetHeadersText() const {
       return m_headersText;
    }
    void SetHeadersText(const String& value) { m_headersText = value; }

    String GetMimeType() { return m_mimeType; }
    void SetMimeType(const String& value) { m_mimeType = value; }

    String GetCharset() { return m_charset; }
    void SetCharset(const String& value) { m_charset = value; }

    bool HasRequestHeaders() { return !!m_requestHeaders; }
    protocol::Network::Headers* GetRequestHeaders(protocol::Network::Headers* defaultValue) {
       return m_requestHeaders ? m_requestHeaders.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::Headers>& GetRequestHeaders() const {
       return m_requestHeaders;
    }
    void SetRequestHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_requestHeaders = std::move(value); }

    bool HasRequestHeadersText() { return !!m_requestHeadersText; }
    String GetRequestHeadersText(const String& defaultValue) const {
       return m_requestHeadersText.value_or(defaultValue);
    }
    const std::optional<String>& GetRequestHeadersText() const {
       return m_requestHeadersText;
    }
    void SetRequestHeadersText(const String& value) { m_requestHeadersText = value; }

    bool GetConnectionReused() { return m_connectionReused; }
    void SetConnectionReused(bool value) { m_connectionReused = value; }

    double GetConnectionId() { return m_connectionId; }
    void SetConnectionId(double value) { m_connectionId = value; }

    bool HasRemoteIPAddress() { return !!m_remoteIPAddress; }
    String GetRemoteIPAddress(const String& defaultValue) const {
       return m_remoteIPAddress.value_or(defaultValue);
    }
    const std::optional<String>& GetRemoteIPAddress() const {
       return m_remoteIPAddress;
    }
    void SetRemoteIPAddress(const String& value) { m_remoteIPAddress = value; }

    bool HasRemotePort() { return !!m_remotePort; }
    int GetRemotePort(int defaultValue) const {
       return m_remotePort.value_or(defaultValue);
    }
    const std::optional<int>& GetRemotePort() const {
       return m_remotePort;
    }
    void SetRemotePort(int value) { m_remotePort = value; }

    bool HasFromDiskCache() { return !!m_fromDiskCache; }
    bool GetFromDiskCache(bool defaultValue) const {
       return m_fromDiskCache.value_or(defaultValue);
    }
    const std::optional<bool>& GetFromDiskCache() const {
       return m_fromDiskCache;
    }
    void SetFromDiskCache(bool value) { m_fromDiskCache = value; }

    bool HasFromServiceWorker() { return !!m_fromServiceWorker; }
    bool GetFromServiceWorker(bool defaultValue) const {
       return m_fromServiceWorker.value_or(defaultValue);
    }
    const std::optional<bool>& GetFromServiceWorker() const {
       return m_fromServiceWorker;
    }
    void SetFromServiceWorker(bool value) { m_fromServiceWorker = value; }

    bool HasFromPrefetchCache() { return !!m_fromPrefetchCache; }
    bool GetFromPrefetchCache(bool defaultValue) const {
       return m_fromPrefetchCache.value_or(defaultValue);
    }
    const std::optional<bool>& GetFromPrefetchCache() const {
       return m_fromPrefetchCache;
    }
    void SetFromPrefetchCache(bool value) { m_fromPrefetchCache = value; }

    bool HasFromEarlyHints() { return !!m_fromEarlyHints; }
    bool GetFromEarlyHints(bool defaultValue) const {
       return m_fromEarlyHints.value_or(defaultValue);
    }
    const std::optional<bool>& GetFromEarlyHints() const {
       return m_fromEarlyHints;
    }
    void SetFromEarlyHints(bool value) { m_fromEarlyHints = value; }

    bool HasServiceWorkerRouterInfo() { return !!m_serviceWorkerRouterInfo; }
    protocol::Network::ServiceWorkerRouterInfo* GetServiceWorkerRouterInfo(protocol::Network::ServiceWorkerRouterInfo* defaultValue) {
       return m_serviceWorkerRouterInfo ? m_serviceWorkerRouterInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo>& GetServiceWorkerRouterInfo() const {
       return m_serviceWorkerRouterInfo;
    }
    void SetServiceWorkerRouterInfo(std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> value) { m_serviceWorkerRouterInfo = std::move(value); }

    double GetEncodedDataLength() { return m_encodedDataLength; }
    void SetEncodedDataLength(double value) { m_encodedDataLength = value; }

    bool HasTiming() { return !!m_timing; }
    protocol::Network::ResourceTiming* GetTiming(protocol::Network::ResourceTiming* defaultValue) {
       return m_timing ? m_timing.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ResourceTiming>& GetTiming() const {
       return m_timing;
    }
    void SetTiming(std::unique_ptr<protocol::Network::ResourceTiming> value) { m_timing = std::move(value); }

    bool HasServiceWorkerResponseSource() { return !!m_serviceWorkerResponseSource; }
    String GetServiceWorkerResponseSource(const String& defaultValue) const {
       return m_serviceWorkerResponseSource.value_or(defaultValue);
    }
    const std::optional<String>& GetServiceWorkerResponseSource() const {
       return m_serviceWorkerResponseSource;
    }
    void SetServiceWorkerResponseSource(const String& value) { m_serviceWorkerResponseSource = value; }

    bool HasResponseTime() { return !!m_responseTime; }
    double GetResponseTime(double defaultValue) const {
       return m_responseTime.value_or(defaultValue);
    }
    const std::optional<double>& GetResponseTime() const {
       return m_responseTime;
    }
    void SetResponseTime(double value) { m_responseTime = value; }

    bool HasCacheStorageCacheName() { return !!m_cacheStorageCacheName; }
    String GetCacheStorageCacheName(const String& defaultValue) const {
       return m_cacheStorageCacheName.value_or(defaultValue);
    }
    const std::optional<String>& GetCacheStorageCacheName() const {
       return m_cacheStorageCacheName;
    }
    void SetCacheStorageCacheName(const String& value) { m_cacheStorageCacheName = value; }

    bool HasProtocol() { return !!m_protocol; }
    String GetProtocol(const String& defaultValue) const {
       return m_protocol.value_or(defaultValue);
    }
    const std::optional<String>& GetProtocol() const {
       return m_protocol;
    }
    void SetProtocol(const String& value) { m_protocol = value; }

    bool HasAlternateProtocolUsage() { return !!m_alternateProtocolUsage; }
    String GetAlternateProtocolUsage(const String& defaultValue) const {
       return m_alternateProtocolUsage.value_or(defaultValue);
    }
    const std::optional<String>& GetAlternateProtocolUsage() const {
       return m_alternateProtocolUsage;
    }
    void SetAlternateProtocolUsage(const String& value) { m_alternateProtocolUsage = value; }

    String GetSecurityState() { return m_securityState; }
    void SetSecurityState(const String& value) { m_securityState = value; }

    bool HasSecurityDetails() { return !!m_securityDetails; }
    protocol::Network::SecurityDetails* GetSecurityDetails(protocol::Network::SecurityDetails* defaultValue) {
       return m_securityDetails ? m_securityDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::SecurityDetails>& GetSecurityDetails() const {
       return m_securityDetails;
    }
    void SetSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value) { m_securityDetails = std::move(value); }

    template<int STATE>
    class ResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            StatusSet = 1 << 2,
            StatusTextSet = 1 << 3,
            HeadersSet = 1 << 4,
            MimeTypeSet = 1 << 5,
            CharsetSet = 1 << 6,
            ConnectionReusedSet = 1 << 7,
            ConnectionIdSet = 1 << 8,
            EncodedDataLengthSet = 1 << 9,
            SecurityStateSet = 1 << 10,
            AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet | CharsetSet | ConnectionReusedSet | ConnectionIdSet | EncodedDataLengthSet | SecurityStateSet | 0)};


        ResponseBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        ResponseBuilder<STATE | StatusSet>& SetStatus(int value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->SetStatus(value);
            return castState<StatusSet>();
        }

        ResponseBuilder<STATE | StatusTextSet>& SetStatusText(const String& value)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText should not be set yet");
            m_result->SetStatusText(value);
            return castState<StatusTextSet>();
        }

        ResponseBuilder<STATE | HeadersSet>& SetHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->SetHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        ResponseBuilder<STATE>& SetHeadersText(const String& value)
        {
            m_result->SetHeadersText(value);
            return *this;
        }

        ResponseBuilder<STATE | MimeTypeSet>& SetMimeType(const String& value)
        {
            static_assert(!(STATE & MimeTypeSet), "property mimeType should not be set yet");
            m_result->SetMimeType(value);
            return castState<MimeTypeSet>();
        }

        ResponseBuilder<STATE | CharsetSet>& SetCharset(const String& value)
        {
            static_assert(!(STATE & CharsetSet), "property charset should not be set yet");
            m_result->SetCharset(value);
            return castState<CharsetSet>();
        }

        ResponseBuilder<STATE>& SetRequestHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            m_result->SetRequestHeaders(std::move(value));
            return *this;
        }

        ResponseBuilder<STATE>& SetRequestHeadersText(const String& value)
        {
            m_result->SetRequestHeadersText(value);
            return *this;
        }

        ResponseBuilder<STATE | ConnectionReusedSet>& SetConnectionReused(bool value)
        {
            static_assert(!(STATE & ConnectionReusedSet), "property connectionReused should not be set yet");
            m_result->SetConnectionReused(value);
            return castState<ConnectionReusedSet>();
        }

        ResponseBuilder<STATE | ConnectionIdSet>& SetConnectionId(double value)
        {
            static_assert(!(STATE & ConnectionIdSet), "property connectionId should not be set yet");
            m_result->SetConnectionId(value);
            return castState<ConnectionIdSet>();
        }

        ResponseBuilder<STATE>& SetRemoteIPAddress(const String& value)
        {
            m_result->SetRemoteIPAddress(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetRemotePort(int value)
        {
            m_result->SetRemotePort(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetFromDiskCache(bool value)
        {
            m_result->SetFromDiskCache(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetFromServiceWorker(bool value)
        {
            m_result->SetFromServiceWorker(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetFromPrefetchCache(bool value)
        {
            m_result->SetFromPrefetchCache(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetFromEarlyHints(bool value)
        {
            m_result->SetFromEarlyHints(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetServiceWorkerRouterInfo(std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> value)
        {
            m_result->SetServiceWorkerRouterInfo(std::move(value));
            return *this;
        }

        ResponseBuilder<STATE | EncodedDataLengthSet>& SetEncodedDataLength(double value)
        {
            static_assert(!(STATE & EncodedDataLengthSet), "property encodedDataLength should not be set yet");
            m_result->SetEncodedDataLength(value);
            return castState<EncodedDataLengthSet>();
        }

        ResponseBuilder<STATE>& SetTiming(std::unique_ptr<protocol::Network::ResourceTiming> value)
        {
            m_result->SetTiming(std::move(value));
            return *this;
        }

        ResponseBuilder<STATE>& SetServiceWorkerResponseSource(const String& value)
        {
            m_result->SetServiceWorkerResponseSource(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetResponseTime(double value)
        {
            m_result->SetResponseTime(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetCacheStorageCacheName(const String& value)
        {
            m_result->SetCacheStorageCacheName(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetProtocol(const String& value)
        {
            m_result->SetProtocol(value);
            return *this;
        }

        ResponseBuilder<STATE>& SetAlternateProtocolUsage(const String& value)
        {
            m_result->SetAlternateProtocolUsage(value);
            return *this;
        }

        ResponseBuilder<STATE | SecurityStateSet>& SetSecurityState(const String& value)
        {
            static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
            m_result->SetSecurityState(value);
            return castState<SecurityStateSet>();
        }

        ResponseBuilder<STATE>& SetSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value)
        {
            m_result->SetSecurityDetails(std::move(value));
            return *this;
        }

        std::unique_ptr<Response> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Response;
        ResponseBuilder() : m_result(new Response()) { }

        template<int STEP> ResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Response> m_result;
    };

    static ResponseBuilder<0> Create()
    {
        return ResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Response()
    {
          m_status = 0;
          m_connectionReused = false;
          m_connectionId = 0;
          m_encodedDataLength = 0;
    }

    String m_url;
    int m_status;
    String m_statusText;
    std::unique_ptr<protocol::Network::Headers> m_headers;
    std::optional<String> m_headersText;
    String m_mimeType;
    String m_charset;
    std::unique_ptr<protocol::Network::Headers> m_requestHeaders;
    std::optional<String> m_requestHeadersText;
    bool m_connectionReused;
    double m_connectionId;
    std::optional<String> m_remoteIPAddress;
    std::optional<int> m_remotePort;
    std::optional<bool> m_fromDiskCache;
    std::optional<bool> m_fromServiceWorker;
    std::optional<bool> m_fromPrefetchCache;
    std::optional<bool> m_fromEarlyHints;
    std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> m_serviceWorkerRouterInfo;
    double m_encodedDataLength;
    std::unique_ptr<protocol::Network::ResourceTiming> m_timing;
    std::optional<String> m_serviceWorkerResponseSource;
    std::optional<double> m_responseTime;
    std::optional<String> m_cacheStorageCacheName;
    std::optional<String> m_protocol;
    std::optional<String> m_alternateProtocolUsage;
    String m_securityState;
    std::unique_ptr<protocol::Network::SecurityDetails> m_securityDetails;
};


class CONTENT_EXPORT Initiator : public ::crdtp::ProtocolObject<Initiator> {
public:
    ~Initiator() override { }

    struct CONTENT_EXPORT TypeEnum {
        static const char* Parser;
        static const char* Script;
        static const char* Preload;
        static const char* SignedExchange;
        static const char* Preflight;
        static const char* Other;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    bool HasStack() { return !!m_stack; }
    protocol::Runtime::StackTrace* GetStack(protocol::Runtime::StackTrace* defaultValue) {
       return m_stack ? m_stack.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::StackTrace>& GetStack() const {
       return m_stack;
    }
    void SetStack(std::unique_ptr<protocol::Runtime::StackTrace> value) { m_stack = std::move(value); }

    bool HasUrl() { return !!m_url; }
    String GetUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& GetUrl() const {
       return m_url;
    }
    void SetUrl(const String& value) { m_url = value; }

    bool HasLineNumber() { return !!m_lineNumber; }
    double GetLineNumber(double defaultValue) const {
       return m_lineNumber.value_or(defaultValue);
    }
    const std::optional<double>& GetLineNumber() const {
       return m_lineNumber;
    }
    void SetLineNumber(double value) { m_lineNumber = value; }

    bool HasColumnNumber() { return !!m_columnNumber; }
    double GetColumnNumber(double defaultValue) const {
       return m_columnNumber.value_or(defaultValue);
    }
    const std::optional<double>& GetColumnNumber() const {
       return m_columnNumber;
    }
    void SetColumnNumber(double value) { m_columnNumber = value; }

    bool HasRequestId() { return !!m_requestId; }
    String GetRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& GetRequestId() const {
       return m_requestId;
    }
    void SetRequestId(const String& value) { m_requestId = value; }

    template<int STATE>
    class InitiatorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        InitiatorBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        InitiatorBuilder<STATE>& SetStack(std::unique_ptr<protocol::Runtime::StackTrace> value)
        {
            m_result->SetStack(std::move(value));
            return *this;
        }

        InitiatorBuilder<STATE>& SetUrl(const String& value)
        {
            m_result->SetUrl(value);
            return *this;
        }

        InitiatorBuilder<STATE>& SetLineNumber(double value)
        {
            m_result->SetLineNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& SetColumnNumber(double value)
        {
            m_result->SetColumnNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& SetRequestId(const String& value)
        {
            m_result->SetRequestId(value);
            return *this;
        }

        std::unique_ptr<Initiator> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Initiator;
        InitiatorBuilder() : m_result(new Initiator()) { }

        template<int STEP> InitiatorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InitiatorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Initiator> m_result;
    };

    static InitiatorBuilder<0> Create()
    {
        return InitiatorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Initiator()
    {
    }

    String m_type;
    std::unique_ptr<protocol::Runtime::StackTrace> m_stack;
    std::optional<String> m_url;
    std::optional<double> m_lineNumber;
    std::optional<double> m_columnNumber;
    std::optional<String> m_requestId;
};


class CONTENT_EXPORT CookiePartitionKey : public ::crdtp::ProtocolObject<CookiePartitionKey> {
public:
    ~CookiePartitionKey() override { }

    String GetTopLevelSite() { return m_topLevelSite; }
    void SetTopLevelSite(const String& value) { m_topLevelSite = value; }

    bool GetHasCrossSiteAncestor() { return m_hasCrossSiteAncestor; }
    void SetHasCrossSiteAncestor(bool value) { m_hasCrossSiteAncestor = value; }

    template<int STATE>
    class CookiePartitionKeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TopLevelSiteSet = 1 << 1,
            HasCrossSiteAncestorSet = 1 << 2,
            AllFieldsSet = (TopLevelSiteSet | HasCrossSiteAncestorSet | 0)};


        CookiePartitionKeyBuilder<STATE | TopLevelSiteSet>& SetTopLevelSite(const String& value)
        {
            static_assert(!(STATE & TopLevelSiteSet), "property topLevelSite should not be set yet");
            m_result->SetTopLevelSite(value);
            return castState<TopLevelSiteSet>();
        }

        CookiePartitionKeyBuilder<STATE | HasCrossSiteAncestorSet>& SetHasCrossSiteAncestor(bool value)
        {
            static_assert(!(STATE & HasCrossSiteAncestorSet), "property hasCrossSiteAncestor should not be set yet");
            m_result->SetHasCrossSiteAncestor(value);
            return castState<HasCrossSiteAncestorSet>();
        }

        std::unique_ptr<CookiePartitionKey> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookiePartitionKey;
        CookiePartitionKeyBuilder() : m_result(new CookiePartitionKey()) { }

        template<int STEP> CookiePartitionKeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookiePartitionKeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CookiePartitionKey> m_result;
    };

    static CookiePartitionKeyBuilder<0> Create()
    {
        return CookiePartitionKeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookiePartitionKey()
    {
          m_hasCrossSiteAncestor = false;
    }

    String m_topLevelSite;
    bool m_hasCrossSiteAncestor;
};


class CONTENT_EXPORT Cookie : public ::crdtp::ProtocolObject<Cookie> {
public:
    ~Cookie() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    String GetDomain() { return m_domain; }
    void SetDomain(const String& value) { m_domain = value; }

    String GetPath() { return m_path; }
    void SetPath(const String& value) { m_path = value; }

    double GetExpires() { return m_expires; }
    void SetExpires(double value) { m_expires = value; }

    int GetSize() { return m_size; }
    void SetSize(int value) { m_size = value; }

    bool GetHttpOnly() { return m_httpOnly; }
    void SetHttpOnly(bool value) { m_httpOnly = value; }

    bool GetSecure() { return m_secure; }
    void SetSecure(bool value) { m_secure = value; }

    bool GetSession() { return m_session; }
    void SetSession(bool value) { m_session = value; }

    bool HasSameSite() { return !!m_sameSite; }
    String GetSameSite(const String& defaultValue) const {
       return m_sameSite.value_or(defaultValue);
    }
    const std::optional<String>& GetSameSite() const {
       return m_sameSite;
    }
    void SetSameSite(const String& value) { m_sameSite = value; }

    String GetPriority() { return m_priority; }
    void SetPriority(const String& value) { m_priority = value; }

    bool GetSameParty() { return m_sameParty; }
    void SetSameParty(bool value) { m_sameParty = value; }

    String GetSourceScheme() { return m_sourceScheme; }
    void SetSourceScheme(const String& value) { m_sourceScheme = value; }

    int GetSourcePort() { return m_sourcePort; }
    void SetSourcePort(int value) { m_sourcePort = value; }

    bool HasPartitionKey() { return !!m_partitionKey; }
    protocol::Network::CookiePartitionKey* GetPartitionKey(protocol::Network::CookiePartitionKey* defaultValue) {
       return m_partitionKey ? m_partitionKey.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::CookiePartitionKey>& GetPartitionKey() const {
       return m_partitionKey;
    }
    void SetPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value) { m_partitionKey = std::move(value); }

    bool HasPartitionKeyOpaque() { return !!m_partitionKeyOpaque; }
    bool GetPartitionKeyOpaque(bool defaultValue) const {
       return m_partitionKeyOpaque.value_or(defaultValue);
    }
    const std::optional<bool>& GetPartitionKeyOpaque() const {
       return m_partitionKeyOpaque;
    }
    void SetPartitionKeyOpaque(bool value) { m_partitionKeyOpaque = value; }

    template<int STATE>
    class CookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            DomainSet = 1 << 3,
            PathSet = 1 << 4,
            ExpiresSet = 1 << 5,
            SizeSet = 1 << 6,
            HttpOnlySet = 1 << 7,
            SecureSet = 1 << 8,
            SessionSet = 1 << 9,
            PrioritySet = 1 << 10,
            SamePartySet = 1 << 11,
            SourceSchemeSet = 1 << 12,
            SourcePortSet = 1 << 13,
            AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SizeSet | HttpOnlySet | SecureSet | SessionSet | PrioritySet | SamePartySet | SourceSchemeSet | SourcePortSet | 0)};


        CookieBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        CookieBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        CookieBuilder<STATE | DomainSet>& SetDomain(const String& value)
        {
            static_assert(!(STATE & DomainSet), "property domain should not be set yet");
            m_result->SetDomain(value);
            return castState<DomainSet>();
        }

        CookieBuilder<STATE | PathSet>& SetPath(const String& value)
        {
            static_assert(!(STATE & PathSet), "property path should not be set yet");
            m_result->SetPath(value);
            return castState<PathSet>();
        }

        CookieBuilder<STATE | ExpiresSet>& SetExpires(double value)
        {
            static_assert(!(STATE & ExpiresSet), "property expires should not be set yet");
            m_result->SetExpires(value);
            return castState<ExpiresSet>();
        }

        CookieBuilder<STATE | SizeSet>& SetSize(int value)
        {
            static_assert(!(STATE & SizeSet), "property size should not be set yet");
            m_result->SetSize(value);
            return castState<SizeSet>();
        }

        CookieBuilder<STATE | HttpOnlySet>& SetHttpOnly(bool value)
        {
            static_assert(!(STATE & HttpOnlySet), "property httpOnly should not be set yet");
            m_result->SetHttpOnly(value);
            return castState<HttpOnlySet>();
        }

        CookieBuilder<STATE | SecureSet>& SetSecure(bool value)
        {
            static_assert(!(STATE & SecureSet), "property secure should not be set yet");
            m_result->SetSecure(value);
            return castState<SecureSet>();
        }

        CookieBuilder<STATE | SessionSet>& SetSession(bool value)
        {
            static_assert(!(STATE & SessionSet), "property session should not be set yet");
            m_result->SetSession(value);
            return castState<SessionSet>();
        }

        CookieBuilder<STATE>& SetSameSite(const String& value)
        {
            m_result->SetSameSite(value);
            return *this;
        }

        CookieBuilder<STATE | PrioritySet>& SetPriority(const String& value)
        {
            static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
            m_result->SetPriority(value);
            return castState<PrioritySet>();
        }

        CookieBuilder<STATE | SamePartySet>& SetSameParty(bool value)
        {
            static_assert(!(STATE & SamePartySet), "property sameParty should not be set yet");
            m_result->SetSameParty(value);
            return castState<SamePartySet>();
        }

        CookieBuilder<STATE | SourceSchemeSet>& SetSourceScheme(const String& value)
        {
            static_assert(!(STATE & SourceSchemeSet), "property sourceScheme should not be set yet");
            m_result->SetSourceScheme(value);
            return castState<SourceSchemeSet>();
        }

        CookieBuilder<STATE | SourcePortSet>& SetSourcePort(int value)
        {
            static_assert(!(STATE & SourcePortSet), "property sourcePort should not be set yet");
            m_result->SetSourcePort(value);
            return castState<SourcePortSet>();
        }

        CookieBuilder<STATE>& SetPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value)
        {
            m_result->SetPartitionKey(std::move(value));
            return *this;
        }

        CookieBuilder<STATE>& SetPartitionKeyOpaque(bool value)
        {
            m_result->SetPartitionKeyOpaque(value);
            return *this;
        }

        std::unique_ptr<Cookie> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Cookie;
        CookieBuilder() : m_result(new Cookie()) { }

        template<int STEP> CookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Cookie> m_result;
    };

    static CookieBuilder<0> Create()
    {
        return CookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Cookie()
    {
          m_expires = 0;
          m_size = 0;
          m_httpOnly = false;
          m_secure = false;
          m_session = false;
          m_sameParty = false;
          m_sourcePort = 0;
    }

    String m_name;
    String m_value;
    String m_domain;
    String m_path;
    double m_expires;
    int m_size;
    bool m_httpOnly;
    bool m_secure;
    bool m_session;
    std::optional<String> m_sameSite;
    String m_priority;
    bool m_sameParty;
    String m_sourceScheme;
    int m_sourcePort;
    std::unique_ptr<protocol::Network::CookiePartitionKey> m_partitionKey;
    std::optional<bool> m_partitionKeyOpaque;
};


class CONTENT_EXPORT BlockedSetCookieWithReason : public ::crdtp::ProtocolObject<BlockedSetCookieWithReason> {
public:
    ~BlockedSetCookieWithReason() override { }

    protocol::Array<String>* GetBlockedReasons() { return m_blockedReasons.get(); }
    void SetBlockedReasons(std::unique_ptr<protocol::Array<String>> value) { m_blockedReasons = std::move(value); }

    String GetCookieLine() { return m_cookieLine; }
    void SetCookieLine(const String& value) { m_cookieLine = value; }

    bool HasCookie() { return !!m_cookie; }
    protocol::Network::Cookie* GetCookie(protocol::Network::Cookie* defaultValue) {
       return m_cookie ? m_cookie.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::Cookie>& GetCookie() const {
       return m_cookie;
    }
    void SetCookie(std::unique_ptr<protocol::Network::Cookie> value) { m_cookie = std::move(value); }

    template<int STATE>
    class BlockedSetCookieWithReasonBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BlockedReasonsSet = 1 << 1,
            CookieLineSet = 1 << 2,
            AllFieldsSet = (BlockedReasonsSet | CookieLineSet | 0)};


        BlockedSetCookieWithReasonBuilder<STATE | BlockedReasonsSet>& SetBlockedReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & BlockedReasonsSet), "property blockedReasons should not be set yet");
            m_result->SetBlockedReasons(std::move(value));
            return castState<BlockedReasonsSet>();
        }

        BlockedSetCookieWithReasonBuilder<STATE | CookieLineSet>& SetCookieLine(const String& value)
        {
            static_assert(!(STATE & CookieLineSet), "property cookieLine should not be set yet");
            m_result->SetCookieLine(value);
            return castState<CookieLineSet>();
        }

        BlockedSetCookieWithReasonBuilder<STATE>& SetCookie(std::unique_ptr<protocol::Network::Cookie> value)
        {
            m_result->SetCookie(std::move(value));
            return *this;
        }

        std::unique_ptr<BlockedSetCookieWithReason> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BlockedSetCookieWithReason;
        BlockedSetCookieWithReasonBuilder() : m_result(new BlockedSetCookieWithReason()) { }

        template<int STEP> BlockedSetCookieWithReasonBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BlockedSetCookieWithReasonBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::BlockedSetCookieWithReason> m_result;
    };

    static BlockedSetCookieWithReasonBuilder<0> Create()
    {
        return BlockedSetCookieWithReasonBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BlockedSetCookieWithReason()
    {
    }

    std::unique_ptr<protocol::Array<String>> m_blockedReasons;
    String m_cookieLine;
    std::unique_ptr<protocol::Network::Cookie> m_cookie;
};


class CONTENT_EXPORT ExemptedSetCookieWithReason : public ::crdtp::ProtocolObject<ExemptedSetCookieWithReason> {
public:
    ~ExemptedSetCookieWithReason() override { }

    String GetExemptionReason() { return m_exemptionReason; }
    void SetExemptionReason(const String& value) { m_exemptionReason = value; }

    String GetCookieLine() { return m_cookieLine; }
    void SetCookieLine(const String& value) { m_cookieLine = value; }

    protocol::Network::Cookie* GetCookie() { return m_cookie.get(); }
    void SetCookie(std::unique_ptr<protocol::Network::Cookie> value) { m_cookie = std::move(value); }

    template<int STATE>
    class ExemptedSetCookieWithReasonBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ExemptionReasonSet = 1 << 1,
            CookieLineSet = 1 << 2,
            CookieSet = 1 << 3,
            AllFieldsSet = (ExemptionReasonSet | CookieLineSet | CookieSet | 0)};


        ExemptedSetCookieWithReasonBuilder<STATE | ExemptionReasonSet>& SetExemptionReason(const String& value)
        {
            static_assert(!(STATE & ExemptionReasonSet), "property exemptionReason should not be set yet");
            m_result->SetExemptionReason(value);
            return castState<ExemptionReasonSet>();
        }

        ExemptedSetCookieWithReasonBuilder<STATE | CookieLineSet>& SetCookieLine(const String& value)
        {
            static_assert(!(STATE & CookieLineSet), "property cookieLine should not be set yet");
            m_result->SetCookieLine(value);
            return castState<CookieLineSet>();
        }

        ExemptedSetCookieWithReasonBuilder<STATE | CookieSet>& SetCookie(std::unique_ptr<protocol::Network::Cookie> value)
        {
            static_assert(!(STATE & CookieSet), "property cookie should not be set yet");
            m_result->SetCookie(std::move(value));
            return castState<CookieSet>();
        }

        std::unique_ptr<ExemptedSetCookieWithReason> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ExemptedSetCookieWithReason;
        ExemptedSetCookieWithReasonBuilder() : m_result(new ExemptedSetCookieWithReason()) { }

        template<int STEP> ExemptedSetCookieWithReasonBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ExemptedSetCookieWithReasonBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ExemptedSetCookieWithReason> m_result;
    };

    static ExemptedSetCookieWithReasonBuilder<0> Create()
    {
        return ExemptedSetCookieWithReasonBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ExemptedSetCookieWithReason()
    {
    }

    String m_exemptionReason;
    String m_cookieLine;
    std::unique_ptr<protocol::Network::Cookie> m_cookie;
};


class CONTENT_EXPORT AssociatedCookie : public ::crdtp::ProtocolObject<AssociatedCookie> {
public:
    ~AssociatedCookie() override { }

    protocol::Network::Cookie* GetCookie() { return m_cookie.get(); }
    void SetCookie(std::unique_ptr<protocol::Network::Cookie> value) { m_cookie = std::move(value); }

    protocol::Array<String>* GetBlockedReasons() { return m_blockedReasons.get(); }
    void SetBlockedReasons(std::unique_ptr<protocol::Array<String>> value) { m_blockedReasons = std::move(value); }

    bool HasExemptionReason() { return !!m_exemptionReason; }
    String GetExemptionReason(const String& defaultValue) const {
       return m_exemptionReason.value_or(defaultValue);
    }
    const std::optional<String>& GetExemptionReason() const {
       return m_exemptionReason;
    }
    void SetExemptionReason(const String& value) { m_exemptionReason = value; }

    template<int STATE>
    class AssociatedCookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CookieSet = 1 << 1,
            BlockedReasonsSet = 1 << 2,
            AllFieldsSet = (CookieSet | BlockedReasonsSet | 0)};


        AssociatedCookieBuilder<STATE | CookieSet>& SetCookie(std::unique_ptr<protocol::Network::Cookie> value)
        {
            static_assert(!(STATE & CookieSet), "property cookie should not be set yet");
            m_result->SetCookie(std::move(value));
            return castState<CookieSet>();
        }

        AssociatedCookieBuilder<STATE | BlockedReasonsSet>& SetBlockedReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & BlockedReasonsSet), "property blockedReasons should not be set yet");
            m_result->SetBlockedReasons(std::move(value));
            return castState<BlockedReasonsSet>();
        }

        AssociatedCookieBuilder<STATE>& SetExemptionReason(const String& value)
        {
            m_result->SetExemptionReason(value);
            return *this;
        }

        std::unique_ptr<AssociatedCookie> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AssociatedCookie;
        AssociatedCookieBuilder() : m_result(new AssociatedCookie()) { }

        template<int STEP> AssociatedCookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AssociatedCookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::AssociatedCookie> m_result;
    };

    static AssociatedCookieBuilder<0> Create()
    {
        return AssociatedCookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AssociatedCookie()
    {
    }

    std::unique_ptr<protocol::Network::Cookie> m_cookie;
    std::unique_ptr<protocol::Array<String>> m_blockedReasons;
    std::optional<String> m_exemptionReason;
};


class CONTENT_EXPORT CookieParam : public ::crdtp::ProtocolObject<CookieParam> {
public:
    ~CookieParam() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    bool HasUrl() { return !!m_url; }
    String GetUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& GetUrl() const {
       return m_url;
    }
    void SetUrl(const String& value) { m_url = value; }

    bool HasDomain() { return !!m_domain; }
    String GetDomain(const String& defaultValue) const {
       return m_domain.value_or(defaultValue);
    }
    const std::optional<String>& GetDomain() const {
       return m_domain;
    }
    void SetDomain(const String& value) { m_domain = value; }

    bool HasPath() { return !!m_path; }
    String GetPath(const String& defaultValue) const {
       return m_path.value_or(defaultValue);
    }
    const std::optional<String>& GetPath() const {
       return m_path;
    }
    void SetPath(const String& value) { m_path = value; }

    bool HasSecure() { return !!m_secure; }
    bool GetSecure(bool defaultValue) const {
       return m_secure.value_or(defaultValue);
    }
    const std::optional<bool>& GetSecure() const {
       return m_secure;
    }
    void SetSecure(bool value) { m_secure = value; }

    bool HasHttpOnly() { return !!m_httpOnly; }
    bool GetHttpOnly(bool defaultValue) const {
       return m_httpOnly.value_or(defaultValue);
    }
    const std::optional<bool>& GetHttpOnly() const {
       return m_httpOnly;
    }
    void SetHttpOnly(bool value) { m_httpOnly = value; }

    bool HasSameSite() { return !!m_sameSite; }
    String GetSameSite(const String& defaultValue) const {
       return m_sameSite.value_or(defaultValue);
    }
    const std::optional<String>& GetSameSite() const {
       return m_sameSite;
    }
    void SetSameSite(const String& value) { m_sameSite = value; }

    bool HasExpires() { return !!m_expires; }
    double GetExpires(double defaultValue) const {
       return m_expires.value_or(defaultValue);
    }
    const std::optional<double>& GetExpires() const {
       return m_expires;
    }
    void SetExpires(double value) { m_expires = value; }

    bool HasPriority() { return !!m_priority; }
    String GetPriority(const String& defaultValue) const {
       return m_priority.value_or(defaultValue);
    }
    const std::optional<String>& GetPriority() const {
       return m_priority;
    }
    void SetPriority(const String& value) { m_priority = value; }

    bool HasSameParty() { return !!m_sameParty; }
    bool GetSameParty(bool defaultValue) const {
       return m_sameParty.value_or(defaultValue);
    }
    const std::optional<bool>& GetSameParty() const {
       return m_sameParty;
    }
    void SetSameParty(bool value) { m_sameParty = value; }

    bool HasSourceScheme() { return !!m_sourceScheme; }
    String GetSourceScheme(const String& defaultValue) const {
       return m_sourceScheme.value_or(defaultValue);
    }
    const std::optional<String>& GetSourceScheme() const {
       return m_sourceScheme;
    }
    void SetSourceScheme(const String& value) { m_sourceScheme = value; }

    bool HasSourcePort() { return !!m_sourcePort; }
    int GetSourcePort(int defaultValue) const {
       return m_sourcePort.value_or(defaultValue);
    }
    const std::optional<int>& GetSourcePort() const {
       return m_sourcePort;
    }
    void SetSourcePort(int value) { m_sourcePort = value; }

    bool HasPartitionKey() { return !!m_partitionKey; }
    protocol::Network::CookiePartitionKey* GetPartitionKey(protocol::Network::CookiePartitionKey* defaultValue) {
       return m_partitionKey ? m_partitionKey.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::CookiePartitionKey>& GetPartitionKey() const {
       return m_partitionKey;
    }
    void SetPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value) { m_partitionKey = std::move(value); }

    template<int STATE>
    class CookieParamBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        CookieParamBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        CookieParamBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        CookieParamBuilder<STATE>& SetUrl(const String& value)
        {
            m_result->SetUrl(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetDomain(const String& value)
        {
            m_result->SetDomain(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetPath(const String& value)
        {
            m_result->SetPath(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetSecure(bool value)
        {
            m_result->SetSecure(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetHttpOnly(bool value)
        {
            m_result->SetHttpOnly(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetSameSite(const String& value)
        {
            m_result->SetSameSite(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetExpires(double value)
        {
            m_result->SetExpires(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetPriority(const String& value)
        {
            m_result->SetPriority(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetSameParty(bool value)
        {
            m_result->SetSameParty(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetSourceScheme(const String& value)
        {
            m_result->SetSourceScheme(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetSourcePort(int value)
        {
            m_result->SetSourcePort(value);
            return *this;
        }

        CookieParamBuilder<STATE>& SetPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value)
        {
            m_result->SetPartitionKey(std::move(value));
            return *this;
        }

        std::unique_ptr<CookieParam> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieParam;
        CookieParamBuilder() : m_result(new CookieParam()) { }

        template<int STEP> CookieParamBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieParamBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CookieParam> m_result;
    };

    static CookieParamBuilder<0> Create()
    {
        return CookieParamBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieParam()
    {
    }

    String m_name;
    String m_value;
    std::optional<String> m_url;
    std::optional<String> m_domain;
    std::optional<String> m_path;
    std::optional<bool> m_secure;
    std::optional<bool> m_httpOnly;
    std::optional<String> m_sameSite;
    std::optional<double> m_expires;
    std::optional<String> m_priority;
    std::optional<bool> m_sameParty;
    std::optional<String> m_sourceScheme;
    std::optional<int> m_sourcePort;
    std::unique_ptr<protocol::Network::CookiePartitionKey> m_partitionKey;
};


class CONTENT_EXPORT AuthChallenge : public ::crdtp::ProtocolObject<AuthChallenge> {
public:
    ~AuthChallenge() override { }

    struct CONTENT_EXPORT SourceEnum {
        static const char* Server;
        static const char* Proxy;
    }; // SourceEnum

    bool HasSource() { return !!m_source; }
    String GetSource(const String& defaultValue) const {
       return m_source.value_or(defaultValue);
    }
    const std::optional<String>& GetSource() const {
       return m_source;
    }
    void SetSource(const String& value) { m_source = value; }

    String GetOrigin() { return m_origin; }
    void SetOrigin(const String& value) { m_origin = value; }

    String GetScheme() { return m_scheme; }
    void SetScheme(const String& value) { m_scheme = value; }

    String GetRealm() { return m_realm; }
    void SetRealm(const String& value) { m_realm = value; }

    template<int STATE>
    class AuthChallengeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            SchemeSet = 1 << 2,
            RealmSet = 1 << 3,
            AllFieldsSet = (OriginSet | SchemeSet | RealmSet | 0)};


        AuthChallengeBuilder<STATE>& SetSource(const String& value)
        {
            m_result->SetSource(value);
            return *this;
        }

        AuthChallengeBuilder<STATE | OriginSet>& SetOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->SetOrigin(value);
            return castState<OriginSet>();
        }

        AuthChallengeBuilder<STATE | SchemeSet>& SetScheme(const String& value)
        {
            static_assert(!(STATE & SchemeSet), "property scheme should not be set yet");
            m_result->SetScheme(value);
            return castState<SchemeSet>();
        }

        AuthChallengeBuilder<STATE | RealmSet>& SetRealm(const String& value)
        {
            static_assert(!(STATE & RealmSet), "property realm should not be set yet");
            m_result->SetRealm(value);
            return castState<RealmSet>();
        }

        std::unique_ptr<AuthChallenge> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AuthChallenge;
        AuthChallengeBuilder() : m_result(new AuthChallenge()) { }

        template<int STEP> AuthChallengeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AuthChallengeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::AuthChallenge> m_result;
    };

    static AuthChallengeBuilder<0> Create()
    {
        return AuthChallengeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AuthChallenge()
    {
    }

    std::optional<String> m_source;
    String m_origin;
    String m_scheme;
    String m_realm;
};


class CONTENT_EXPORT AuthChallengeResponse : public ::crdtp::ProtocolObject<AuthChallengeResponse> {
public:
    ~AuthChallengeResponse() override { }

    struct CONTENT_EXPORT ResponseEnum {
        static const char* Default;
        static const char* CancelAuth;
        static const char* ProvideCredentials;
    }; // ResponseEnum

    String GetResponse() { return m_response; }
    void SetResponse(const String& value) { m_response = value; }

    bool HasUsername() { return !!m_username; }
    String GetUsername(const String& defaultValue) const {
       return m_username.value_or(defaultValue);
    }
    const std::optional<String>& GetUsername() const {
       return m_username;
    }
    void SetUsername(const String& value) { m_username = value; }

    bool HasPassword() { return !!m_password; }
    String GetPassword(const String& defaultValue) const {
       return m_password.value_or(defaultValue);
    }
    const std::optional<String>& GetPassword() const {
       return m_password;
    }
    void SetPassword(const String& value) { m_password = value; }

    template<int STATE>
    class AuthChallengeResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResponseSet = 1 << 1,
            AllFieldsSet = (ResponseSet | 0)};


        AuthChallengeResponseBuilder<STATE | ResponseSet>& SetResponse(const String& value)
        {
            static_assert(!(STATE & ResponseSet), "property response should not be set yet");
            m_result->SetResponse(value);
            return castState<ResponseSet>();
        }

        AuthChallengeResponseBuilder<STATE>& SetUsername(const String& value)
        {
            m_result->SetUsername(value);
            return *this;
        }

        AuthChallengeResponseBuilder<STATE>& SetPassword(const String& value)
        {
            m_result->SetPassword(value);
            return *this;
        }

        std::unique_ptr<AuthChallengeResponse> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AuthChallengeResponse;
        AuthChallengeResponseBuilder() : m_result(new AuthChallengeResponse()) { }

        template<int STEP> AuthChallengeResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AuthChallengeResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::AuthChallengeResponse> m_result;
    };

    static AuthChallengeResponseBuilder<0> Create()
    {
        return AuthChallengeResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AuthChallengeResponse()
    {
    }

    String m_response;
    std::optional<String> m_username;
    std::optional<String> m_password;
};


class CONTENT_EXPORT RequestPattern : public ::crdtp::ProtocolObject<RequestPattern> {
public:
    ~RequestPattern() override { }

    bool HasUrlPattern() { return !!m_urlPattern; }
    String GetUrlPattern(const String& defaultValue) const {
       return m_urlPattern.value_or(defaultValue);
    }
    const std::optional<String>& GetUrlPattern() const {
       return m_urlPattern;
    }
    void SetUrlPattern(const String& value) { m_urlPattern = value; }

    bool HasResourceType() { return !!m_resourceType; }
    String GetResourceType(const String& defaultValue) const {
       return m_resourceType.value_or(defaultValue);
    }
    const std::optional<String>& GetResourceType() const {
       return m_resourceType;
    }
    void SetResourceType(const String& value) { m_resourceType = value; }

    bool HasInterceptionStage() { return !!m_interceptionStage; }
    String GetInterceptionStage(const String& defaultValue) const {
       return m_interceptionStage.value_or(defaultValue);
    }
    const std::optional<String>& GetInterceptionStage() const {
       return m_interceptionStage;
    }
    void SetInterceptionStage(const String& value) { m_interceptionStage = value; }

    template<int STATE>
    class RequestPatternBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        RequestPatternBuilder<STATE>& SetUrlPattern(const String& value)
        {
            m_result->SetUrlPattern(value);
            return *this;
        }

        RequestPatternBuilder<STATE>& SetResourceType(const String& value)
        {
            m_result->SetResourceType(value);
            return *this;
        }

        RequestPatternBuilder<STATE>& SetInterceptionStage(const String& value)
        {
            m_result->SetInterceptionStage(value);
            return *this;
        }

        std::unique_ptr<RequestPattern> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RequestPattern;
        RequestPatternBuilder() : m_result(new RequestPattern()) { }

        template<int STEP> RequestPatternBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestPatternBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::RequestPattern> m_result;
    };

    static RequestPatternBuilder<0> Create()
    {
        return RequestPatternBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RequestPattern()
    {
    }

    std::optional<String> m_urlPattern;
    std::optional<String> m_resourceType;
    std::optional<String> m_interceptionStage;
};


class CONTENT_EXPORT SignedExchangeSignature : public ::crdtp::ProtocolObject<SignedExchangeSignature> {
public:
    ~SignedExchangeSignature() override { }

    String GetLabel() { return m_label; }
    void SetLabel(const String& value) { m_label = value; }

    String GetSignature() { return m_signature; }
    void SetSignature(const String& value) { m_signature = value; }

    String GetIntegrity() { return m_integrity; }
    void SetIntegrity(const String& value) { m_integrity = value; }

    bool HasCertUrl() { return !!m_certUrl; }
    String GetCertUrl(const String& defaultValue) const {
       return m_certUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetCertUrl() const {
       return m_certUrl;
    }
    void SetCertUrl(const String& value) { m_certUrl = value; }

    bool HasCertSha256() { return !!m_certSha256; }
    String GetCertSha256(const String& defaultValue) const {
       return m_certSha256.value_or(defaultValue);
    }
    const std::optional<String>& GetCertSha256() const {
       return m_certSha256;
    }
    void SetCertSha256(const String& value) { m_certSha256 = value; }

    String GetValidityUrl() { return m_validityUrl; }
    void SetValidityUrl(const String& value) { m_validityUrl = value; }

    int GetDate() { return m_date; }
    void SetDate(int value) { m_date = value; }

    int GetExpires() { return m_expires; }
    void SetExpires(int value) { m_expires = value; }

    bool HasCertificates() { return !!m_certificates; }
    protocol::Array<String>* GetCertificates(protocol::Array<String>* defaultValue) {
       return m_certificates ? m_certificates.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetCertificates() const {
       return m_certificates;
    }
    void SetCertificates(std::unique_ptr<protocol::Array<String>> value) { m_certificates = std::move(value); }

    template<int STATE>
    class SignedExchangeSignatureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LabelSet = 1 << 1,
            SignatureSet = 1 << 2,
            IntegritySet = 1 << 3,
            ValidityUrlSet = 1 << 4,
            DateSet = 1 << 5,
            ExpiresSet = 1 << 6,
            AllFieldsSet = (LabelSet | SignatureSet | IntegritySet | ValidityUrlSet | DateSet | ExpiresSet | 0)};


        SignedExchangeSignatureBuilder<STATE | LabelSet>& SetLabel(const String& value)
        {
            static_assert(!(STATE & LabelSet), "property label should not be set yet");
            m_result->SetLabel(value);
            return castState<LabelSet>();
        }

        SignedExchangeSignatureBuilder<STATE | SignatureSet>& SetSignature(const String& value)
        {
            static_assert(!(STATE & SignatureSet), "property signature should not be set yet");
            m_result->SetSignature(value);
            return castState<SignatureSet>();
        }

        SignedExchangeSignatureBuilder<STATE | IntegritySet>& SetIntegrity(const String& value)
        {
            static_assert(!(STATE & IntegritySet), "property integrity should not be set yet");
            m_result->SetIntegrity(value);
            return castState<IntegritySet>();
        }

        SignedExchangeSignatureBuilder<STATE>& SetCertUrl(const String& value)
        {
            m_result->SetCertUrl(value);
            return *this;
        }

        SignedExchangeSignatureBuilder<STATE>& SetCertSha256(const String& value)
        {
            m_result->SetCertSha256(value);
            return *this;
        }

        SignedExchangeSignatureBuilder<STATE | ValidityUrlSet>& SetValidityUrl(const String& value)
        {
            static_assert(!(STATE & ValidityUrlSet), "property validityUrl should not be set yet");
            m_result->SetValidityUrl(value);
            return castState<ValidityUrlSet>();
        }

        SignedExchangeSignatureBuilder<STATE | DateSet>& SetDate(int value)
        {
            static_assert(!(STATE & DateSet), "property date should not be set yet");
            m_result->SetDate(value);
            return castState<DateSet>();
        }

        SignedExchangeSignatureBuilder<STATE | ExpiresSet>& SetExpires(int value)
        {
            static_assert(!(STATE & ExpiresSet), "property expires should not be set yet");
            m_result->SetExpires(value);
            return castState<ExpiresSet>();
        }

        SignedExchangeSignatureBuilder<STATE>& SetCertificates(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetCertificates(std::move(value));
            return *this;
        }

        std::unique_ptr<SignedExchangeSignature> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeSignature;
        SignedExchangeSignatureBuilder() : m_result(new SignedExchangeSignature()) { }

        template<int STEP> SignedExchangeSignatureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeSignatureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeSignature> m_result;
    };

    static SignedExchangeSignatureBuilder<0> Create()
    {
        return SignedExchangeSignatureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeSignature()
    {
          m_date = 0;
          m_expires = 0;
    }

    String m_label;
    String m_signature;
    String m_integrity;
    std::optional<String> m_certUrl;
    std::optional<String> m_certSha256;
    String m_validityUrl;
    int m_date;
    int m_expires;
    std::unique_ptr<protocol::Array<String>> m_certificates;
};


class CONTENT_EXPORT SignedExchangeHeader : public ::crdtp::ProtocolObject<SignedExchangeHeader> {
public:
    ~SignedExchangeHeader() override { }

    String GetRequestUrl() { return m_requestUrl; }
    void SetRequestUrl(const String& value) { m_requestUrl = value; }

    int GetResponseCode() { return m_responseCode; }
    void SetResponseCode(int value) { m_responseCode = value; }

    protocol::Network::Headers* GetResponseHeaders() { return m_responseHeaders.get(); }
    void SetResponseHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_responseHeaders = std::move(value); }

    protocol::Array<protocol::Network::SignedExchangeSignature>* GetSignatures() { return m_signatures.get(); }
    void SetSignatures(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeSignature>> value) { m_signatures = std::move(value); }

    String GetHeaderIntegrity() { return m_headerIntegrity; }
    void SetHeaderIntegrity(const String& value) { m_headerIntegrity = value; }

    template<int STATE>
    class SignedExchangeHeaderBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestUrlSet = 1 << 1,
            ResponseCodeSet = 1 << 2,
            ResponseHeadersSet = 1 << 3,
            SignaturesSet = 1 << 4,
            HeaderIntegritySet = 1 << 5,
            AllFieldsSet = (RequestUrlSet | ResponseCodeSet | ResponseHeadersSet | SignaturesSet | HeaderIntegritySet | 0)};


        SignedExchangeHeaderBuilder<STATE | RequestUrlSet>& SetRequestUrl(const String& value)
        {
            static_assert(!(STATE & RequestUrlSet), "property requestUrl should not be set yet");
            m_result->SetRequestUrl(value);
            return castState<RequestUrlSet>();
        }

        SignedExchangeHeaderBuilder<STATE | ResponseCodeSet>& SetResponseCode(int value)
        {
            static_assert(!(STATE & ResponseCodeSet), "property responseCode should not be set yet");
            m_result->SetResponseCode(value);
            return castState<ResponseCodeSet>();
        }

        SignedExchangeHeaderBuilder<STATE | ResponseHeadersSet>& SetResponseHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & ResponseHeadersSet), "property responseHeaders should not be set yet");
            m_result->SetResponseHeaders(std::move(value));
            return castState<ResponseHeadersSet>();
        }

        SignedExchangeHeaderBuilder<STATE | SignaturesSet>& SetSignatures(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeSignature>> value)
        {
            static_assert(!(STATE & SignaturesSet), "property signatures should not be set yet");
            m_result->SetSignatures(std::move(value));
            return castState<SignaturesSet>();
        }

        SignedExchangeHeaderBuilder<STATE | HeaderIntegritySet>& SetHeaderIntegrity(const String& value)
        {
            static_assert(!(STATE & HeaderIntegritySet), "property headerIntegrity should not be set yet");
            m_result->SetHeaderIntegrity(value);
            return castState<HeaderIntegritySet>();
        }

        std::unique_ptr<SignedExchangeHeader> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeHeader;
        SignedExchangeHeaderBuilder() : m_result(new SignedExchangeHeader()) { }

        template<int STEP> SignedExchangeHeaderBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeHeaderBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeHeader> m_result;
    };

    static SignedExchangeHeaderBuilder<0> Create()
    {
        return SignedExchangeHeaderBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeHeader()
    {
          m_responseCode = 0;
    }

    String m_requestUrl;
    int m_responseCode;
    std::unique_ptr<protocol::Network::Headers> m_responseHeaders;
    std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeSignature>> m_signatures;
    String m_headerIntegrity;
};


class CONTENT_EXPORT SignedExchangeError : public ::crdtp::ProtocolObject<SignedExchangeError> {
public:
    ~SignedExchangeError() override { }

    String GetMessage() { return m_message; }
    void SetMessage(const String& value) { m_message = value; }

    bool HasSignatureIndex() { return !!m_signatureIndex; }
    int GetSignatureIndex(int defaultValue) const {
       return m_signatureIndex.value_or(defaultValue);
    }
    const std::optional<int>& GetSignatureIndex() const {
       return m_signatureIndex;
    }
    void SetSignatureIndex(int value) { m_signatureIndex = value; }

    bool HasErrorField() { return !!m_errorField; }
    String GetErrorField(const String& defaultValue) const {
       return m_errorField.value_or(defaultValue);
    }
    const std::optional<String>& GetErrorField() const {
       return m_errorField;
    }
    void SetErrorField(const String& value) { m_errorField = value; }

    template<int STATE>
    class SignedExchangeErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            MessageSet = 1 << 1,
            AllFieldsSet = (MessageSet | 0)};


        SignedExchangeErrorBuilder<STATE | MessageSet>& SetMessage(const String& value)
        {
            static_assert(!(STATE & MessageSet), "property message should not be set yet");
            m_result->SetMessage(value);
            return castState<MessageSet>();
        }

        SignedExchangeErrorBuilder<STATE>& SetSignatureIndex(int value)
        {
            m_result->SetSignatureIndex(value);
            return *this;
        }

        SignedExchangeErrorBuilder<STATE>& SetErrorField(const String& value)
        {
            m_result->SetErrorField(value);
            return *this;
        }

        std::unique_ptr<SignedExchangeError> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeError;
        SignedExchangeErrorBuilder() : m_result(new SignedExchangeError()) { }

        template<int STEP> SignedExchangeErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeError> m_result;
    };

    static SignedExchangeErrorBuilder<0> Create()
    {
        return SignedExchangeErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeError()
    {
    }

    String m_message;
    std::optional<int> m_signatureIndex;
    std::optional<String> m_errorField;
};


class CONTENT_EXPORT SignedExchangeInfo : public ::crdtp::ProtocolObject<SignedExchangeInfo> {
public:
    ~SignedExchangeInfo() override { }

    protocol::Network::Response* GetOuterResponse() { return m_outerResponse.get(); }
    void SetOuterResponse(std::unique_ptr<protocol::Network::Response> value) { m_outerResponse = std::move(value); }

    bool HasHeader() { return !!m_header; }
    protocol::Network::SignedExchangeHeader* GetHeader(protocol::Network::SignedExchangeHeader* defaultValue) {
       return m_header ? m_header.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::SignedExchangeHeader>& GetHeader() const {
       return m_header;
    }
    void SetHeader(std::unique_ptr<protocol::Network::SignedExchangeHeader> value) { m_header = std::move(value); }

    bool HasSecurityDetails() { return !!m_securityDetails; }
    protocol::Network::SecurityDetails* GetSecurityDetails(protocol::Network::SecurityDetails* defaultValue) {
       return m_securityDetails ? m_securityDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::SecurityDetails>& GetSecurityDetails() const {
       return m_securityDetails;
    }
    void SetSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value) { m_securityDetails = std::move(value); }

    bool HasErrors() { return !!m_errors; }
    protocol::Array<protocol::Network::SignedExchangeError>* GetErrors(protocol::Array<protocol::Network::SignedExchangeError>* defaultValue) {
       return m_errors ? m_errors.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>>& GetErrors() const {
       return m_errors;
    }
    void SetErrors(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>> value) { m_errors = std::move(value); }

    template<int STATE>
    class SignedExchangeInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OuterResponseSet = 1 << 1,
            AllFieldsSet = (OuterResponseSet | 0)};


        SignedExchangeInfoBuilder<STATE | OuterResponseSet>& SetOuterResponse(std::unique_ptr<protocol::Network::Response> value)
        {
            static_assert(!(STATE & OuterResponseSet), "property outerResponse should not be set yet");
            m_result->SetOuterResponse(std::move(value));
            return castState<OuterResponseSet>();
        }

        SignedExchangeInfoBuilder<STATE>& SetHeader(std::unique_ptr<protocol::Network::SignedExchangeHeader> value)
        {
            m_result->SetHeader(std::move(value));
            return *this;
        }

        SignedExchangeInfoBuilder<STATE>& SetSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value)
        {
            m_result->SetSecurityDetails(std::move(value));
            return *this;
        }

        SignedExchangeInfoBuilder<STATE>& SetErrors(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>> value)
        {
            m_result->SetErrors(std::move(value));
            return *this;
        }

        std::unique_ptr<SignedExchangeInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeInfo;
        SignedExchangeInfoBuilder() : m_result(new SignedExchangeInfo()) { }

        template<int STEP> SignedExchangeInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeInfo> m_result;
    };

    static SignedExchangeInfoBuilder<0> Create()
    {
        return SignedExchangeInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeInfo()
    {
    }

    std::unique_ptr<protocol::Network::Response> m_outerResponse;
    std::unique_ptr<protocol::Network::SignedExchangeHeader> m_header;
    std::unique_ptr<protocol::Network::SecurityDetails> m_securityDetails;
    std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>> m_errors;
};


class CONTENT_EXPORT ConnectTiming : public ::crdtp::ProtocolObject<ConnectTiming> {
public:
    ~ConnectTiming() override { }

    double GetRequestTime() { return m_requestTime; }
    void SetRequestTime(double value) { m_requestTime = value; }

    template<int STATE>
    class ConnectTimingBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestTimeSet = 1 << 1,
            AllFieldsSet = (RequestTimeSet | 0)};


        ConnectTimingBuilder<STATE | RequestTimeSet>& SetRequestTime(double value)
        {
            static_assert(!(STATE & RequestTimeSet), "property requestTime should not be set yet");
            m_result->SetRequestTime(value);
            return castState<RequestTimeSet>();
        }

        std::unique_ptr<ConnectTiming> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ConnectTiming;
        ConnectTimingBuilder() : m_result(new ConnectTiming()) { }

        template<int STEP> ConnectTimingBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ConnectTimingBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ConnectTiming> m_result;
    };

    static ConnectTimingBuilder<0> Create()
    {
        return ConnectTimingBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ConnectTiming()
    {
          m_requestTime = 0;
    }

    double m_requestTime;
};


class CONTENT_EXPORT ClientSecurityState : public ::crdtp::ProtocolObject<ClientSecurityState> {
public:
    ~ClientSecurityState() override { }

    bool GetInitiatorIsSecureContext() { return m_initiatorIsSecureContext; }
    void SetInitiatorIsSecureContext(bool value) { m_initiatorIsSecureContext = value; }

    String GetInitiatorIPAddressSpace() { return m_initiatorIPAddressSpace; }
    void SetInitiatorIPAddressSpace(const String& value) { m_initiatorIPAddressSpace = value; }

    String GetPrivateNetworkRequestPolicy() { return m_privateNetworkRequestPolicy; }
    void SetPrivateNetworkRequestPolicy(const String& value) { m_privateNetworkRequestPolicy = value; }

    template<int STATE>
    class ClientSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            InitiatorIsSecureContextSet = 1 << 1,
            InitiatorIPAddressSpaceSet = 1 << 2,
            PrivateNetworkRequestPolicySet = 1 << 3,
            AllFieldsSet = (InitiatorIsSecureContextSet | InitiatorIPAddressSpaceSet | PrivateNetworkRequestPolicySet | 0)};


        ClientSecurityStateBuilder<STATE | InitiatorIsSecureContextSet>& SetInitiatorIsSecureContext(bool value)
        {
            static_assert(!(STATE & InitiatorIsSecureContextSet), "property initiatorIsSecureContext should not be set yet");
            m_result->SetInitiatorIsSecureContext(value);
            return castState<InitiatorIsSecureContextSet>();
        }

        ClientSecurityStateBuilder<STATE | InitiatorIPAddressSpaceSet>& SetInitiatorIPAddressSpace(const String& value)
        {
            static_assert(!(STATE & InitiatorIPAddressSpaceSet), "property initiatorIPAddressSpace should not be set yet");
            m_result->SetInitiatorIPAddressSpace(value);
            return castState<InitiatorIPAddressSpaceSet>();
        }

        ClientSecurityStateBuilder<STATE | PrivateNetworkRequestPolicySet>& SetPrivateNetworkRequestPolicy(const String& value)
        {
            static_assert(!(STATE & PrivateNetworkRequestPolicySet), "property privateNetworkRequestPolicy should not be set yet");
            m_result->SetPrivateNetworkRequestPolicy(value);
            return castState<PrivateNetworkRequestPolicySet>();
        }

        std::unique_ptr<ClientSecurityState> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ClientSecurityState;
        ClientSecurityStateBuilder() : m_result(new ClientSecurityState()) { }

        template<int STEP> ClientSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ClientSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ClientSecurityState> m_result;
    };

    static ClientSecurityStateBuilder<0> Create()
    {
        return ClientSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ClientSecurityState()
    {
          m_initiatorIsSecureContext = false;
    }

    bool m_initiatorIsSecureContext;
    String m_initiatorIPAddressSpace;
    String m_privateNetworkRequestPolicy;
};


class CONTENT_EXPORT CrossOriginOpenerPolicyStatus : public ::crdtp::ProtocolObject<CrossOriginOpenerPolicyStatus> {
public:
    ~CrossOriginOpenerPolicyStatus() override { }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    String GetReportOnlyValue() { return m_reportOnlyValue; }
    void SetReportOnlyValue(const String& value) { m_reportOnlyValue = value; }

    bool HasReportingEndpoint() { return !!m_reportingEndpoint; }
    String GetReportingEndpoint(const String& defaultValue) const {
       return m_reportingEndpoint.value_or(defaultValue);
    }
    const std::optional<String>& GetReportingEndpoint() const {
       return m_reportingEndpoint;
    }
    void SetReportingEndpoint(const String& value) { m_reportingEndpoint = value; }

    bool HasReportOnlyReportingEndpoint() { return !!m_reportOnlyReportingEndpoint; }
    String GetReportOnlyReportingEndpoint(const String& defaultValue) const {
       return m_reportOnlyReportingEndpoint.value_or(defaultValue);
    }
    const std::optional<String>& GetReportOnlyReportingEndpoint() const {
       return m_reportOnlyReportingEndpoint;
    }
    void SetReportOnlyReportingEndpoint(const String& value) { m_reportOnlyReportingEndpoint = value; }

    template<int STATE>
    class CrossOriginOpenerPolicyStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValueSet = 1 << 1,
            ReportOnlyValueSet = 1 << 2,
            AllFieldsSet = (ValueSet | ReportOnlyValueSet | 0)};


        CrossOriginOpenerPolicyStatusBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        CrossOriginOpenerPolicyStatusBuilder<STATE | ReportOnlyValueSet>& SetReportOnlyValue(const String& value)
        {
            static_assert(!(STATE & ReportOnlyValueSet), "property reportOnlyValue should not be set yet");
            m_result->SetReportOnlyValue(value);
            return castState<ReportOnlyValueSet>();
        }

        CrossOriginOpenerPolicyStatusBuilder<STATE>& SetReportingEndpoint(const String& value)
        {
            m_result->SetReportingEndpoint(value);
            return *this;
        }

        CrossOriginOpenerPolicyStatusBuilder<STATE>& SetReportOnlyReportingEndpoint(const String& value)
        {
            m_result->SetReportOnlyReportingEndpoint(value);
            return *this;
        }

        std::unique_ptr<CrossOriginOpenerPolicyStatus> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CrossOriginOpenerPolicyStatus;
        CrossOriginOpenerPolicyStatusBuilder() : m_result(new CrossOriginOpenerPolicyStatus()) { }

        template<int STEP> CrossOriginOpenerPolicyStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CrossOriginOpenerPolicyStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CrossOriginOpenerPolicyStatus> m_result;
    };

    static CrossOriginOpenerPolicyStatusBuilder<0> Create()
    {
        return CrossOriginOpenerPolicyStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CrossOriginOpenerPolicyStatus()
    {
    }

    String m_value;
    String m_reportOnlyValue;
    std::optional<String> m_reportingEndpoint;
    std::optional<String> m_reportOnlyReportingEndpoint;
};


class CONTENT_EXPORT CrossOriginEmbedderPolicyStatus : public ::crdtp::ProtocolObject<CrossOriginEmbedderPolicyStatus> {
public:
    ~CrossOriginEmbedderPolicyStatus() override { }

    String GetValue() { return m_value; }
    void SetValue(const String& value) { m_value = value; }

    String GetReportOnlyValue() { return m_reportOnlyValue; }
    void SetReportOnlyValue(const String& value) { m_reportOnlyValue = value; }

    bool HasReportingEndpoint() { return !!m_reportingEndpoint; }
    String GetReportingEndpoint(const String& defaultValue) const {
       return m_reportingEndpoint.value_or(defaultValue);
    }
    const std::optional<String>& GetReportingEndpoint() const {
       return m_reportingEndpoint;
    }
    void SetReportingEndpoint(const String& value) { m_reportingEndpoint = value; }

    bool HasReportOnlyReportingEndpoint() { return !!m_reportOnlyReportingEndpoint; }
    String GetReportOnlyReportingEndpoint(const String& defaultValue) const {
       return m_reportOnlyReportingEndpoint.value_or(defaultValue);
    }
    const std::optional<String>& GetReportOnlyReportingEndpoint() const {
       return m_reportOnlyReportingEndpoint;
    }
    void SetReportOnlyReportingEndpoint(const String& value) { m_reportOnlyReportingEndpoint = value; }

    template<int STATE>
    class CrossOriginEmbedderPolicyStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValueSet = 1 << 1,
            ReportOnlyValueSet = 1 << 2,
            AllFieldsSet = (ValueSet | ReportOnlyValueSet | 0)};


        CrossOriginEmbedderPolicyStatusBuilder<STATE | ValueSet>& SetValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->SetValue(value);
            return castState<ValueSet>();
        }

        CrossOriginEmbedderPolicyStatusBuilder<STATE | ReportOnlyValueSet>& SetReportOnlyValue(const String& value)
        {
            static_assert(!(STATE & ReportOnlyValueSet), "property reportOnlyValue should not be set yet");
            m_result->SetReportOnlyValue(value);
            return castState<ReportOnlyValueSet>();
        }

        CrossOriginEmbedderPolicyStatusBuilder<STATE>& SetReportingEndpoint(const String& value)
        {
            m_result->SetReportingEndpoint(value);
            return *this;
        }

        CrossOriginEmbedderPolicyStatusBuilder<STATE>& SetReportOnlyReportingEndpoint(const String& value)
        {
            m_result->SetReportOnlyReportingEndpoint(value);
            return *this;
        }

        std::unique_ptr<CrossOriginEmbedderPolicyStatus> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CrossOriginEmbedderPolicyStatus;
        CrossOriginEmbedderPolicyStatusBuilder() : m_result(new CrossOriginEmbedderPolicyStatus()) { }

        template<int STEP> CrossOriginEmbedderPolicyStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CrossOriginEmbedderPolicyStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CrossOriginEmbedderPolicyStatus> m_result;
    };

    static CrossOriginEmbedderPolicyStatusBuilder<0> Create()
    {
        return CrossOriginEmbedderPolicyStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CrossOriginEmbedderPolicyStatus()
    {
    }

    String m_value;
    String m_reportOnlyValue;
    std::optional<String> m_reportingEndpoint;
    std::optional<String> m_reportOnlyReportingEndpoint;
};


class CONTENT_EXPORT ContentSecurityPolicyStatus : public ::crdtp::ProtocolObject<ContentSecurityPolicyStatus> {
public:
    ~ContentSecurityPolicyStatus() override { }

    String GetEffectiveDirectives() { return m_effectiveDirectives; }
    void SetEffectiveDirectives(const String& value) { m_effectiveDirectives = value; }

    bool GetIsEnforced() { return m_isEnforced; }
    void SetIsEnforced(bool value) { m_isEnforced = value; }

    String GetSource() { return m_source; }
    void SetSource(const String& value) { m_source = value; }

    template<int STATE>
    class ContentSecurityPolicyStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            EffectiveDirectivesSet = 1 << 1,
            IsEnforcedSet = 1 << 2,
            SourceSet = 1 << 3,
            AllFieldsSet = (EffectiveDirectivesSet | IsEnforcedSet | SourceSet | 0)};


        ContentSecurityPolicyStatusBuilder<STATE | EffectiveDirectivesSet>& SetEffectiveDirectives(const String& value)
        {
            static_assert(!(STATE & EffectiveDirectivesSet), "property effectiveDirectives should not be set yet");
            m_result->SetEffectiveDirectives(value);
            return castState<EffectiveDirectivesSet>();
        }

        ContentSecurityPolicyStatusBuilder<STATE | IsEnforcedSet>& SetIsEnforced(bool value)
        {
            static_assert(!(STATE & IsEnforcedSet), "property isEnforced should not be set yet");
            m_result->SetIsEnforced(value);
            return castState<IsEnforcedSet>();
        }

        ContentSecurityPolicyStatusBuilder<STATE | SourceSet>& SetSource(const String& value)
        {
            static_assert(!(STATE & SourceSet), "property source should not be set yet");
            m_result->SetSource(value);
            return castState<SourceSet>();
        }

        std::unique_ptr<ContentSecurityPolicyStatus> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContentSecurityPolicyStatus;
        ContentSecurityPolicyStatusBuilder() : m_result(new ContentSecurityPolicyStatus()) { }

        template<int STEP> ContentSecurityPolicyStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContentSecurityPolicyStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ContentSecurityPolicyStatus> m_result;
    };

    static ContentSecurityPolicyStatusBuilder<0> Create()
    {
        return ContentSecurityPolicyStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContentSecurityPolicyStatus()
    {
          m_isEnforced = false;
    }

    String m_effectiveDirectives;
    bool m_isEnforced;
    String m_source;
};


class CONTENT_EXPORT SecurityIsolationStatus : public ::crdtp::ProtocolObject<SecurityIsolationStatus> {
public:
    ~SecurityIsolationStatus() override { }

    bool HasCoop() { return !!m_coop; }
    protocol::Network::CrossOriginOpenerPolicyStatus* GetCoop(protocol::Network::CrossOriginOpenerPolicyStatus* defaultValue) {
       return m_coop ? m_coop.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::CrossOriginOpenerPolicyStatus>& GetCoop() const {
       return m_coop;
    }
    void SetCoop(std::unique_ptr<protocol::Network::CrossOriginOpenerPolicyStatus> value) { m_coop = std::move(value); }

    bool HasCoep() { return !!m_coep; }
    protocol::Network::CrossOriginEmbedderPolicyStatus* GetCoep(protocol::Network::CrossOriginEmbedderPolicyStatus* defaultValue) {
       return m_coep ? m_coep.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::CrossOriginEmbedderPolicyStatus>& GetCoep() const {
       return m_coep;
    }
    void SetCoep(std::unique_ptr<protocol::Network::CrossOriginEmbedderPolicyStatus> value) { m_coep = std::move(value); }

    bool HasCsp() { return !!m_csp; }
    protocol::Array<protocol::Network::ContentSecurityPolicyStatus>* GetCsp(protocol::Array<protocol::Network::ContentSecurityPolicyStatus>* defaultValue) {
       return m_csp ? m_csp.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Network::ContentSecurityPolicyStatus>>& GetCsp() const {
       return m_csp;
    }
    void SetCsp(std::unique_ptr<protocol::Array<protocol::Network::ContentSecurityPolicyStatus>> value) { m_csp = std::move(value); }

    template<int STATE>
    class SecurityIsolationStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        SecurityIsolationStatusBuilder<STATE>& SetCoop(std::unique_ptr<protocol::Network::CrossOriginOpenerPolicyStatus> value)
        {
            m_result->SetCoop(std::move(value));
            return *this;
        }

        SecurityIsolationStatusBuilder<STATE>& SetCoep(std::unique_ptr<protocol::Network::CrossOriginEmbedderPolicyStatus> value)
        {
            m_result->SetCoep(std::move(value));
            return *this;
        }

        SecurityIsolationStatusBuilder<STATE>& SetCsp(std::unique_ptr<protocol::Array<protocol::Network::ContentSecurityPolicyStatus>> value)
        {
            m_result->SetCsp(std::move(value));
            return *this;
        }

        std::unique_ptr<SecurityIsolationStatus> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SecurityIsolationStatus;
        SecurityIsolationStatusBuilder() : m_result(new SecurityIsolationStatus()) { }

        template<int STEP> SecurityIsolationStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SecurityIsolationStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SecurityIsolationStatus> m_result;
    };

    static SecurityIsolationStatusBuilder<0> Create()
    {
        return SecurityIsolationStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SecurityIsolationStatus()
    {
    }

    std::unique_ptr<protocol::Network::CrossOriginOpenerPolicyStatus> m_coop;
    std::unique_ptr<protocol::Network::CrossOriginEmbedderPolicyStatus> m_coep;
    std::unique_ptr<protocol::Array<protocol::Network::ContentSecurityPolicyStatus>> m_csp;
};


class CONTENT_EXPORT ReportingApiReport : public ::crdtp::ProtocolObject<ReportingApiReport> {
public:
    ~ReportingApiReport() override { }

    String GetId() { return m_id; }
    void SetId(const String& value) { m_id = value; }

    String GetInitiatorUrl() { return m_initiatorUrl; }
    void SetInitiatorUrl(const String& value) { m_initiatorUrl = value; }

    String GetDestination() { return m_destination; }
    void SetDestination(const String& value) { m_destination = value; }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    double GetTimestamp() { return m_timestamp; }
    void SetTimestamp(double value) { m_timestamp = value; }

    int GetDepth() { return m_depth; }
    void SetDepth(int value) { m_depth = value; }

    int GetCompletedAttempts() { return m_completedAttempts; }
    void SetCompletedAttempts(int value) { m_completedAttempts = value; }

    protocol::DictionaryValue* GetBody() { return m_body.get(); }
    void SetBody(std::unique_ptr<protocol::DictionaryValue> value) { m_body = std::move(value); }

    String GetStatus() { return m_status; }
    void SetStatus(const String& value) { m_status = value; }

    template<int STATE>
    class ReportingApiReportBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            InitiatorUrlSet = 1 << 2,
            DestinationSet = 1 << 3,
            TypeSet = 1 << 4,
            TimestampSet = 1 << 5,
            DepthSet = 1 << 6,
            CompletedAttemptsSet = 1 << 7,
            BodySet = 1 << 8,
            StatusSet = 1 << 9,
            AllFieldsSet = (IdSet | InitiatorUrlSet | DestinationSet | TypeSet | TimestampSet | DepthSet | CompletedAttemptsSet | BodySet | StatusSet | 0)};


        ReportingApiReportBuilder<STATE | IdSet>& SetId(const String& value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->SetId(value);
            return castState<IdSet>();
        }

        ReportingApiReportBuilder<STATE | InitiatorUrlSet>& SetInitiatorUrl(const String& value)
        {
            static_assert(!(STATE & InitiatorUrlSet), "property initiatorUrl should not be set yet");
            m_result->SetInitiatorUrl(value);
            return castState<InitiatorUrlSet>();
        }

        ReportingApiReportBuilder<STATE | DestinationSet>& SetDestination(const String& value)
        {
            static_assert(!(STATE & DestinationSet), "property destination should not be set yet");
            m_result->SetDestination(value);
            return castState<DestinationSet>();
        }

        ReportingApiReportBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        ReportingApiReportBuilder<STATE | TimestampSet>& SetTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->SetTimestamp(value);
            return castState<TimestampSet>();
        }

        ReportingApiReportBuilder<STATE | DepthSet>& SetDepth(int value)
        {
            static_assert(!(STATE & DepthSet), "property depth should not be set yet");
            m_result->SetDepth(value);
            return castState<DepthSet>();
        }

        ReportingApiReportBuilder<STATE | CompletedAttemptsSet>& SetCompletedAttempts(int value)
        {
            static_assert(!(STATE & CompletedAttemptsSet), "property completedAttempts should not be set yet");
            m_result->SetCompletedAttempts(value);
            return castState<CompletedAttemptsSet>();
        }

        ReportingApiReportBuilder<STATE | BodySet>& SetBody(std::unique_ptr<protocol::DictionaryValue> value)
        {
            static_assert(!(STATE & BodySet), "property body should not be set yet");
            m_result->SetBody(std::move(value));
            return castState<BodySet>();
        }

        ReportingApiReportBuilder<STATE | StatusSet>& SetStatus(const String& value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->SetStatus(value);
            return castState<StatusSet>();
        }

        std::unique_ptr<ReportingApiReport> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ReportingApiReport;
        ReportingApiReportBuilder() : m_result(new ReportingApiReport()) { }

        template<int STEP> ReportingApiReportBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ReportingApiReportBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ReportingApiReport> m_result;
    };

    static ReportingApiReportBuilder<0> Create()
    {
        return ReportingApiReportBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ReportingApiReport()
    {
          m_timestamp = 0;
          m_depth = 0;
          m_completedAttempts = 0;
    }

    String m_id;
    String m_initiatorUrl;
    String m_destination;
    String m_type;
    double m_timestamp;
    int m_depth;
    int m_completedAttempts;
    std::unique_ptr<protocol::DictionaryValue> m_body;
    String m_status;
};


class CONTENT_EXPORT ReportingApiEndpoint : public ::crdtp::ProtocolObject<ReportingApiEndpoint> {
public:
    ~ReportingApiEndpoint() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    String GetGroupName() { return m_groupName; }
    void SetGroupName(const String& value) { m_groupName = value; }

    template<int STATE>
    class ReportingApiEndpointBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            GroupNameSet = 1 << 2,
            AllFieldsSet = (UrlSet | GroupNameSet | 0)};


        ReportingApiEndpointBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        ReportingApiEndpointBuilder<STATE | GroupNameSet>& SetGroupName(const String& value)
        {
            static_assert(!(STATE & GroupNameSet), "property groupName should not be set yet");
            m_result->SetGroupName(value);
            return castState<GroupNameSet>();
        }

        std::unique_ptr<ReportingApiEndpoint> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ReportingApiEndpoint;
        ReportingApiEndpointBuilder() : m_result(new ReportingApiEndpoint()) { }

        template<int STEP> ReportingApiEndpointBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ReportingApiEndpointBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ReportingApiEndpoint> m_result;
    };

    static ReportingApiEndpointBuilder<0> Create()
    {
        return ReportingApiEndpointBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ReportingApiEndpoint()
    {
    }

    String m_url;
    String m_groupName;
};


class CONTENT_EXPORT LoadNetworkResourcePageResult : public ::crdtp::ProtocolObject<LoadNetworkResourcePageResult> {
public:
    ~LoadNetworkResourcePageResult() override { }

    bool GetSuccess() { return m_success; }
    void SetSuccess(bool value) { m_success = value; }

    bool HasNetError() { return !!m_netError; }
    double GetNetError(double defaultValue) const {
       return m_netError.value_or(defaultValue);
    }
    const std::optional<double>& GetNetError() const {
       return m_netError;
    }
    void SetNetError(double value) { m_netError = value; }

    bool HasNetErrorName() { return !!m_netErrorName; }
    String GetNetErrorName(const String& defaultValue) const {
       return m_netErrorName.value_or(defaultValue);
    }
    const std::optional<String>& GetNetErrorName() const {
       return m_netErrorName;
    }
    void SetNetErrorName(const String& value) { m_netErrorName = value; }

    bool HasHttpStatusCode() { return !!m_httpStatusCode; }
    double GetHttpStatusCode(double defaultValue) const {
       return m_httpStatusCode.value_or(defaultValue);
    }
    const std::optional<double>& GetHttpStatusCode() const {
       return m_httpStatusCode;
    }
    void SetHttpStatusCode(double value) { m_httpStatusCode = value; }

    bool HasStream() { return !!m_stream; }
    String GetStream(const String& defaultValue) const {
       return m_stream.value_or(defaultValue);
    }
    const std::optional<String>& GetStream() const {
       return m_stream;
    }
    void SetStream(const String& value) { m_stream = value; }

    bool HasHeaders() { return !!m_headers; }
    protocol::Network::Headers* GetHeaders(protocol::Network::Headers* defaultValue) {
       return m_headers ? m_headers.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::Headers>& GetHeaders() const {
       return m_headers;
    }
    void SetHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    template<int STATE>
    class LoadNetworkResourcePageResultBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SuccessSet = 1 << 1,
            AllFieldsSet = (SuccessSet | 0)};


        LoadNetworkResourcePageResultBuilder<STATE | SuccessSet>& SetSuccess(bool value)
        {
            static_assert(!(STATE & SuccessSet), "property success should not be set yet");
            m_result->SetSuccess(value);
            return castState<SuccessSet>();
        }

        LoadNetworkResourcePageResultBuilder<STATE>& SetNetError(double value)
        {
            m_result->SetNetError(value);
            return *this;
        }

        LoadNetworkResourcePageResultBuilder<STATE>& SetNetErrorName(const String& value)
        {
            m_result->SetNetErrorName(value);
            return *this;
        }

        LoadNetworkResourcePageResultBuilder<STATE>& SetHttpStatusCode(double value)
        {
            m_result->SetHttpStatusCode(value);
            return *this;
        }

        LoadNetworkResourcePageResultBuilder<STATE>& SetStream(const String& value)
        {
            m_result->SetStream(value);
            return *this;
        }

        LoadNetworkResourcePageResultBuilder<STATE>& SetHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            m_result->SetHeaders(std::move(value));
            return *this;
        }

        std::unique_ptr<LoadNetworkResourcePageResult> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LoadNetworkResourcePageResult;
        LoadNetworkResourcePageResultBuilder() : m_result(new LoadNetworkResourcePageResult()) { }

        template<int STEP> LoadNetworkResourcePageResultBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LoadNetworkResourcePageResultBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::LoadNetworkResourcePageResult> m_result;
    };

    static LoadNetworkResourcePageResultBuilder<0> Create()
    {
        return LoadNetworkResourcePageResultBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LoadNetworkResourcePageResult()
    {
          m_success = false;
    }

    bool m_success;
    std::optional<double> m_netError;
    std::optional<String> m_netErrorName;
    std::optional<double> m_httpStatusCode;
    std::optional<String> m_stream;
    std::unique_ptr<protocol::Network::Headers> m_headers;
};


class CONTENT_EXPORT LoadNetworkResourceOptions : public ::crdtp::ProtocolObject<LoadNetworkResourceOptions> {
public:
    ~LoadNetworkResourceOptions() override { }

    bool GetDisableCache() { return m_disableCache; }
    void SetDisableCache(bool value) { m_disableCache = value; }

    bool GetIncludeCredentials() { return m_includeCredentials; }
    void SetIncludeCredentials(bool value) { m_includeCredentials = value; }

    template<int STATE>
    class LoadNetworkResourceOptionsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DisableCacheSet = 1 << 1,
            IncludeCredentialsSet = 1 << 2,
            AllFieldsSet = (DisableCacheSet | IncludeCredentialsSet | 0)};


        LoadNetworkResourceOptionsBuilder<STATE | DisableCacheSet>& SetDisableCache(bool value)
        {
            static_assert(!(STATE & DisableCacheSet), "property disableCache should not be set yet");
            m_result->SetDisableCache(value);
            return castState<DisableCacheSet>();
        }

        LoadNetworkResourceOptionsBuilder<STATE | IncludeCredentialsSet>& SetIncludeCredentials(bool value)
        {
            static_assert(!(STATE & IncludeCredentialsSet), "property includeCredentials should not be set yet");
            m_result->SetIncludeCredentials(value);
            return castState<IncludeCredentialsSet>();
        }

        std::unique_ptr<LoadNetworkResourceOptions> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LoadNetworkResourceOptions;
        LoadNetworkResourceOptionsBuilder() : m_result(new LoadNetworkResourceOptions()) { }

        template<int STEP> LoadNetworkResourceOptionsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LoadNetworkResourceOptionsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::LoadNetworkResourceOptions> m_result;
    };

    static LoadNetworkResourceOptionsBuilder<0> Create()
    {
        return LoadNetworkResourceOptionsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LoadNetworkResourceOptions()
    {
          m_disableCache = false;
          m_includeCredentials = false;
    }

    bool m_disableCache;
    bool m_includeCredentials;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse SetAcceptedEncodings(std::unique_ptr<protocol::Array<String>> in_encodings) = 0;
    virtual DispatchResponse ClearAcceptedEncodingsOverride() = 0;
    virtual DispatchResponse CanEmulateNetworkConditions(bool* out_result) = 0;
    class CONTENT_EXPORT ClearBrowserCacheCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearBrowserCacheCallback() { }
    };
    virtual void ClearBrowserCache(std::unique_ptr<ClearBrowserCacheCallback> callback) = 0;
    class CONTENT_EXPORT ClearBrowserCookiesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearBrowserCookiesCallback() { }
    };
    virtual void ClearBrowserCookies(std::unique_ptr<ClearBrowserCookiesCallback> callback) = 0;
    class CONTENT_EXPORT ContinueInterceptedRequestCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ContinueInterceptedRequestCallback() { }
    };
    virtual void ContinueInterceptedRequest(const String& in_interceptionId, std::optional<String> in_errorReason, std::optional<Binary> in_rawResponse, std::optional<String> in_url, std::optional<String> in_method, std::optional<String> in_postData, std::unique_ptr<protocol::Network::Headers> in_headers, std::unique_ptr<protocol::Network::AuthChallengeResponse> in_authChallengeResponse, std::unique_ptr<ContinueInterceptedRequestCallback> callback) = 0;
    class CONTENT_EXPORT DeleteCookiesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DeleteCookiesCallback() { }
    };
    virtual void DeleteCookies(const String& in_name, std::optional<String> in_url, std::optional<String> in_domain, std::optional<String> in_path, std::unique_ptr<protocol::Network::CookiePartitionKey> in_partitionKey, std::unique_ptr<DeleteCookiesCallback> callback) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse EmulateNetworkConditions(bool in_offline, double in_latency, double in_downloadThroughput, double in_uploadThroughput, std::optional<String> in_connectionType, std::optional<double> in_packetLoss, std::optional<int> in_packetQueueLength, std::optional<bool> in_packetReordering) = 0;
    virtual DispatchResponse Enable(std::optional<int> in_maxTotalBufferSize, std::optional<int> in_maxResourceBufferSize, std::optional<int> in_maxPostDataSize) = 0;
    class CONTENT_EXPORT GetAllCookiesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Network::Cookie>> cookies) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetAllCookiesCallback() { }
    };
    virtual void GetAllCookies(std::unique_ptr<GetAllCookiesCallback> callback) = 0;
    class CONTENT_EXPORT GetCookiesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Network::Cookie>> cookies) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetCookiesCallback() { }
    };
    virtual void GetCookies(std::unique_ptr<protocol::Array<String>> in_urls, std::unique_ptr<GetCookiesCallback> callback) = 0;
    class CONTENT_EXPORT GetResponseBodyCallback {
    public:
        virtual void sendSuccess(const String& body, bool base64Encoded) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetResponseBodyCallback() { }
    };
    virtual void GetResponseBody(const String& in_requestId, std::unique_ptr<GetResponseBodyCallback> callback) = 0;
    class CONTENT_EXPORT GetResponseBodyForInterceptionCallback {
    public:
        virtual void sendSuccess(const String& body, bool base64Encoded) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetResponseBodyForInterceptionCallback() { }
    };
    virtual void GetResponseBodyForInterception(const String& in_interceptionId, std::unique_ptr<GetResponseBodyForInterceptionCallback> callback) = 0;
    class CONTENT_EXPORT TakeResponseBodyForInterceptionAsStreamCallback {
    public:
        virtual void sendSuccess(const String& stream) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~TakeResponseBodyForInterceptionAsStreamCallback() { }
    };
    virtual void TakeResponseBodyForInterceptionAsStream(const String& in_interceptionId, std::unique_ptr<TakeResponseBodyForInterceptionAsStreamCallback> callback) = 0;
    virtual DispatchResponse SetBypassServiceWorker(bool in_bypass) = 0;
    virtual DispatchResponse SetCacheDisabled(bool in_cacheDisabled) = 0;
    class CONTENT_EXPORT SetCookieCallback {
    public:
        virtual void sendSuccess(bool success) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetCookieCallback() { }
    };
    virtual void SetCookie(const String& in_name, const String& in_value, std::optional<String> in_url, std::optional<String> in_domain, std::optional<String> in_path, std::optional<bool> in_secure, std::optional<bool> in_httpOnly, std::optional<String> in_sameSite, std::optional<double> in_expires, std::optional<String> in_priority, std::optional<bool> in_sameParty, std::optional<String> in_sourceScheme, std::optional<int> in_sourcePort, std::unique_ptr<protocol::Network::CookiePartitionKey> in_partitionKey, std::unique_ptr<SetCookieCallback> callback) = 0;
    class CONTENT_EXPORT SetCookiesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetCookiesCallback() { }
    };
    virtual void SetCookies(std::unique_ptr<protocol::Array<protocol::Network::CookieParam>> in_cookies, std::unique_ptr<SetCookiesCallback> callback) = 0;
    virtual DispatchResponse SetExtraHTTPHeaders(std::unique_ptr<protocol::Network::Headers> in_headers) = 0;
    virtual DispatchResponse SetRequestInterception(std::unique_ptr<protocol::Array<protocol::Network::RequestPattern>> in_patterns) = 0;
    virtual DispatchResponse GetSecurityIsolationStatus(std::optional<String> in_frameId, std::unique_ptr<protocol::Network::SecurityIsolationStatus>* out_status) = 0;
    virtual DispatchResponse EnableReportingApi(bool in_enable) = 0;
    class CONTENT_EXPORT LoadNetworkResourceCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Network::LoadNetworkResourcePageResult> resource) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~LoadNetworkResourceCallback() { }
    };
    virtual void LoadNetworkResource(std::optional<String> in_frameId, const String& in_url, std::unique_ptr<protocol::Network::LoadNetworkResourceOptions> in_options, std::unique_ptr<LoadNetworkResourceCallback> callback) = 0;
    virtual DispatchResponse SetCookieControls(bool in_enableThirdPartyCookieRestriction, bool in_disableThirdPartyCookieMetadata, bool in_disableThirdPartyCookieHeuristics) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void LoadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText, std::optional<bool> canceled = {}, std::optional<String> blockedReason = {}, std::unique_ptr<protocol::Network::CorsErrorStatus> corsErrorStatus = {});
    void LoadingFinished(const String& requestId, double timestamp, double encodedDataLength);
    void RequestIntercepted(const String& interceptionId, std::unique_ptr<protocol::Network::Request> request, const String& frameId, const String& resourceType, bool isNavigationRequest, std::optional<bool> isDownload = {}, std::optional<String> redirectUrl = {}, std::unique_ptr<protocol::Network::AuthChallenge> authChallenge = {}, std::optional<String> responseErrorReason = {}, std::optional<int> responseStatusCode = {}, std::unique_ptr<protocol::Network::Headers> responseHeaders = {}, std::optional<String> requestId = {});
    void RequestWillBeSent(const String& requestId, const String& loaderId, const String& documentURL, std::unique_ptr<protocol::Network::Request> request, double timestamp, double wallTime, std::unique_ptr<protocol::Network::Initiator> initiator, bool redirectHasExtraInfo, std::unique_ptr<protocol::Network::Response> redirectResponse = {}, std::optional<String> type = {}, std::optional<String> frameId = {}, std::optional<bool> hasUserGesture = {});
    void SignedExchangeReceived(const String& requestId, std::unique_ptr<protocol::Network::SignedExchangeInfo> info);
    void ResponseReceived(const String& requestId, const String& loaderId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response, bool hasExtraInfo, std::optional<String> frameId = {});
    void RequestWillBeSentExtraInfo(const String& requestId, std::unique_ptr<protocol::Array<protocol::Network::AssociatedCookie>> associatedCookies, std::unique_ptr<protocol::Network::Headers> headers, std::unique_ptr<protocol::Network::ConnectTiming> connectTiming, std::unique_ptr<protocol::Network::ClientSecurityState> clientSecurityState = {}, std::optional<bool> siteHasCookieInOtherPartition = {});
    void ResponseReceivedExtraInfo(const String& requestId, std::unique_ptr<protocol::Array<protocol::Network::BlockedSetCookieWithReason>> blockedCookies, std::unique_ptr<protocol::Network::Headers> headers, const String& resourceIPAddressSpace, int statusCode, std::optional<String> headersText = {}, std::unique_ptr<protocol::Network::CookiePartitionKey> cookiePartitionKey = {}, std::optional<bool> cookiePartitionKeyOpaque = {}, std::unique_ptr<protocol::Array<protocol::Network::ExemptedSetCookieWithReason>> exemptedCookies = {});
    void ResponseReceivedEarlyHints(const String& requestId, std::unique_ptr<protocol::Network::Headers> headers);
    void TrustTokenOperationDone(const String& status, const String& type, const String& requestId, std::optional<String> topLevelOrigin = {}, std::optional<String> issuerOrigin = {}, std::optional<int> issuedTokenCount = {});
    void PolicyUpdated();
    void SubresourceWebBundleMetadataReceived(const String& requestId, std::unique_ptr<protocol::Array<String>> urls);
    void SubresourceWebBundleMetadataError(const String& requestId, const String& errorMessage);
    void SubresourceWebBundleInnerResponseParsed(const String& innerRequestId, const String& innerRequestURL, std::optional<String> bundleRequestId = {});
    void SubresourceWebBundleInnerResponseError(const String& innerRequestId, const String& innerRequestURL, const String& errorMessage, std::optional<String> bundleRequestId = {});
    void ReportingApiReportAdded(std::unique_ptr<protocol::Network::ReportingApiReport> report);
    void ReportingApiReportUpdated(std::unique_ptr<protocol::Network::ReportingApiReport> report);
    void ReportingApiEndpointsChangedForOrigin(const String& origin, std::unique_ptr<protocol::Array<protocol::Network::ReportingApiEndpoint>> endpoints);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Network
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Network_h)
