// content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_NETWORK_EVENTS_HANDLER_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_NETWORK_EVENTS_HANDLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "services/network/public/mojom/url_request.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"


namespace network { struct ResourceRequest; }


namespace auction_worklet::mojom {

class AuctionNetworkEventsHandlerProxy;

template <typename ImplRefTraits>
class AuctionNetworkEventsHandlerStub;

class AuctionNetworkEventsHandlerRequestValidator;


class CONTENT_EXPORT AuctionNetworkEventsHandler
    : public AuctionNetworkEventsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AuctionNetworkEventsHandlerInterfaceBase;
  using Proxy_ = AuctionNetworkEventsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = AuctionNetworkEventsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = AuctionNetworkEventsHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNetworkSendRequestMinVersion = 0,
    kOnNetworkResponseReceivedMinVersion = 0,
    kOnNetworkRequestCompleteMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNetworkSendRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkResponseReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkRequestComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AuctionNetworkEventsHandler() = default;

  
  virtual void OnNetworkSendRequest(const ::network::ResourceRequest& request, ::base::TimeTicks timestamp) = 0;
  // Default implementation for non-const ref params. This method can be
  // implemented as a performance optimization for non-const ref types.
  virtual void OnNetworkSendRequest(::network::ResourceRequest& request, ::base::TimeTicks timestamp) {
    OnNetworkSendRequest(const_cast<const ::network::ResourceRequest&>(request), std::move(timestamp));
  }

  
  virtual void OnNetworkResponseReceived(const std::string& request_id, const std::string& loader_id, const ::GURL& request_url, ::network::mojom::URLResponseHeadPtr headers) = 0;

  
  virtual void OnNetworkRequestComplete(const std::string& request_id, const ::network::URLLoaderCompletionStatus& status) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<AuctionNetworkEventsHandler> receiver) = 0;
};



class CONTENT_EXPORT AuctionNetworkEventsHandlerProxy
    : public AuctionNetworkEventsHandler {
 public:
  using InterfaceType = AuctionNetworkEventsHandler;

  explicit AuctionNetworkEventsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNetworkSendRequest(const ::network::ResourceRequest& request, ::base::TimeTicks timestamp) final;
  
  void OnNetworkResponseReceived(const std::string& request_id, const std::string& loader_id, const ::GURL& request_url, ::network::mojom::URLResponseHeadPtr headers) final;
  
  void OnNetworkRequestComplete(const std::string& request_id, const ::network::URLLoaderCompletionStatus& status) final;
  
  void Clone(::mojo::PendingReceiver<AuctionNetworkEventsHandler> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT AuctionNetworkEventsHandlerStubDispatch {
 public:
  static bool Accept(AuctionNetworkEventsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AuctionNetworkEventsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AuctionNetworkEventsHandler>>
class AuctionNetworkEventsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AuctionNetworkEventsHandlerStub() = default;
  ~AuctionNetworkEventsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuctionNetworkEventsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuctionNetworkEventsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT AuctionNetworkEventsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // auction_worklet::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_NETWORK_EVENTS_HANDLER_MOJOM_H_