// services/video_capture/public/mojom/video_source.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_SHARED_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/video_source.mojom-shared-internal.h"
#include "media/capture/mojom/image_capture.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/capture/mojom/video_effects_manager.mojom-shared.h"
#include "services/video_effects/public/mojom/video_effects_processor.mojom-shared.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace video_capture::mojom {
class CreatePushSubscriptionResultCodeDataView;


}  // video_capture::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::video_capture::mojom::CreatePushSubscriptionResultCodeDataView> {
  using Data = ::video_capture::mojom::internal::CreatePushSubscriptionResultCode_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace video_capture::mojom {


enum class CreatePushSubscriptionSuccessCode : int32_t {
  
  kCreatedWithRequestedSettings = 0,
  
  kCreatedWithDifferentSettings = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CreatePushSubscriptionSuccessCode value);
inline bool IsKnownEnumValue(CreatePushSubscriptionSuccessCode value) {
  return internal::CreatePushSubscriptionSuccessCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PushVideoStreamSubscriptionInterfaceBase {};

using PushVideoStreamSubscriptionPtrDataView =
    mojo::InterfacePtrDataView<PushVideoStreamSubscriptionInterfaceBase>;
using PushVideoStreamSubscriptionRequestDataView =
    mojo::InterfaceRequestDataView<PushVideoStreamSubscriptionInterfaceBase>;
using PushVideoStreamSubscriptionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PushVideoStreamSubscriptionInterfaceBase>;
using PushVideoStreamSubscriptionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PushVideoStreamSubscriptionInterfaceBase>;
class VideoSourceInterfaceBase {};

using VideoSourcePtrDataView =
    mojo::InterfacePtrDataView<VideoSourceInterfaceBase>;
using VideoSourceRequestDataView =
    mojo::InterfaceRequestDataView<VideoSourceInterfaceBase>;
using VideoSourceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoSourceInterfaceBase>;
using VideoSourceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoSourceInterfaceBase>;


class CreatePushSubscriptionResultCodeDataView {
 public:
  using Tag = internal::CreatePushSubscriptionResultCode_Data::CreatePushSubscriptionResultCode_Tag;

  CreatePushSubscriptionResultCodeDataView() = default;

  CreatePushSubscriptionResultCodeDataView(
      internal::CreatePushSubscriptionResultCode_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success_code() const { return data_->tag == Tag::kSuccessCode; }
  template <typename UserType>
  [[nodiscard]] bool ReadSuccessCode(UserType* output) const {
    CHECK(is_success_code());
    return mojo::internal::Deserialize<::video_capture::mojom::CreatePushSubscriptionSuccessCode>(
        data_->data.f_success_code, output);
  }
  CreatePushSubscriptionSuccessCode success_code() const {
    CHECK(is_success_code());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::video_capture::mojom::CreatePushSubscriptionSuccessCode>(data_->data.f_success_code));
  }
  bool is_error_code() const { return data_->tag == Tag::kErrorCode; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    CHECK(is_error_code());
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureError>(
        data_->data.f_error_code, output);
  }
  ::media::mojom::VideoCaptureError error_code() const {
    CHECK(is_error_code());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureError>(data_->data.f_error_code));
  }

 private:
  internal::CreatePushSubscriptionResultCode_Data* data_ = nullptr;
};



}  // video_capture::mojom

namespace std {

template <>
struct hash<::video_capture::mojom::CreatePushSubscriptionSuccessCode>
    : public mojo::internal::EnumHashImpl<::video_capture::mojom::CreatePushSubscriptionSuccessCode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::video_capture::mojom::CreatePushSubscriptionSuccessCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::video_capture::mojom::CreatePushSubscriptionSuccessCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::video_capture::mojom::CreatePushSubscriptionSuccessCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::video_capture::mojom::CreatePushSubscriptionResultCodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::video_capture::mojom::CreatePushSubscriptionResultCodeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::video_capture::mojom::internal::CreatePushSubscriptionResultCode_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::video_capture::mojom::CreatePushSubscriptionResultCodeDataView::Tag::kSuccessCode: {
        decltype(Traits::success_code(input))
            in_success_code = Traits::success_code(input);
        mojo::internal::Serialize<::video_capture::mojom::CreatePushSubscriptionSuccessCode>(
            in_success_code, &fragment->data.f_success_code);
        break;
      }
      case ::video_capture::mojom::CreatePushSubscriptionResultCodeDataView::Tag::kErrorCode: {
        decltype(Traits::error_code(input))
            in_error_code = Traits::error_code(input);
        mojo::internal::Serialize<::media::mojom::VideoCaptureError>(
            in_error_code, &fragment->data.f_error_code);
        break;
      }
    }
  }

  static bool Deserialize(::video_capture::mojom::internal::CreatePushSubscriptionResultCode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::video_capture::mojom::CreatePushSubscriptionResultCodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace video_capture::mojom {



}  // video_capture::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::video_capture::mojom::CreatePushSubscriptionSuccessCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::video_capture::mojom::CreatePushSubscriptionSuccessCode value);
};

} // namespace perfetto

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_SHARED_H_