// services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* ContentFrameIntervalTypeToStringHelper(ContentFrameIntervalType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentFrameIntervalType::kVideo:
      return "kVideo";
    case ContentFrameIntervalType::kAnimatingImage:
      return "kAnimatingImage";
    case ContentFrameIntervalType::kScrollBarFadeOutAnimation:
      return "kScrollBarFadeOutAnimation";
    default:
      return nullptr;
  }
}

std::string ContentFrameIntervalTypeToString(ContentFrameIntervalType value) {
  const char *str = ContentFrameIntervalTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentFrameIntervalType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentFrameIntervalType value) {
  return os << ContentFrameIntervalTypeToString(value);
}

namespace internal {


// static
bool ContentFrameIntervalInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentFrameIntervalInfo_Data* object =
      static_cast<const ContentFrameIntervalInfo_Data*>(data);


  if (!::viz::mojom::internal::ContentFrameIntervalType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_interval, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_interval, validation_context))
    return false;

  return true;
}

ContentFrameIntervalInfo_Data::ContentFrameIntervalInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameIntervalInputs_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameIntervalInputs_Data* object =
      static_cast<const FrameIntervalInputs_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_interval_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_interval_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_interval_info, validation_context,
                                         &content_interval_info_validate_params)) {
    return false;
  }

  return true;
}

FrameIntervalInputs_Data::FrameIntervalInputs_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ContentFrameIntervalType>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::ContentFrameIntervalType value) {
  return std::move(context).WriteString(::viz::mojom::ContentFrameIntervalTypeToString(value));
}

} // namespace perfetto