// third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANDROID_FONT_LOOKUP_ANDROID_FONT_LOOKUP_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANDROID_FONT_LOOKUP_ANDROID_FONT_LOOKUP_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/android_font_lookup/android_font_lookup.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class AndroidFontLookupProxy;

template <typename ImplRefTraits>
class AndroidFontLookupStub;

class AndroidFontLookupRequestValidator;
class AndroidFontLookupResponseValidator;


class BLINK_COMMON_EXPORT AndroidFontLookup
    : public AndroidFontLookupInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AndroidFontLookupInterfaceBase;
  using Proxy_ = AndroidFontLookupProxy;

  template <typename ImplRefTraits>
  using Stub_ = AndroidFontLookupStub<ImplRefTraits>;

  using RequestValidator_ = AndroidFontLookupRequestValidator;
  using ResponseValidator_ = AndroidFontLookupResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetUniqueNameLookupTableMinVersion = 0,
    kMatchLocalFontByUniqueNameMinVersion = 0,
    kFetchAllFontFilesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetUniqueNameLookupTable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MatchLocalFontByUniqueName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FetchAllFontFiles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AndroidFontLookup() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetUniqueNameLookupTable(std::vector<std::string>* out_unique_font_names);

  using GetUniqueNameLookupTableCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  
  virtual void GetUniqueNameLookupTable(GetUniqueNameLookupTableCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MatchLocalFontByUniqueName(const std::string& font_unique_name, ::base::File* out_font_file_handle);

  using MatchLocalFontByUniqueNameCallback = base::OnceCallback<void(::base::File)>;
  
  virtual void MatchLocalFontByUniqueName(const std::string& font_unique_name, MatchLocalFontByUniqueNameCallback callback) = 0;


  using FetchAllFontFilesCallback = base::OnceCallback<void(base::flat_map<std::string, ::base::File>)>;
  
  virtual void FetchAllFontFiles(FetchAllFontFilesCallback callback) = 0;
};



class BLINK_COMMON_EXPORT AndroidFontLookupProxy
    : public AndroidFontLookup {
 public:
  using InterfaceType = AndroidFontLookup;

  explicit AndroidFontLookupProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetUniqueNameLookupTable(std::vector<std::string>* out_unique_font_names) final;
  
  void GetUniqueNameLookupTable(GetUniqueNameLookupTableCallback callback) final;
  
  bool MatchLocalFontByUniqueName(const std::string& font_unique_name, ::base::File* out_font_file_handle) final;
  
  void MatchLocalFontByUniqueName(const std::string& font_unique_name, MatchLocalFontByUniqueNameCallback callback) final;
  
  void FetchAllFontFiles(FetchAllFontFilesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT AndroidFontLookupStubDispatch {
 public:
  static bool Accept(AndroidFontLookup* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AndroidFontLookup* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AndroidFontLookup>>
class AndroidFontLookupStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AndroidFontLookupStub() = default;
  ~AndroidFontLookupStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AndroidFontLookupStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AndroidFontLookupStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT AndroidFontLookupRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT AndroidFontLookupResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANDROID_FONT_LOOKUP_ANDROID_FONT_LOOKUP_MOJOM_H_