// third_party/blink/public/mojom/frame/policy_container.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/policy_container.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class PolicyContainerHostProxy;

template <typename ImplRefTraits>
class PolicyContainerHostStub;

class PolicyContainerHostRequestValidator;


class BLINK_COMMON_EXPORT PolicyContainerHost
    : public PolicyContainerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PolicyContainerHostInterfaceBase;
  using Proxy_ = PolicyContainerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PolicyContainerHostStub<ImplRefTraits>;

  using RequestValidator_ = PolicyContainerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetReferrerPolicyMinVersion = 0,
    kAddContentSecurityPoliciesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetReferrerPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddContentSecurityPolicies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PolicyContainerHost() = default;

  
  virtual void SetReferrerPolicy(::network::mojom::ReferrerPolicy referrer_policy) = 0;

  
  virtual void AddContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policies) = 0;
};



class BLINK_COMMON_EXPORT PolicyContainerHostProxy
    : public PolicyContainerHost {
 public:
  using InterfaceType = PolicyContainerHost;

  explicit PolicyContainerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetReferrerPolicy(::network::mojom::ReferrerPolicy referrer_policy) final;
  
  void AddContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policies) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT PolicyContainerHostStubDispatch {
 public:
  static bool Accept(PolicyContainerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PolicyContainerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PolicyContainerHost>>
class PolicyContainerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PolicyContainerHostStub() = default;
  ~PolicyContainerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PolicyContainerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PolicyContainerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PolicyContainerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class BLINK_COMMON_EXPORT PolicyContainerPolicies {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PolicyContainerPolicies, T>::value>;
  using DataView = PolicyContainerPoliciesDataView;
  using Data_ = internal::PolicyContainerPolicies_Data;

  template <typename... Args>
  static PolicyContainerPoliciesPtr New(Args&&... args) {
    return PolicyContainerPoliciesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PolicyContainerPoliciesPtr From(const U& u) {
    return mojo::TypeConverter<PolicyContainerPoliciesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PolicyContainerPolicies>::Convert(*this);
  }


  PolicyContainerPolicies();

  PolicyContainerPolicies(
      const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy,
      ::network::mojom::ReferrerPolicy referrer_policy,
      std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policies,
      bool is_credentialless,
      ::network::mojom::WebSandboxFlags sandbox_flags,
      ::network::mojom::IPAddressSpace ip_address_space,
      bool can_navigate_top_without_user_gesture,
      bool allow_cross_origin_isolation);

PolicyContainerPolicies(const PolicyContainerPolicies&) = delete;
PolicyContainerPolicies& operator=(const PolicyContainerPolicies&) = delete;

  ~PolicyContainerPolicies();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PolicyContainerPoliciesPtr>
  PolicyContainerPoliciesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PolicyContainerPolicies::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PolicyContainerPolicies::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PolicyContainerPolicies_UnserializedMessageContext<
            UserType, PolicyContainerPolicies::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PolicyContainerPolicies::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PolicyContainerPolicies::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PolicyContainerPolicies_UnserializedMessageContext<
            UserType, PolicyContainerPolicies::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PolicyContainerPolicies::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::CrossOriginEmbedderPolicy cross_origin_embedder_policy;
  
  ::network::mojom::ReferrerPolicy referrer_policy;
  
  std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policies;
  
  bool is_credentialless;
  
  ::network::mojom::WebSandboxFlags sandbox_flags;
  
  ::network::mojom::IPAddressSpace ip_address_space;
  
  bool can_navigate_top_without_user_gesture;
  
  bool allow_cross_origin_isolation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PolicyContainer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PolicyContainer, T>::value>;
  using DataView = PolicyContainerDataView;
  using Data_ = internal::PolicyContainer_Data;

  template <typename... Args>
  static PolicyContainerPtr New(Args&&... args) {
    return PolicyContainerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PolicyContainerPtr From(const U& u) {
    return mojo::TypeConverter<PolicyContainerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PolicyContainer>::Convert(*this);
  }


  PolicyContainer();

  PolicyContainer(
      PolicyContainerPoliciesPtr policies,
      ::mojo::PendingAssociatedRemote<PolicyContainerHost> remote);

PolicyContainer(const PolicyContainer&) = delete;
PolicyContainer& operator=(const PolicyContainer&) = delete;

  ~PolicyContainer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PolicyContainerPtr>
  PolicyContainerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PolicyContainer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PolicyContainer_UnserializedMessageContext<
            UserType, PolicyContainer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PolicyContainer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PolicyContainer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PolicyContainer_UnserializedMessageContext<
            UserType, PolicyContainer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PolicyContainer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PolicyContainerPoliciesPtr policies;
  
  ::mojo::PendingAssociatedRemote<PolicyContainerHost> remote;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PolicyContainerBindParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PolicyContainerBindParams, T>::value>;
  using DataView = PolicyContainerBindParamsDataView;
  using Data_ = internal::PolicyContainerBindParams_Data;

  template <typename... Args>
  static PolicyContainerBindParamsPtr New(Args&&... args) {
    return PolicyContainerBindParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PolicyContainerBindParamsPtr From(const U& u) {
    return mojo::TypeConverter<PolicyContainerBindParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PolicyContainerBindParams>::Convert(*this);
  }


  PolicyContainerBindParams();

  explicit PolicyContainerBindParams(
      ::mojo::PendingAssociatedReceiver<PolicyContainerHost> receiver);

PolicyContainerBindParams(const PolicyContainerBindParams&) = delete;
PolicyContainerBindParams& operator=(const PolicyContainerBindParams&) = delete;

  ~PolicyContainerBindParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PolicyContainerBindParamsPtr>
  PolicyContainerBindParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PolicyContainerBindParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PolicyContainerBindParams_UnserializedMessageContext<
            UserType, PolicyContainerBindParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PolicyContainerBindParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PolicyContainerBindParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PolicyContainerBindParams_UnserializedMessageContext<
            UserType, PolicyContainerBindParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PolicyContainerBindParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedReceiver<PolicyContainerHost> receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PolicyContainerPoliciesPtr PolicyContainerPolicies::Clone() const {
  return New(
      mojo::Clone(cross_origin_embedder_policy),
      mojo::Clone(referrer_policy),
      mojo::Clone(content_security_policies),
      mojo::Clone(is_credentialless),
      mojo::Clone(sandbox_flags),
      mojo::Clone(ip_address_space),
      mojo::Clone(can_navigate_top_without_user_gesture),
      mojo::Clone(allow_cross_origin_isolation)
  );
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>*>
bool PolicyContainerPolicies::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cross_origin_embedder_policy, other_struct.cross_origin_embedder_policy))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->content_security_policies, other_struct.content_security_policies))
    return false;
  if (!mojo::Equals(this->is_credentialless, other_struct.is_credentialless))
    return false;
  if (!mojo::Equals(this->sandbox_flags, other_struct.sandbox_flags))
    return false;
  if (!mojo::Equals(this->ip_address_space, other_struct.ip_address_space))
    return false;
  if (!mojo::Equals(this->can_navigate_top_without_user_gesture, other_struct.can_navigate_top_without_user_gesture))
    return false;
  if (!mojo::Equals(this->allow_cross_origin_isolation, other_struct.allow_cross_origin_isolation))
    return false;
  return true;
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cross_origin_embedder_policy < rhs.cross_origin_embedder_policy)
    return true;
  if (rhs.cross_origin_embedder_policy < lhs.cross_origin_embedder_policy)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.content_security_policies < rhs.content_security_policies)
    return true;
  if (rhs.content_security_policies < lhs.content_security_policies)
    return false;
  if (lhs.is_credentialless < rhs.is_credentialless)
    return true;
  if (rhs.is_credentialless < lhs.is_credentialless)
    return false;
  if (lhs.sandbox_flags < rhs.sandbox_flags)
    return true;
  if (rhs.sandbox_flags < lhs.sandbox_flags)
    return false;
  if (lhs.ip_address_space < rhs.ip_address_space)
    return true;
  if (rhs.ip_address_space < lhs.ip_address_space)
    return false;
  if (lhs.can_navigate_top_without_user_gesture < rhs.can_navigate_top_without_user_gesture)
    return true;
  if (rhs.can_navigate_top_without_user_gesture < lhs.can_navigate_top_without_user_gesture)
    return false;
  if (lhs.allow_cross_origin_isolation < rhs.allow_cross_origin_isolation)
    return true;
  if (rhs.allow_cross_origin_isolation < lhs.allow_cross_origin_isolation)
    return false;
  return false;
}
template <typename StructPtrType>
PolicyContainerPtr PolicyContainer::Clone() const {
  return New(
      mojo::Clone(policies),
      mojo::Clone(remote)
  );
}

template <typename T, PolicyContainer::EnableIfSame<T>*>
bool PolicyContainer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->policies, other_struct.policies))
    return false;
  if (!mojo::Equals(this->remote, other_struct.remote))
    return false;
  return true;
}

template <typename T, PolicyContainer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.policies < rhs.policies)
    return true;
  if (rhs.policies < lhs.policies)
    return false;
  if (lhs.remote < rhs.remote)
    return true;
  if (rhs.remote < lhs.remote)
    return false;
  return false;
}
template <typename StructPtrType>
PolicyContainerBindParamsPtr PolicyContainerBindParams::Clone() const {
  return New(
      mojo::Clone(receiver)
  );
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>*>
bool PolicyContainerBindParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  return true;
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PolicyContainerPolicies::DataView,
                                         ::blink::mojom::PolicyContainerPoliciesPtr> {
  static bool IsNull(const ::blink::mojom::PolicyContainerPoliciesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PolicyContainerPoliciesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PolicyContainerPolicies::cross_origin_embedder_policy)& cross_origin_embedder_policy(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->cross_origin_embedder_policy;
  }

  static decltype(::blink::mojom::PolicyContainerPolicies::referrer_policy) referrer_policy(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::blink::mojom::PolicyContainerPolicies::content_security_policies)& content_security_policies(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->content_security_policies;
  }

  static decltype(::blink::mojom::PolicyContainerPolicies::is_credentialless) is_credentialless(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->is_credentialless;
  }

  static decltype(::blink::mojom::PolicyContainerPolicies::sandbox_flags) sandbox_flags(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->sandbox_flags;
  }

  static decltype(::blink::mojom::PolicyContainerPolicies::ip_address_space) ip_address_space(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->ip_address_space;
  }

  static decltype(::blink::mojom::PolicyContainerPolicies::can_navigate_top_without_user_gesture) can_navigate_top_without_user_gesture(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->can_navigate_top_without_user_gesture;
  }

  static decltype(::blink::mojom::PolicyContainerPolicies::allow_cross_origin_isolation) allow_cross_origin_isolation(
      const ::blink::mojom::PolicyContainerPoliciesPtr& input) {
    return input->allow_cross_origin_isolation;
  }

  static bool Read(::blink::mojom::PolicyContainerPolicies::DataView input, ::blink::mojom::PolicyContainerPoliciesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PolicyContainer::DataView,
                                         ::blink::mojom::PolicyContainerPtr> {
  static bool IsNull(const ::blink::mojom::PolicyContainerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PolicyContainerPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PolicyContainer::policies)& policies(
      const ::blink::mojom::PolicyContainerPtr& input) {
    return input->policies;
  }

  static  decltype(::blink::mojom::PolicyContainer::remote)& remote(
       ::blink::mojom::PolicyContainerPtr& input) {
    return input->remote;
  }

  static bool Read(::blink::mojom::PolicyContainer::DataView input, ::blink::mojom::PolicyContainerPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PolicyContainerBindParams::DataView,
                                         ::blink::mojom::PolicyContainerBindParamsPtr> {
  static bool IsNull(const ::blink::mojom::PolicyContainerBindParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PolicyContainerBindParamsPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::PolicyContainerBindParams::receiver)& receiver(
       ::blink::mojom::PolicyContainerBindParamsPtr& input) {
    return input->receiver;
  }

  static bool Read(::blink::mojom::PolicyContainerBindParams::DataView input, ::blink::mojom::PolicyContainerBindParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_H_