// ui/display/mojom/screen_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_H_
#define UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/screen_info.mojom-features.h"  // IWYU pragma: export
#include "ui/display/mojom/screen_info.mojom-shared.h"  // IWYU pragma: export
#include "ui/display/mojom/screen_info.mojom-forward.h"  // IWYU pragma: export
#include "ui/display/mojom/screen_orientation.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/display_color_spaces.mojom.h"
#include <string>
#include <vector>




#include "ui/display/mojom/screen_info_mojom_traits.h"




namespace display::mojom {








class  ScreenInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScreenInfo, T>::value>;
  using DataView = ScreenInfoDataView;
  using Data_ = internal::ScreenInfo_Data;

  template <typename... Args>
  static ScreenInfoPtr New(Args&&... args) {
    return ScreenInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScreenInfoPtr From(const U& u) {
    return mojo::TypeConverter<ScreenInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScreenInfo>::Convert(*this);
  }


  ScreenInfo();

  ScreenInfo(
      float device_scale_factor,
      const ::gfx::DisplayColorSpaces& display_color_spaces,
      uint32_t depth,
      uint32_t depth_per_component,
      bool is_monochrome,
      const ::gfx::Rect& rect,
      const ::gfx::Rect& available_rect,
      ::display::mojom::ScreenOrientation orientation_type,
      uint16_t orientation_angle,
      bool is_extended,
      bool is_primary,
      bool is_internal,
      const std::string& label,
      int64_t display_id);


  ~ScreenInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScreenInfoPtr>
  ScreenInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScreenInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScreenInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScreenInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScreenInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScreenInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScreenInfo_UnserializedMessageContext<
            UserType, ScreenInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScreenInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScreenInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScreenInfo_UnserializedMessageContext<
            UserType, ScreenInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScreenInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float device_scale_factor;
  
  ::gfx::DisplayColorSpaces display_color_spaces;
  
  uint32_t depth;
  
  uint32_t depth_per_component;
  
  bool is_monochrome;
  
  ::gfx::Rect rect;
  
  ::gfx::Rect available_rect;
  
  ::display::mojom::ScreenOrientation orientation_type;
  
  uint16_t orientation_angle;
  
  bool is_extended;
  
  bool is_primary;
  
  bool is_internal;
  
  std::string label;
  
  int64_t display_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScreenInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScreenInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScreenInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScreenInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ScreenInfoPtr ScreenInfo::Clone() const {
  return New(
      mojo::Clone(device_scale_factor),
      mojo::Clone(display_color_spaces),
      mojo::Clone(depth),
      mojo::Clone(depth_per_component),
      mojo::Clone(is_monochrome),
      mojo::Clone(rect),
      mojo::Clone(available_rect),
      mojo::Clone(orientation_type),
      mojo::Clone(orientation_angle),
      mojo::Clone(is_extended),
      mojo::Clone(is_primary),
      mojo::Clone(is_internal),
      mojo::Clone(label),
      mojo::Clone(display_id)
  );
}

template <typename T, ScreenInfo::EnableIfSame<T>*>
bool ScreenInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->display_color_spaces, other_struct.display_color_spaces))
    return false;
  if (!mojo::Equals(this->depth, other_struct.depth))
    return false;
  if (!mojo::Equals(this->depth_per_component, other_struct.depth_per_component))
    return false;
  if (!mojo::Equals(this->is_monochrome, other_struct.is_monochrome))
    return false;
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->available_rect, other_struct.available_rect))
    return false;
  if (!mojo::Equals(this->orientation_type, other_struct.orientation_type))
    return false;
  if (!mojo::Equals(this->orientation_angle, other_struct.orientation_angle))
    return false;
  if (!mojo::Equals(this->is_extended, other_struct.is_extended))
    return false;
  if (!mojo::Equals(this->is_primary, other_struct.is_primary))
    return false;
  if (!mojo::Equals(this->is_internal, other_struct.is_internal))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->display_id, other_struct.display_id))
    return false;
  return true;
}

template <typename T, ScreenInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.display_color_spaces < rhs.display_color_spaces)
    return true;
  if (rhs.display_color_spaces < lhs.display_color_spaces)
    return false;
  if (lhs.depth < rhs.depth)
    return true;
  if (rhs.depth < lhs.depth)
    return false;
  if (lhs.depth_per_component < rhs.depth_per_component)
    return true;
  if (rhs.depth_per_component < lhs.depth_per_component)
    return false;
  if (lhs.is_monochrome < rhs.is_monochrome)
    return true;
  if (rhs.is_monochrome < lhs.is_monochrome)
    return false;
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  if (lhs.available_rect < rhs.available_rect)
    return true;
  if (rhs.available_rect < lhs.available_rect)
    return false;
  if (lhs.orientation_type < rhs.orientation_type)
    return true;
  if (rhs.orientation_type < lhs.orientation_type)
    return false;
  if (lhs.orientation_angle < rhs.orientation_angle)
    return true;
  if (rhs.orientation_angle < lhs.orientation_angle)
    return false;
  if (lhs.is_extended < rhs.is_extended)
    return true;
  if (rhs.is_extended < lhs.is_extended)
    return false;
  if (lhs.is_primary < rhs.is_primary)
    return true;
  if (rhs.is_primary < lhs.is_primary)
    return false;
  if (lhs.is_internal < rhs.is_internal)
    return true;
  if (rhs.is_internal < lhs.is_internal)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.display_id < rhs.display_id)
    return true;
  if (rhs.display_id < lhs.display_id)
    return false;
  return false;
}


}  // display::mojom

namespace mojo {


template <>
struct  StructTraits<::display::mojom::ScreenInfo::DataView,
                                         ::display::mojom::ScreenInfoPtr> {
  static bool IsNull(const ::display::mojom::ScreenInfoPtr& input) { return !input; }
  static void SetToNull(::display::mojom::ScreenInfoPtr* output) { output->reset(); }

  static decltype(::display::mojom::ScreenInfo::device_scale_factor) device_scale_factor(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->device_scale_factor;
  }

  static const decltype(::display::mojom::ScreenInfo::display_color_spaces)& display_color_spaces(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->display_color_spaces;
  }

  static decltype(::display::mojom::ScreenInfo::depth) depth(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->depth;
  }

  static decltype(::display::mojom::ScreenInfo::depth_per_component) depth_per_component(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->depth_per_component;
  }

  static decltype(::display::mojom::ScreenInfo::is_monochrome) is_monochrome(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->is_monochrome;
  }

  static const decltype(::display::mojom::ScreenInfo::rect)& rect(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->rect;
  }

  static const decltype(::display::mojom::ScreenInfo::available_rect)& available_rect(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->available_rect;
  }

  static decltype(::display::mojom::ScreenInfo::orientation_type) orientation_type(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->orientation_type;
  }

  static decltype(::display::mojom::ScreenInfo::orientation_angle) orientation_angle(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->orientation_angle;
  }

  static decltype(::display::mojom::ScreenInfo::is_extended) is_extended(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->is_extended;
  }

  static decltype(::display::mojom::ScreenInfo::is_primary) is_primary(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->is_primary;
  }

  static decltype(::display::mojom::ScreenInfo::is_internal) is_internal(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->is_internal;
  }

  static const decltype(::display::mojom::ScreenInfo::label)& label(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->label;
  }

  static decltype(::display::mojom::ScreenInfo::display_id) display_id(
      const ::display::mojom::ScreenInfoPtr& input) {
    return input->display_id;
  }

  static bool Read(::display::mojom::ScreenInfo::DataView input, ::display::mojom::ScreenInfoPtr* output);
};

}  // namespace mojo

#endif  // UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_H_