// GENERATED FILE - DO NOT EDIT.
// Generated by gen_spirv_builder_and_parser.py using data from spirv.core.grammar.json.
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// spirv_instruction_builder_autogen.cpp:
//   Functions to generate SPIR-V binary for each instruction.

#include "spirv_instruction_builder_autogen.h"

#include <string.h>

#include "common/debug.h"

namespace angle
{
namespace spirv
{
namespace
{
uint32_t MakeLengthOp(size_t length, spv::Op op)
{
    ASSERT(length <= 0xFFFFu);
    ASSERT(op <= 0xFFFFu);

    // It's easy for a complex shader to be crafted to hit the length limit,
    // turn that into a crash instead of a security bug.  Ideally, the compiler
    // would gracefully fail compilation, so this is more of a safety net.
    if (ANGLE_UNLIKELY(length > 0xFFFFu))
    {
        ERR() << "Complex shader not representible in SPIR-V";
        ANGLE_CRASH();
    }

    return static_cast<uint32_t>(length) << 16 | op;
}
}  // anonymous namespace

void WriteSpirvHeader(std::vector<uint32_t> *blob, uint32_t version, uint32_t idCount)
{
    // Header:
    //
    //  - Magic number
    //  - Version (1.X)
    //  - ANGLE's Generator number:
    //     * 24 for tool id (higher 16 bits)
    //     * 1 for tool version (lower 16 bits))
    //  - Bound (idCount)
    //  - 0 (reserved)
    constexpr uint32_t kANGLEGeneratorId      = 24;
    constexpr uint32_t kANGLEGeneratorVersion = 1;

    ASSERT(blob->empty());

    blob->push_back(spv::MagicNumber);
    blob->push_back(version);
    blob->push_back(kANGLEGeneratorId << 16 | kANGLEGeneratorVersion);
    blob->push_back(idCount);
    blob->push_back(0x00000000);
}

void WriteNop(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpNop);
}
void WriteUndef(Blob *blob, IdResultType idResultType1, IdResult idResult2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUndef);
}
void WriteSourceContinued(Blob *blob, LiteralString continuedSource)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(continuedSource) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), continuedSource);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSourceContinued);
}
void WriteSource(Blob *blob,
                 spv::SourceLanguage sourceLanguage1,
                 LiteralInteger version,
                 const IdRef *file,
                 const LiteralString *source)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(sourceLanguage1);
    blob->push_back(version);
    if (file)
    {
        blob->push_back(*file);
    }
    if (source)
    {
        {
            size_t d = blob->size();
            blob->resize(d + strlen(*source) / 4 + 1, 0);
            ASSERT(IsLittleEndian());
            strcpy(reinterpret_cast<char *>(blob->data() + d), *source);
        }
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSource);
}
void WriteSourceExtension(Blob *blob, LiteralString extension)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(extension) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), extension);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSourceExtension);
}
void WriteName(Blob *blob, IdRef target, LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(target);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpName);
}
void WriteMemberName(Blob *blob, IdRef type, LiteralInteger member, LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(type);
    blob->push_back(member);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemberName);
}
void WriteString(Blob *blob, IdResult idResult1, LiteralString string)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(string) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), string);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpString);
}
void WriteLine(Blob *blob, IdRef file, LiteralInteger line, LiteralInteger column)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(file);
    blob->push_back(line);
    blob->push_back(column);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLine);
}
void WriteExtension(Blob *blob, LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExtension);
}
void WriteExtInstImport(Blob *blob, IdResult idResult1, LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExtInstImport);
}
void WriteExtInst(Blob *blob,
                  IdResultType idResultType1,
                  IdResult idResult2,
                  IdRef set,
                  LiteralExtInstInteger instruction,
                  const IdRefList &operandList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(set);
    blob->push_back(instruction);
    for (const auto &operand : operandList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExtInst);
}
void WriteMemoryModel(Blob *blob,
                      spv::AddressingModel addressingModel1,
                      spv::MemoryModel memoryModel2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(addressingModel1);
    blob->push_back(memoryModel2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemoryModel);
}
void WriteEntryPoint(Blob *blob,
                     spv::ExecutionModel executionModel1,
                     IdRef entryPoint,
                     LiteralString name,
                     const IdRefList &interfaceList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(executionModel1);
    blob->push_back(entryPoint);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    for (const auto &operand : interfaceList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEntryPoint);
}
void WriteExecutionMode(Blob *blob,
                        IdRef entryPoint,
                        spv::ExecutionMode mode,
                        const LiteralIntegerList &operandsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(entryPoint);
    blob->push_back(mode);
    for (const auto &operand : operandsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExecutionMode);
}
void WriteCapability(Blob *blob, spv::Capability capability)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(capability);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCapability);
}
void WriteTypeVoid(Blob *blob, IdResult idResult1)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeVoid);
}
void WriteTypeBool(Blob *blob, IdResult idResult1)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeBool);
}
void WriteTypeInt(Blob *blob, IdResult idResult1, LiteralInteger width, LiteralInteger signedness)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(width);
    blob->push_back(signedness);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeInt);
}
void WriteTypeFloat(Blob *blob,
                    IdResult idResult1,
                    LiteralInteger width,
                    const spv::FPEncoding *floatingPointEncoding)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(width);
    if (floatingPointEncoding)
    {
        blob->push_back(*floatingPointEncoding);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeFloat);
}
void WriteTypeVector(Blob *blob,
                     IdResult idResult1,
                     IdRef componentType,
                     LiteralInteger componentCount)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(componentType);
    blob->push_back(componentCount);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeVector);
}
void WriteTypeMatrix(Blob *blob, IdResult idResult1, IdRef columnType, LiteralInteger columnCount)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(columnType);
    blob->push_back(columnCount);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeMatrix);
}
void WriteTypeImage(Blob *blob,
                    IdResult idResult1,
                    IdRef sampledType,
                    spv::Dim dim3,
                    LiteralInteger depth,
                    LiteralInteger arrayed,
                    LiteralInteger mS,
                    LiteralInteger sampled,
                    spv::ImageFormat imageFormat8,
                    const spv::AccessQualifier *accessQualifier9)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(sampledType);
    blob->push_back(dim3);
    blob->push_back(depth);
    blob->push_back(arrayed);
    blob->push_back(mS);
    blob->push_back(sampled);
    blob->push_back(imageFormat8);
    if (accessQualifier9)
    {
        blob->push_back(*accessQualifier9);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeImage);
}
void WriteTypeSampler(Blob *blob, IdResult idResult1)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeSampler);
}
void WriteTypeSampledImage(Blob *blob, IdResult idResult1, IdRef imageType)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(imageType);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeSampledImage);
}
void WriteTypeArray(Blob *blob, IdResult idResult1, IdRef elementType, IdRef length)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(elementType);
    blob->push_back(length);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeArray);
}
void WriteTypeRuntimeArray(Blob *blob, IdResult idResult1, IdRef elementType)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(elementType);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeRuntimeArray);
}
void WriteTypeStruct(Blob *blob, IdResult idResult1, const IdRefList &memberList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    for (const auto &operand : memberList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeStruct);
}
void WriteTypePointer(Blob *blob, IdResult idResult1, spv::StorageClass storageClass2, IdRef type)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(storageClass2);
    blob->push_back(type);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypePointer);
}
void WriteTypeFunction(Blob *blob,
                       IdResult idResult1,
                       IdRef returnType,
                       const IdRefList &parameterList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    blob->push_back(returnType);
    for (const auto &operand : parameterList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeFunction);
}
void WriteConstantTrue(Blob *blob, IdResultType idResultType1, IdResult idResult2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantTrue);
}
void WriteConstantFalse(Blob *blob, IdResultType idResultType1, IdResult idResult2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantFalse);
}
void WriteConstant(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   LiteralContextDependentNumber value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstant);
}
void WriteConstantComposite(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            const IdRefList &constituentsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    for (const auto &operand : constituentsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantComposite);
}
void WriteConstantNull(Blob *blob, IdResultType idResultType1, IdResult idResult2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantNull);
}
void WriteSpecConstantTrue(Blob *blob, IdResultType idResultType1, IdResult idResult2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstantTrue);
}
void WriteSpecConstantFalse(Blob *blob, IdResultType idResultType1, IdResult idResult2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstantFalse);
}
void WriteSpecConstant(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       LiteralContextDependentNumber value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstant);
}
void WriteSpecConstantComposite(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                const IdRefList &constituentsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    for (const auto &operand : constituentsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstantComposite);
}
void WriteFunction(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   spv::FunctionControlMask functionControl3,
                   IdRef functionType)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(functionControl3);
    blob->push_back(functionType);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunction);
}
void WriteFunctionParameter(Blob *blob, IdResultType idResultType1, IdResult idResult2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunctionParameter);
}
void WriteFunctionEnd(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunctionEnd);
}
void WriteFunctionCall(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef function,
                       const IdRefList &argumentList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(function);
    for (const auto &operand : argumentList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunctionCall);
}
void WriteVariable(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   spv::StorageClass storageClass3,
                   const IdRef *initializer)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(storageClass3);
    if (initializer)
    {
        blob->push_back(*initializer);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVariable);
}
void WriteImageTexelPointer(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef image,
                            IdRef coordinate,
                            IdRef sample)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    blob->push_back(coordinate);
    blob->push_back(sample);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageTexelPointer);
}
void WriteLoad(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef pointer,
               const spv::MemoryAccessMask *memoryAccess4)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    if (memoryAccess4)
    {
        blob->push_back(*memoryAccess4);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLoad);
}
void WriteStore(Blob *blob, IdRef pointer, IdRef object, const spv::MemoryAccessMask *memoryAccess3)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(pointer);
    blob->push_back(object);
    if (memoryAccess3)
    {
        blob->push_back(*memoryAccess3);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpStore);
}
void WriteCopyMemory(Blob *blob,
                     IdRef target,
                     IdRef source,
                     const spv::MemoryAccessMask *memoryAccess3,
                     const spv::MemoryAccessMask *memoryAccess4)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(target);
    blob->push_back(source);
    if (memoryAccess3)
    {
        blob->push_back(*memoryAccess3);
    }
    if (memoryAccess4)
    {
        blob->push_back(*memoryAccess4);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCopyMemory);
}
void WriteAccessChain(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef base,
                      const IdRefList &indexesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    for (const auto &operand : indexesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAccessChain);
}
void WriteInBoundsAccessChain(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdRef base,
                              const IdRefList &indexesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    for (const auto &operand : indexesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpInBoundsAccessChain);
}
void WriteArrayLength(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef structure,
                      LiteralInteger arraymember)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(structure);
    blob->push_back(arraymember);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpArrayLength);
}
void WriteDecorate(Blob *blob,
                   IdRef target,
                   spv::Decoration decoration2,
                   const LiteralIntegerList &valuesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(target);
    blob->push_back(decoration2);
    for (const auto &operand : valuesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDecorate);
}
void WriteMemberDecorate(Blob *blob,
                         IdRef structureType,
                         LiteralInteger member,
                         spv::Decoration decoration3,
                         const LiteralIntegerList &valuesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(structureType);
    blob->push_back(member);
    blob->push_back(decoration3);
    for (const auto &operand : valuesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemberDecorate);
}
void WriteDecorationGroup(Blob *blob, IdResult idResult1)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDecorationGroup);
}
void WriteGroupDecorate(Blob *blob, IdRef decorationGroup, const IdRefList &targetsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(decorationGroup);
    for (const auto &operand : targetsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupDecorate);
}
void WriteGroupMemberDecorate(Blob *blob,
                              IdRef decorationGroup,
                              const PairIdRefLiteralIntegerList &targetsPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(decorationGroup);
    for (const auto &operand : targetsPairList)
    {
        blob->push_back(operand.id);
        blob->push_back(operand.literal);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupMemberDecorate);
}
void WriteVectorExtractDynamic(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdRef vector,
                               IdRef index)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector);
    blob->push_back(index);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorExtractDynamic);
}
void WriteVectorInsertDynamic(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdRef vector,
                              IdRef component,
                              IdRef index)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector);
    blob->push_back(component);
    blob->push_back(index);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorInsertDynamic);
}
void WriteVectorShuffle(Blob *blob,
                        IdResultType idResultType1,
                        IdResult idResult2,
                        IdRef vector1,
                        IdRef vector2,
                        const LiteralIntegerList &componentsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector1);
    blob->push_back(vector2);
    for (const auto &operand : componentsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorShuffle);
}
void WriteCompositeConstruct(Blob *blob,
                             IdResultType idResultType1,
                             IdResult idResult2,
                             const IdRefList &constituentsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    for (const auto &operand : constituentsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCompositeConstruct);
}
void WriteCompositeExtract(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef composite,
                           const LiteralIntegerList &indexesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(composite);
    for (const auto &operand : indexesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCompositeExtract);
}
void WriteCompositeInsert(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef object,
                          IdRef composite,
                          const LiteralIntegerList &indexesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(object);
    blob->push_back(composite);
    for (const auto &operand : indexesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCompositeInsert);
}
void WriteCopyObject(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCopyObject);
}
void WriteTranspose(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef matrix)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(matrix);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTranspose);
}
void WriteSampledImage(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef image,
                       IdRef sampler)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    blob->push_back(sampler);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSampledImage);
}
void WriteImageSampleImplicitLod(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 const spv::ImageOperandsMask *imageOperands5,
                                 const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleImplicitLod);
}
void WriteImageSampleExplicitLod(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 spv::ImageOperandsMask imageOperands5,
                                 const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands5);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleExplicitLod);
}
void WriteImageSampleDrefImplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     const spv::ImageOperandsMask *imageOperands6,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleDrefImplicitLod);
}
void WriteImageSampleDrefExplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     spv::ImageOperandsMask imageOperands6,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands6);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleDrefExplicitLod);
}
void WriteImageSampleProjImplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     const spv::ImageOperandsMask *imageOperands5,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjImplicitLod);
}
void WriteImageSampleProjExplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     spv::ImageOperandsMask imageOperands5,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands5);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjExplicitLod);
}
void WriteImageSampleProjDrefImplicitLod(Blob *blob,
                                         IdResultType idResultType1,
                                         IdResult idResult2,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         const spv::ImageOperandsMask *imageOperands6,
                                         const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjDrefImplicitLod);
}
void WriteImageSampleProjDrefExplicitLod(Blob *blob,
                                         IdResultType idResultType1,
                                         IdResult idResult2,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         spv::ImageOperandsMask imageOperands6,
                                         const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands6);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjDrefExplicitLod);
}
void WriteImageFetch(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef image,
                     IdRef coordinate,
                     const spv::ImageOperandsMask *imageOperands5,
                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageFetch);
}
void WriteImageGather(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef sampledImage,
                      IdRef coordinate,
                      IdRef component,
                      const spv::ImageOperandsMask *imageOperands6,
                      const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(component);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageGather);
}
void WriteImageDrefGather(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef sampledImage,
                          IdRef coordinate,
                          IdRef dref,
                          const spv::ImageOperandsMask *imageOperands6,
                          const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageDrefGather);
}
void WriteImageRead(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef image,
                    IdRef coordinate,
                    const spv::ImageOperandsMask *imageOperands5,
                    const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageRead);
}
void WriteImageWrite(Blob *blob,
                     IdRef image,
                     IdRef coordinate,
                     IdRef texel,
                     const spv::ImageOperandsMask *imageOperands4,
                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(image);
    blob->push_back(coordinate);
    blob->push_back(texel);
    if (imageOperands4)
    {
        blob->push_back(*imageOperands4);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageWrite);
}
void WriteImage(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef sampledImage)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImage);
}
void WriteImageQuerySizeLod(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef image,
                            IdRef levelofDetail)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    blob->push_back(levelofDetail);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageQuerySizeLod);
}
void WriteImageQuerySize(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef image)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageQuerySize);
}
void WriteImageQueryLod(Blob *blob,
                        IdResultType idResultType1,
                        IdResult idResult2,
                        IdRef sampledImage,
                        IdRef coordinate)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageQueryLod);
}
void WriteImageQueryLevels(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef image)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageQueryLevels);
}
void WriteImageQuerySamples(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef image)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageQuerySamples);
}
void WriteConvertFToU(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef floatValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(floatValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertFToU);
}
void WriteConvertFToS(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef floatValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(floatValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertFToS);
}
void WriteConvertSToF(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef signedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(signedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertSToF);
}
void WriteConvertUToF(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef unsignedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(unsignedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertUToF);
}
void WriteUConvert(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef unsignedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(unsignedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUConvert);
}
void WriteSConvert(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef signedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(signedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSConvert);
}
void WriteFConvert(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef floatValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(floatValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFConvert);
}
void WriteQuantizeToF16(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpQuantizeToF16);
}
void WriteBitcast(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitcast);
}
void WriteSNegate(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSNegate);
}
void WriteFNegate(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFNegate);
}
void WriteIAdd(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIAdd);
}
void WriteFAdd(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFAdd);
}
void WriteISub(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpISub);
}
void WriteFSub(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFSub);
}
void WriteIMul(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIMul);
}
void WriteFMul(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFMul);
}
void WriteUDiv(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUDiv);
}
void WriteSDiv(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSDiv);
}
void WriteFDiv(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFDiv);
}
void WriteUMod(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUMod);
}
void WriteSRem(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSRem);
}
void WriteSMod(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSMod);
}
void WriteFRem(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFRem);
}
void WriteFMod(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFMod);
}
void WriteVectorTimesScalar(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef vector,
                            IdRef scalar)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector);
    blob->push_back(scalar);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorTimesScalar);
}
void WriteMatrixTimesScalar(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef matrix,
                            IdRef scalar)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(matrix);
    blob->push_back(scalar);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMatrixTimesScalar);
}
void WriteVectorTimesMatrix(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef vector,
                            IdRef matrix)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector);
    blob->push_back(matrix);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorTimesMatrix);
}
void WriteMatrixTimesVector(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef matrix,
                            IdRef vector)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(matrix);
    blob->push_back(vector);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMatrixTimesVector);
}
void WriteMatrixTimesMatrix(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef leftMatrix,
                            IdRef rightMatrix)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(leftMatrix);
    blob->push_back(rightMatrix);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMatrixTimesMatrix);
}
void WriteOuterProduct(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef vector1,
                       IdRef vector2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector1);
    blob->push_back(vector2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpOuterProduct);
}
void WriteDot(Blob *blob,
              IdResultType idResultType1,
              IdResult idResult2,
              IdRef vector1,
              IdRef vector2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector1);
    blob->push_back(vector2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDot);
}
void WriteIAddCarry(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIAddCarry);
}
void WriteISubBorrow(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpISubBorrow);
}
void WriteUMulExtended(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUMulExtended);
}
void WriteSMulExtended(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSMulExtended);
}
void WriteAny(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef vector)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAny);
}
void WriteAll(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef vector)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(vector);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAll);
}
void WriteIsNan(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIsNan);
}
void WriteIsInf(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIsInf);
}
void WriteLogicalEqual(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalEqual);
}
void WriteLogicalNotEqual(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef operand1,
                          IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalNotEqual);
}
void WriteLogicalOr(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalOr);
}
void WriteLogicalAnd(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalAnd);
}
void WriteLogicalNot(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalNot);
}
void WriteSelect(Blob *blob,
                 IdResultType idResultType1,
                 IdResult idResult2,
                 IdRef condition,
                 IdRef object1,
                 IdRef object2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(condition);
    blob->push_back(object1);
    blob->push_back(object2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSelect);
}
void WriteIEqual(Blob *blob,
                 IdResultType idResultType1,
                 IdResult idResult2,
                 IdRef operand1,
                 IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIEqual);
}
void WriteINotEqual(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpINotEqual);
}
void WriteUGreaterThan(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUGreaterThan);
}
void WriteSGreaterThan(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSGreaterThan);
}
void WriteUGreaterThanEqual(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUGreaterThanEqual);
}
void WriteSGreaterThanEqual(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSGreaterThanEqual);
}
void WriteULessThan(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpULessThan);
}
void WriteSLessThan(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSLessThan);
}
void WriteULessThanEqual(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpULessThanEqual);
}
void WriteSLessThanEqual(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSLessThanEqual);
}
void WriteFOrdEqual(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdEqual);
}
void WriteFUnordEqual(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef operand1,
                      IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordEqual);
}
void WriteFOrdNotEqual(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdNotEqual);
}
void WriteFUnordNotEqual(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordNotEqual);
}
void WriteFOrdLessThan(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdLessThan);
}
void WriteFUnordLessThan(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordLessThan);
}
void WriteFOrdGreaterThan(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef operand1,
                          IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdGreaterThan);
}
void WriteFUnordGreaterThan(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordGreaterThan);
}
void WriteFOrdLessThanEqual(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdLessThanEqual);
}
void WriteFUnordLessThanEqual(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdRef operand1,
                              IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordLessThanEqual);
}
void WriteFOrdGreaterThanEqual(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdRef operand1,
                               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdGreaterThanEqual);
}
void WriteFUnordGreaterThanEqual(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdRef operand1,
                                 IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordGreaterThanEqual);
}
void WriteShiftRightLogical(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef base,
                            IdRef shift)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    blob->push_back(shift);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpShiftRightLogical);
}
void WriteShiftRightArithmetic(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdRef base,
                               IdRef shift)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    blob->push_back(shift);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpShiftRightArithmetic);
}
void WriteShiftLeftLogical(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef base,
                           IdRef shift)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    blob->push_back(shift);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpShiftLeftLogical);
}
void WriteBitwiseOr(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitwiseOr);
}
void WriteBitwiseXor(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitwiseXor);
}
void WriteBitwiseAnd(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitwiseAnd);
}
void WriteNot(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpNot);
}
void WriteBitFieldInsert(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef base,
                         IdRef insert,
                         IdRef offset,
                         IdRef count)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    blob->push_back(insert);
    blob->push_back(offset);
    blob->push_back(count);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitFieldInsert);
}
void WriteBitFieldSExtract(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef base,
                           IdRef offset,
                           IdRef count)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    blob->push_back(offset);
    blob->push_back(count);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitFieldSExtract);
}
void WriteBitFieldUExtract(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef base,
                           IdRef offset,
                           IdRef count)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    blob->push_back(offset);
    blob->push_back(count);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitFieldUExtract);
}
void WriteBitReverse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef base)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitReverse);
}
void WriteBitCount(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef base)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(base);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitCount);
}
void WriteDPdx(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdx);
}
void WriteDPdy(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdy);
}
void WriteFwidth(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFwidth);
}
void WriteDPdxFine(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdxFine);
}
void WriteDPdyFine(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdyFine);
}
void WriteFwidthFine(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFwidthFine);
}
void WriteDPdxCoarse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdxCoarse);
}
void WriteDPdyCoarse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdyCoarse);
}
void WriteFwidthCoarse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFwidthCoarse);
}
void WriteEmitVertex(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEmitVertex);
}
void WriteEndPrimitive(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEndPrimitive);
}
void WriteEmitStreamVertex(Blob *blob, IdRef stream)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(stream);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEmitStreamVertex);
}
void WriteEndStreamPrimitive(Blob *blob, IdRef stream)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(stream);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEndStreamPrimitive);
}
void WriteControlBarrier(Blob *blob, IdScope execution, IdScope memory, IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(execution);
    blob->push_back(memory);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpControlBarrier);
}
void WriteMemoryBarrier(Blob *blob, IdScope memory, IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(memory);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemoryBarrier);
}
void WriteAtomicLoad(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicLoad);
}
void WriteAtomicStore(Blob *blob,
                      IdRef pointer,
                      IdScope memory,
                      IdMemorySemantics semantics,
                      IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicStore);
}
void WriteAtomicExchange(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef pointer,
                         IdScope memory,
                         IdMemorySemantics semantics,
                         IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicExchange);
}
void WriteAtomicCompareExchange(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                IdRef pointer,
                                IdScope memory,
                                IdMemorySemantics equal,
                                IdMemorySemantics unequal,
                                IdRef value,
                                IdRef comparator)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(equal);
    blob->push_back(unequal);
    blob->push_back(value);
    blob->push_back(comparator);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicCompareExchange);
}
void WriteAtomicIIncrement(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef pointer,
                           IdScope memory,
                           IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicIIncrement);
}
void WriteAtomicIDecrement(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef pointer,
                           IdScope memory,
                           IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicIDecrement);
}
void WriteAtomicIAdd(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicIAdd);
}
void WriteAtomicISub(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicISub);
}
void WriteAtomicSMin(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicSMin);
}
void WriteAtomicUMin(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicUMin);
}
void WriteAtomicSMax(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicSMax);
}
void WriteAtomicUMax(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicUMax);
}
void WriteAtomicAnd(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef pointer,
                    IdScope memory,
                    IdMemorySemantics semantics,
                    IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicAnd);
}
void WriteAtomicOr(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   IdRef pointer,
                   IdScope memory,
                   IdMemorySemantics semantics,
                   IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicOr);
}
void WriteAtomicXor(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef pointer,
                    IdScope memory,
                    IdMemorySemantics semantics,
                    IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(pointer);
    blob->push_back(memory);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicXor);
}
void WritePhi(Blob *blob,
              IdResultType idResultType1,
              IdResult idResult2,
              const PairIdRefIdRefList &variableParentPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    for (const auto &operand : variableParentPairList)
    {
        blob->push_back(operand.id1);
        blob->push_back(operand.id2);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpPhi);
}
void WriteLoopMerge(Blob *blob,
                    IdRef mergeBlock,
                    IdRef continueTarget,
                    spv::LoopControlMask loopControl3)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(mergeBlock);
    blob->push_back(continueTarget);
    blob->push_back(loopControl3);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLoopMerge);
}
void WriteSelectionMerge(Blob *blob, IdRef mergeBlock, spv::SelectionControlMask selectionControl2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(mergeBlock);
    blob->push_back(selectionControl2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSelectionMerge);
}
void WriteLabel(Blob *blob, IdResult idResult1)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult1);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLabel);
}
void WriteBranch(Blob *blob, IdRef targetLabel)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(targetLabel);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBranch);
}
void WriteBranchConditional(Blob *blob,
                            IdRef condition,
                            IdRef trueLabel,
                            IdRef falseLabel,
                            const LiteralIntegerList &branchweightsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(condition);
    blob->push_back(trueLabel);
    blob->push_back(falseLabel);
    for (const auto &operand : branchweightsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBranchConditional);
}
void WriteSwitch(Blob *blob,
                 IdRef selector,
                 IdRef default_,
                 const PairLiteralIntegerIdRefList &targetPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(selector);
    blob->push_back(default_);
    for (const auto &operand : targetPairList)
    {
        blob->push_back(operand.literal);
        blob->push_back(operand.id);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSwitch);
}
void WriteKill(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpKill);
}
void WriteReturn(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpReturn);
}
void WriteReturnValue(Blob *blob, IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpReturnValue);
}
void WriteUnreachable(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUnreachable);
}
void WriteImageSparseSampleImplicitLod(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       const spv::ImageOperandsMask *imageOperands5,
                                       const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleImplicitLod);
}
void WriteImageSparseSampleExplicitLod(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       spv::ImageOperandsMask imageOperands5,
                                       const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands5);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleExplicitLod);
}
void WriteImageSparseSampleDrefImplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           const spv::ImageOperandsMask *imageOperands6,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleDrefImplicitLod);
}
void WriteImageSparseSampleDrefExplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           spv::ImageOperandsMask imageOperands6,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands6);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleDrefExplicitLod);
}
void WriteImageSparseSampleProjImplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           const spv::ImageOperandsMask *imageOperands5,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjImplicitLod);
}
void WriteImageSparseSampleProjExplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           spv::ImageOperandsMask imageOperands5,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands5);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjExplicitLod);
}
void WriteImageSparseSampleProjDrefImplicitLod(Blob *blob,
                                               IdResultType idResultType1,
                                               IdResult idResult2,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               const spv::ImageOperandsMask *imageOperands6,
                                               const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjDrefImplicitLod);
}
void WriteImageSparseSampleProjDrefExplicitLod(Blob *blob,
                                               IdResultType idResultType1,
                                               IdResult idResult2,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               spv::ImageOperandsMask imageOperands6,
                                               const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands6);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjDrefExplicitLod);
}
void WriteImageSparseFetch(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef image,
                           IdRef coordinate,
                           const spv::ImageOperandsMask *imageOperands5,
                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseFetch);
}
void WriteImageSparseGather(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef sampledImage,
                            IdRef coordinate,
                            IdRef component,
                            const spv::ImageOperandsMask *imageOperands6,
                            const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(component);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseGather);
}
void WriteImageSparseDrefGather(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                IdRef sampledImage,
                                IdRef coordinate,
                                IdRef dref,
                                const spv::ImageOperandsMask *imageOperands6,
                                const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands6)
    {
        blob->push_back(*imageOperands6);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseDrefGather);
}
void WriteImageSparseTexelsResident(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdRef residentCode)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(residentCode);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseTexelsResident);
}
void WriteNoLine(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpNoLine);
}
void WriteImageSparseRead(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef image,
                          IdRef coordinate,
                          const spv::ImageOperandsMask *imageOperands5,
                          const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands5)
    {
        blob->push_back(*imageOperands5);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseRead);
}
void WriteModuleProcessed(Blob *blob, LiteralString process)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(process) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), process);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpModuleProcessed);
}
void WriteExecutionModeId(Blob *blob,
                          IdRef entryPoint,
                          spv::ExecutionMode mode,
                          const LiteralIntegerList &operandsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(entryPoint);
    blob->push_back(mode);
    for (const auto &operand : operandsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExecutionModeId);
}
void WriteGroupNonUniformElect(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdScope execution)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformElect);
}
void WriteGroupNonUniformAll(Blob *blob,
                             IdResultType idResultType1,
                             IdResult idResult2,
                             IdScope execution,
                             IdRef predicate)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(predicate);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformAll);
}
void WriteGroupNonUniformAny(Blob *blob,
                             IdResultType idResultType1,
                             IdResult idResult2,
                             IdScope execution,
                             IdRef predicate)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(predicate);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformAny);
}
void WriteGroupNonUniformAllEqual(Blob *blob,
                                  IdResultType idResultType1,
                                  IdResult idResult2,
                                  IdScope execution,
                                  IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformAllEqual);
}
void WriteGroupNonUniformBroadcast(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   IdRef value,
                                   IdRef id)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(id);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBroadcast);
}
void WriteGroupNonUniformBroadcastFirst(Blob *blob,
                                        IdResultType idResultType1,
                                        IdResult idResult2,
                                        IdScope execution,
                                        IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBroadcastFirst);
}
void WriteGroupNonUniformBallot(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                IdScope execution,
                                IdRef predicate)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(predicate);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBallot);
}
void WriteGroupNonUniformInverseBallot(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformInverseBallot);
}
void WriteGroupNonUniformBallotBitExtract(Blob *blob,
                                          IdResultType idResultType1,
                                          IdResult idResult2,
                                          IdScope execution,
                                          IdRef value,
                                          IdRef index)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(index);
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBallotBitExtract);
}
void WriteGroupNonUniformBallotBitCount(Blob *blob,
                                        IdResultType idResultType1,
                                        IdResult idResult2,
                                        IdScope execution,
                                        spv::GroupOperation operation,
                                        IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBallotBitCount);
}
void WriteGroupNonUniformBallotFindLSB(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBallotFindLSB);
}
void WriteGroupNonUniformBallotFindMSB(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBallotFindMSB);
}
void WriteGroupNonUniformShuffle(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdScope execution,
                                 IdRef value,
                                 IdRef id)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(id);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformShuffle);
}
void WriteGroupNonUniformShuffleXor(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    IdRef value,
                                    IdRef mask)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(mask);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformShuffleXor);
}
void WriteGroupNonUniformShuffleUp(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   IdRef value,
                                   IdRef delta)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(delta);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformShuffleUp);
}
void WriteGroupNonUniformShuffleDown(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdScope execution,
                                     IdRef value,
                                     IdRef delta)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(delta);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformShuffleDown);
}
void WriteGroupNonUniformIAdd(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformIAdd);
}
void WriteGroupNonUniformFAdd(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformFAdd);
}
void WriteGroupNonUniformIMul(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformIMul);
}
void WriteGroupNonUniformFMul(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformFMul);
}
void WriteGroupNonUniformSMin(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformSMin);
}
void WriteGroupNonUniformUMin(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformUMin);
}
void WriteGroupNonUniformFMin(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformFMin);
}
void WriteGroupNonUniformSMax(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformSMax);
}
void WriteGroupNonUniformUMax(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformUMax);
}
void WriteGroupNonUniformFMax(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformFMax);
}
void WriteGroupNonUniformBitwiseAnd(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBitwiseAnd);
}
void WriteGroupNonUniformBitwiseOr(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   spv::GroupOperation operation,
                                   IdRef value,
                                   const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBitwiseOr);
}
void WriteGroupNonUniformBitwiseXor(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformBitwiseXor);
}
void WriteGroupNonUniformLogicalAnd(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformLogicalAnd);
}
void WriteGroupNonUniformLogicalOr(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   spv::GroupOperation operation,
                                   IdRef value,
                                   const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformLogicalOr);
}
void WriteGroupNonUniformLogicalXor(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(value);
    if (clusterSize)
    {
        blob->push_back(*clusterSize);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformLogicalXor);
}
void WriteGroupNonUniformQuadBroadcast(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value,
                                       IdRef index)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(index);
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformQuadBroadcast);
}
void WriteGroupNonUniformQuadSwap(Blob *blob,
                                  IdResultType idResultType1,
                                  IdResult idResult2,
                                  IdScope execution,
                                  IdRef value,
                                  IdRef direction)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(direction);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupNonUniformQuadSwap);
}
void WriteCopyLogical(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCopyLogical);
}
void WritePtrEqual(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   IdRef operand1,
                   IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpPtrEqual);
}
void WritePtrNotEqual(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef operand1,
                      IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType1);
    blob->push_back(idResult2);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpPtrNotEqual);
}
void WriteBeginInvocationInterlockEXT(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBeginInvocationInterlockEXT);
}
void WriteEndInvocationInterlockEXT(Blob *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEndInvocationInterlockEXT);
}

}  // namespace spirv
}  // namespace angle
