// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum units.yaml. DO NOT EDIT.

package report

import (
	"fmt"
	"iter"
)

// LengthUnit represents units of measurement for the length of a string.
//
// The most commonly used [LengthUnit] in protocompile is [TermWidth], which
// approximates columns in a terminal emulator. This takes into account the
// Unicode width of runes, and tabstops. The rune A is one column wide, the rune
// 貓 is two columns wide, and the multi-rune emoji presentation sequence 🐈‍⬛ is
// also two columns wide.
//
// Other units of length can be used to cope with the needs of other rendering
// contexts, such as the Language Server Protocol.
type LengthUnit int

const (
	ByteLength  LengthUnit = iota // The length in UTF-8 code units (bytes).
	UTF16Length                   // The length in UTF-16 code units (uint16s).
	RuneLength                    // The length in UTF-32 code units (runes).
	TermWidth                     // The length in approximate terminal columns.
)

// String implements [fmt.Stringer].
func (v LengthUnit) String() string {
	if int(v) < 0 || int(v) > len(_table_LengthUnit_String) {
		return fmt.Sprintf("LengthUnit(%v)", int(v))
	}
	return _table_LengthUnit_String[v]
}

// GoString implements [fmt.GoStringer].
func (v LengthUnit) GoString() string {
	if int(v) < 0 || int(v) > len(_table_LengthUnit_GoString) {
		return fmt.Sprintf("report.LengthUnit(%v)", int(v))
	}
	return _table_LengthUnit_GoString[v]
}

// LengthUnits returns an iterator over all of the [LengthUnit]s
func LengthUnits() iter.Seq[LengthUnit] {
	return func(yield func(LengthUnit) bool) {
		for i := 0; i < 4; i++ {
			if !yield(LengthUnit(i)) {
				return
			}
		}
	}
}

var _table_LengthUnit_String = [...]string{
	ByteLength:  "ByteLength",
	UTF16Length: "UTF16Length",
	RuneLength:  "RuneLength",
	TermWidth:   "TermWidth",
}

var _table_LengthUnit_GoString = [...]string{
	ByteLength:  "ByteLength",
	UTF16Length: "UTF16Length",
	RuneLength:  "RuneLength",
	TermWidth:   "TermWidth",
}
var _ iter.Seq[int] // Mark iter as used.
