/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#pragma once

#include <QByteArray>
#include <QList>
#include <QMetaType>
#if (QT_VERSION >= QT_VERSION_CHECK(5, 12, 0))
#  include <memory> /* ::std::unique_ptr */
#else /* < Qt-5.12 */
#  include <QScopedPointer>
#endif /* >= Qt-5.12 */

#include "src/datovka_shared/isds/types.h"
#include "src/datovka_shared/json/object.h"

class QDateTime; /* Forward declaration. */
class QJsonValue; /* Forward declaration. */

namespace Json {

	class MsgId1Private;
	/*!
	 * @brief Holds message identifier.
	 */
	class MsgId1 : public Object {
		Q_DECLARE_PRIVATE(MsgId1)
	public:
		MsgId1(void);
		MsgId1(const MsgId1 &other);
#ifdef Q_COMPILER_RVALUE_REFS
		MsgId1(MsgId1 &&other) Q_DECL_NOEXCEPT;
#endif /* Q_COMPILER_RVALUE_REFS */
		~MsgId1(void);

		explicit MsgId1(enum Isds::Type::NilBool testEnv, qint64 dmId);

		MsgId1 &operator=(const MsgId1 &other) Q_DECL_NOTHROW;
#ifdef Q_COMPILER_RVALUE_REFS
		MsgId1 &operator=(MsgId1 &&other) Q_DECL_NOTHROW;
#endif /* Q_COMPILER_RVALUE_REFS */

		bool operator==(const MsgId1 &other) const;
		bool operator!=(const MsgId1 &other) const;

		friend void swap(MsgId1 &first, MsgId1 &second) Q_DECL_NOTHROW;

		bool isNull(void) const;

		bool isValid(void) const;

		/* test environment */
		enum Isds::Type::NilBool testEnv(void) const;
		void setTestEnv(enum Isds::Type::NilBool t);
		/* message identifier */
		qint64 dmId(void) const;
		void setDmId(qint64 di);

		static
		MsgId1 fromJson(const QByteArray &json, bool *ok = Q_NULLPTR);
		static
		MsgId1 fromJsonVal(const QJsonValue &jsonVal, bool *ok = Q_NULLPTR);

		virtual
		bool toJsonVal(QJsonValue &jsonVal) const Q_DECL_OVERRIDE;

	private:
#if (QT_VERSION >= QT_VERSION_CHECK(5, 12, 0))
		::std::unique_ptr<MsgId1Private> d_ptr;
#else /* < Qt-5.12 */
		QScopedPointer<MsgId1Private> d_ptr;
#endif /* >= Qt-5.12 */
	};

	void swap(MsgId1 &first, MsgId1 &second) Q_DECL_NOTHROW;

	/*!
	 * @brief List of message identifiers.
	 */
	class MsgId1List : public Object, public QList<MsgId1> {
	public:
		/* Expose list constructors. */
		using QList<MsgId1>::QList;

		/* Some older compilers complain about missing constructor. */
		MsgId1List(void);

		MsgId1List(const QList<MsgId1> &other);
#ifdef Q_COMPILER_RVALUE_REFS
		MsgId1List(QList<MsgId1> &&other);
#endif /* Q_COMPILER_RVALUE_REFS */

		static
		MsgId1List fromJson(const QByteArray &json, bool *ok = Q_NULLPTR);
		static
		MsgId1List fromJsonVal(const QJsonValue &jsonVal, bool *ok = Q_NULLPTR);

		virtual
		bool toJsonVal(QJsonValue &jsonVal) const Q_DECL_OVERRIDE;
	};

	class MsgId2Private;
	/*!
	 * @brief Holds message identifier.
	 */
	class MsgId2 : public Object {
		Q_DECLARE_PRIVATE(MsgId2)
	public:
		MsgId2(void);
		MsgId2(const MsgId2 &other);
#ifdef Q_COMPILER_RVALUE_REFS
		MsgId2(MsgId2 &&other) Q_DECL_NOEXCEPT;
#endif /* Q_COMPILER_RVALUE_REFS */
		~MsgId2(void);

		explicit MsgId2(enum Isds::Type::NilBool testEnv, qint64 dmId,
		    const QDateTime &deliveryTime);
#ifdef Q_COMPILER_RVALUE_REFS
		explicit MsgId2(enum Isds::Type::NilBool testEnv, qint64 dmId,
		    QDateTime &&deliveryTime);
#endif /* Q_COMPILER_RVALUE_REFS */

		MsgId2 &operator=(const MsgId2 &other) Q_DECL_NOTHROW;
#ifdef Q_COMPILER_RVALUE_REFS
		MsgId2 &operator=(MsgId2 &&other) Q_DECL_NOTHROW;
#endif /* Q_COMPILER_RVALUE_REFS */

		bool operator==(const MsgId2 &other) const;
		bool operator!=(const MsgId2 &other) const;

		friend void swap(MsgId2 &first, MsgId2 &second) Q_DECL_NOTHROW;

		bool isNull(void) const;

		bool isValid(void) const;

		/* test environment */
		enum Isds::Type::NilBool testEnv(void) const;
		void setTestEnv(enum Isds::Type::NilBool t);
		/* message identifier */
		qint64 dmId(void) const;
		void setDmId(qint64 di);
		/* delivery time */
		const QDateTime &deliveryTime(void) const;
		void setDeliveryTime(const QDateTime &dt);
#ifdef Q_COMPILER_RVALUE_REFS
		void setDeliveryTime(QDateTime &&dt);
#endif /* Q_COMPILER_RVALUE_REFS */

		static
		MsgId2 fromJson(const QByteArray &json, bool *ok = Q_NULLPTR);
		static
		MsgId2 fromJsonVal(const QJsonValue &jsonVal, bool *ok = Q_NULLPTR);

		virtual
		bool toJsonVal(QJsonValue &jsonVal) const Q_DECL_OVERRIDE;

	private:
#if (QT_VERSION >= QT_VERSION_CHECK(5, 12, 0))
		::std::unique_ptr<MsgId2Private> d_ptr;
#else /* < Qt-5.12 */
		QScopedPointer<MsgId2Private> d_ptr;
#endif /* >= Qt-5.12 */
	};

	void swap(MsgId2 &first, MsgId2 &second) Q_DECL_NOTHROW;

	/*!
	 * @brief List of message identifiers.
	 */
	class MsgId2List : public Object, public QList<MsgId2> {
	public:
		/* Expose list constructors. */
		using QList<MsgId2>::QList;

		/* Some older compilers complain about missing constructor. */
		MsgId2List(void);

		MsgId2List(const QList<MsgId2> &other);
#ifdef Q_COMPILER_RVALUE_REFS
		MsgId2List(QList<MsgId2> &&other);
#endif /* Q_COMPILER_RVALUE_REFS */

		static
		MsgId2List fromJson(const QByteArray &json, bool *ok = Q_NULLPTR);
		static
		MsgId2List fromJsonVal(const QJsonValue &jsonVal, bool *ok = Q_NULLPTR);

		virtual
		bool toJsonVal(QJsonValue &jsonVal) const Q_DECL_OVERRIDE;
	};

#if (QT_VERSION >= QT_VERSION_CHECK(6, 0, 0))
	size_t qHash(const MsgId1 &key, size_t seed = 0);
#else /* < Qt-6.0 */
	uint qHash(const MsgId1 &key, uint seed = 0);
#endif /* >= Qt-6.0 */

#if (QT_VERSION >= QT_VERSION_CHECK(6, 0, 0))
	size_t qHash(const MsgId2 &key, size_t seed = 0);
#else /* < Qt-6.0 */
	uint qHash(const MsgId2 &key, uint seed = 0);
#endif /* >= Qt-6.0 */

}

Q_DECLARE_METATYPE(Json::MsgId1)
Q_DECLARE_METATYPE(Json::MsgId1List)
Q_DECLARE_METATYPE(Json::MsgId2)
Q_DECLARE_METATYPE(Json::MsgId2List)
