
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabicon_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// inner classes
#include "tabicon_data_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabIcon_Type = nullptr;
static PyTypeObject *Sbk_TabIcon_TypeF(void)
{
    return _Sbk_TabIcon_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void TabIconWrapper::pysideInitQtMetaTypes()
{
}

void TabIconWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

TabIconWrapper::TabIconWrapper(::QWidget * parent) : TabIcon(parent)
{
}

void TabIconWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabIcon", funcName, gil, pyOverride, signal);
}

void TabIconWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("TabIcon", funcName, gil, pyOverride, event);
}

int TabIconWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("TabIcon", funcName, gil, pyOverride);
}

void TabIconWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabIcon", funcName, gil, pyOverride, signal);
}

void TabIconWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("TabIcon", funcName, gil, pyOverride, event);
}

bool TabIconWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("TabIcon", funcName, gil, pyOverride, watched, event);
}

void TabIconWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("TabIcon", funcName, gil, pyOverride, event);
}

bool TabIconWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("TabIcon", funcName, gil, pyOverride, next);
}

void TabIconWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("TabIcon", funcName, gil, pyOverride, event);
}

bool TabIconWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabIcon", funcName, gil, pyOverride);
}

int TabIconWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("TabIcon", funcName, gil, pyOverride, arg__1);
}

void TabIconWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("TabIcon", funcName, gil, pyOverride, painter);
}

void TabIconWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("TabIcon", funcName, gil, pyOverride, event);
}

::QVariant TabIconWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("TabIcon", funcName, gil, pyOverride, arg__1);
}

void TabIconWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("TabIcon", funcName, gil, pyOverride, event);
}

int TabIconWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("TabIcon", funcName, gil, pyOverride, arg__1);
}

::QSize TabIconWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabIcon", funcName, gil, pyOverride);
}

void TabIconWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("TabIcon", funcName, gil, pyOverride, event);
}

bool TabIconWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("TabIcon", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * TabIconWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("TabIcon", funcName, gil, pyOverride);
}

::QPaintDevice * TabIconWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("TabIcon", funcName, gil, pyOverride, offset);
}

void TabIconWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("TabIcon", funcName, gil, pyOverride, visible);
}

::QPainter * TabIconWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("TabIcon", funcName, gil, pyOverride);
}

void TabIconWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("TabIcon", funcName, gil, pyOverride, event);
}

::QSize TabIconWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabIcon", funcName, gil, pyOverride);
}

void TabIconWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("TabIcon", funcName, gil, pyOverride, event);
}

void TabIconWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabIcon_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("TabIcon", funcName, gil, pyOverride, event);
}

const QMetaObject *TabIconWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return TabIcon::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int TabIconWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = TabIcon::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *TabIconWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< TabIconWrapper *>(this));
    }
    return TabIcon::qt_metacast(_clname);
}

TabIconWrapper::~TabIconWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_TabIcon_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabIcon_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabIcon >()))
        return -1;

    TabIconWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:TabIcon", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: TabIcon::TabIcon(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // TabIcon(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // TabIcon(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // TabIcon(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) TabIconWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new TabIconWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< TabIcon >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);
    };


    return 1;
}

static PyObject *Sbk_TabIconFunc_data(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // data()
        TabIcon::Data * cppResult = ::TabIcon::data();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_Data_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabIconFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabIconWrapper *>(reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("event(QEvent *event)");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabIconFunc_hide(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabIconWrapper *>(reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("hide()");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabIconFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabIconWrapper *>(reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mousePressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("mousePressEvent(QMouseEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabIconFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabIconWrapper *>(reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("paintEvent(QPaintEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabIconFunc_setWebTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabIconWrapper *>(reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabIcon::setWebTab(WebTab*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArg)))) {
        overloadId = 0; // setWebTab(WebTab*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWebTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebTab *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWebTab(WebTab*)
            cppSelf->setWebTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabIconFunc_show(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabIconWrapper *>(reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("show()");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabIconFunc_updateIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabIconWrapper *>(reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // updateIcon()
        cppSelf->updateIcon();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_TabIcon_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabIcon_methods[] = {
    {"data", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_data), METH_NOARGS|METH_STATIC, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_event), METH_O, nullptr},
    {"hide", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_hide), METH_NOARGS, nullptr},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_mousePressEvent), METH_O, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_paintEvent), METH_O, nullptr},
    {"setWebTab", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_setWebTab), METH_O, nullptr},
    {"show", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_show), METH_NOARGS, nullptr},
    {"updateIcon", reinterpret_cast<PyCFunction>(Sbk_TabIconFunc_updateIcon), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_TabIcon_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::TabIcon *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabIcon_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<TabIconWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_TabIcon_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabIcon_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_TabIconSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::TabIcon *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabIcon_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_TabIcon_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabIcon_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabIcon_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabIcon_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabIcon_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabIcon_spec = {
    "1:PyFalkon.TabIcon",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabIcon_slots
};

} //extern "C"

static void *Sbk_TabIcon_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::TabIcon *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::TabIcon *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::TabIcon *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TabIcon_PythonToCpp_TabIcon_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabIcon_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TabIcon_PythonToCpp_TabIcon_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabIcon_TypeF()))
        return TabIcon_PythonToCpp_TabIcon_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TabIcon_PTR_CppToPython_TabIcon(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::TabIcon *>(const_cast<void *>(cppIn)), Sbk_TabIcon_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabIcon_SignatureStrings[] = {
    "PyFalkon.TabIcon(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.TabIcon.data()->PyFalkon.TabIcon.Data",
    "PyFalkon.TabIcon.event(self,event:PySide6.QtCore.QEvent)->bool",
    "PyFalkon.TabIcon.hide(self)",
    "PyFalkon.TabIcon.mousePressEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.TabIcon.paintEvent(self,event:PySide6.QtGui.QPaintEvent)",
    "PyFalkon.TabIcon.setWebTab(self,tab:PyFalkon.WebTab)",
    "PyFalkon.TabIcon.show(self)",
    "PyFalkon.TabIcon.updateIcon(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t TabIcon_SignatureByteSize = 187;
static constexpr uint8_t TabIcon_SignatureBytes[187] = {
    0x78, 0xda, 0x85, 0x91, 0x4d, 0x0b, 0xc2, 0x20, 0x18, 0xc7, 0xef, 0xfb, 0x24, 0x1b, 0x94, 0xc7,
    0x0e, 0x83, 0xba, 0xd4, 0x8a, 0x0e, 0x81, 0x52, 0xb0, 0xb3, 0xb6, 0xa7, 0x26, 0x99, 0x8a, 0x2f,
    0xc5, 0xbe, 0x7d, 0x6e, 0xc2, 0x88, 0xdc, 0xe8, 0xf6, 0xe8, 0xff, 0xe5, 0xe7, 0x0b, 0xee, 0xf6,
    0x54, 0x3c, 0x94, 0x44, 0x17, 0xca, 0x8e, 0x57, 0x25, 0x73, 0x0b, 0xe2, 0xb6, 0xd0, 0xd4, 0x80,
    0x74, 0x25, 0xee, 0xce, 0xbc, 0x81, 0x15, 0x22, 0xae, 0xe6, 0xcd, 0x1d, 0x9c, 0x45, 0x24, 0x0e,
    0x6b, 0xe9, 0x85, 0xd0, 0xce, 0x14, 0x19, 0xfe, 0xc9, 0xa3, 0x86, 0x3a, 0x9a, 0x17, 0xcb, 0x4d,
    0x22, 0xec, 0x82, 0x90, 0xda, 0xe1, 0x15, 0x40, 0x11, 0x3a, 0x8c, 0x5f, 0xcc, 0xad, 0x32, 0x80,
    0x48, 0xd5, 0xef, 0x86, 0x3e, 0xa6, 0x94, 0x48, 0xe3, 0x6d, 0xf0, 0x0e, 0xe9, 0x89, 0x93, 0x3c,
    0x95, 0xb7, 0x80, 0x0d, 0x58, 0x5b, 0xcd, 0x43, 0x0e, 0x9e, 0x23, 0x72, 0xea, 0x9d, 0x11, 0x94,
    0xd6, 0x68, 0xca, 0xa5, 0xfb, 0xd7, 0x80, 0x47, 0xd3, 0x44, 0x83, 0x05, 0x57, 0x03, 0x0b, 0xab,
    0x58, 0xe0, 0x28, 0x2b, 0x47, 0x4f, 0x14, 0xa6, 0x42, 0xad, 0x7a, 0xcf, 0xdd, 0xcc, 0xeb, 0xf0,
    0xca, 0x30, 0x7e, 0x57, 0x91, 0x7d, 0x00, 0xc6, 0xa3, 0xa2, 0x77
};
#endif

PyTypeObject *init_TabIcon(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_TabIcon_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabIcon_IDX].type;

    Shiboken::AutoDecRef Sbk_TabIcon_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_TabIcon_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "TabIcon",
        "TabIcon*",
        &Sbk_TabIcon_spec,
        &Shiboken::callCppDestructor< TabIcon >,
        Sbk_TabIcon_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_TabIcon_Type; // references _Sbk_TabIcon_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabIcon_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabIcon_SignatureBytes, TabIcon_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabIcon_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabIcon_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        TabIcon_PythonToCpp_TabIcon_PTR,
        is_TabIcon_PythonToCpp_TabIcon_PTR_Convertible,
        TabIcon_PTR_CppToPython_TabIcon);

    Shiboken::Conversions::registerConverterName(converter, "TabIcon");
    Shiboken::Conversions::registerConverterName(converter, "TabIcon*");
    Shiboken::Conversions::registerConverterName(converter, "TabIcon&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabIcon).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(TabIconWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_TabIcon_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_TabIcon_TypeF(), &Sbk_TabIconSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_TabIcon_TypeF(), &Sbk_TabIcon_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::TabIcon::staticMetaObject);
    TabIconWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::TabIcon::staticMetaObject, sizeof(TabIconWrapper));

    return pyType;
}
