/* ecb-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ecb-provider.vala, do not modify */

#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ECB_CURRENCY_PROVIDER_0_PROPERTY,
	ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	ECB_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

static gpointer ecb_currency_provider_parent_class = NULL;

static GDateTime* ecb_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                                  const gchar* date);
static gboolean ecb_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static void ecb_currency_provider_set_ecb_rate (EcbCurrencyProvider* self,
                                         xmlNode* node,
                                         Number* eur_rate,
                                         const gchar* date);
static void ecb_currency_provider_set_ecb_fixed_rate (EcbCurrencyProvider* self,
                                               const gchar* name,
                                               const gchar* value,
                                               Number* eur_rate,
                                               const gchar* date);
static GType ecb_currency_provider_get_type_once (void);
static void _vala_ecb_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GDateTime*
ecb_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                       const gchar* date)
{
	EcbCurrencyProvider * self;
	gchar** array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint array_length1;
	gint _array_size_;
	gint year = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gint month = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint day = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	GTimeZone* _tmp8_;
	GTimeZone* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* result;
	self = (EcbCurrencyProvider*) base;
	if (date == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = _tmp0_ = g_strsplit (date, "-", 0);
	array = _tmp1_;
	array_length1 = _vala_array_length (_tmp0_);
	_array_size_ = array_length1;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	_tmp3_ = _tmp2_[0];
	year = atoi (_tmp3_);
	_tmp4_ = array;
	_tmp4__length1 = array_length1;
	_tmp5_ = _tmp4_[1];
	month = atoi (_tmp5_);
	_tmp6_ = array;
	_tmp6__length1 = array_length1;
	_tmp7_ = _tmp6_[2];
	day = atoi (_tmp7_);
	_tmp8_ = g_time_zone_new_local ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_date_time_new (_tmp9_, year, month, day, 0, 0, (gdouble) 0);
	_tmp11_ = _tmp10_;
	_g_time_zone_unref0 (_tmp9_);
	result = _tmp11_;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
ecb_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	EcbCurrencyProvider * self;
	Currency* eur_rate = NULL;
	Currency* _tmp0_;
	Currency* _tmp1_;
	xmlDoc* document = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	xmlDoc* _tmp5_;
	xmlDoc* _tmp6_;
	xmlDoc* _tmp7_;
	xmlXPathContext* xpath_ctx = NULL;
	xmlDoc* _tmp11_;
	xmlXPathContext* _tmp12_;
	xmlXPathContext* _tmp13_;
	xmlXPathContext* _tmp14_;
	xmlXPathObject* xpath_obj = NULL;
	xmlXPathContext* _tmp15_;
	xmlXPathObject* _tmp16_;
	xmlXPathObject* _tmp17_;
	xmlXPathObject* xpath_date = NULL;
	xmlXPathContext* _tmp18_;
	xmlXPathObject* _tmp19_;
	gchar* _tmp20_ = NULL;
	xmlXPathObject* _tmp21_;
	xmlNodeSet* _tmp22_;
	gchar* date = NULL;
	gchar* _tmp27_;
	gint _tmp28_ = 0;
	xmlXPathObject* _tmp29_;
	xmlNodeSet* _tmp30_;
	gint len = 0;
	Currency* _tmp45_;
	Number* _tmp46_;
	Number* _tmp47_;
	const gchar* _tmp48_;
	Currency* _tmp49_;
	Number* _tmp50_;
	Number* _tmp51_;
	const gchar* _tmp52_;
	Currency* _tmp53_;
	Number* _tmp54_;
	Number* _tmp55_;
	const gchar* _tmp56_;
	gboolean result;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_base_currency ((AbstractCurrencyProvider*) self);
	eur_rate = _tmp0_;
	_tmp1_ = eur_rate;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (eur_rate);
		return result;
	}
	xmlInitParser ();
	_tmp2_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = xmlReadFile (_tmp4_, NULL, 0);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	document = _tmp6_;
	_tmp7_ = document;
	if (_tmp7_ == NULL) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		g_warning ("ecb-provider.vala:38: Couldn't parse ECB rate file %s", _tmp10_);
		_g_free0 (_tmp10_);
		result = FALSE;
		_g_object_unref0 (eur_rate);
		return result;
	}
	_tmp11_ = document;
	_tmp12_ = xmlXPathNewContext (_tmp11_);
	xpath_ctx = _tmp12_;
	_tmp13_ = xpath_ctx;
	if (_tmp13_ == NULL) {
		g_warning ("ecb-provider.vala:45: Couldn't create XPath context");
		result = FALSE;
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (eur_rate);
		return result;
	}
	_tmp14_ = xpath_ctx;
	xmlXPathRegisterNs (_tmp14_, (xmlChar*) "xref", (xmlChar*) "http://www.ecb.int/vocabulary/2002-08-01/eurofxref");
	_tmp15_ = xpath_ctx;
	_tmp16_ = xmlXPathEvalExpression ((xmlChar*) "//xref:Cube[@currency][@rate]", _tmp15_);
	xpath_obj = _tmp16_;
	_tmp17_ = xpath_obj;
	if (_tmp17_ == NULL) {
		g_warning ("ecb-provider.vala:53: Couldn't create XPath object");
		result = FALSE;
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (eur_rate);
		return result;
	}
	_tmp18_ = xpath_ctx;
	_tmp19_ = xmlXPathEvalExpression ((xmlChar*) "//xref:Cube/@time", _tmp18_);
	xpath_date = _tmp19_;
	_tmp21_ = xpath_date;
	_tmp22_ = _tmp21_->nodesetval;
	if (_tmp22_ != NULL) {
		xmlXPathObject* _tmp23_;
		xmlNodeSet* _tmp24_;
		xmlNode* _tmp25_;
		gchar* _tmp26_;
		_tmp23_ = xpath_date;
		_tmp24_ = _tmp23_->nodesetval;
		_tmp25_ = xmlXPathNodeSetItem (_tmp24_, 0);
		_tmp26_ = (gchar*) xmlNodeGetContent (_tmp25_);
		_g_free0 (_tmp20_);
		_tmp20_ = _tmp26_;
	} else {
		_g_free0 (_tmp20_);
		_tmp20_ = NULL;
	}
	_tmp27_ = g_strdup (_tmp20_);
	date = _tmp27_;
	_tmp29_ = xpath_obj;
	_tmp30_ = _tmp29_->nodesetval;
	if (_tmp30_ != NULL) {
		xmlXPathObject* _tmp31_;
		xmlNodeSet* _tmp32_;
		_tmp31_ = xpath_obj;
		_tmp32_ = _tmp31_->nodesetval;
		_tmp28_ = xmlXPathNodeSetGetLength (_tmp32_);
	} else {
		_tmp28_ = 0;
	}
	len = _tmp28_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				xmlNode* node = NULL;
				xmlXPathObject* _tmp35_;
				xmlNodeSet* _tmp36_;
				xmlNode* _tmp37_;
				xmlNode* _tmp38_;
				xmlNode* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				if (!(i < len)) {
					break;
				}
				_tmp35_ = xpath_obj;
				_tmp36_ = _tmp35_->nodesetval;
				_tmp37_ = xmlXPathNodeSetItem (_tmp36_, i);
				node = _tmp37_;
				_tmp38_ = node;
				if (_tmp38_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp39_;
					Currency* _tmp40_;
					Number* _tmp41_;
					Number* _tmp42_;
					const gchar* _tmp43_;
					_tmp39_ = node;
					_tmp40_ = eur_rate;
					_tmp41_ = currency_get_value (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = date;
					ecb_currency_provider_set_ecb_rate (self, _tmp39_, _tmp42_, _tmp43_);
					_g_object_unref0 (_tmp42_);
				}
				_tmp44_ = node;
				if (_tmp44_->type != XML_NAMESPACE_DECL) {
					node = NULL;
				}
			}
		}
	}
	_tmp45_ = eur_rate;
	_tmp46_ = currency_get_value (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = date;
	ecb_currency_provider_set_ecb_fixed_rate (self, "RSD", "0.0085", _tmp47_, _tmp48_);
	_g_object_unref0 (_tmp47_);
	_tmp49_ = eur_rate;
	_tmp50_ = currency_get_value (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = date;
	ecb_currency_provider_set_ecb_fixed_rate (self, "EEK", "0.06391", _tmp51_, _tmp52_);
	_g_object_unref0 (_tmp51_);
	_tmp53_ = eur_rate;
	_tmp54_ = currency_get_value (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = date;
	ecb_currency_provider_set_ecb_fixed_rate (self, "CFA", "0.00152449", _tmp55_, _tmp56_);
	_g_object_unref0 (_tmp55_);
	result = ABSTRACT_CURRENCY_PROVIDER_CLASS (ecb_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	_g_free0 (date);
	_g_free0 (_tmp20_);
	_xmlXPathFreeContext0 (xpath_ctx);
	_g_object_unref0 (eur_rate);
	return result;
}

static void
ecb_currency_provider_set_ecb_rate (EcbCurrencyProvider* self,
                                    xmlNode* node,
                                    Number* eur_rate,
                                    const gchar* date)
{
	gchar* name = NULL;
	gchar* value = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (eur_rate != NULL);
	name = NULL;
	value = NULL;
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = node->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				xmlNode* n = NULL;
				xmlAttr* _tmp5_;
				xmlAttr* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				n = (xmlNode*) _tmp5_;
				_tmp6_ = attribute;
				_tmp7_ = _tmp6_->name;
				if (g_strcmp0 (_tmp7_, "currency") == 0) {
					xmlNode* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = n;
					_tmp9_ = (gchar*) xmlNodeGetContent (_tmp8_);
					_g_free0 (name);
					name = _tmp9_;
				} else {
					xmlAttr* _tmp10_;
					const gchar* _tmp11_;
					_tmp10_ = attribute;
					_tmp11_ = _tmp10_->name;
					if (g_strcmp0 (_tmp11_, "rate") == 0) {
						xmlNode* _tmp12_;
						gchar* _tmp13_;
						_tmp12_ = n;
						_tmp13_ = (gchar*) xmlNodeGetContent (_tmp12_);
						_g_free0 (value);
						value = _tmp13_;
					}
				}
			}
		}
	}
	_tmp16_ = name;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = value;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		Currency* _tmp19_;
		Currency* _tmp20_;
		_tmp18_ = name;
		_tmp19_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = _tmp20_ == NULL;
		_g_object_unref0 (_tmp20_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		Number* r = NULL;
		const gchar* _tmp23_;
		Number* _tmp24_;
		Currency* c = NULL;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		Number* _tmp29_;
		Number* _tmp30_;
		Number* _tmp31_;
		Currency* _tmp32_;
		Currency* _tmp33_;
		_tmp21_ = value;
		_tmp22_ = name;
		g_debug ("ecb-provider.vala:95: Using ECB rate of %s for %s", _tmp21_, _tmp22_);
		_tmp23_ = value;
		_tmp24_ = mp_set_from_string (_tmp23_, 10, TRUE);
		r = _tmp24_;
		_tmp25_ = name;
		_tmp26_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = r;
		_tmp30_ = number_multiply (eur_rate, _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp25_, _tmp28_, _tmp31_, date);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_g_free0 (_tmp28_);
		c = _tmp33_;
		_g_object_unref0 (c);
		_g_object_unref0 (r);
	}
	_g_free0 (value);
	_g_free0 (name);
}

static void
ecb_currency_provider_set_ecb_fixed_rate (EcbCurrencyProvider* self,
                                          const gchar* name,
                                          const gchar* value,
                                          Number* eur_rate,
                                          const gchar* date)
{
	Number* r = NULL;
	Number* _tmp0_;
	Currency* c = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Currency* _tmp8_;
	Currency* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (eur_rate != NULL);
	g_debug ("ecb-provider.vala:103: Using ECB fixed rate of %s for %s", value, name);
	_tmp0_ = mp_set_from_string (value, 10, TRUE);
	r = _tmp0_;
	_tmp1_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "#fixed", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_divide (eur_rate, r);
	_tmp7_ = _tmp6_;
	_tmp8_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, name, _tmp5_, _tmp7_, date);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	c = _tmp9_;
	_g_object_unref0 (c);
	_g_object_unref0 (r);
}

EcbCurrencyProvider*
ecb_currency_provider_construct (GType object_type,
                                 CurrencyManager* _currency_manager)
{
	EcbCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (EcbCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, "base-currency-symbol", "EUR", NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

EcbCurrencyProvider*
ecb_currency_provider_new (CurrencyManager* _currency_manager)
{
	return ecb_currency_provider_construct (TYPE_ECB_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
ecb_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "eurofxref-daily.xml", NULL);
	result = _tmp1_;
	return result;
}

static gchar*
ecb_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	gchar* _tmp0_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://exchange-api.gnome.org/ecb/eurofxref-daily.xml");
	result = _tmp0_;
	return result;
}

static gchar*
ecb_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	gchar* _tmp0_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml");
	result = _tmp0_;
	return result;
}

static const gchar*
ecb_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	EcbCurrencyProvider* self;
	self = (EcbCurrencyProvider*) base;
	result = _ ("European Central Bank");
	return result;
}

static gchar*
ecb_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	gchar* _tmp0_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_strdup ("ECB");
	result = _tmp0_;
	return result;
}

static void
ecb_currency_provider_class_init (EcbCurrencyProviderClass * klass,
                                  gpointer klass_data)
{
	ecb_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->parse_date = (GDateTime* (*) (AbstractCurrencyProvider*, const gchar*)) ecb_currency_provider_real_parse_date;
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (gboolean (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_ecb_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
ecb_currency_provider_instance_init (EcbCurrencyProvider * self,
                                     gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
ecb_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EcbCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ecb_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EcbCurrencyProvider), 0, (GInstanceInitFunc) ecb_currency_provider_instance_init, NULL };
	GType ecb_currency_provider_type_id;
	ecb_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "EcbCurrencyProvider", &g_define_type_info, 0);
	return ecb_currency_provider_type_id;
}

GType
ecb_currency_provider_get_type (void)
{
	static gsize ecb_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&ecb_currency_provider_type_id__once)) {
		GType ecb_currency_provider_type_id;
		ecb_currency_provider_type_id = ecb_currency_provider_get_type_once ();
		g_once_init_leave (&ecb_currency_provider_type_id__once, ecb_currency_provider_type_id);
	}
	return ecb_currency_provider_type_id__once;
}

static void
_vala_ecb_currency_provider_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	EcbCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ECB_CURRENCY_PROVIDER, EcbCurrencyProvider);
	switch (property_id) {
		case ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

