/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_annotator_alltoall = R"doc(All-to-all stream annotator testing block. FOR TESTING PURPOSES ONLY.

This block creates tags to be sent downstream every 10,000 items it sees. The tags contain the name and ID of the instantiated block, use \"seq\" as a key, and have a counter that increments by 1 for every tag produced that is used as the tag's value. The tags are propagated using the all-to-all policy.


It also stores a copy of all tags it sees flow past it. These tags can be recalled externally with the data() member.


This block is only meant for testing and showing how to use the tags.

Constructor Specific Documentation:



Args:
    when : 
    sizeof_stream_item : )doc";


static const char* __doc_gr_blocks_annotator_alltoall_annotator_alltoall_0 = R"doc()doc";


static const char* __doc_gr_blocks_annotator_alltoall_annotator_alltoall_1 = R"doc()doc";


static const char* __doc_gr_blocks_annotator_alltoall_make = R"doc(All-to-all stream annotator testing block. FOR TESTING PURPOSES ONLY.

This block creates tags to be sent downstream every 10,000 items it sees. The tags contain the name and ID of the instantiated block, use \"seq\" as a key, and have a counter that increments by 1 for every tag produced that is used as the tag's value. The tags are propagated using the all-to-all policy.


It also stores a copy of all tags it sees flow past it. These tags can be recalled externally with the data() member.


This block is only meant for testing and showing how to use the tags.

Constructor Specific Documentation:



Args:
    when : 
    sizeof_stream_item : )doc";


static const char* __doc_gr_blocks_annotator_alltoall_data = R"doc()doc";
