/*
 * Copyright 2021 Marcus Müller
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_rfnoc_graph = R"doc(GNU Radio-specific wrapper for uhd::rfnoc::rfnoc_graph


This wraps uhd::rfnoc::rfnoc_graph for simpler insertion into GNU Radio flow graphs. All API calls match those on said class.

Constructor Specific Documentation:



Args:
    dev_addr : )doc";

static const char* __doc_gr_uhd_rfnoc_graph_make = R"doc(GNU Radio-specific wrapper for uhd::rfnoc::rfnoc_graph


This wraps uhd::rfnoc::rfnoc_graph for simpler insertion into GNU Radio flow graphs. All API calls match those on said class.

Constructor Specific Documentation:



Args:
    dev_addr : )doc";

static const char* __doc_gr_uhd_rfnoc_graph_connect = R"doc(Connect two blocks, or a block to a streamer, or a streamer to a block.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_create_rx_streamer = R"doc(Create an RX streamer.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_create_tx_streamer = R"doc(Create a TX streamer.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_set_streamer_adapter_id = R"doc(Set the desired adapter ID for a streamer connection.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_commit = R"doc(Commit the graph and run initial checks.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_get_block_id = R"doc(Return a valid block ID string, if it exists, or an empty string, if not


This will check the available blocks on the connected devices and see if they match the block name, device ID, and block number.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_set_time_source = R"doc(Set time source on the specified motherboard.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_set_clock_source = R"doc(Set clock source on the specified motherboard.)doc";

static const char* __doc_gr_uhd_rfnoc_graph_get_block_ref = R"doc(Return a reference to the block with a given block ID.)doc";
