// Copyright Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: extensions/v1alpha1/wasm.proto

// $schema: istio.extensions.v1alpha1.WasmPlugin
// $title: Wasm Plugin
// $description: Extend the functionality provided by the Istio proxy through WebAssembly filters.
// $location: https://istio.io/docs/reference/config/proxy_extensions/wasm-plugin.html
// $aliases: [/docs/reference/config/extensions/v1alpha1/wasm-plugin]

// WasmPlugins provides a mechanism to extend the functionality provided by
// the Istio proxy through WebAssembly filters.
//
// The order of execution (as part of Envoy's filter chain) is determined by
// phase and priority settings, allowing the configuration of complex
// interactions between user-supplied WasmPlugins and Istio's internal
// filters.
//
// Examples:
//
// AuthN Filter deployed to ingress-gateway that implements an OpenID flow
// and populates the `Authorization` header with a JWT to be consumed by
// Istio AuthN.
//
// ```yaml
// apiVersion: extensions.istio.io/v1alpha1
// kind: WasmPlugin
// metadata:
//   name: openid-connect
//   namespace: istio-ingress
// spec:
//   selector:
//     matchLabels:
//       istio: ingressgateway
//   url: file:///opt/filters/openid.wasm
//   sha256: 1ef0c9a92b0420cf25f7fe5d481b231464bc88f486ca3b9c83ed5cc21d2f6210
//   phase: AUTHN
//   pluginConfig:
//     openid_server: authn
//     openid_realm: ingress
// ```
//
// This is the same as the last example, but using an OCI image.
//
// ```yaml
// apiVersion: extensions.istio.io/v1alpha1
// kind: WasmPlugin
// metadata:
//   name: openid-connect
//   namespace: istio-ingress
// spec:
//   selector:
//     matchLabels:
//       istio: ingressgateway
//   url: oci://private-registry:5000/openid-connect/openid:latest
//   imagePullPolicy: IfNotPresent
//   imagePullSecret: private-registry-pull-secret
//   phase: AUTHN
//   pluginConfig:
//     openid_server: authn
//     openid_realm: ingress
// ```
//
// This is the same as the last example, but using VmConfig to configure environment variables in the VM.
//
// ```yaml
// apiVersion: extensions.istio.io/v1alpha1
// kind: WasmPlugin
// metadata:
//   name: openid-connect
//   namespace: istio-ingress
// spec:
//   selector:
//     matchLabels:
//       istio: ingressgateway
//   url: oci://private-registry:5000/openid-connect/openid:latest
//   imagePullPolicy: IfNotPresent
//   imagePullSecret: private-registry-pull-secret
//   phase: AUTHN
//   pluginConfig:
//     openid_server: authn
//     openid_realm: ingress
//   vmConfig:
//     env:
//     - name: POD_NAME
//       valueFrom: HOST
//     - name: TRUST_DOMAIN
//       value: "cluster.local"
// ```
//
// This is also the same as the last example, but the Wasm module is pulled via https and updated for each time when this plugin resource is changed.
// ```yaml
// apiVersion: extensions.istio.io/v1alpha1
// kind: WasmPlugin
// metadata:
//   name: openid-connect
//   namespace: istio-ingress
// spec:
//   selector:
//     matchLabels:
//       istio: ingressgateway
//   url: https://private-bucket/filters/openid.wasm
//   imagePullPolicy: Always
//   phase: AUTHN
//   pluginConfig:
//     openid_server: authn
//     openid_realm: ingress
//   vmConfig:
//     env:
//     - name: POD_NAME
//       valueFrom: HOST
//     - name: TRUST_DOMAIN
//       value: "cluster.local"
// ```
//
// And a more complex example that deploys three WasmPlugins and orders them
// using `phase` and `priority`. The (hypothetical) setup is that the
// `openid-connect` filter performs an OpenID Connect flow to authenticate the
// user, writing a signed JWT into the Authorization header of the request,
// which can be verified by the Istio authn plugin. Then, the `acl-check` plugin
// kicks in, passing the JWT to a policy server, which in turn responds with a
// signed token that contains information about which files and functions of the
// system are available to the user that was previously authenticated. The
// `acl-check` filter writes this token to a header. Finally, the `check-header`
// filter verifies the token in that header and makes sure that the token's
// contents (the permitted 'function') matches its plugin configuration.
//
// The resulting filter chain looks like this:
// -> openid-connect -> istio.authn -> acl-check -> check-header -> router
//
// ```yaml
// apiVersion: extensions.istio.io/v1alpha1
// kind: WasmPlugin
// metadata:
//   name: openid-connect
//   namespace: istio-ingress
// spec:
//   selector:
//     matchLabels:
//       istio: ingressgateway
//   url: oci://private-registry:5000/openid-connect/openid:latest
//   imagePullPolicy: IfNotPresent
//   imagePullSecret: private-registry-pull-secret
//   phase: AUTHN
//   pluginConfig:
//     openid_server: authn
//     openid_realm: ingress
// ```
//
// ```yaml
// apiVersion: extensions.istio.io/v1alpha1
// kind: WasmPlugin
// metadata:
//   name: acl-check
//   namespace: istio-ingress
// spec:
//   selector:
//     matchLabels:
//       istio: ingressgateway
//   url: oci://private-registry:5000/acl-check/acl:latest
//   imagePullPolicy: Always
//   imagePullSecret: private-registry-pull-secret
//   phase: AUTHZ
//   priority: 1000
//   pluginConfig:
//     acl_server: some_server
//     set_header: authz_complete
// ```
//
// ```yaml
// apiVersion: extensions.istio.io/v1alpha1
// kind: WasmPlugin
// metadata:
//   name: check-header
//   namespace: istio-ingress
// spec:
//   selector:
//     matchLabels:
//       istio: ingressgateway
//   url: oci://private-registry:5000/check-header:latest
//   imagePullPolicy: IfNotPresent
//   imagePullSecret: private-registry-pull-secret
//   phase: AUTHZ
//   priority: 10
//   pluginConfig:
//     read_header: authz_complete
//     verification_key: a89gAzxvls0JKAKIJSBnnvvvkIO
//     function: read_data
// ```
//

package v1alpha1

import (
	_struct "github.com/golang/protobuf/ptypes/struct"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1beta1 "istio.io/api/type/v1beta1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PluginType indicates the type of Wasm extension to be used.
// There are two types of extensions: `HTTP` and `NETWORK`.
//
// The `HTTP` extension works at Layer 7 (for example, as an HTTP filter in Envoy).
// The detailed HTTP interface can be found here:
// - [C++](https://github.com/proxy-wasm/proxy-wasm-cpp-host/blob/b7e690703c7f26707438a2f1ebd7c197bc8f0296/include/proxy-wasm/context_interface.h#L199)
// - [Rust](https://github.com/proxy-wasm/proxy-wasm-rust-sdk/blob/6b47aec926bc29971c727471d6f4c972ec407c7f/src/traits.rs#L309)
//
// The `NETWORK` extension works at Layer 4 (for example, as a network filter in Envoy).
// The detailed `NETWORK` interface can be found here:
// - [C++](https://github.com/proxy-wasm/proxy-wasm-cpp-host/blob/b7e690703c7f26707438a2f1ebd7c197bc8f0296/include/proxy-wasm/context_interface.h#L257)
// - [Rust](https://github.com/proxy-wasm/proxy-wasm-rust-sdk/blob/6b47aec926bc29971c727471d6f4c972ec407c7f/src/traits.rs#L257)
//
// The `NETWORK` extension can be applied to HTTP traffic as well.
type PluginType int32

const (
	// Defaults to HTTP.
	PluginType_UNSPECIFIED_PLUGIN_TYPE PluginType = 0
	// Use HTTP Wasm Extension.
	PluginType_HTTP PluginType = 1
	// Use Network Wasm Extension.
	PluginType_NETWORK PluginType = 2
)

// Enum value maps for PluginType.
var (
	PluginType_name = map[int32]string{
		0: "UNSPECIFIED_PLUGIN_TYPE",
		1: "HTTP",
		2: "NETWORK",
	}
	PluginType_value = map[string]int32{
		"UNSPECIFIED_PLUGIN_TYPE": 0,
		"HTTP":                    1,
		"NETWORK":                 2,
	}
)

func (x PluginType) Enum() *PluginType {
	p := new(PluginType)
	*p = x
	return p
}

func (x PluginType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginType) Descriptor() protoreflect.EnumDescriptor {
	return file_extensions_v1alpha1_wasm_proto_enumTypes[0].Descriptor()
}

func (PluginType) Type() protoreflect.EnumType {
	return &file_extensions_v1alpha1_wasm_proto_enumTypes[0]
}

func (x PluginType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PluginType.Descriptor instead.
func (PluginType) EnumDescriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{0}
}

// The phase in the filter chain where the plugin will be injected.
type PluginPhase int32

const (
	// Control plane decides where to insert the plugin. This will generally
	// be at the end of the filter chain, right before the Router.
	// Do not specify `PluginPhase` if the plugin is independent of others.
	PluginPhase_UNSPECIFIED_PHASE PluginPhase = 0
	// Insert plugin before Istio authentication filters.
	PluginPhase_AUTHN PluginPhase = 1
	// Insert plugin before Istio authorization filters and after Istio authentication filters.
	PluginPhase_AUTHZ PluginPhase = 2
	// Insert plugin before Istio stats filters and after Istio authorization filters.
	PluginPhase_STATS PluginPhase = 3
)

// Enum value maps for PluginPhase.
var (
	PluginPhase_name = map[int32]string{
		0: "UNSPECIFIED_PHASE",
		1: "AUTHN",
		2: "AUTHZ",
		3: "STATS",
	}
	PluginPhase_value = map[string]int32{
		"UNSPECIFIED_PHASE": 0,
		"AUTHN":             1,
		"AUTHZ":             2,
		"STATS":             3,
	}
)

func (x PluginPhase) Enum() *PluginPhase {
	p := new(PluginPhase)
	*p = x
	return p
}

func (x PluginPhase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginPhase) Descriptor() protoreflect.EnumDescriptor {
	return file_extensions_v1alpha1_wasm_proto_enumTypes[1].Descriptor()
}

func (PluginPhase) Type() protoreflect.EnumType {
	return &file_extensions_v1alpha1_wasm_proto_enumTypes[1]
}

func (x PluginPhase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PluginPhase.Descriptor instead.
func (PluginPhase) EnumDescriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{1}
}

// The pull behaviour to be applied when fetching a Wam module,
// mirroring K8s behaviour.
//
// <!--
// buf:lint:ignore ENUM_VALUE_UPPER_SNAKE_CASE
// -->
type PullPolicy int32

const (
	// Defaults to `IfNotPresent`, except for OCI images with tag `latest`, for which
	// the default will be `Always`.
	PullPolicy_UNSPECIFIED_POLICY PullPolicy = 0
	// If an existing version of the image has been pulled before, that
	// will be used. If no version of the image is present locally, we
	// will pull the latest version.
	PullPolicy_IfNotPresent PullPolicy = 1
	// We will always pull the latest version of an image when changing
	// this plugin. Note that the change includes `metadata` field as well.
	PullPolicy_Always PullPolicy = 2
)

// Enum value maps for PullPolicy.
var (
	PullPolicy_name = map[int32]string{
		0: "UNSPECIFIED_POLICY",
		1: "IfNotPresent",
		2: "Always",
	}
	PullPolicy_value = map[string]int32{
		"UNSPECIFIED_POLICY": 0,
		"IfNotPresent":       1,
		"Always":             2,
	}
)

func (x PullPolicy) Enum() *PullPolicy {
	p := new(PullPolicy)
	*p = x
	return p
}

func (x PullPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PullPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_extensions_v1alpha1_wasm_proto_enumTypes[2].Descriptor()
}

func (PullPolicy) Type() protoreflect.EnumType {
	return &file_extensions_v1alpha1_wasm_proto_enumTypes[2]
}

func (x PullPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PullPolicy.Descriptor instead.
func (PullPolicy) EnumDescriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{2}
}

type EnvValueSource int32

const (
	// Explicitly given key-value pairs to be injected to this VM
	EnvValueSource_INLINE EnvValueSource = 0
	// Proxy environment variables exposed to this VM.
	EnvValueSource_HOST EnvValueSource = 1
)

// Enum value maps for EnvValueSource.
var (
	EnvValueSource_name = map[int32]string{
		0: "INLINE",
		1: "HOST",
	}
	EnvValueSource_value = map[string]int32{
		"INLINE": 0,
		"HOST":   1,
	}
)

func (x EnvValueSource) Enum() *EnvValueSource {
	p := new(EnvValueSource)
	*p = x
	return p
}

func (x EnvValueSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvValueSource) Descriptor() protoreflect.EnumDescriptor {
	return file_extensions_v1alpha1_wasm_proto_enumTypes[3].Descriptor()
}

func (EnvValueSource) Type() protoreflect.EnumType {
	return &file_extensions_v1alpha1_wasm_proto_enumTypes[3]
}

func (x EnvValueSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvValueSource.Descriptor instead.
func (EnvValueSource) EnumDescriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{3}
}

type FailStrategy int32

const (
	// A fatal error in the binary fetching or during the plugin execution causes
	// all subsequent requests to fail with 5xx.
	FailStrategy_FAIL_CLOSE FailStrategy = 0
	// Enables the fail open behavior for the Wasm plugin fatal errors to bypass
	// the plugin execution. A fatal error can be a failure to fetch the remote
	// binary, an exception, or abort() on the VM. This flag is not recommended
	// for the authentication or the authorization plugins.
	FailStrategy_FAIL_OPEN FailStrategy = 1
	// New plugin instance will be created for the new request if the Wasm plugin
	// has failed. This only applies for “proxy_wasm::FailState::RuntimeError“.
	// For all other error types this will fallback to “FAIL_CLOSED“.
	FailStrategy_FAIL_RELOAD FailStrategy = 2
)

// Enum value maps for FailStrategy.
var (
	FailStrategy_name = map[int32]string{
		0: "FAIL_CLOSE",
		1: "FAIL_OPEN",
		2: "FAIL_RELOAD",
	}
	FailStrategy_value = map[string]int32{
		"FAIL_CLOSE":  0,
		"FAIL_OPEN":   1,
		"FAIL_RELOAD": 2,
	}
)

func (x FailStrategy) Enum() *FailStrategy {
	p := new(FailStrategy)
	*p = x
	return p
}

func (x FailStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FailStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_extensions_v1alpha1_wasm_proto_enumTypes[4].Descriptor()
}

func (FailStrategy) Type() protoreflect.EnumType {
	return &file_extensions_v1alpha1_wasm_proto_enumTypes[4]
}

func (x FailStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FailStrategy.Descriptor instead.
func (FailStrategy) EnumDescriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{4}
}

// WasmPlugin provides a mechanism to extend the functionality provided by
// the Istio proxy through WebAssembly filters.
//
// <!-- crd generation tags
// +cue-gen:WasmPlugin:groupName:extensions.istio.io
// +cue-gen:WasmPlugin:versions:v1alpha1
// +cue-gen:WasmPlugin:storageVersion
// +cue-gen:WasmPlugin:annotations:helm.sh/resource-policy=keep
// +cue-gen:WasmPlugin:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:WasmPlugin:subresource:status
// +cue-gen:WasmPlugin:spec:required
// +cue-gen:WasmPlugin:scope:Namespaced
// +cue-gen:WasmPlugin:releaseChannel:extended
// +cue-gen:WasmPlugin:resource:categories=istio-io,extensions-istio-io
// +cue-gen:WasmPlugin:preserveUnknownFields:pluginConfig
// +cue-gen:WasmPlugin:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=extensions.istio.io/v1alpha1
// +genclient
// +k8s:deepcopy-gen=true
// -->
// +kubebuilder:validation:XValidation:message="only one of targetRefs or selector can be set",rule="oneof(self.selector, self.targetRef, self.targetRefs)"
type WasmPlugin struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Criteria used to select the specific set of pods/VMs on which
	// this plugin configuration should be applied. If omitted, this
	// configuration will be applied to all workload instances in the same
	// namespace. If the `WasmPlugin` is present in the config root
	// namespace, it will be applied to all applicable workloads in any
	// namespace.
	//
	// At most, only one of `selector` or `targetRefs` can be set for a given policy.
	Selector *v1beta1.WorkloadSelector `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// $hide_from_docs
	TargetRef *v1beta1.PolicyTargetReference `protobuf:"bytes,15,opt,name=targetRef,proto3" json:"targetRef,omitempty"`
	// Optional. The targetRefs specifies a list of resources the policy should be
	// applied to. The targeted resources specified will determine which workloads
	// the policy applies to.
	//
	// Currently, the following resource attachment types are supported:
	// * `kind: Gateway` with `group: gateway.networking.k8s.io` in the same namespace.
	// * `kind: GatewayClass` with `group: gateway.networking.k8s.io` in the root namespace.
	// * `kind: Service` with `group: ""` or `group: "core"` in the same namespace. This type is only supported for waypoints.
	// * `kind: ServiceEntry` with `group: networking.istio.io` in the same namespace.
	//
	// If not set, the policy is applied as defined by the selector.
	// At most one of the selector and targetRefs can be set.
	//
	// NOTE: If you are using the `targetRefs` field in a multi-revision environment with Istio versions prior to 1.22,
	// it is highly recommended that you pin the policy to a revision running 1.22+ via the `istio.io/rev` label.
	// This is to prevent proxies connected to older control planes (that don't know about the `targetRefs` field)
	// from misinterpreting the policy as namespace-wide during the upgrade process.
	//
	// NOTE: Waypoint proxies are required to use this field for policies to apply; `selector` policies will be ignored.
	// +kubebuilder:validation:MaxItems=16
	TargetRefs []*v1beta1.PolicyTargetReference `protobuf:"bytes,16,rep,name=targetRefs,proto3" json:"targetRefs,omitempty"`
	// URL of a Wasm module or OCI container. If no scheme is present,
	// defaults to `oci://`, referencing an OCI image. Other valid schemes
	// are `file://` for referencing .wasm module files present locally
	// within the proxy container, and `http[s]://` for `.wasm` module files
	// hosted remotely.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:XValidation:message="url must have schema one of [http, https, file, oci]",rule="isURL(self) ? (url(self).getScheme() in [”, 'http', 'https', 'oci', 'file']) : (isURL('http://' + self) && url('http://' +self).getScheme() in [”, 'http', 'https', 'oci', 'file'])"
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// SHA256 checksum that will be used to verify Wasm module or OCI container.
	// If the `url` field already references a SHA256 (using the `@sha256:`
	// notation), it must match the value of this field. If an OCI image is
	// referenced by tag and this field is set, its checksum will be verified
	// against the contents of this field after pulling.
	// +kubebuilder:validation:Pattern="(^$|^[a-f0-9]{64}$)"
	Sha256 string `protobuf:"bytes,3,opt,name=sha256,proto3" json:"sha256,omitempty"`
	// The pull behaviour to be applied when fetching Wasm module by either
	// OCI image or `http/https`. Only relevant when referencing Wasm module without
	// any digest, including the digest in OCI image URL or `sha256` field in `vm_config`.
	// Defaults to `IfNotPresent`, except when an OCI image is referenced in the `url`
	// and the `latest` tag is used, in which case `Always` is the default,
	// mirroring Kubernetes behaviour.
	ImagePullPolicy PullPolicy `protobuf:"varint,4,opt,name=image_pull_policy,json=imagePullPolicy,proto3,enum=istio.extensions.v1alpha1.PullPolicy" json:"image_pull_policy,omitempty"`
	// Credentials to use for OCI image pulling.
	// Name of a Kubernetes Secret in the same namespace as the `WasmPlugin` that
	// contains a Docker pull secret which is to be used to authenticate
	// against the registry when pulling the image.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=253
	ImagePullSecret string `protobuf:"bytes,5,opt,name=image_pull_secret,json=imagePullSecret,proto3" json:"image_pull_secret,omitempty"`
	// $hide_from_docs
	// Public key that will be used to verify signatures of signed OCI images
	// or Wasm modules.
	//
	// At this moment, various ways for signing/verifying are emerging and being proposed.
	// We can observe two major streams for signing OCI images: Cosign from Sigstore and Notary,
	// which is used in Docker Content Trust.
	// In case of Wasm module, multiple approaches are still in discussion.
	//   - https://github.com/WebAssembly/design/issues/1413
	//   - https://github.com/wasm-signatures/design (various signing tools are enumerated)
	//
	// In addition, for each method for signing&verifying, we may need to consider to provide
	// additional data or configuration (e.g., key rolling, KMS, root certs, ...) as well.
	//
	// To deal with this situation, we need to elaborate more generic way to describe
	// how to sign and verify the image or wasm binary, and how to specify relevant data,
	// including this `verification_key`.
	//
	// Therefore, this field will not be implemented until the detailed design is established.
	// For the future use, just keep this field in proto and hide from documentation.
	VerificationKey string `protobuf:"bytes,6,opt,name=verification_key,json=verificationKey,proto3" json:"verification_key,omitempty"`
	// The configuration that will be passed on to the plugin.
	PluginConfig *_struct.Struct `protobuf:"bytes,7,opt,name=plugin_config,json=pluginConfig,proto3" json:"plugin_config,omitempty"`
	// The plugin name to be used in the Envoy configuration (used to be called
	// `rootID`). Some .wasm modules might require this value to select the Wasm
	// plugin to execute.
	// +kubebuilder:validation:MaxLength=256
	// +kubebuilder:validation:MinLength=1
	PluginName string `protobuf:"bytes,8,opt,name=plugin_name,json=pluginName,proto3" json:"plugin_name,omitempty"`
	// Determines where in the filter chain this `WasmPlugin` is to be injected.
	Phase PluginPhase `protobuf:"varint,9,opt,name=phase,proto3,enum=istio.extensions.v1alpha1.PluginPhase" json:"phase,omitempty"`
	// Determines ordering of `WasmPlugins` in the same `phase`.
	// When multiple `WasmPlugins` are applied to the same workload in the
	// same `phase`, they will be applied by priority, in descending order.
	// If `priority` is not set, or two `WasmPlugins` exist with the same
	// value, the ordering will be deterministically derived from name and
	// namespace of the `WasmPlugins`. Defaults to `0`.
	Priority *wrappers.Int32Value `protobuf:"bytes,10,opt,name=priority,proto3" json:"priority,omitempty"`
	// Specifies the failure behavior for the plugin due to fatal errors.
	FailStrategy FailStrategy `protobuf:"varint,13,opt,name=fail_strategy,json=failStrategy,proto3,enum=istio.extensions.v1alpha1.FailStrategy" json:"fail_strategy,omitempty"`
	// Configuration for a Wasm VM.
	// More details can be found [here](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/wasm/v3/wasm.proto#extensions-wasm-v3-vmconfig).
	VmConfig *VmConfig `protobuf:"bytes,11,opt,name=vm_config,json=vmConfig,proto3" json:"vm_config,omitempty"`
	// Specifies the criteria to determine which traffic is passed to WasmPlugin.
	// If a traffic satisfies any of TrafficSelectors,
	// the traffic passes the WasmPlugin.
	Match []*WasmPlugin_TrafficSelector `protobuf:"bytes,12,rep,name=match,proto3" json:"match,omitempty"`
	// Specifies the type of Wasm Extension to be used.
	Type          PluginType `protobuf:"varint,14,opt,name=type,proto3,enum=istio.extensions.v1alpha1.PluginType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WasmPlugin) Reset() {
	*x = WasmPlugin{}
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WasmPlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WasmPlugin) ProtoMessage() {}

func (x *WasmPlugin) ProtoReflect() protoreflect.Message {
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WasmPlugin.ProtoReflect.Descriptor instead.
func (*WasmPlugin) Descriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{0}
}

func (x *WasmPlugin) GetSelector() *v1beta1.WorkloadSelector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *WasmPlugin) GetTargetRef() *v1beta1.PolicyTargetReference {
	if x != nil {
		return x.TargetRef
	}
	return nil
}

func (x *WasmPlugin) GetTargetRefs() []*v1beta1.PolicyTargetReference {
	if x != nil {
		return x.TargetRefs
	}
	return nil
}

func (x *WasmPlugin) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *WasmPlugin) GetSha256() string {
	if x != nil {
		return x.Sha256
	}
	return ""
}

func (x *WasmPlugin) GetImagePullPolicy() PullPolicy {
	if x != nil {
		return x.ImagePullPolicy
	}
	return PullPolicy_UNSPECIFIED_POLICY
}

func (x *WasmPlugin) GetImagePullSecret() string {
	if x != nil {
		return x.ImagePullSecret
	}
	return ""
}

func (x *WasmPlugin) GetVerificationKey() string {
	if x != nil {
		return x.VerificationKey
	}
	return ""
}

func (x *WasmPlugin) GetPluginConfig() *_struct.Struct {
	if x != nil {
		return x.PluginConfig
	}
	return nil
}

func (x *WasmPlugin) GetPluginName() string {
	if x != nil {
		return x.PluginName
	}
	return ""
}

func (x *WasmPlugin) GetPhase() PluginPhase {
	if x != nil {
		return x.Phase
	}
	return PluginPhase_UNSPECIFIED_PHASE
}

func (x *WasmPlugin) GetPriority() *wrappers.Int32Value {
	if x != nil {
		return x.Priority
	}
	return nil
}

func (x *WasmPlugin) GetFailStrategy() FailStrategy {
	if x != nil {
		return x.FailStrategy
	}
	return FailStrategy_FAIL_CLOSE
}

func (x *WasmPlugin) GetVmConfig() *VmConfig {
	if x != nil {
		return x.VmConfig
	}
	return nil
}

func (x *WasmPlugin) GetMatch() []*WasmPlugin_TrafficSelector {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *WasmPlugin) GetType() PluginType {
	if x != nil {
		return x.Type
	}
	return PluginType_UNSPECIFIED_PLUGIN_TYPE
}

// Configuration for a Wasm VM.
// more details can be found [here](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/wasm/v3/wasm.proto#extensions-wasm-v3-vmconfig).
type VmConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies environment variables to be injected to this VM.
	// Note that if a key does not exist, it will be ignored.
	// +kubebuilder:validation:MaxItems=256
	// +listType=map
	// +listMapKey=name
	Env           []*EnvVar `protobuf:"bytes,1,rep,name=env,proto3" json:"env,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VmConfig) Reset() {
	*x = VmConfig{}
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmConfig) ProtoMessage() {}

func (x *VmConfig) ProtoReflect() protoreflect.Message {
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmConfig.ProtoReflect.Descriptor instead.
func (*VmConfig) Descriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{1}
}

func (x *VmConfig) GetEnv() []*EnvVar {
	if x != nil {
		return x.Env
	}
	return nil
}

// +kubebuilder:validation:XValidation:message="value may only be set when valueFrom is INLINE",rule="default(self.valueFrom, ”) != 'HOST' || !has(self.value)"
type EnvVar struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the environment variable.
	// Must be a C_IDENTIFIER.
	// +kubebuilder:validation:MaxLength=256
	// +kubebuilder:validation:MinLength=1
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Source for the environment variable's value.
	ValueFrom EnvValueSource `protobuf:"varint,3,opt,name=value_from,json=valueFrom,proto3,enum=istio.extensions.v1alpha1.EnvValueSource" json:"value_from,omitempty"`
	// Value for the environment variable.
	// Only applicable if `valueFrom` is `HOST`.
	// Defaults to "".
	// +kubebuilder:validation:MaxLength=2048
	Value         string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnvVar) Reset() {
	*x = EnvVar{}
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnvVar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvVar) ProtoMessage() {}

func (x *EnvVar) ProtoReflect() protoreflect.Message {
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvVar.ProtoReflect.Descriptor instead.
func (*EnvVar) Descriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{2}
}

func (x *EnvVar) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnvVar) GetValueFrom() EnvValueSource {
	if x != nil {
		return x.ValueFrom
	}
	return EnvValueSource_INLINE
}

func (x *EnvVar) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// TrafficSelector provides a mechanism to select a specific traffic flow
// for which this Wasm Plugin will be enabled.
// When all the sub conditions in the TrafficSelector are satisfied, the
// traffic will be selected.
type WasmPlugin_TrafficSelector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Criteria for selecting traffic by their direction.
	// Note that `CLIENT` and `SERVER` are analogous to OUTBOUND and INBOUND,
	// respectively.
	// For the gateway, the field should be `CLIENT` or `CLIENT_AND_SERVER`.
	// If not specified, the default value is `CLIENT_AND_SERVER`.
	Mode v1beta1.WorkloadMode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.type.v1beta1.WorkloadMode" json:"mode,omitempty"`
	// Criteria for selecting traffic by their destination port.
	// More specifically, for the outbound traffic, the destination port would be
	// the port of the target service. On the other hand, for the inbound traffic,
	// the destination port is the port bound by the server process in the same Pod.
	//
	// If one of the given `ports` is matched, this condition is evaluated to true.
	// If not specified, this condition is evaluated to true for any port.
	// +listType=map
	// +listMapKey=number
	Ports         []*v1beta1.PortSelector `protobuf:"bytes,2,rep,name=ports,proto3" json:"ports,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WasmPlugin_TrafficSelector) Reset() {
	*x = WasmPlugin_TrafficSelector{}
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WasmPlugin_TrafficSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WasmPlugin_TrafficSelector) ProtoMessage() {}

func (x *WasmPlugin_TrafficSelector) ProtoReflect() protoreflect.Message {
	mi := &file_extensions_v1alpha1_wasm_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WasmPlugin_TrafficSelector.ProtoReflect.Descriptor instead.
func (*WasmPlugin_TrafficSelector) Descriptor() ([]byte, []int) {
	return file_extensions_v1alpha1_wasm_proto_rawDescGZIP(), []int{0, 0}
}

func (x *WasmPlugin_TrafficSelector) GetMode() v1beta1.WorkloadMode {
	if x != nil {
		return x.Mode
	}
	return v1beta1.WorkloadMode(0)
}

func (x *WasmPlugin_TrafficSelector) GetPorts() []*v1beta1.PortSelector {
	if x != nil {
		return x.Ports
	}
	return nil
}

var File_extensions_v1alpha1_wasm_proto protoreflect.FileDescriptor

const file_extensions_v1alpha1_wasm_proto_rawDesc = "" +
	"\n" +
	"\x1eextensions/v1alpha1/wasm.proto\x12\x19istio.extensions.v1alpha1\x1a\x1fgoogle/api/field_behavior.proto\x1a\x1cgoogle/protobuf/struct.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1btype/v1beta1/selector.proto\"\xab\b\n" +
	"\n" +
	"WasmPlugin\x12@\n" +
	"\bselector\x18\x01 \x01(\v2$.istio.type.v1beta1.WorkloadSelectorR\bselector\x12G\n" +
	"\ttargetRef\x18\x0f \x01(\v2).istio.type.v1beta1.PolicyTargetReferenceR\ttargetRef\x12I\n" +
	"\n" +
	"targetRefs\x18\x10 \x03(\v2).istio.type.v1beta1.PolicyTargetReferenceR\n" +
	"targetRefs\x12\x16\n" +
	"\x03url\x18\x02 \x01(\tB\x04\xe2A\x01\x02R\x03url\x12\x16\n" +
	"\x06sha256\x18\x03 \x01(\tR\x06sha256\x12Q\n" +
	"\x11image_pull_policy\x18\x04 \x01(\x0e2%.istio.extensions.v1alpha1.PullPolicyR\x0fimagePullPolicy\x12*\n" +
	"\x11image_pull_secret\x18\x05 \x01(\tR\x0fimagePullSecret\x12)\n" +
	"\x10verification_key\x18\x06 \x01(\tR\x0fverificationKey\x12<\n" +
	"\rplugin_config\x18\a \x01(\v2\x17.google.protobuf.StructR\fpluginConfig\x12\x1f\n" +
	"\vplugin_name\x18\b \x01(\tR\n" +
	"pluginName\x12<\n" +
	"\x05phase\x18\t \x01(\x0e2&.istio.extensions.v1alpha1.PluginPhaseR\x05phase\x127\n" +
	"\bpriority\x18\n" +
	" \x01(\v2\x1b.google.protobuf.Int32ValueR\bpriority\x12L\n" +
	"\rfail_strategy\x18\r \x01(\x0e2'.istio.extensions.v1alpha1.FailStrategyR\ffailStrategy\x12@\n" +
	"\tvm_config\x18\v \x01(\v2#.istio.extensions.v1alpha1.VmConfigR\bvmConfig\x12K\n" +
	"\x05match\x18\f \x03(\v25.istio.extensions.v1alpha1.WasmPlugin.TrafficSelectorR\x05match\x129\n" +
	"\x04type\x18\x0e \x01(\x0e2%.istio.extensions.v1alpha1.PluginTypeR\x04type\x1a\x7f\n" +
	"\x0fTrafficSelector\x124\n" +
	"\x04mode\x18\x01 \x01(\x0e2 .istio.type.v1beta1.WorkloadModeR\x04mode\x126\n" +
	"\x05ports\x18\x02 \x03(\v2 .istio.type.v1beta1.PortSelectorR\x05ports\"?\n" +
	"\bVmConfig\x123\n" +
	"\x03env\x18\x01 \x03(\v2!.istio.extensions.v1alpha1.EnvVarR\x03env\"\x82\x01\n" +
	"\x06EnvVar\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12H\n" +
	"\n" +
	"value_from\x18\x03 \x01(\x0e2).istio.extensions.v1alpha1.EnvValueSourceR\tvalueFrom\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value*@\n" +
	"\n" +
	"PluginType\x12\x1b\n" +
	"\x17UNSPECIFIED_PLUGIN_TYPE\x10\x00\x12\b\n" +
	"\x04HTTP\x10\x01\x12\v\n" +
	"\aNETWORK\x10\x02*E\n" +
	"\vPluginPhase\x12\x15\n" +
	"\x11UNSPECIFIED_PHASE\x10\x00\x12\t\n" +
	"\x05AUTHN\x10\x01\x12\t\n" +
	"\x05AUTHZ\x10\x02\x12\t\n" +
	"\x05STATS\x10\x03*B\n" +
	"\n" +
	"PullPolicy\x12\x16\n" +
	"\x12UNSPECIFIED_POLICY\x10\x00\x12\x10\n" +
	"\fIfNotPresent\x10\x01\x12\n" +
	"\n" +
	"\x06Always\x10\x02*&\n" +
	"\x0eEnvValueSource\x12\n" +
	"\n" +
	"\x06INLINE\x10\x00\x12\b\n" +
	"\x04HOST\x10\x01*>\n" +
	"\fFailStrategy\x12\x0e\n" +
	"\n" +
	"FAIL_CLOSE\x10\x00\x12\r\n" +
	"\tFAIL_OPEN\x10\x01\x12\x0f\n" +
	"\vFAIL_RELOAD\x10\x02B\"Z istio.io/api/extensions/v1alpha1b\x06proto3"

var (
	file_extensions_v1alpha1_wasm_proto_rawDescOnce sync.Once
	file_extensions_v1alpha1_wasm_proto_rawDescData []byte
)

func file_extensions_v1alpha1_wasm_proto_rawDescGZIP() []byte {
	file_extensions_v1alpha1_wasm_proto_rawDescOnce.Do(func() {
		file_extensions_v1alpha1_wasm_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_extensions_v1alpha1_wasm_proto_rawDesc), len(file_extensions_v1alpha1_wasm_proto_rawDesc)))
	})
	return file_extensions_v1alpha1_wasm_proto_rawDescData
}

var file_extensions_v1alpha1_wasm_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_extensions_v1alpha1_wasm_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_extensions_v1alpha1_wasm_proto_goTypes = []any{
	(PluginType)(0),                       // 0: istio.extensions.v1alpha1.PluginType
	(PluginPhase)(0),                      // 1: istio.extensions.v1alpha1.PluginPhase
	(PullPolicy)(0),                       // 2: istio.extensions.v1alpha1.PullPolicy
	(EnvValueSource)(0),                   // 3: istio.extensions.v1alpha1.EnvValueSource
	(FailStrategy)(0),                     // 4: istio.extensions.v1alpha1.FailStrategy
	(*WasmPlugin)(nil),                    // 5: istio.extensions.v1alpha1.WasmPlugin
	(*VmConfig)(nil),                      // 6: istio.extensions.v1alpha1.VmConfig
	(*EnvVar)(nil),                        // 7: istio.extensions.v1alpha1.EnvVar
	(*WasmPlugin_TrafficSelector)(nil),    // 8: istio.extensions.v1alpha1.WasmPlugin.TrafficSelector
	(*v1beta1.WorkloadSelector)(nil),      // 9: istio.type.v1beta1.WorkloadSelector
	(*v1beta1.PolicyTargetReference)(nil), // 10: istio.type.v1beta1.PolicyTargetReference
	(*_struct.Struct)(nil),                // 11: google.protobuf.Struct
	(*wrappers.Int32Value)(nil),           // 12: google.protobuf.Int32Value
	(v1beta1.WorkloadMode)(0),             // 13: istio.type.v1beta1.WorkloadMode
	(*v1beta1.PortSelector)(nil),          // 14: istio.type.v1beta1.PortSelector
}
var file_extensions_v1alpha1_wasm_proto_depIdxs = []int32{
	9,  // 0: istio.extensions.v1alpha1.WasmPlugin.selector:type_name -> istio.type.v1beta1.WorkloadSelector
	10, // 1: istio.extensions.v1alpha1.WasmPlugin.targetRef:type_name -> istio.type.v1beta1.PolicyTargetReference
	10, // 2: istio.extensions.v1alpha1.WasmPlugin.targetRefs:type_name -> istio.type.v1beta1.PolicyTargetReference
	2,  // 3: istio.extensions.v1alpha1.WasmPlugin.image_pull_policy:type_name -> istio.extensions.v1alpha1.PullPolicy
	11, // 4: istio.extensions.v1alpha1.WasmPlugin.plugin_config:type_name -> google.protobuf.Struct
	1,  // 5: istio.extensions.v1alpha1.WasmPlugin.phase:type_name -> istio.extensions.v1alpha1.PluginPhase
	12, // 6: istio.extensions.v1alpha1.WasmPlugin.priority:type_name -> google.protobuf.Int32Value
	4,  // 7: istio.extensions.v1alpha1.WasmPlugin.fail_strategy:type_name -> istio.extensions.v1alpha1.FailStrategy
	6,  // 8: istio.extensions.v1alpha1.WasmPlugin.vm_config:type_name -> istio.extensions.v1alpha1.VmConfig
	8,  // 9: istio.extensions.v1alpha1.WasmPlugin.match:type_name -> istio.extensions.v1alpha1.WasmPlugin.TrafficSelector
	0,  // 10: istio.extensions.v1alpha1.WasmPlugin.type:type_name -> istio.extensions.v1alpha1.PluginType
	7,  // 11: istio.extensions.v1alpha1.VmConfig.env:type_name -> istio.extensions.v1alpha1.EnvVar
	3,  // 12: istio.extensions.v1alpha1.EnvVar.value_from:type_name -> istio.extensions.v1alpha1.EnvValueSource
	13, // 13: istio.extensions.v1alpha1.WasmPlugin.TrafficSelector.mode:type_name -> istio.type.v1beta1.WorkloadMode
	14, // 14: istio.extensions.v1alpha1.WasmPlugin.TrafficSelector.ports:type_name -> istio.type.v1beta1.PortSelector
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_extensions_v1alpha1_wasm_proto_init() }
func file_extensions_v1alpha1_wasm_proto_init() {
	if File_extensions_v1alpha1_wasm_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_extensions_v1alpha1_wasm_proto_rawDesc), len(file_extensions_v1alpha1_wasm_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_extensions_v1alpha1_wasm_proto_goTypes,
		DependencyIndexes: file_extensions_v1alpha1_wasm_proto_depIdxs,
		EnumInfos:         file_extensions_v1alpha1_wasm_proto_enumTypes,
		MessageInfos:      file_extensions_v1alpha1_wasm_proto_msgTypes,
	}.Build()
	File_extensions_v1alpha1_wasm_proto = out.File
	file_extensions_v1alpha1_wasm_proto_goTypes = nil
	file_extensions_v1alpha1_wasm_proto_depIdxs = nil
}
