/* shutdown-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from shutdown-dialog.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Marco Trevisan <marco.trevisan@canonical.com>
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <lightdm.h>
#include "config.h"
#include <atk/atk.h>

#define SHUTDOWN_DIALOG_BORDER_SIZE 30
#define SHUTDOWN_DIALOG_BORDER_INTERNAL_SIZE 10
#define SHUTDOWN_DIALOG_BORDER_EXTERNAL_SIZE (SHUTDOWN_DIALOG_BORDER_SIZE - SHUTDOWN_DIALOG_BORDER_INTERNAL_SIZE)
#define SHUTDOWN_DIALOG_CLOSE_OFFSET 3
#define SHUTDOWN_DIALOG_BUTTON_TEXT_SPACE 9
#define SHUTDOWN_DIALOG_BLUR_RADIUS 8
#define ANIMATE_TIMER_INSTANT 150
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SHUTDOWN_DIALOG_TYPE_LOGOUT,
	SHUTDOWN_DIALOG_TYPE_SHUTDOWN,
	SHUTDOWN_DIALOG_TYPE_RESTART
} ShutdownDialogType;

#define TYPE_SHUTDOWN_DIALOG_TYPE (shutdown_dialog_type_get_type ())

#define TYPE_SHUTDOWN_DIALOG (shutdown_dialog_get_type ())
#define SHUTDOWN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHUTDOWN_DIALOG, ShutdownDialog))
#define SHUTDOWN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHUTDOWN_DIALOG, ShutdownDialogClass))
#define IS_SHUTDOWN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHUTDOWN_DIALOG))
#define IS_SHUTDOWN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHUTDOWN_DIALOG))
#define SHUTDOWN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHUTDOWN_DIALOG, ShutdownDialogClass))

typedef struct _ShutdownDialog ShutdownDialog;
typedef struct _ShutdownDialogClass ShutdownDialogClass;
typedef struct _ShutdownDialogPrivate ShutdownDialogPrivate;

#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_DIALOG_BUTTON (dialog_button_get_type ())
#define DIALOG_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIALOG_BUTTON, DialogButton))
#define DIALOG_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIALOG_BUTTON, DialogButtonClass))
#define IS_DIALOG_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIALOG_BUTTON))
#define IS_DIALOG_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIALOG_BUTTON))
#define DIALOG_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIALOG_BUTTON, DialogButtonClass))

typedef struct _DialogButton DialogButton;
typedef struct _DialogButtonClass DialogButtonClass;

#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;
enum  {
	SHUTDOWN_DIALOG_0_PROPERTY,
	SHUTDOWN_DIALOG_NUM_PROPERTIES
};
static GParamSpec* shutdown_dialog_properties[SHUTDOWN_DIALOG_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _monitor_unref0(var) ((var == NULL) ? NULL : (var = (monitor_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef gdouble (*AnimateTimerEasingFunc) (gdouble x, gpointer user_data);
typedef struct _Block9Data Block9Data;
typedef struct _MonitorPrivate MonitorPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
enum  {
	SHUTDOWN_DIALOG_CLOSED_SIGNAL,
	SHUTDOWN_DIALOG_NUM_SIGNALS
};
static guint shutdown_dialog_signals[SHUTDOWN_DIALOG_NUM_SIGNALS] = {0};
typedef struct _DialogButtonPrivate DialogButtonPrivate;
enum  {
	DIALOG_BUTTON_0_PROPERTY,
	DIALOG_BUTTON_NUM_PROPERTIES
};
static GParamSpec* dialog_button_properties[DIALOG_BUTTON_NUM_PROPERTIES];

struct _ShutdownDialog {
	GtkFixed parent_instance;
	ShutdownDialogPrivate * priv;
};

struct _ShutdownDialogClass {
	GtkFixedClass parent_class;
};

struct _ShutdownDialogPrivate {
	cairo_surface_t* bg_surface;
	cairo_surface_t* corner_surface;
	cairo_surface_t* left_surface;
	cairo_surface_t* top_surface;
	cairo_pattern_t* corner_pattern;
	cairo_pattern_t* left_pattern;
	cairo_pattern_t* top_pattern;
	Monitor* monitor;
	Background* background;
	GdkRGBA avg_color;
	GtkBox* vbox;
	DialogButton* close_button;
	GtkBox* button_box;
	GtkEventBox* monitor_events;
	GtkEventBox* vbox_events;
	AnimateTimer* animation;
	gboolean closing;
};

struct _Block8Data {
	int _ref_count_;
	ShutdownDialog* self;
	DialogButton* button;
};

struct _Block9Data {
	int _ref_count_;
	ShutdownDialog* self;
	gdouble start_value;
};

struct _Monitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _MonitorClass {
	GTypeClass parent_class;
	void (*finalize) (Monitor *self);
};

struct _DialogButton {
	GtkButton parent_instance;
	DialogButtonPrivate * priv;
};

struct _DialogButtonClass {
	GtkButtonClass parent_class;
};

struct _DialogButtonPrivate {
	gchar* inactive_filename;
	gchar* focused_filename;
	gchar* active_filename;
	GtkImage* i;
	GtkLabel* l;
};

static gint ShutdownDialog_private_offset;
static gpointer shutdown_dialog_parent_class = NULL;
static gint DialogButton_private_offset;
static gpointer dialog_button_parent_class = NULL;

VALA_EXTERN GType shutdown_dialog_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType shutdown_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShutdownDialog, g_object_unref)
VALA_EXTERN gpointer monitor_ref (gpointer instance);
VALA_EXTERN void monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_monitor (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_monitor (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_monitor (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_monitor (const GValue* value);
VALA_EXTERN GType monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitor, monitor_unref)
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
VALA_EXTERN GType dialog_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DialogButton, g_object_unref)
VALA_EXTERN GType animate_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimateTimer, g_object_unref)
VALA_EXTERN ShutdownDialog* shutdown_dialog_new (ShutdownDialogType type,
                                     Background* bg);
VALA_EXTERN ShutdownDialog* shutdown_dialog_construct (GType object_type,
                                           ShutdownDialogType type,
                                           Background* bg);
static void shutdown_dialog_rebuild_background (ShutdownDialog* self);
static void _shutdown_dialog_rebuild_background_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void shutdown_dialog_update_background_color (ShutdownDialog* self);
static void _shutdown_dialog_update_background_color_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static gboolean __lambda8_ (ShutdownDialog* self);
VALA_EXTERN void shutdown_dialog_close (ShutdownDialog* self);
static gboolean ___lambda8__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static gboolean __lambda11_ (ShutdownDialog* self);
static gboolean ___lambda11__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static DialogButton* shutdown_dialog_add_button (ShutdownDialog* self,
                                          const gchar* text,
                                          const gchar* inactive_filename,
                                          const gchar* active_filename);
static void ____lambda12_ (ShutdownDialog* self);
static void _____lambda12__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static void ____lambda13_ (ShutdownDialog* self);
static void _____lambda13__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static void ___lambda14_ (ShutdownDialog* self);
static void ____lambda14__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ___lambda15_ (ShutdownDialog* self);
static void ____lambda15__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ____lambda16_ (Block8Data* _data8_);
static void _____lambda16__gtk_widget_show (GtkWidget* _sender,
                                     gpointer self);
VALA_EXTERN DialogButton* dialog_button_new (const gchar* inactive_filename,
                                 const gchar* focused_filename,
                                 const gchar* active_filename,
                                 GtkLabel* label);
VALA_EXTERN DialogButton* dialog_button_construct (GType object_type,
                                       const gchar* inactive_filename,
                                       const gchar* focused_filename,
                                       const gchar* active_filename,
                                       GtkLabel* label);
static void __lambda17_ (ShutdownDialog* self);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gdouble __lambda18_ (ShutdownDialog* self,
                     gdouble x);
static gdouble ___lambda18__animate_timer_easing_func (gdouble x,
                                                gpointer self);
VALA_EXTERN AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func,
                                 gpointer func_target,
                                 gint speed);
VALA_EXTERN AnimateTimer* animate_timer_construct (GType object_type,
                                       AnimateTimerEasingFunc func,
                                       gpointer func_target,
                                       gint speed);
static void __lambda19_ (ShutdownDialog* self);
static void ___lambda19__animate_timer_animate (AnimateTimer* _sender,
                                         gdouble progress,
                                         gpointer self);
static void __lambda20_ (ShutdownDialog* self);
VALA_EXTERN void animate_timer_reset (AnimateTimer* self,
                          gint temp_speed);
static void ___lambda20__gtk_widget_show (GtkWidget* _sender,
                                   gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
VALA_EXTERN gdouble animate_timer_get_progress (AnimateTimer* self);
static gdouble __lambda9_ (Block9Data* _data9_,
                    gdouble x);
static gdouble ___lambda9__animate_timer_easing_func (gdouble x,
                                               gpointer self);
static void __lambda10_ (ShutdownDialog* self,
                  gdouble p);
VALA_EXTERN void animate_timer_stop (AnimateTimer* self);
static void ___lambda10__animate_timer_animate (AnimateTimer* _sender,
                                         gdouble progress,
                                         gpointer self);
VALA_EXTERN void background_get_average_color (Background* self,
                                   GdkRGBA * result);
VALA_EXTERN void shutdown_dialog_set_active_monitor (ShutdownDialog* self,
                                         Monitor* m);
VALA_EXTERN gboolean monitor_equals (Monitor* self,
                         Monitor* other);
VALA_EXTERN void shutdown_dialog_focus_next (ShutdownDialog* self);
VALA_EXTERN void shutdown_dialog_focus_prev (ShutdownDialog* self);
VALA_EXTERN void shutdown_dialog_cancel (ShutdownDialog* self);
static void shutdown_dialog_real_size_allocate (GtkWidget* base,
                                         GtkAllocation* allocation);
static gboolean shutdown_dialog_real_draw (GtkWidget* base,
                                    cairo_t* c);
VALA_EXTERN gboolean animate_timer_get_is_running (AnimateTimer* self);
VALA_EXTERN void cairo_utils_exponential_blur_surface (cairo_surface_t* surface,
                                           gint radius);
VALA_EXTERN void cairo_utils_rounded_rectangle (cairo_t* c,
                                    gdouble x,
                                    gdouble y,
                                    gdouble width,
                                    gdouble height,
                                    gdouble radius);
static void shutdown_dialog_finalize (GObject * obj);
static GType shutdown_dialog_get_type_once (void);
VALA_EXTERN void slick_greeter_add_style_class (GtkWidget* widget);
static gboolean dialog_button_real_enter_notify_event (GtkWidget* base,
                                                GdkEventCrossing* event);
static gboolean dialog_button_real_leave_notify_event (GtkWidget* base,
                                                GdkEventCrossing* event);
static gboolean dialog_button_real_draw (GtkWidget* base,
                                  cairo_t* c);
static void dialog_button_real_state_flags_changed (GtkWidget* base,
                                             GtkStateFlags previous_state);
static void dialog_button_finalize (GObject * obj);
static GType dialog_button_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
shutdown_dialog_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SHUTDOWN_DIALOG_TYPE_LOGOUT, "SHUTDOWN_DIALOG_TYPE_LOGOUT", "logout"}, {SHUTDOWN_DIALOG_TYPE_SHUTDOWN, "SHUTDOWN_DIALOG_TYPE_SHUTDOWN", "shutdown"}, {SHUTDOWN_DIALOG_TYPE_RESTART, "SHUTDOWN_DIALOG_TYPE_RESTART", "restart"}, {0, NULL, NULL}};
	GType shutdown_dialog_type_type_id;
	shutdown_dialog_type_type_id = g_enum_register_static ("ShutdownDialogType", values);
	return shutdown_dialog_type_type_id;
}

GType
shutdown_dialog_type_get_type (void)
{
	static volatile gsize shutdown_dialog_type_type_id__once = 0;
	if (g_once_init_enter (&shutdown_dialog_type_type_id__once)) {
		GType shutdown_dialog_type_type_id;
		shutdown_dialog_type_type_id = shutdown_dialog_type_get_type_once ();
		g_once_init_leave (&shutdown_dialog_type_type_id__once, shutdown_dialog_type_type_id);
	}
	return shutdown_dialog_type_type_id__once;
}

static inline gpointer
shutdown_dialog_get_instance_private (ShutdownDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ShutdownDialog_private_offset);
}

static void
_shutdown_dialog_rebuild_background_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
#line 64 "../src/shutdown-dialog.vala"
	shutdown_dialog_rebuild_background ((ShutdownDialog*) self);
#line 417 "shutdown-dialog.c"
}

static void
_shutdown_dialog_update_background_color_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
#line 65 "../src/shutdown-dialog.vala"
	shutdown_dialog_update_background_color ((ShutdownDialog*) self);
#line 427 "shutdown-dialog.c"
}

static gboolean
__lambda8_ (ShutdownDialog* self)
{
	gboolean result;
#line 74 "../src/shutdown-dialog.vala"
	shutdown_dialog_close (self);
#line 75 "../src/shutdown-dialog.vala"
	result = TRUE;
#line 75 "../src/shutdown-dialog.vala"
	return result;
#line 440 "shutdown-dialog.c"
}

static gboolean
___lambda8__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda8_ ((ShutdownDialog*) self);
#line 73 "../src/shutdown-dialog.vala"
	return result;
#line 452 "shutdown-dialog.c"
}

static gboolean
__lambda11_ (ShutdownDialog* self)
{
	gboolean result;
#line 93 "../src/shutdown-dialog.vala"
	result = TRUE;
#line 93 "../src/shutdown-dialog.vala"
	return result;
#line 463 "shutdown-dialog.c"
}

static gboolean
___lambda11__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda11_ ((ShutdownDialog*) self);
#line 93 "../src/shutdown-dialog.vala"
	return result;
#line 475 "shutdown-dialog.c"
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 107 "../src/shutdown-dialog.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 483 "shutdown-dialog.c"
}

static void
____lambda12_ (ShutdownDialog* self)
{
	GError* _inner_error0_ = NULL;
	{
#line 160 "../src/shutdown-dialog.vala"
		lightdm_suspend (&_inner_error0_);
#line 160 "../src/shutdown-dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 495 "shutdown-dialog.c"
			goto __catch0_g_error;
		}
#line 161 "../src/shutdown-dialog.vala"
		shutdown_dialog_close (self);
#line 500 "shutdown-dialog.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 158 "../src/shutdown-dialog.vala"
		e = _inner_error0_;
#line 158 "../src/shutdown-dialog.vala"
		_inner_error0_ = NULL;
#line 165 "../src/shutdown-dialog.vala"
		_tmp0_ = e;
#line 165 "../src/shutdown-dialog.vala"
		_tmp1_ = _tmp0_->message;
#line 165 "../src/shutdown-dialog.vala"
		g_warning ("shutdown-dialog.vala:165: Failed to suspend: %s", _tmp1_);
#line 158 "../src/shutdown-dialog.vala"
		_g_error_free0 (e);
#line 520 "shutdown-dialog.c"
	}
	__finally0:
#line 158 "../src/shutdown-dialog.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 158 "../src/shutdown-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 158 "../src/shutdown-dialog.vala"
		g_clear_error (&_inner_error0_);
#line 158 "../src/shutdown-dialog.vala"
		return;
#line 531 "shutdown-dialog.c"
	}
}

static void
_____lambda12__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
#line 156 "../src/shutdown-dialog.vala"
	____lambda12_ ((ShutdownDialog*) self);
#line 541 "shutdown-dialog.c"
}

static void
____lambda13_ (ShutdownDialog* self)
{
	GError* _inner_error0_ = NULL;
	{
#line 177 "../src/shutdown-dialog.vala"
		lightdm_hibernate (&_inner_error0_);
#line 177 "../src/shutdown-dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 553 "shutdown-dialog.c"
			goto __catch0_g_error;
		}
#line 178 "../src/shutdown-dialog.vala"
		shutdown_dialog_close (self);
#line 558 "shutdown-dialog.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 175 "../src/shutdown-dialog.vala"
		e = _inner_error0_;
#line 175 "../src/shutdown-dialog.vala"
		_inner_error0_ = NULL;
#line 182 "../src/shutdown-dialog.vala"
		_tmp0_ = e;
#line 182 "../src/shutdown-dialog.vala"
		_tmp1_ = _tmp0_->message;
#line 182 "../src/shutdown-dialog.vala"
		g_warning ("shutdown-dialog.vala:182: Failed to hibernate: %s", _tmp1_);
#line 175 "../src/shutdown-dialog.vala"
		_g_error_free0 (e);
#line 578 "shutdown-dialog.c"
	}
	__finally0:
#line 175 "../src/shutdown-dialog.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 175 "../src/shutdown-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 175 "../src/shutdown-dialog.vala"
		g_clear_error (&_inner_error0_);
#line 175 "../src/shutdown-dialog.vala"
		return;
#line 589 "shutdown-dialog.c"
	}
}

static void
_____lambda13__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
#line 173 "../src/shutdown-dialog.vala"
	____lambda13_ ((ShutdownDialog*) self);
#line 599 "shutdown-dialog.c"
}

static void
___lambda14_ (ShutdownDialog* self)
{
	GError* _inner_error0_ = NULL;
	{
#line 195 "../src/shutdown-dialog.vala"
		lightdm_restart (&_inner_error0_);
#line 195 "../src/shutdown-dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 611 "shutdown-dialog.c"
			goto __catch0_g_error;
		}
#line 196 "../src/shutdown-dialog.vala"
		shutdown_dialog_close (self);
#line 616 "shutdown-dialog.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 193 "../src/shutdown-dialog.vala"
		e = _inner_error0_;
#line 193 "../src/shutdown-dialog.vala"
		_inner_error0_ = NULL;
#line 200 "../src/shutdown-dialog.vala"
		_tmp0_ = e;
#line 200 "../src/shutdown-dialog.vala"
		_tmp1_ = _tmp0_->message;
#line 200 "../src/shutdown-dialog.vala"
		g_warning ("shutdown-dialog.vala:200: Failed to restart: %s", _tmp1_);
#line 193 "../src/shutdown-dialog.vala"
		_g_error_free0 (e);
#line 636 "shutdown-dialog.c"
	}
	__finally0:
#line 193 "../src/shutdown-dialog.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 193 "../src/shutdown-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 193 "../src/shutdown-dialog.vala"
		g_clear_error (&_inner_error0_);
#line 193 "../src/shutdown-dialog.vala"
		return;
#line 647 "shutdown-dialog.c"
	}
}

static void
____lambda14__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
#line 191 "../src/shutdown-dialog.vala"
	___lambda14_ ((ShutdownDialog*) self);
#line 657 "shutdown-dialog.c"
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 205 "../src/shutdown-dialog.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 205 "../src/shutdown-dialog.vala"
	return _data8_;
#line 667 "shutdown-dialog.c"
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 205 "../src/shutdown-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 677 "shutdown-dialog.c"
		ShutdownDialog* self;
#line 205 "../src/shutdown-dialog.vala"
		self = _data8_->self;
#line 205 "../src/shutdown-dialog.vala"
		_g_object_unref0 (_data8_->button);
#line 205 "../src/shutdown-dialog.vala"
		_g_object_unref0 (self);
#line 205 "../src/shutdown-dialog.vala"
		g_slice_free (Block8Data, _data8_);
#line 687 "shutdown-dialog.c"
	}
}

static void
___lambda15_ (ShutdownDialog* self)
{
	GError* _inner_error0_ = NULL;
	{
#line 212 "../src/shutdown-dialog.vala"
		lightdm_shutdown (&_inner_error0_);
#line 212 "../src/shutdown-dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 700 "shutdown-dialog.c"
			goto __catch0_g_error;
		}
#line 213 "../src/shutdown-dialog.vala"
		shutdown_dialog_close (self);
#line 705 "shutdown-dialog.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 210 "../src/shutdown-dialog.vala"
		e = _inner_error0_;
#line 210 "../src/shutdown-dialog.vala"
		_inner_error0_ = NULL;
#line 217 "../src/shutdown-dialog.vala"
		_tmp0_ = e;
#line 217 "../src/shutdown-dialog.vala"
		_tmp1_ = _tmp0_->message;
#line 217 "../src/shutdown-dialog.vala"
		g_warning ("shutdown-dialog.vala:217: Failed to shutdown: %s", _tmp1_);
#line 210 "../src/shutdown-dialog.vala"
		_g_error_free0 (e);
#line 725 "shutdown-dialog.c"
	}
	__finally0:
#line 210 "../src/shutdown-dialog.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 210 "../src/shutdown-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 210 "../src/shutdown-dialog.vala"
		g_clear_error (&_inner_error0_);
#line 210 "../src/shutdown-dialog.vala"
		return;
#line 736 "shutdown-dialog.c"
	}
}

static void
____lambda15__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
#line 208 "../src/shutdown-dialog.vala"
	___lambda15_ ((ShutdownDialog*) self);
#line 746 "shutdown-dialog.c"
}

static void
____lambda16_ (Block8Data* _data8_)
{
	ShutdownDialog* self;
	DialogButton* _tmp0_;
#line 222 "../src/shutdown-dialog.vala"
	self = _data8_->self;
#line 222 "../src/shutdown-dialog.vala"
	_tmp0_ = _data8_->button;
#line 222 "../src/shutdown-dialog.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 760 "shutdown-dialog.c"
}

static void
_____lambda16__gtk_widget_show (GtkWidget* _sender,
                                gpointer self)
{
#line 222 "../src/shutdown-dialog.vala"
	____lambda16_ (self);
#line 769 "shutdown-dialog.c"
}

static void
__lambda17_ (ShutdownDialog* self)
{
#line 227 "../src/shutdown-dialog.vala"
	shutdown_dialog_close (self);
#line 777 "shutdown-dialog.c"
}

static void
___lambda17__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 227 "../src/shutdown-dialog.vala"
	__lambda17_ ((ShutdownDialog*) self);
#line 786 "shutdown-dialog.c"
}

static gdouble
__lambda18_ (ShutdownDialog* self,
             gdouble x)
{
	gdouble result;
#line 231 "../src/shutdown-dialog.vala"
	result = x;
#line 231 "../src/shutdown-dialog.vala"
	return result;
#line 798 "shutdown-dialog.c"
}

static gdouble
___lambda18__animate_timer_easing_func (gdouble x,
                                        gpointer self)
{
	gdouble result;
	result = __lambda18_ ((ShutdownDialog*) self, x);
#line 231 "../src/shutdown-dialog.vala"
	return result;
#line 809 "shutdown-dialog.c"
}

static void
__lambda19_ (ShutdownDialog* self)
{
#line 232 "../src/shutdown-dialog.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 817 "shutdown-dialog.c"
}

static void
___lambda19__animate_timer_animate (AnimateTimer* _sender,
                                    gdouble progress,
                                    gpointer self)
{
#line 232 "../src/shutdown-dialog.vala"
	__lambda19_ ((ShutdownDialog*) self);
#line 827 "shutdown-dialog.c"
}

static void
__lambda20_ (ShutdownDialog* self)
{
	AnimateTimer* _tmp0_;
#line 233 "../src/shutdown-dialog.vala"
	_tmp0_ = self->priv->animation;
#line 233 "../src/shutdown-dialog.vala"
	animate_timer_reset (_tmp0_, -1);
#line 838 "shutdown-dialog.c"
}

static void
___lambda20__gtk_widget_show (GtkWidget* _sender,
                              gpointer self)
{
#line 233 "../src/shutdown-dialog.vala"
	__lambda20_ ((ShutdownDialog*) self);
#line 847 "shutdown-dialog.c"
}

ShutdownDialog*
shutdown_dialog_construct (GType object_type,
                           ShutdownDialogType type,
                           Background* bg)
{
	ShutdownDialog * self = NULL;
	Background* _tmp0_;
	Background* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkEventBox* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkEventBox* _tmp5_;
	GtkEventBox* _tmp6_;
	GdkEventMask _tmp7_;
	GdkEventMask _tmp8_;
	GtkEventBox* _tmp9_;
	GtkEventBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GtkBox* _tmp26_;
	GtkBox* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GtkEventBox* _tmp30_;
	GtkEventBox* _tmp31_;
	GtkEventBox* _tmp32_;
	GtkEventBox* _tmp33_;
	GtkEventBox* _tmp34_;
	GdkEventMask _tmp35_;
	GdkEventMask _tmp36_;
	GtkEventBox* _tmp37_;
	GtkEventBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkEventBox* _tmp40_;
	GtkEventBox* _tmp41_;
	gchar* text = NULL;
	gboolean have_open_sessions = FALSE;
	GtkLabel* label = NULL;
	const gchar* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	PangoFontDescription* _tmp73_;
	PangoFontDescription* _tmp74_;
	GtkLabel* _tmp75_;
	GdkRGBA _tmp76_ = {0};
	GtkLabel* _tmp77_;
	GtkLabel* _tmp78_;
	GtkBox* _tmp79_;
	GtkLabel* _tmp80_;
	GtkBox* _tmp81_;
	GtkBox* _tmp82_;
	GtkBox* _tmp83_;
	GtkBox* _tmp84_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	DialogButton* _tmp119_;
	DialogButton* _tmp120_;
	DialogButton* _tmp121_;
	DialogButton* _tmp122_;
	DialogButton* _tmp123_;
	AnimateTimer* _tmp124_;
	AnimateTimer* _tmp125_;
	GError* _inner_error0_ = NULL;
#line 61 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (bg != NULL, NULL);
#line 61 "../src/shutdown-dialog.vala"
	self = (ShutdownDialog*) g_object_new (object_type, NULL);
#line 63 "../src/shutdown-dialog.vala"
	self->priv->background = bg;
#line 64 "../src/shutdown-dialog.vala"
	_tmp0_ = self->priv->background;
#line 64 "../src/shutdown-dialog.vala"
	g_signal_connect_object ((GObject*) _tmp0_, "notify::alpha", (GCallback) _shutdown_dialog_rebuild_background_g_object_notify, self, 0);
#line 65 "../src/shutdown-dialog.vala"
	_tmp1_ = self->priv->background;
#line 65 "../src/shutdown-dialog.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::average-color", (GCallback) _shutdown_dialog_update_background_color_g_object_notify, self, 0);
#line 66 "../src/shutdown-dialog.vala"
	shutdown_dialog_update_background_color (self);
#line 69 "../src/shutdown-dialog.vala"
	_tmp2_ = (GtkEventBox*) gtk_event_box_new ();
#line 69 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp2_);
#line 69 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->monitor_events);
#line 69 "../src/shutdown-dialog.vala"
	self->priv->monitor_events = _tmp2_;
#line 70 "../src/shutdown-dialog.vala"
	_tmp3_ = self->priv->monitor_events;
#line 70 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
#line 71 "../src/shutdown-dialog.vala"
	_tmp4_ = self->priv->monitor_events;
#line 71 "../src/shutdown-dialog.vala"
	gtk_event_box_set_visible_window (_tmp4_, FALSE);
#line 72 "../src/shutdown-dialog.vala"
	_tmp5_ = self->priv->monitor_events;
#line 72 "../src/shutdown-dialog.vala"
	_tmp6_ = self->priv->monitor_events;
#line 72 "../src/shutdown-dialog.vala"
	_tmp7_ = gtk_widget_get_events ((GtkWidget*) _tmp6_);
#line 72 "../src/shutdown-dialog.vala"
	_tmp8_ = _tmp7_;
#line 72 "../src/shutdown-dialog.vala"
	gtk_widget_set_events ((GtkWidget*) _tmp6_, _tmp8_ | GDK_BUTTON_PRESS_MASK);
#line 73 "../src/shutdown-dialog.vala"
	_tmp9_ = self->priv->monitor_events;
#line 73 "../src/shutdown-dialog.vala"
	g_signal_connect_object ((GtkWidget*) _tmp9_, "button-press-event", (GCallback) ___lambda8__gtk_widget_button_press_event, self, 0);
#line 77 "../src/shutdown-dialog.vala"
	_tmp10_ = self->priv->monitor_events;
#line 77 "../src/shutdown-dialog.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
#line 79 "../src/shutdown-dialog.vala"
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
#line 79 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp11_);
#line 79 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->vbox);
#line 79 "../src/shutdown-dialog.vala"
	self->priv->vbox = _tmp11_;
#line 80 "../src/shutdown-dialog.vala"
	_tmp12_ = self->priv->vbox;
#line 80 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, TRUE);
#line 82 "../src/shutdown-dialog.vala"
	_tmp13_ = self->priv->vbox;
#line 82 "../src/shutdown-dialog.vala"
	g_object_set ((GtkWidget*) _tmp13_, "margin", SHUTDOWN_DIALOG_BORDER_INTERNAL_SIZE, NULL);
#line 83 "../src/shutdown-dialog.vala"
	_tmp14_ = self->priv->vbox;
#line 83 "../src/shutdown-dialog.vala"
	_tmp15_ = self->priv->vbox;
#line 83 "../src/shutdown-dialog.vala"
	_tmp16_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp15_);
#line 83 "../src/shutdown-dialog.vala"
	_tmp17_ = _tmp16_;
#line 83 "../src/shutdown-dialog.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, _tmp17_ + 9);
#line 84 "../src/shutdown-dialog.vala"
	_tmp18_ = self->priv->vbox;
#line 84 "../src/shutdown-dialog.vala"
	_tmp19_ = self->priv->vbox;
#line 84 "../src/shutdown-dialog.vala"
	_tmp20_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp19_);
#line 84 "../src/shutdown-dialog.vala"
	_tmp21_ = _tmp20_;
#line 84 "../src/shutdown-dialog.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp19_, _tmp21_ + 20);
#line 85 "../src/shutdown-dialog.vala"
	_tmp22_ = self->priv->vbox;
#line 85 "../src/shutdown-dialog.vala"
	_tmp23_ = self->priv->vbox;
#line 85 "../src/shutdown-dialog.vala"
	_tmp24_ = gtk_widget_get_margin_end ((GtkWidget*) _tmp23_);
#line 85 "../src/shutdown-dialog.vala"
	_tmp25_ = _tmp24_;
#line 85 "../src/shutdown-dialog.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp23_, _tmp25_ + 20);
#line 86 "../src/shutdown-dialog.vala"
	_tmp26_ = self->priv->vbox;
#line 86 "../src/shutdown-dialog.vala"
	_tmp27_ = self->priv->vbox;
#line 86 "../src/shutdown-dialog.vala"
	_tmp28_ = gtk_widget_get_margin_bottom ((GtkWidget*) _tmp27_);
#line 86 "../src/shutdown-dialog.vala"
	_tmp29_ = _tmp28_;
#line 86 "../src/shutdown-dialog.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp27_, _tmp29_ + 2);
#line 89 "../src/shutdown-dialog.vala"
	_tmp30_ = (GtkEventBox*) gtk_event_box_new ();
#line 89 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp30_);
#line 89 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->vbox_events);
#line 89 "../src/shutdown-dialog.vala"
	self->priv->vbox_events = _tmp30_;
#line 90 "../src/shutdown-dialog.vala"
	_tmp31_ = self->priv->vbox_events;
#line 90 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp31_, TRUE);
#line 91 "../src/shutdown-dialog.vala"
	_tmp32_ = self->priv->vbox_events;
#line 91 "../src/shutdown-dialog.vala"
	gtk_event_box_set_visible_window (_tmp32_, FALSE);
#line 92 "../src/shutdown-dialog.vala"
	_tmp33_ = self->priv->vbox_events;
#line 92 "../src/shutdown-dialog.vala"
	_tmp34_ = self->priv->vbox_events;
#line 92 "../src/shutdown-dialog.vala"
	_tmp35_ = gtk_widget_get_events ((GtkWidget*) _tmp34_);
#line 92 "../src/shutdown-dialog.vala"
	_tmp36_ = _tmp35_;
#line 92 "../src/shutdown-dialog.vala"
	gtk_widget_set_events ((GtkWidget*) _tmp34_, _tmp36_ | GDK_BUTTON_PRESS_MASK);
#line 93 "../src/shutdown-dialog.vala"
	_tmp37_ = self->priv->vbox_events;
#line 93 "../src/shutdown-dialog.vala"
	g_signal_connect_object ((GtkWidget*) _tmp37_, "button-press-event", (GCallback) ___lambda11__gtk_widget_button_press_event, self, 0);
#line 94 "../src/shutdown-dialog.vala"
	_tmp38_ = self->priv->vbox_events;
#line 94 "../src/shutdown-dialog.vala"
	_tmp39_ = self->priv->vbox;
#line 94 "../src/shutdown-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
#line 95 "../src/shutdown-dialog.vala"
	_tmp40_ = self->priv->monitor_events;
#line 95 "../src/shutdown-dialog.vala"
	_tmp41_ = self->priv->vbox_events;
#line 95 "../src/shutdown-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
#line 99 "../src/shutdown-dialog.vala"
	if (type == SHUTDOWN_DIALOG_TYPE_SHUTDOWN) {
#line 1081 "shutdown-dialog.c"
		gchar* _tmp42_;
#line 101 "../src/shutdown-dialog.vala"
		_tmp42_ = g_strdup (_ ("Goodbye. Would you like to..."));
#line 101 "../src/shutdown-dialog.vala"
		_g_free0 (text);
#line 101 "../src/shutdown-dialog.vala"
		text = _tmp42_;
#line 1089 "shutdown-dialog.c"
	} else {
		GtkLabel* title_label = NULL;
		GtkLabel* _tmp43_;
		GtkLabel* _tmp44_;
		GtkLabel* _tmp45_;
		PangoFontDescription* _tmp46_;
		PangoFontDescription* _tmp47_;
		GtkLabel* _tmp48_;
		GdkRGBA _tmp49_ = {0};
		GtkLabel* _tmp50_;
		GtkBox* _tmp51_;
		GtkLabel* _tmp52_;
		gchar* _tmp53_;
#line 105 "../src/shutdown-dialog.vala"
		_tmp43_ = (GtkLabel*) gtk_label_new (_ ("Shut Down"));
#line 105 "../src/shutdown-dialog.vala"
		g_object_ref_sink (_tmp43_);
#line 105 "../src/shutdown-dialog.vala"
		title_label = _tmp43_;
#line 106 "../src/shutdown-dialog.vala"
		_tmp44_ = title_label;
#line 106 "../src/shutdown-dialog.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp44_, TRUE);
#line 107 "../src/shutdown-dialog.vala"
		_tmp45_ = title_label;
#line 107 "../src/shutdown-dialog.vala"
		_tmp46_ = pango_font_description_from_string ("Ubuntu Light 15");
#line 107 "../src/shutdown-dialog.vala"
		_tmp47_ = _tmp46_;
#line 107 "../src/shutdown-dialog.vala"
		gtk_widget_override_font ((GtkWidget*) _tmp45_, _tmp47_);
#line 107 "../src/shutdown-dialog.vala"
		__vala_PangoFontDescription_free0 (_tmp47_);
#line 108 "../src/shutdown-dialog.vala"
		_tmp48_ = title_label;
#line 108 "../src/shutdown-dialog.vala"
		_tmp49_.red = (gdouble) 1.0f;
#line 108 "../src/shutdown-dialog.vala"
		_tmp49_.green = (gdouble) 1.0f;
#line 108 "../src/shutdown-dialog.vala"
		_tmp49_.blue = (gdouble) 1.0f;
#line 108 "../src/shutdown-dialog.vala"
		_tmp49_.alpha = (gdouble) 1.0f;
#line 108 "../src/shutdown-dialog.vala"
		gtk_widget_override_color ((GtkWidget*) _tmp48_, GTK_STATE_FLAG_NORMAL, &_tmp49_);
#line 109 "../src/shutdown-dialog.vala"
		_tmp50_ = title_label;
#line 109 "../src/shutdown-dialog.vala"
		gtk_misc_set_alignment ((GtkMisc*) _tmp50_, 0.0f, 0.5f);
#line 110 "../src/shutdown-dialog.vala"
		_tmp51_ = self->priv->vbox;
#line 110 "../src/shutdown-dialog.vala"
		_tmp52_ = title_label;
#line 110 "../src/shutdown-dialog.vala"
		gtk_box_pack_start (_tmp51_, (GtkWidget*) _tmp52_, FALSE, FALSE, (guint) 0);
#line 112 "../src/shutdown-dialog.vala"
		_tmp53_ = g_strdup (_ ("Are you sure you want to shut down the computer?"));
#line 112 "../src/shutdown-dialog.vala"
		_g_free0 (text);
#line 112 "../src/shutdown-dialog.vala"
		text = _tmp53_;
#line 99 "../src/shutdown-dialog.vala"
		_g_object_unref0 (title_label);
#line 1153 "shutdown-dialog.c"
	}
#line 115 "../src/shutdown-dialog.vala"
	have_open_sessions = FALSE;
#line 1157 "shutdown-dialog.c"
	{
		GDBusConnection* b = NULL;
		GDBusConnection* _tmp54_;
		GVariant* _result_ = NULL;
		GDBusConnection* _tmp55_;
		GVariant* _tmp56_;
		GVariant* _tmp57_;
		GVariantType* _tmp58_;
		GVariantType* _tmp59_;
		GVariant* _tmp60_;
		GVariant* _tmp61_;
		GVariant* value = NULL;
		GVariant* _tmp62_;
		GVariant* _tmp63_ = NULL;
		GVariant* _tmp64_;
#line 118 "../src/shutdown-dialog.vala"
		_tmp54_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error0_);
#line 118 "../src/shutdown-dialog.vala"
		b = _tmp54_;
#line 118 "../src/shutdown-dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1179 "shutdown-dialog.c"
			goto __catch0_g_error;
		}
#line 119 "../src/shutdown-dialog.vala"
		_tmp55_ = b;
#line 119 "../src/shutdown-dialog.vala"
		_tmp56_ = g_variant_new ("(ss)", "org.freedesktop.DisplayManager", "Sessions", NULL);
#line 119 "../src/shutdown-dialog.vala"
		g_variant_ref_sink (_tmp56_);
#line 119 "../src/shutdown-dialog.vala"
		_tmp57_ = _tmp56_;
#line 119 "../src/shutdown-dialog.vala"
		_tmp58_ = g_variant_type_new ("(v)");
#line 119 "../src/shutdown-dialog.vala"
		_tmp59_ = _tmp58_;
#line 119 "../src/shutdown-dialog.vala"
		_tmp60_ = g_dbus_connection_call_sync (_tmp55_, "org.freedesktop.DisplayManager", "/org/freedesktop/DisplayManager", "org.freedesktop.DBus.Properties", "Get", _tmp57_, _tmp59_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
#line 119 "../src/shutdown-dialog.vala"
		_tmp61_ = _tmp60_;
#line 119 "../src/shutdown-dialog.vala"
		_g_variant_type_free0 (_tmp59_);
#line 119 "../src/shutdown-dialog.vala"
		_g_variant_unref0 (_tmp57_);
#line 119 "../src/shutdown-dialog.vala"
		_result_ = _tmp61_;
#line 119 "../src/shutdown-dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 119 "../src/shutdown-dialog.vala"
			_g_object_unref0 (b);
#line 1208 "shutdown-dialog.c"
			goto __catch0_g_error;
		}
#line 129 "../src/shutdown-dialog.vala"
		_tmp62_ = _result_;
#line 129 "../src/shutdown-dialog.vala"
		g_variant_get (_tmp62_, "(v)", &_tmp63_, NULL);
#line 129 "../src/shutdown-dialog.vala"
		_g_variant_unref0 (value);
#line 129 "../src/shutdown-dialog.vala"
		value = _tmp63_;
#line 130 "../src/shutdown-dialog.vala"
		_tmp64_ = value;
#line 130 "../src/shutdown-dialog.vala"
		have_open_sessions = g_variant_n_children (_tmp64_) > ((gsize) 0);
#line 116 "../src/shutdown-dialog.vala"
		_g_variant_unref0 (value);
#line 116 "../src/shutdown-dialog.vala"
		_g_variant_unref0 (_result_);
#line 116 "../src/shutdown-dialog.vala"
		_g_object_unref0 (b);
#line 1229 "shutdown-dialog.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp65_;
		const gchar* _tmp66_;
#line 116 "../src/shutdown-dialog.vala"
		e = _inner_error0_;
#line 116 "../src/shutdown-dialog.vala"
		_inner_error0_ = NULL;
#line 134 "../src/shutdown-dialog.vala"
		_tmp65_ = e;
#line 134 "../src/shutdown-dialog.vala"
		_tmp66_ = _tmp65_->message;
#line 134 "../src/shutdown-dialog.vala"
		g_warning ("shutdown-dialog.vala:134: Failed to check sessions from logind: %s", _tmp66_);
#line 116 "../src/shutdown-dialog.vala"
		_g_error_free0 (e);
#line 1249 "shutdown-dialog.c"
	}
	__finally0:
#line 116 "../src/shutdown-dialog.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 116 "../src/shutdown-dialog.vala"
		_g_free0 (text);
#line 116 "../src/shutdown-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 116 "../src/shutdown-dialog.vala"
		g_clear_error (&_inner_error0_);
#line 116 "../src/shutdown-dialog.vala"
		return NULL;
#line 1262 "shutdown-dialog.c"
	}
#line 136 "../src/shutdown-dialog.vala"
	if (have_open_sessions) {
#line 1266 "shutdown-dialog.c"
		const gchar* _tmp67_;
		gchar* _tmp68_;
#line 137 "../src/shutdown-dialog.vala"
		_tmp67_ = text;
#line 137 "../src/shutdown-dialog.vala"
		_tmp68_ = g_strdup_printf ("%s\n\n%s", _ ("Other users are currently logged in to this computer, shutting down no" \
"w will also close these other sessions."), _tmp67_);
#line 137 "../src/shutdown-dialog.vala"
		_g_free0 (text);
#line 137 "../src/shutdown-dialog.vala"
		text = _tmp68_;
#line 1277 "shutdown-dialog.c"
	}
#line 139 "../src/shutdown-dialog.vala"
	_tmp69_ = text;
#line 139 "../src/shutdown-dialog.vala"
	_tmp70_ = (GtkLabel*) gtk_label_new (_tmp69_);
#line 139 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp70_);
#line 139 "../src/shutdown-dialog.vala"
	label = _tmp70_;
#line 140 "../src/shutdown-dialog.vala"
	_tmp71_ = label;
#line 140 "../src/shutdown-dialog.vala"
	gtk_label_set_line_wrap (_tmp71_, TRUE);
#line 141 "../src/shutdown-dialog.vala"
	_tmp72_ = label;
#line 141 "../src/shutdown-dialog.vala"
	_tmp73_ = pango_font_description_from_string ("Ubuntu Light 12");
#line 141 "../src/shutdown-dialog.vala"
	_tmp74_ = _tmp73_;
#line 141 "../src/shutdown-dialog.vala"
	gtk_widget_override_font ((GtkWidget*) _tmp72_, _tmp74_);
#line 141 "../src/shutdown-dialog.vala"
	__vala_PangoFontDescription_free0 (_tmp74_);
#line 142 "../src/shutdown-dialog.vala"
	_tmp75_ = label;
#line 142 "../src/shutdown-dialog.vala"
	_tmp76_.red = (gdouble) 1.0f;
#line 142 "../src/shutdown-dialog.vala"
	_tmp76_.green = (gdouble) 1.0f;
#line 142 "../src/shutdown-dialog.vala"
	_tmp76_.blue = (gdouble) 1.0f;
#line 142 "../src/shutdown-dialog.vala"
	_tmp76_.alpha = (gdouble) 1.0f;
#line 142 "../src/shutdown-dialog.vala"
	gtk_widget_override_color ((GtkWidget*) _tmp75_, GTK_STATE_FLAG_NORMAL, &_tmp76_);
#line 143 "../src/shutdown-dialog.vala"
	_tmp77_ = label;
#line 143 "../src/shutdown-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp77_, 0.0f, 0.5f);
#line 144 "../src/shutdown-dialog.vala"
	_tmp78_ = label;
#line 144 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp78_, TRUE);
#line 145 "../src/shutdown-dialog.vala"
	_tmp79_ = self->priv->vbox;
#line 145 "../src/shutdown-dialog.vala"
	_tmp80_ = label;
#line 145 "../src/shutdown-dialog.vala"
	gtk_box_pack_start (_tmp79_, (GtkWidget*) _tmp80_, FALSE, FALSE, (guint) 0);
#line 147 "../src/shutdown-dialog.vala"
	_tmp81_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 20);
#line 147 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp81_);
#line 147 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->button_box);
#line 147 "../src/shutdown-dialog.vala"
	self->priv->button_box = _tmp81_;
#line 148 "../src/shutdown-dialog.vala"
	_tmp82_ = self->priv->button_box;
#line 148 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp82_, TRUE);
#line 149 "../src/shutdown-dialog.vala"
	_tmp83_ = self->priv->vbox;
#line 149 "../src/shutdown-dialog.vala"
	_tmp84_ = self->priv->button_box;
#line 149 "../src/shutdown-dialog.vala"
	gtk_box_pack_start (_tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 0);
#line 151 "../src/shutdown-dialog.vala"
	if (type == SHUTDOWN_DIALOG_TYPE_SHUTDOWN) {
#line 153 "../src/shutdown-dialog.vala"
		if (lightdm_get_can_suspend ()) {
#line 1349 "shutdown-dialog.c"
			DialogButton* button = NULL;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			DialogButton* _tmp89_;
			DialogButton* _tmp90_;
			DialogButton* _tmp91_;
#line 155 "../src/shutdown-dialog.vala"
			_tmp85_ = g_build_filename (PKGDATADIR, "suspend.svg", NULL);
#line 155 "../src/shutdown-dialog.vala"
			_tmp86_ = _tmp85_;
#line 155 "../src/shutdown-dialog.vala"
			_tmp87_ = g_build_filename (PKGDATADIR, "suspend_highlight.svg", NULL);
#line 155 "../src/shutdown-dialog.vala"
			_tmp88_ = _tmp87_;
#line 155 "../src/shutdown-dialog.vala"
			_tmp89_ = shutdown_dialog_add_button (self, _ ("Suspend"), _tmp86_, _tmp88_);
#line 155 "../src/shutdown-dialog.vala"
			_tmp90_ = _tmp89_;
#line 155 "../src/shutdown-dialog.vala"
			_g_free0 (_tmp88_);
#line 155 "../src/shutdown-dialog.vala"
			_g_free0 (_tmp86_);
#line 155 "../src/shutdown-dialog.vala"
			button = _tmp90_;
#line 156 "../src/shutdown-dialog.vala"
			_tmp91_ = button;
#line 156 "../src/shutdown-dialog.vala"
			g_signal_connect_object ((GtkButton*) _tmp91_, "clicked", (GCallback) _____lambda12__gtk_button_clicked, self, 0);
#line 153 "../src/shutdown-dialog.vala"
			_g_object_unref0 (button);
#line 1382 "shutdown-dialog.c"
		}
#line 170 "../src/shutdown-dialog.vala"
		if (lightdm_get_can_hibernate ()) {
#line 1386 "shutdown-dialog.c"
			DialogButton* button = NULL;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			DialogButton* _tmp96_;
			DialogButton* _tmp97_;
			DialogButton* _tmp98_;
#line 172 "../src/shutdown-dialog.vala"
			_tmp92_ = g_build_filename (PKGDATADIR, "hibernate.svg", NULL);
#line 172 "../src/shutdown-dialog.vala"
			_tmp93_ = _tmp92_;
#line 172 "../src/shutdown-dialog.vala"
			_tmp94_ = g_build_filename (PKGDATADIR, "hibernate_highlight.svg", NULL);
#line 172 "../src/shutdown-dialog.vala"
			_tmp95_ = _tmp94_;
#line 172 "../src/shutdown-dialog.vala"
			_tmp96_ = shutdown_dialog_add_button (self, _ ("Hibernate"), _tmp93_, _tmp95_);
#line 172 "../src/shutdown-dialog.vala"
			_tmp97_ = _tmp96_;
#line 172 "../src/shutdown-dialog.vala"
			_g_free0 (_tmp95_);
#line 172 "../src/shutdown-dialog.vala"
			_g_free0 (_tmp93_);
#line 172 "../src/shutdown-dialog.vala"
			button = _tmp97_;
#line 173 "../src/shutdown-dialog.vala"
			_tmp98_ = button;
#line 173 "../src/shutdown-dialog.vala"
			g_signal_connect_object ((GtkButton*) _tmp98_, "clicked", (GCallback) _____lambda13__gtk_button_clicked, self, 0);
#line 170 "../src/shutdown-dialog.vala"
			_g_object_unref0 (button);
#line 1419 "shutdown-dialog.c"
		}
	}
#line 188 "../src/shutdown-dialog.vala"
	if (lightdm_get_can_restart ()) {
#line 1424 "shutdown-dialog.c"
		DialogButton* button = NULL;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		DialogButton* _tmp103_;
		DialogButton* _tmp104_;
		DialogButton* _tmp105_;
#line 190 "../src/shutdown-dialog.vala"
		_tmp99_ = g_build_filename (PKGDATADIR, "restart.svg", NULL);
#line 190 "../src/shutdown-dialog.vala"
		_tmp100_ = _tmp99_;
#line 190 "../src/shutdown-dialog.vala"
		_tmp101_ = g_build_filename (PKGDATADIR, "restart_highlight.svg", NULL);
#line 190 "../src/shutdown-dialog.vala"
		_tmp102_ = _tmp101_;
#line 190 "../src/shutdown-dialog.vala"
		_tmp103_ = shutdown_dialog_add_button (self, _ ("Restart"), _tmp100_, _tmp102_);
#line 190 "../src/shutdown-dialog.vala"
		_tmp104_ = _tmp103_;
#line 190 "../src/shutdown-dialog.vala"
		_g_free0 (_tmp102_);
#line 190 "../src/shutdown-dialog.vala"
		_g_free0 (_tmp100_);
#line 190 "../src/shutdown-dialog.vala"
		button = _tmp104_;
#line 191 "../src/shutdown-dialog.vala"
		_tmp105_ = button;
#line 191 "../src/shutdown-dialog.vala"
		g_signal_connect_object ((GtkButton*) _tmp105_, "clicked", (GCallback) ____lambda14__gtk_button_clicked, self, 0);
#line 188 "../src/shutdown-dialog.vala"
		_g_object_unref0 (button);
#line 1457 "shutdown-dialog.c"
	}
#line 205 "../src/shutdown-dialog.vala"
	if (lightdm_get_can_shutdown ()) {
#line 1461 "shutdown-dialog.c"
		Block8Data* _data8_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		DialogButton* _tmp110_;
		DialogButton* _tmp111_;
		DialogButton* _tmp112_;
#line 205 "../src/shutdown-dialog.vala"
		_data8_ = g_slice_new0 (Block8Data);
#line 205 "../src/shutdown-dialog.vala"
		_data8_->_ref_count_ = 1;
#line 205 "../src/shutdown-dialog.vala"
		_data8_->self = g_object_ref (self);
#line 207 "../src/shutdown-dialog.vala"
		_tmp106_ = g_build_filename (PKGDATADIR, "shutdown_dialog.svg", NULL);
#line 207 "../src/shutdown-dialog.vala"
		_tmp107_ = _tmp106_;
#line 207 "../src/shutdown-dialog.vala"
		_tmp108_ = g_build_filename (PKGDATADIR, "shutdown_highlight.svg", NULL);
#line 207 "../src/shutdown-dialog.vala"
		_tmp109_ = _tmp108_;
#line 207 "../src/shutdown-dialog.vala"
		_tmp110_ = shutdown_dialog_add_button (self, _ ("Shut Down"), _tmp107_, _tmp109_);
#line 207 "../src/shutdown-dialog.vala"
		_tmp111_ = _tmp110_;
#line 207 "../src/shutdown-dialog.vala"
		_g_free0 (_tmp109_);
#line 207 "../src/shutdown-dialog.vala"
		_g_free0 (_tmp107_);
#line 207 "../src/shutdown-dialog.vala"
		_data8_->button = _tmp111_;
#line 208 "../src/shutdown-dialog.vala"
		_tmp112_ = _data8_->button;
#line 208 "../src/shutdown-dialog.vala"
		g_signal_connect_object ((GtkButton*) _tmp112_, "clicked", (GCallback) ____lambda15__gtk_button_clicked, self, 0);
#line 221 "../src/shutdown-dialog.vala"
		if (type != SHUTDOWN_DIALOG_TYPE_SHUTDOWN) {
#line 222 "../src/shutdown-dialog.vala"
			g_signal_connect_data ((GtkWidget*) self, "show", (GCallback) _____lambda16__gtk_widget_show, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 1502 "shutdown-dialog.c"
		}
#line 205 "../src/shutdown-dialog.vala"
		block8_data_unref (_data8_);
#line 205 "../src/shutdown-dialog.vala"
		_data8_ = NULL;
#line 1508 "shutdown-dialog.c"
	}
#line 225 "../src/shutdown-dialog.vala"
	_tmp113_ = g_build_filename (PKGDATADIR, "dialog_close.svg", NULL);
#line 225 "../src/shutdown-dialog.vala"
	_tmp114_ = _tmp113_;
#line 225 "../src/shutdown-dialog.vala"
	_tmp115_ = g_build_filename (PKGDATADIR, "dialog_close_highlight.svg", NULL);
#line 225 "../src/shutdown-dialog.vala"
	_tmp116_ = _tmp115_;
#line 225 "../src/shutdown-dialog.vala"
	_tmp117_ = g_build_filename (PKGDATADIR, "dialog_close_press.svg", NULL);
#line 225 "../src/shutdown-dialog.vala"
	_tmp118_ = _tmp117_;
#line 225 "../src/shutdown-dialog.vala"
	_tmp119_ = dialog_button_new (_tmp114_, _tmp116_, _tmp118_, NULL);
#line 225 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp119_);
#line 225 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->close_button);
#line 225 "../src/shutdown-dialog.vala"
	self->priv->close_button = _tmp119_;
#line 225 "../src/shutdown-dialog.vala"
	_g_free0 (_tmp118_);
#line 225 "../src/shutdown-dialog.vala"
	_g_free0 (_tmp116_);
#line 225 "../src/shutdown-dialog.vala"
	_g_free0 (_tmp114_);
#line 226 "../src/shutdown-dialog.vala"
	_tmp120_ = self->priv->close_button;
#line 226 "../src/shutdown-dialog.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp120_, FALSE);
#line 227 "../src/shutdown-dialog.vala"
	_tmp121_ = self->priv->close_button;
#line 227 "../src/shutdown-dialog.vala"
	g_signal_connect_object ((GtkButton*) _tmp121_, "clicked", (GCallback) ___lambda17__gtk_button_clicked, self, 0);
#line 228 "../src/shutdown-dialog.vala"
	_tmp122_ = self->priv->close_button;
#line 228 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp122_, TRUE);
#line 229 "../src/shutdown-dialog.vala"
	_tmp123_ = self->priv->close_button;
#line 229 "../src/shutdown-dialog.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp123_);
#line 231 "../src/shutdown-dialog.vala"
	_tmp124_ = animate_timer_new (___lambda18__animate_timer_easing_func, self, ANIMATE_TIMER_INSTANT);
#line 231 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->animation);
#line 231 "../src/shutdown-dialog.vala"
	self->priv->animation = _tmp124_;
#line 232 "../src/shutdown-dialog.vala"
	_tmp125_ = self->priv->animation;
#line 232 "../src/shutdown-dialog.vala"
	g_signal_connect_object (_tmp125_, "animate", (GCallback) ___lambda19__animate_timer_animate, self, 0);
#line 233 "../src/shutdown-dialog.vala"
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) ___lambda20__gtk_widget_show, self, 0);
#line 61 "../src/shutdown-dialog.vala"
	_g_object_unref0 (label);
#line 61 "../src/shutdown-dialog.vala"
	_g_free0 (text);
#line 61 "../src/shutdown-dialog.vala"
	return self;
#line 1570 "shutdown-dialog.c"
}

ShutdownDialog*
shutdown_dialog_new (ShutdownDialogType type,
                     Background* bg)
{
#line 61 "../src/shutdown-dialog.vala"
	return shutdown_dialog_construct (TYPE_SHUTDOWN_DIALOG, type, bg);
#line 1579 "shutdown-dialog.c"
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 236 "../src/shutdown-dialog.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 236 "../src/shutdown-dialog.vala"
	return _data9_;
#line 1589 "shutdown-dialog.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 236 "../src/shutdown-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 1599 "shutdown-dialog.c"
		ShutdownDialog* self;
#line 236 "../src/shutdown-dialog.vala"
		self = _data9_->self;
#line 236 "../src/shutdown-dialog.vala"
		_g_object_unref0 (self);
#line 236 "../src/shutdown-dialog.vala"
		g_slice_free (Block9Data, _data9_);
#line 1607 "shutdown-dialog.c"
	}
}

static gdouble
__lambda9_ (Block9Data* _data9_,
            gdouble x)
{
	ShutdownDialog* self;
	gdouble result;
#line 239 "../src/shutdown-dialog.vala"
	self = _data9_->self;
#line 239 "../src/shutdown-dialog.vala"
	result = _data9_->start_value + x;
#line 239 "../src/shutdown-dialog.vala"
	return result;
#line 1623 "shutdown-dialog.c"
}

static gdouble
___lambda9__animate_timer_easing_func (gdouble x,
                                       gpointer self)
{
	gdouble result;
	result = __lambda9_ (self, x);
#line 239 "../src/shutdown-dialog.vala"
	return result;
#line 1634 "shutdown-dialog.c"
}

static void
__lambda10_ (ShutdownDialog* self,
             gdouble p)
{
#line 242 "../src/shutdown-dialog.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 244 "../src/shutdown-dialog.vala"
	if (p >= ((gdouble) 1.0f)) {
#line 1645 "shutdown-dialog.c"
		AnimateTimer* _tmp0_;
#line 246 "../src/shutdown-dialog.vala"
		_tmp0_ = self->priv->animation;
#line 246 "../src/shutdown-dialog.vala"
		animate_timer_stop (_tmp0_);
#line 247 "../src/shutdown-dialog.vala"
		g_signal_emit (self, shutdown_dialog_signals[SHUTDOWN_DIALOG_CLOSED_SIGNAL], 0);
#line 1653 "shutdown-dialog.c"
	}
}

static void
___lambda10__animate_timer_animate (AnimateTimer* _sender,
                                    gdouble progress,
                                    gpointer self)
{
#line 240 "../src/shutdown-dialog.vala"
	__lambda10_ ((ShutdownDialog*) self, progress);
#line 1664 "shutdown-dialog.c"
}

void
shutdown_dialog_close (ShutdownDialog* self)
{
	Block9Data* _data9_;
	AnimateTimer* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	AnimateTimer* _tmp3_;
	AnimateTimer* _tmp4_;
	AnimateTimer* _tmp5_;
#line 236 "../src/shutdown-dialog.vala"
	g_return_if_fail (self != NULL);
#line 236 "../src/shutdown-dialog.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 236 "../src/shutdown-dialog.vala"
	_data9_->_ref_count_ = 1;
#line 236 "../src/shutdown-dialog.vala"
	_data9_->self = g_object_ref (self);
#line 238 "../src/shutdown-dialog.vala"
	_tmp0_ = self->priv->animation;
#line 238 "../src/shutdown-dialog.vala"
	_tmp1_ = animate_timer_get_progress (_tmp0_);
#line 238 "../src/shutdown-dialog.vala"
	_tmp2_ = _tmp1_;
#line 238 "../src/shutdown-dialog.vala"
	_data9_->start_value = 1.0f - _tmp2_;
#line 239 "../src/shutdown-dialog.vala"
	_tmp3_ = animate_timer_new (___lambda9__animate_timer_easing_func, _data9_, ANIMATE_TIMER_INSTANT);
#line 239 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->animation);
#line 239 "../src/shutdown-dialog.vala"
	self->priv->animation = _tmp3_;
#line 240 "../src/shutdown-dialog.vala"
	_tmp4_ = self->priv->animation;
#line 240 "../src/shutdown-dialog.vala"
	g_signal_connect_object (_tmp4_, "animate", (GCallback) ___lambda10__animate_timer_animate, self, 0);
#line 251 "../src/shutdown-dialog.vala"
	self->priv->closing = TRUE;
#line 252 "../src/shutdown-dialog.vala"
	_tmp5_ = self->priv->animation;
#line 252 "../src/shutdown-dialog.vala"
	animate_timer_reset (_tmp5_, -1);
#line 236 "../src/shutdown-dialog.vala"
	block9_data_unref (_data9_);
#line 236 "../src/shutdown-dialog.vala"
	_data9_ = NULL;
#line 1713 "shutdown-dialog.c"
}

static void
shutdown_dialog_rebuild_background (ShutdownDialog* self)
{
#line 255 "../src/shutdown-dialog.vala"
	g_return_if_fail (self != NULL);
#line 257 "../src/shutdown-dialog.vala"
	_cairo_surface_destroy0 (self->priv->bg_surface);
#line 257 "../src/shutdown-dialog.vala"
	self->priv->bg_surface = NULL;
#line 258 "../src/shutdown-dialog.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1727 "shutdown-dialog.c"
}

static void
shutdown_dialog_update_background_color (ShutdownDialog* self)
{
	gdouble hue = 0.0;
	gdouble saturation = 0.0;
	gdouble value = 0.0;
#line 266 "../src/shutdown-dialog.vala"
	static const gdouble COLOR_ALPHA = (gdouble) 0.72f;
#line 1738 "shutdown-dialog.c"
	GdkRGBA color = {0};
	Background* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
#line 261 "../src/shutdown-dialog.vala"
	g_return_if_fail (self != NULL);
#line 268 "../src/shutdown-dialog.vala"
	_tmp0_ = self->priv->background;
#line 268 "../src/shutdown-dialog.vala"
	background_get_average_color (_tmp0_, &_tmp1_);
#line 268 "../src/shutdown-dialog.vala"
	_tmp2_ = _tmp1_;
#line 268 "../src/shutdown-dialog.vala"
	color = _tmp2_;
#line 269 "../src/shutdown-dialog.vala"
	_tmp3_ = color;
#line 269 "../src/shutdown-dialog.vala"
	_tmp4_ = color;
#line 269 "../src/shutdown-dialog.vala"
	_tmp5_ = color;
#line 269 "../src/shutdown-dialog.vala"
	gtk_rgb_to_hsv (_tmp3_.red, _tmp4_.green, _tmp5_.blue, &_tmp6_, &_tmp7_, &_tmp8_);
#line 269 "../src/shutdown-dialog.vala"
	hue = _tmp6_;
#line 269 "../src/shutdown-dialog.vala"
	saturation = _tmp7_;
#line 269 "../src/shutdown-dialog.vala"
	value = _tmp8_;
#line 272 "../src/shutdown-dialog.vala"
	if (saturation < 0.08) {
#line 1775 "shutdown-dialog.c"
		GdkRGBA _tmp9_ = {0};
#line 275 "../src/shutdown-dialog.vala"
		_tmp9_.red = (gdouble) 0.18f;
#line 275 "../src/shutdown-dialog.vala"
		_tmp9_.green = (gdouble) 0.20f;
#line 275 "../src/shutdown-dialog.vala"
		_tmp9_.blue = (gdouble) 0.21f;
#line 275 "../src/shutdown-dialog.vala"
		_tmp9_.alpha = COLOR_ALPHA;
#line 275 "../src/shutdown-dialog.vala"
		self->priv->avg_color = _tmp9_;
#line 1787 "shutdown-dialog.c"
	} else {
#line 279 "../src/shutdown-dialog.vala"
		static const GdkRGBA cmp_colors[12] = {{(gdouble) (84 / 255.0f), (gdouble) (14 / 255.0f), (gdouble) (68 / 255.0f), (gdouble) 1.0f}, {(gdouble) (110 / 255.0f), (gdouble) (11 / 255.0f), (gdouble) (42 / 255.0f), (gdouble) 1.0f}, {(gdouble) (132 / 255.0f), (gdouble) (22 / 255.0f), (gdouble) (23 / 255.0f), (gdouble) 1.0f}, {(gdouble) (132 / 255.0f), (gdouble) (55 / 255.0f), (gdouble) (27 / 255.0f), (gdouble) 1.0f}, {(gdouble) (134 / 255.0f), (gdouble) (77 / 255.0f), (gdouble) (32 / 255.0f), (gdouble) 1.0f}, {(gdouble) (133 / 255.0f), (gdouble) (127 / 255.0f), (gdouble) (49 / 255.0f), (gdouble) 1.0f}, {(gdouble) (29 / 255.0f), (gdouble) (99 / 255.0f), (gdouble) (49 / 255.0f), (gdouble) 1.0f}, {(gdouble) (17 / 255.0f), (gdouble) (88 / 255.0f), (gdouble) (46 / 255.0f), (gdouble) 1.0f}, {(gdouble) (14 / 255.0f), (gdouble) (89 / 255.0f), (gdouble) (85 / 255.0f), (gdouble) 1.0f}, {(gdouble) (25 / 255.0f), (gdouble) (43 / 255.0f), (gdouble) (89 / 255.0f), (gdouble) 1.0f}, {(gdouble) (27 / 255.0f), (gdouble) (19 / 255.0f), (gdouble) (76 / 255.0f), (gdouble) 1.0f}, {(gdouble) (2 / 255.0f), (gdouble) (192 / 255.0f), (gdouble) (212 / 255.0f), (gdouble) 1.0f}};
#line 1791 "shutdown-dialog.c"
		GdkRGBA _tmp10_ = {0};
		gdouble closest_diff = 0.0;
		gdouble new_hue = 0.0;
		gdouble new_saturation = 0.0;
		gdouble new_value = 0.0;
		GdkRGBA _tmp18_;
		GdkRGBA _tmp19_;
		GdkRGBA _tmp20_;
		gdouble _tmp21_ = 0.0;
		gdouble _tmp22_ = 0.0;
		gdouble _tmp23_ = 0.0;
		gdouble _tmp24_ = 0.0;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
#line 295 "../src/shutdown-dialog.vala"
		_tmp10_.red = (gdouble) 0;
#line 295 "../src/shutdown-dialog.vala"
		_tmp10_.green = (gdouble) 0;
#line 295 "../src/shutdown-dialog.vala"
		_tmp10_.blue = (gdouble) 0;
#line 295 "../src/shutdown-dialog.vala"
		_tmp10_.alpha = (gdouble) 1;
#line 295 "../src/shutdown-dialog.vala"
		self->priv->avg_color = _tmp10_;
#line 296 "../src/shutdown-dialog.vala"
		closest_diff = (gdouble) 200.0f;
#line 1818 "shutdown-dialog.c"
		{
			GdkRGBA* c_collection = NULL;
			gint c_collection_length1 = 0;
			gint _c_collection_size_ = 0;
			gint c_it = 0;
#line 298 "../src/shutdown-dialog.vala"
			c_collection = cmp_colors;
#line 298 "../src/shutdown-dialog.vala"
			c_collection_length1 = G_N_ELEMENTS (cmp_colors);
#line 298 "../src/shutdown-dialog.vala"
			for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
#line 1830 "shutdown-dialog.c"
				GdkRGBA c = {0};
#line 298 "../src/shutdown-dialog.vala"
				c = c_collection[c_it];
#line 1834 "shutdown-dialog.c"
				{
					gdouble cmp_hue = 0.0;
					gdouble cmp_sat = 0.0;
					gdouble cmp_value = 0.0;
					GdkRGBA _tmp11_;
					GdkRGBA _tmp12_;
					GdkRGBA _tmp13_;
					gdouble _tmp14_ = 0.0;
					gdouble _tmp15_ = 0.0;
					gdouble _tmp16_ = 0.0;
					gdouble color_diff = 0.0;
#line 301 "../src/shutdown-dialog.vala"
					_tmp11_ = c;
#line 301 "../src/shutdown-dialog.vala"
					_tmp12_ = c;
#line 301 "../src/shutdown-dialog.vala"
					_tmp13_ = c;
#line 301 "../src/shutdown-dialog.vala"
					gtk_rgb_to_hsv (_tmp11_.red, _tmp12_.green, _tmp13_.blue, &_tmp14_, &_tmp15_, &_tmp16_);
#line 301 "../src/shutdown-dialog.vala"
					cmp_hue = _tmp14_;
#line 301 "../src/shutdown-dialog.vala"
					cmp_sat = _tmp15_;
#line 301 "../src/shutdown-dialog.vala"
					cmp_value = _tmp16_;
#line 303 "../src/shutdown-dialog.vala"
					color_diff = fabs (hue - cmp_hue);
#line 305 "../src/shutdown-dialog.vala"
					if (color_diff < closest_diff) {
#line 1864 "shutdown-dialog.c"
						GdkRGBA _tmp17_;
#line 307 "../src/shutdown-dialog.vala"
						_tmp17_ = c;
#line 307 "../src/shutdown-dialog.vala"
						self->priv->avg_color = _tmp17_;
#line 308 "../src/shutdown-dialog.vala"
						closest_diff = color_diff;
#line 1872 "shutdown-dialog.c"
					}
				}
			}
		}
#line 313 "../src/shutdown-dialog.vala"
		_tmp18_ = self->priv->avg_color;
#line 313 "../src/shutdown-dialog.vala"
		_tmp19_ = self->priv->avg_color;
#line 313 "../src/shutdown-dialog.vala"
		_tmp20_ = self->priv->avg_color;
#line 313 "../src/shutdown-dialog.vala"
		gtk_rgb_to_hsv (_tmp18_.red, _tmp19_.green, _tmp20_.blue, &_tmp21_, &_tmp22_, &_tmp23_);
#line 313 "../src/shutdown-dialog.vala"
		new_hue = _tmp21_;
#line 313 "../src/shutdown-dialog.vala"
		new_saturation = _tmp22_;
#line 313 "../src/shutdown-dialog.vala"
		new_value = _tmp23_;
#line 316 "../src/shutdown-dialog.vala"
		saturation = MIN (saturation, new_saturation);
#line 317 "../src/shutdown-dialog.vala"
		saturation *= 2.0f - saturation;
#line 318 "../src/shutdown-dialog.vala"
		value = MIN (MIN (value, new_value), (gdouble) 0.26f);
#line 319 "../src/shutdown-dialog.vala"
		gtk_hsv_to_rgb (hue, saturation, value, &_tmp24_, &_tmp25_, &_tmp26_);
#line 319 "../src/shutdown-dialog.vala"
		self->priv->avg_color.red = _tmp24_;
#line 319 "../src/shutdown-dialog.vala"
		self->priv->avg_color.green = _tmp25_;
#line 319 "../src/shutdown-dialog.vala"
		self->priv->avg_color.blue = _tmp26_;
#line 321 "../src/shutdown-dialog.vala"
		self->priv->avg_color.alpha = COLOR_ALPHA;
#line 1907 "shutdown-dialog.c"
	}
#line 324 "../src/shutdown-dialog.vala"
	shutdown_dialog_rebuild_background (self);
#line 1911 "shutdown-dialog.c"
}

static gpointer
_monitor_ref0 (gpointer self)
{
#line 332 "../src/shutdown-dialog.vala"
	return self ? monitor_ref (self) : NULL;
#line 1919 "shutdown-dialog.c"
}

void
shutdown_dialog_set_active_monitor (ShutdownDialog* self,
                                    Monitor* m)
{
	gboolean _tmp0_ = FALSE;
	Monitor* _tmp1_;
	Monitor* _tmp3_;
	Monitor* _tmp4_;
	Monitor* _tmp5_;
#line 327 "../src/shutdown-dialog.vala"
	g_return_if_fail (self != NULL);
#line 327 "../src/shutdown-dialog.vala"
	g_return_if_fail (m != NULL);
#line 329 "../src/shutdown-dialog.vala"
	_tmp1_ = self->priv->monitor;
#line 329 "../src/shutdown-dialog.vala"
	if (m == _tmp1_) {
#line 329 "../src/shutdown-dialog.vala"
		_tmp0_ = TRUE;
#line 1941 "shutdown-dialog.c"
	} else {
		Monitor* _tmp2_;
#line 329 "../src/shutdown-dialog.vala"
		_tmp2_ = self->priv->monitor;
#line 329 "../src/shutdown-dialog.vala"
		_tmp0_ = monitor_equals (m, _tmp2_);
#line 1948 "shutdown-dialog.c"
	}
#line 329 "../src/shutdown-dialog.vala"
	if (_tmp0_) {
#line 330 "../src/shutdown-dialog.vala"
		return;
#line 1954 "shutdown-dialog.c"
	}
#line 332 "../src/shutdown-dialog.vala"
	_tmp3_ = _monitor_ref0 (m);
#line 332 "../src/shutdown-dialog.vala"
	_monitor_unref0 (self->priv->monitor);
#line 332 "../src/shutdown-dialog.vala"
	self->priv->monitor = _tmp3_;
#line 333 "../src/shutdown-dialog.vala"
	shutdown_dialog_rebuild_background (self);
#line 334 "../src/shutdown-dialog.vala"
	_tmp4_ = self->priv->monitor;
#line 334 "../src/shutdown-dialog.vala"
	_tmp5_ = self->priv->monitor;
#line 334 "../src/shutdown-dialog.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, _tmp4_->width, _tmp5_->height);
#line 1970 "shutdown-dialog.c"
}

void
shutdown_dialog_focus_next (ShutdownDialog* self)
{
	GtkWidget* _tmp0_;
#line 337 "../src/shutdown-dialog.vala"
	g_return_if_fail (self != NULL);
#line 339 "../src/shutdown-dialog.vala"
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 339 "../src/shutdown-dialog.vala"
	g_signal_emit_by_name ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL), "move-focus", GTK_DIR_TAB_FORWARD);
#line 1983 "shutdown-dialog.c"
}

void
shutdown_dialog_focus_prev (ShutdownDialog* self)
{
	GtkWidget* _tmp0_;
#line 342 "../src/shutdown-dialog.vala"
	g_return_if_fail (self != NULL);
#line 344 "../src/shutdown-dialog.vala"
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 344 "../src/shutdown-dialog.vala"
	g_signal_emit_by_name ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL), "move-focus", GTK_DIR_TAB_BACKWARD);
#line 1996 "shutdown-dialog.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 349 "../src/shutdown-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 2004 "shutdown-dialog.c"
}

void
shutdown_dialog_cancel (ShutdownDialog* self)
{
	GtkWidget* widget = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
#line 347 "../src/shutdown-dialog.vala"
	g_return_if_fail (self != NULL);
#line 349 "../src/shutdown-dialog.vala"
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 349 "../src/shutdown-dialog.vala"
	_tmp1_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL);
#line 349 "../src/shutdown-dialog.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 349 "../src/shutdown-dialog.vala"
	widget = _tmp2_;
#line 350 "../src/shutdown-dialog.vala"
	_tmp3_ = widget;
#line 350 "../src/shutdown-dialog.vala"
	if (IS_DIALOG_BUTTON (_tmp3_)) {
#line 2029 "shutdown-dialog.c"
		GtkWidget* _tmp4_;
#line 351 "../src/shutdown-dialog.vala"
		_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 351 "../src/shutdown-dialog.vala"
		gtk_window_set_focus (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp4_) : NULL, NULL);
#line 2035 "shutdown-dialog.c"
	} else {
#line 353 "../src/shutdown-dialog.vala"
		shutdown_dialog_close (self);
#line 2039 "shutdown-dialog.c"
	}
#line 347 "../src/shutdown-dialog.vala"
	_g_object_unref0 (widget);
#line 2043 "shutdown-dialog.c"
}

static void
shutdown_dialog_real_size_allocate (GtkWidget* base,
                                    GtkAllocation* allocation)
{
	ShutdownDialog * self;
	GtkAllocation _tmp0_;
	GtkEventBox* _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation content_allocation = {0};
	gint minimum_width = 0;
	gint natural_width = 0;
	gint minimum_height = 0;
	gint natural_height = 0;
	GtkEventBox* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkEventBox* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GtkAllocation _tmp9_;
	GtkAllocation _tmp10_;
	GtkAllocation _tmp11_;
	GtkAllocation _tmp12_;
	GtkEventBox* _tmp13_;
	GtkAllocation _tmp14_;
	GtkAllocation a = {0};
	DialogButton* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	DialogButton* _tmp18_;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GtkAllocation _tmp21_;
	GtkAllocation _tmp22_;
	DialogButton* _tmp23_;
	GtkAllocation _tmp24_;
#line 356 "../src/shutdown-dialog.vala"
	self = (ShutdownDialog*) base;
#line 356 "../src/shutdown-dialog.vala"
	g_return_if_fail (allocation != NULL);
#line 358 "../src/shutdown-dialog.vala"
	_tmp0_ = *allocation;
#line 358 "../src/shutdown-dialog.vala"
	GTK_WIDGET_CLASS (shutdown_dialog_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_fixed_get_type (), GtkFixed), &_tmp0_);
#line 359 "../src/shutdown-dialog.vala"
	_tmp1_ = self->priv->monitor_events;
#line 359 "../src/shutdown-dialog.vala"
	_tmp2_ = *allocation;
#line 359 "../src/shutdown-dialog.vala"
	gtk_widget_size_allocate ((GtkWidget*) _tmp1_, &_tmp2_);
#line 361 "../src/shutdown-dialog.vala"
	memset (&content_allocation, 0, sizeof (GtkAllocation));
#line 363 "../src/shutdown-dialog.vala"
	_tmp3_ = self->priv->vbox_events;
#line 363 "../src/shutdown-dialog.vala"
	gtk_widget_get_preferred_width ((GtkWidget*) _tmp3_, &_tmp4_, &_tmp5_);
#line 363 "../src/shutdown-dialog.vala"
	minimum_width = _tmp4_;
#line 363 "../src/shutdown-dialog.vala"
	natural_width = _tmp5_;
#line 364 "../src/shutdown-dialog.vala"
	_tmp6_ = self->priv->vbox_events;
#line 364 "../src/shutdown-dialog.vala"
	gtk_widget_get_preferred_height_for_width ((GtkWidget*) _tmp6_, minimum_width, &_tmp7_, &_tmp8_);
#line 364 "../src/shutdown-dialog.vala"
	minimum_height = _tmp7_;
#line 364 "../src/shutdown-dialog.vala"
	natural_height = _tmp8_;
#line 365 "../src/shutdown-dialog.vala"
	_tmp9_ = *allocation;
#line 365 "../src/shutdown-dialog.vala"
	_tmp10_ = *allocation;
#line 365 "../src/shutdown-dialog.vala"
	content_allocation.x = _tmp9_.x + ((_tmp10_.width - minimum_width) / 2);
#line 366 "../src/shutdown-dialog.vala"
	_tmp11_ = *allocation;
#line 366 "../src/shutdown-dialog.vala"
	_tmp12_ = *allocation;
#line 366 "../src/shutdown-dialog.vala"
	content_allocation.y = _tmp11_.y + ((_tmp12_.height - minimum_height) / 2);
#line 367 "../src/shutdown-dialog.vala"
	content_allocation.width = minimum_width;
#line 368 "../src/shutdown-dialog.vala"
	content_allocation.height = minimum_height;
#line 369 "../src/shutdown-dialog.vala"
	_tmp13_ = self->priv->vbox_events;
#line 369 "../src/shutdown-dialog.vala"
	_tmp14_ = content_allocation;
#line 369 "../src/shutdown-dialog.vala"
	gtk_widget_size_allocate ((GtkWidget*) _tmp13_, &_tmp14_);
#line 371 "../src/shutdown-dialog.vala"
	memset (&a, 0, sizeof (GtkAllocation));
#line 372 "../src/shutdown-dialog.vala"
	_tmp15_ = self->priv->close_button;
#line 372 "../src/shutdown-dialog.vala"
	gtk_widget_get_preferred_width ((GtkWidget*) _tmp15_, &_tmp16_, &_tmp17_);
#line 372 "../src/shutdown-dialog.vala"
	minimum_width = _tmp16_;
#line 372 "../src/shutdown-dialog.vala"
	natural_width = _tmp17_;
#line 373 "../src/shutdown-dialog.vala"
	_tmp18_ = self->priv->close_button;
#line 373 "../src/shutdown-dialog.vala"
	gtk_widget_get_preferred_height ((GtkWidget*) _tmp18_, &_tmp19_, &_tmp20_);
#line 373 "../src/shutdown-dialog.vala"
	minimum_height = _tmp19_;
#line 373 "../src/shutdown-dialog.vala"
	natural_height = _tmp20_;
#line 374 "../src/shutdown-dialog.vala"
	_tmp21_ = content_allocation;
#line 374 "../src/shutdown-dialog.vala"
	a.x = (_tmp21_.x - SHUTDOWN_DIALOG_BORDER_EXTERNAL_SIZE) + SHUTDOWN_DIALOG_CLOSE_OFFSET;
#line 375 "../src/shutdown-dialog.vala"
	_tmp22_ = content_allocation;
#line 375 "../src/shutdown-dialog.vala"
	a.y = (_tmp22_.y - SHUTDOWN_DIALOG_BORDER_EXTERNAL_SIZE) + SHUTDOWN_DIALOG_CLOSE_OFFSET;
#line 376 "../src/shutdown-dialog.vala"
	a.width = minimum_width;
#line 377 "../src/shutdown-dialog.vala"
	a.height = minimum_height;
#line 378 "../src/shutdown-dialog.vala"
	_tmp23_ = self->priv->close_button;
#line 378 "../src/shutdown-dialog.vala"
	_tmp24_ = a;
#line 378 "../src/shutdown-dialog.vala"
	gtk_widget_size_allocate ((GtkWidget*) _tmp23_, &_tmp24_);
#line 2172 "shutdown-dialog.c"
}

static gboolean
shutdown_dialog_real_draw (GtkWidget* base,
                           cairo_t* c)
{
	ShutdownDialog * self;
	cairo_surface_t* _tmp0_;
	gint width = 0;
	GtkEventBox* _tmp18_;
	gint height = 0;
	GtkEventBox* _tmp19_;
	gint x = 0;
	gint y = 0;
	AnimateTimer* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_ = FALSE;
	cairo_surface_t* _tmp24_;
	cairo_surface_t* _tmp38_;
	GdkRGBA _tmp39_;
	GdkRGBA _tmp40_;
	GdkRGBA _tmp41_;
	GdkRGBA _tmp42_;
	cairo_matrix_t m = {0};
	cairo_pattern_t* _tmp43_;
	cairo_matrix_t _tmp44_;
	cairo_pattern_t* _tmp45_;
	cairo_pattern_t* _tmp46_;
	cairo_matrix_t _tmp47_;
	cairo_pattern_t* _tmp48_;
	cairo_pattern_t* _tmp49_;
	cairo_matrix_t _tmp50_;
	cairo_pattern_t* _tmp51_;
	cairo_pattern_t* _tmp52_;
	cairo_matrix_t _tmp53_;
	cairo_pattern_t* _tmp54_;
	cairo_pattern_t* _tmp55_;
	cairo_matrix_t _tmp56_;
	cairo_pattern_t* _tmp57_;
	cairo_pattern_t* _tmp58_;
	cairo_matrix_t _tmp59_;
	cairo_pattern_t* _tmp60_;
	cairo_pattern_t* _tmp61_;
	cairo_matrix_t _tmp62_;
	cairo_pattern_t* _tmp63_;
	cairo_pattern_t* _tmp64_;
	cairo_matrix_t _tmp65_;
	cairo_pattern_t* _tmp66_;
	gboolean ret = FALSE;
	AnimateTimer* _tmp67_;
	gboolean _tmp68_;
	gboolean _tmp69_;
	gboolean result;
#line 381 "../src/shutdown-dialog.vala"
	self = (ShutdownDialog*) base;
#line 381 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 383 "../src/shutdown-dialog.vala"
	_tmp0_ = self->priv->corner_surface;
#line 383 "../src/shutdown-dialog.vala"
	if (_tmp0_ == NULL) {
#line 2235 "shutdown-dialog.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		cairo_surface_t* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		cairo_surface_t* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		cairo_surface_t* _tmp9_;
		cairo_surface_t* _tmp10_;
		cairo_pattern_t* _tmp11_;
		cairo_surface_t* _tmp12_;
		cairo_pattern_t* _tmp13_;
		cairo_pattern_t* _tmp14_;
		cairo_surface_t* _tmp15_;
		cairo_pattern_t* _tmp16_;
		cairo_pattern_t* _tmp17_;
#line 385 "../src/shutdown-dialog.vala"
		_tmp1_ = g_build_filename (PKGDATADIR, "switcher_corner.png", NULL);
#line 385 "../src/shutdown-dialog.vala"
		_tmp2_ = _tmp1_;
#line 385 "../src/shutdown-dialog.vala"
		_tmp3_ = cairo_image_surface_create_from_png (_tmp2_);
#line 385 "../src/shutdown-dialog.vala"
		_cairo_surface_destroy0 (self->priv->corner_surface);
#line 385 "../src/shutdown-dialog.vala"
		self->priv->corner_surface = _tmp3_;
#line 385 "../src/shutdown-dialog.vala"
		_g_free0 (_tmp2_);
#line 386 "../src/shutdown-dialog.vala"
		_tmp4_ = g_build_filename (PKGDATADIR, "switcher_left.png", NULL);
#line 386 "../src/shutdown-dialog.vala"
		_tmp5_ = _tmp4_;
#line 386 "../src/shutdown-dialog.vala"
		_tmp6_ = cairo_image_surface_create_from_png (_tmp5_);
#line 386 "../src/shutdown-dialog.vala"
		_cairo_surface_destroy0 (self->priv->left_surface);
#line 386 "../src/shutdown-dialog.vala"
		self->priv->left_surface = _tmp6_;
#line 386 "../src/shutdown-dialog.vala"
		_g_free0 (_tmp5_);
#line 387 "../src/shutdown-dialog.vala"
		_tmp7_ = g_build_filename (PKGDATADIR, "switcher_top.png", NULL);
#line 387 "../src/shutdown-dialog.vala"
		_tmp8_ = _tmp7_;
#line 387 "../src/shutdown-dialog.vala"
		_tmp9_ = cairo_image_surface_create_from_png (_tmp8_);
#line 387 "../src/shutdown-dialog.vala"
		_cairo_surface_destroy0 (self->priv->top_surface);
#line 387 "../src/shutdown-dialog.vala"
		self->priv->top_surface = _tmp9_;
#line 387 "../src/shutdown-dialog.vala"
		_g_free0 (_tmp8_);
#line 388 "../src/shutdown-dialog.vala"
		_tmp10_ = self->priv->corner_surface;
#line 388 "../src/shutdown-dialog.vala"
		_tmp11_ = cairo_pattern_create_for_surface (_tmp10_);
#line 388 "../src/shutdown-dialog.vala"
		_cairo_pattern_destroy0 (self->priv->corner_pattern);
#line 388 "../src/shutdown-dialog.vala"
		self->priv->corner_pattern = _tmp11_;
#line 389 "../src/shutdown-dialog.vala"
		_tmp12_ = self->priv->left_surface;
#line 389 "../src/shutdown-dialog.vala"
		_tmp13_ = cairo_pattern_create_for_surface (_tmp12_);
#line 389 "../src/shutdown-dialog.vala"
		_cairo_pattern_destroy0 (self->priv->left_pattern);
#line 389 "../src/shutdown-dialog.vala"
		self->priv->left_pattern = _tmp13_;
#line 390 "../src/shutdown-dialog.vala"
		_tmp14_ = self->priv->left_pattern;
#line 390 "../src/shutdown-dialog.vala"
		cairo_pattern_set_extend (_tmp14_, CAIRO_EXTEND_REPEAT);
#line 391 "../src/shutdown-dialog.vala"
		_tmp15_ = self->priv->top_surface;
#line 391 "../src/shutdown-dialog.vala"
		_tmp16_ = cairo_pattern_create_for_surface (_tmp15_);
#line 391 "../src/shutdown-dialog.vala"
		_cairo_pattern_destroy0 (self->priv->top_pattern);
#line 391 "../src/shutdown-dialog.vala"
		self->priv->top_pattern = _tmp16_;
#line 392 "../src/shutdown-dialog.vala"
		_tmp17_ = self->priv->top_pattern;
#line 392 "../src/shutdown-dialog.vala"
		cairo_pattern_set_extend (_tmp17_, CAIRO_EXTEND_REPEAT);
#line 2321 "shutdown-dialog.c"
	}
#line 395 "../src/shutdown-dialog.vala"
	_tmp18_ = self->priv->vbox_events;
#line 395 "../src/shutdown-dialog.vala"
	width = gtk_widget_get_allocated_width ((GtkWidget*) _tmp18_);
#line 396 "../src/shutdown-dialog.vala"
	_tmp19_ = self->priv->vbox_events;
#line 396 "../src/shutdown-dialog.vala"
	height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp19_);
#line 397 "../src/shutdown-dialog.vala"
	x = (gtk_widget_get_allocated_width ((GtkWidget*) self) - width) / 2;
#line 398 "../src/shutdown-dialog.vala"
	y = (gtk_widget_get_allocated_height ((GtkWidget*) self) - height) / 2;
#line 400 "../src/shutdown-dialog.vala"
	_tmp20_ = self->priv->animation;
#line 400 "../src/shutdown-dialog.vala"
	_tmp21_ = animate_timer_get_is_running (_tmp20_);
#line 400 "../src/shutdown-dialog.vala"
	_tmp22_ = _tmp21_;
#line 400 "../src/shutdown-dialog.vala"
	if (_tmp22_) {
#line 401 "../src/shutdown-dialog.vala"
		cairo_push_group (c);
#line 2345 "shutdown-dialog.c"
	}
#line 404 "../src/shutdown-dialog.vala"
	cairo_set_source_rgba (c, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
#line 405 "../src/shutdown-dialog.vala"
	cairo_paint (c);
#line 407 "../src/shutdown-dialog.vala"
	_tmp24_ = self->priv->bg_surface;
#line 407 "../src/shutdown-dialog.vala"
	if (_tmp24_ == NULL) {
#line 407 "../src/shutdown-dialog.vala"
		_tmp23_ = TRUE;
#line 2357 "shutdown-dialog.c"
	} else {
		AnimateTimer* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
#line 407 "../src/shutdown-dialog.vala"
		_tmp25_ = self->priv->animation;
#line 407 "../src/shutdown-dialog.vala"
		_tmp26_ = animate_timer_get_is_running (_tmp25_);
#line 407 "../src/shutdown-dialog.vala"
		_tmp27_ = _tmp26_;
#line 407 "../src/shutdown-dialog.vala"
		_tmp23_ = _tmp27_;
#line 2370 "shutdown-dialog.c"
	}
#line 407 "../src/shutdown-dialog.vala"
	if (_tmp23_) {
#line 2374 "shutdown-dialog.c"
		cairo_surface_t* _tmp28_;
		cairo_t* bg_cr = NULL;
		cairo_surface_t* _tmp29_;
		cairo_t* _tmp30_;
		cairo_t* _tmp31_;
		cairo_surface_t* _tmp32_;
		Monitor* _tmp33_;
		Monitor* _tmp34_;
		cairo_t* _tmp35_;
		cairo_t* _tmp36_;
		cairo_surface_t* _tmp37_;
#line 410 "../src/shutdown-dialog.vala"
		_tmp28_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
#line 410 "../src/shutdown-dialog.vala"
		_cairo_surface_destroy0 (self->priv->bg_surface);
#line 410 "../src/shutdown-dialog.vala"
		self->priv->bg_surface = _tmp28_;
#line 411 "../src/shutdown-dialog.vala"
		_tmp29_ = self->priv->bg_surface;
#line 411 "../src/shutdown-dialog.vala"
		_tmp30_ = cairo_create (_tmp29_);
#line 411 "../src/shutdown-dialog.vala"
		bg_cr = _tmp30_;
#line 413 "../src/shutdown-dialog.vala"
		_tmp31_ = bg_cr;
#line 413 "../src/shutdown-dialog.vala"
		_tmp32_ = cairo_get_target (c);
#line 413 "../src/shutdown-dialog.vala"
		_tmp33_ = self->priv->monitor;
#line 413 "../src/shutdown-dialog.vala"
		_tmp34_ = self->priv->monitor;
#line 413 "../src/shutdown-dialog.vala"
		cairo_set_source_surface (_tmp31_, _tmp32_, (gdouble) ((-x) - _tmp33_->x), (gdouble) ((-y) - _tmp34_->y));
#line 414 "../src/shutdown-dialog.vala"
		_tmp35_ = bg_cr;
#line 414 "../src/shutdown-dialog.vala"
		cairo_rectangle (_tmp35_, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
#line 415 "../src/shutdown-dialog.vala"
		_tmp36_ = bg_cr;
#line 415 "../src/shutdown-dialog.vala"
		cairo_fill (_tmp36_);
#line 417 "../src/shutdown-dialog.vala"
		_tmp37_ = self->priv->bg_surface;
#line 417 "../src/shutdown-dialog.vala"
		cairo_utils_exponential_blur_surface (_tmp37_, SHUTDOWN_DIALOG_BLUR_RADIUS);
#line 407 "../src/shutdown-dialog.vala"
		_cairo_destroy0 (bg_cr);
#line 2422 "shutdown-dialog.c"
	}
#line 421 "../src/shutdown-dialog.vala"
	cairo_save (c);
#line 422 "../src/shutdown-dialog.vala"
	cairo_translate (c, (gdouble) x, (gdouble) y);
#line 424 "../src/shutdown-dialog.vala"
	cairo_utils_rounded_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) 4);
#line 425 "../src/shutdown-dialog.vala"
	_tmp38_ = self->priv->bg_surface;
#line 425 "../src/shutdown-dialog.vala"
	cairo_set_source_surface (c, _tmp38_, (gdouble) 0, (gdouble) 0);
#line 426 "../src/shutdown-dialog.vala"
	cairo_fill_preserve (c);
#line 427 "../src/shutdown-dialog.vala"
	_tmp39_ = self->priv->avg_color;
#line 427 "../src/shutdown-dialog.vala"
	_tmp40_ = self->priv->avg_color;
#line 427 "../src/shutdown-dialog.vala"
	_tmp41_ = self->priv->avg_color;
#line 427 "../src/shutdown-dialog.vala"
	_tmp42_ = self->priv->avg_color;
#line 427 "../src/shutdown-dialog.vala"
	cairo_set_source_rgba (c, _tmp39_.red, _tmp40_.green, _tmp41_.blue, _tmp42_.alpha);
#line 428 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 430 "../src/shutdown-dialog.vala"
	cairo_restore (c);
#line 433 "../src/shutdown-dialog.vala"
	x -= SHUTDOWN_DIALOG_BORDER_EXTERNAL_SIZE;
#line 434 "../src/shutdown-dialog.vala"
	y -= SHUTDOWN_DIALOG_BORDER_EXTERNAL_SIZE;
#line 435 "../src/shutdown-dialog.vala"
	width += SHUTDOWN_DIALOG_BORDER_EXTERNAL_SIZE * 2;
#line 436 "../src/shutdown-dialog.vala"
	height += SHUTDOWN_DIALOG_BORDER_EXTERNAL_SIZE * 2;
#line 438 "../src/shutdown-dialog.vala"
	cairo_save (c);
#line 439 "../src/shutdown-dialog.vala"
	cairo_translate (c, (gdouble) x, (gdouble) y);
#line 442 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 443 "../src/shutdown-dialog.vala"
	_tmp43_ = self->priv->corner_pattern;
#line 443 "../src/shutdown-dialog.vala"
	_tmp44_ = m;
#line 443 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp43_, &_tmp44_);
#line 444 "../src/shutdown-dialog.vala"
	_tmp45_ = self->priv->corner_pattern;
#line 444 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp45_);
#line 445 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE);
#line 446 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 449 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 450 "../src/shutdown-dialog.vala"
	cairo_matrix_translate (&m, (gdouble) width, (gdouble) 0);
#line 451 "../src/shutdown-dialog.vala"
	cairo_matrix_scale (&m, (gdouble) -1, (gdouble) 1);
#line 452 "../src/shutdown-dialog.vala"
	_tmp46_ = self->priv->corner_pattern;
#line 452 "../src/shutdown-dialog.vala"
	_tmp47_ = m;
#line 452 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp46_, &_tmp47_);
#line 453 "../src/shutdown-dialog.vala"
	_tmp48_ = self->priv->corner_pattern;
#line 453 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp48_);
#line 454 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) (width - SHUTDOWN_DIALOG_BORDER_SIZE), (gdouble) 0, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE);
#line 455 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 458 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 459 "../src/shutdown-dialog.vala"
	cairo_matrix_translate (&m, (gdouble) 0, (gdouble) height);
#line 460 "../src/shutdown-dialog.vala"
	cairo_matrix_scale (&m, (gdouble) 1, (gdouble) -1);
#line 461 "../src/shutdown-dialog.vala"
	_tmp49_ = self->priv->corner_pattern;
#line 461 "../src/shutdown-dialog.vala"
	_tmp50_ = m;
#line 461 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp49_, &_tmp50_);
#line 462 "../src/shutdown-dialog.vala"
	_tmp51_ = self->priv->corner_pattern;
#line 462 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp51_);
#line 463 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) 0, (gdouble) (height - SHUTDOWN_DIALOG_BORDER_SIZE), (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE);
#line 464 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 467 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 468 "../src/shutdown-dialog.vala"
	cairo_matrix_translate (&m, (gdouble) width, (gdouble) height);
#line 469 "../src/shutdown-dialog.vala"
	cairo_matrix_scale (&m, (gdouble) -1, (gdouble) -1);
#line 470 "../src/shutdown-dialog.vala"
	_tmp52_ = self->priv->corner_pattern;
#line 470 "../src/shutdown-dialog.vala"
	_tmp53_ = m;
#line 470 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp52_, &_tmp53_);
#line 471 "../src/shutdown-dialog.vala"
	_tmp54_ = self->priv->corner_pattern;
#line 471 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp54_);
#line 472 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) (width - SHUTDOWN_DIALOG_BORDER_SIZE), (gdouble) (height - SHUTDOWN_DIALOG_BORDER_SIZE), (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE);
#line 473 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 476 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 477 "../src/shutdown-dialog.vala"
	_tmp55_ = self->priv->left_pattern;
#line 477 "../src/shutdown-dialog.vala"
	_tmp56_ = m;
#line 477 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp55_, &_tmp56_);
#line 478 "../src/shutdown-dialog.vala"
	_tmp57_ = self->priv->left_pattern;
#line 478 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp57_);
#line 479 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) 0, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) (height - (SHUTDOWN_DIALOG_BORDER_SIZE * 2)));
#line 480 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 483 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 484 "../src/shutdown-dialog.vala"
	cairo_matrix_translate (&m, (gdouble) width, (gdouble) 0);
#line 485 "../src/shutdown-dialog.vala"
	cairo_matrix_scale (&m, (gdouble) -1, (gdouble) 1);
#line 486 "../src/shutdown-dialog.vala"
	_tmp58_ = self->priv->left_pattern;
#line 486 "../src/shutdown-dialog.vala"
	_tmp59_ = m;
#line 486 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp58_, &_tmp59_);
#line 487 "../src/shutdown-dialog.vala"
	_tmp60_ = self->priv->left_pattern;
#line 487 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp60_);
#line 488 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) (width - SHUTDOWN_DIALOG_BORDER_SIZE), (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) (height - (SHUTDOWN_DIALOG_BORDER_SIZE * 2)));
#line 489 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 492 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 493 "../src/shutdown-dialog.vala"
	_tmp61_ = self->priv->top_pattern;
#line 493 "../src/shutdown-dialog.vala"
	_tmp62_ = m;
#line 493 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp61_, &_tmp62_);
#line 494 "../src/shutdown-dialog.vala"
	_tmp63_ = self->priv->top_pattern;
#line 494 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp63_);
#line 495 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) 0, (gdouble) (width - (SHUTDOWN_DIALOG_BORDER_SIZE * 2)), (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE);
#line 496 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 499 "../src/shutdown-dialog.vala"
	cairo_matrix_init_identity (&m);
#line 500 "../src/shutdown-dialog.vala"
	cairo_matrix_translate (&m, (gdouble) 0, (gdouble) height);
#line 501 "../src/shutdown-dialog.vala"
	cairo_matrix_scale (&m, (gdouble) 1, (gdouble) -1);
#line 502 "../src/shutdown-dialog.vala"
	_tmp64_ = self->priv->top_pattern;
#line 502 "../src/shutdown-dialog.vala"
	_tmp65_ = m;
#line 502 "../src/shutdown-dialog.vala"
	cairo_pattern_set_matrix (_tmp64_, &_tmp65_);
#line 503 "../src/shutdown-dialog.vala"
	_tmp66_ = self->priv->top_pattern;
#line 503 "../src/shutdown-dialog.vala"
	cairo_set_source (c, _tmp66_);
#line 504 "../src/shutdown-dialog.vala"
	cairo_rectangle (c, (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE, (gdouble) (height - SHUTDOWN_DIALOG_BORDER_SIZE), (gdouble) (width - (SHUTDOWN_DIALOG_BORDER_SIZE * 2)), (gdouble) SHUTDOWN_DIALOG_BORDER_SIZE);
#line 505 "../src/shutdown-dialog.vala"
	cairo_fill (c);
#line 507 "../src/shutdown-dialog.vala"
	cairo_restore (c);
#line 509 "../src/shutdown-dialog.vala"
	ret = GTK_WIDGET_CLASS (shutdown_dialog_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_fixed_get_type (), GtkFixed), c);
#line 511 "../src/shutdown-dialog.vala"
	_tmp67_ = self->priv->animation;
#line 511 "../src/shutdown-dialog.vala"
	_tmp68_ = animate_timer_get_is_running (_tmp67_);
#line 511 "../src/shutdown-dialog.vala"
	_tmp69_ = _tmp68_;
#line 511 "../src/shutdown-dialog.vala"
	if (_tmp69_) {
#line 2622 "shutdown-dialog.c"
		gdouble _tmp70_ = 0.0;
#line 513 "../src/shutdown-dialog.vala"
		cairo_pop_group_to_source (c);
#line 514 "../src/shutdown-dialog.vala"
		if (self->priv->closing) {
#line 2628 "shutdown-dialog.c"
			AnimateTimer* _tmp71_;
			gdouble _tmp72_;
			gdouble _tmp73_;
#line 514 "../src/shutdown-dialog.vala"
			_tmp71_ = self->priv->animation;
#line 514 "../src/shutdown-dialog.vala"
			_tmp72_ = animate_timer_get_progress (_tmp71_);
#line 514 "../src/shutdown-dialog.vala"
			_tmp73_ = _tmp72_;
#line 514 "../src/shutdown-dialog.vala"
			_tmp70_ = 1.0f - _tmp73_;
#line 2640 "shutdown-dialog.c"
		} else {
			AnimateTimer* _tmp74_;
			gdouble _tmp75_;
			gdouble _tmp76_;
#line 514 "../src/shutdown-dialog.vala"
			_tmp74_ = self->priv->animation;
#line 514 "../src/shutdown-dialog.vala"
			_tmp75_ = animate_timer_get_progress (_tmp74_);
#line 514 "../src/shutdown-dialog.vala"
			_tmp76_ = _tmp75_;
#line 514 "../src/shutdown-dialog.vala"
			_tmp70_ = _tmp76_;
#line 2653 "shutdown-dialog.c"
		}
#line 514 "../src/shutdown-dialog.vala"
		cairo_paint_with_alpha (c, _tmp70_);
#line 2657 "shutdown-dialog.c"
	}
#line 517 "../src/shutdown-dialog.vala"
	result = ret;
#line 517 "../src/shutdown-dialog.vala"
	return result;
#line 2663 "shutdown-dialog.c"
}

static DialogButton*
shutdown_dialog_add_button (ShutdownDialog* self,
                            const gchar* text,
                            const gchar* inactive_filename,
                            const gchar* active_filename)
{
	GtkBox* b = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp2_;
	DialogButton* button = NULL;
	DialogButton* _tmp3_;
	DialogButton* result;
#line 520 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 520 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 520 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (inactive_filename != NULL, NULL);
#line 520 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (active_filename != NULL, NULL);
#line 522 "../src/shutdown-dialog.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, SHUTDOWN_DIALOG_BUTTON_TEXT_SPACE);
#line 522 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 522 "../src/shutdown-dialog.vala"
	b = _tmp0_;
#line 523 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) b, TRUE);
#line 524 "../src/shutdown-dialog.vala"
	_tmp1_ = self->priv->button_box;
#line 524 "../src/shutdown-dialog.vala"
	gtk_box_pack_start (_tmp1_, (GtkWidget*) b, FALSE, FALSE, (guint) 0);
#line 526 "../src/shutdown-dialog.vala"
	_tmp2_ = (GtkLabel*) gtk_label_new (text);
#line 526 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp2_);
#line 526 "../src/shutdown-dialog.vala"
	label = _tmp2_;
#line 527 "../src/shutdown-dialog.vala"
	_tmp3_ = dialog_button_new (inactive_filename, active_filename, NULL, label);
#line 527 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp3_);
#line 527 "../src/shutdown-dialog.vala"
	button = _tmp3_;
#line 528 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) button, TRUE);
#line 530 "../src/shutdown-dialog.vala"
	gtk_box_pack_start (b, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
#line 531 "../src/shutdown-dialog.vala"
	gtk_box_pack_start (b, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
#line 533 "../src/shutdown-dialog.vala"
	result = button;
#line 533 "../src/shutdown-dialog.vala"
	_g_object_unref0 (label);
#line 533 "../src/shutdown-dialog.vala"
	_g_object_unref0 (b);
#line 533 "../src/shutdown-dialog.vala"
	return result;
#line 2726 "shutdown-dialog.c"
}

static void
shutdown_dialog_class_init (ShutdownDialogClass * klass,
                            gpointer klass_data)
{
#line 28 "../src/shutdown-dialog.vala"
	shutdown_dialog_parent_class = g_type_class_peek_parent (klass);
#line 28 "../src/shutdown-dialog.vala"
	g_type_class_adjust_private_offset (klass, &ShutdownDialog_private_offset);
#line 28 "../src/shutdown-dialog.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) shutdown_dialog_real_size_allocate;
#line 28 "../src/shutdown-dialog.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) shutdown_dialog_real_draw;
#line 28 "../src/shutdown-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = shutdown_dialog_finalize;
#line 28 "../src/shutdown-dialog.vala"
	shutdown_dialog_signals[SHUTDOWN_DIALOG_CLOSED_SIGNAL] = g_signal_new ("closed", TYPE_SHUTDOWN_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2745 "shutdown-dialog.c"
}

static void
shutdown_dialog_instance_init (ShutdownDialog * self,
                               gpointer klass)
{
#line 28 "../src/shutdown-dialog.vala"
	self->priv = shutdown_dialog_get_instance_private (self);
#line 32 "../src/shutdown-dialog.vala"
	self->priv->bg_surface = NULL;
#line 33 "../src/shutdown-dialog.vala"
	self->priv->corner_surface = NULL;
#line 34 "../src/shutdown-dialog.vala"
	self->priv->left_surface = NULL;
#line 35 "../src/shutdown-dialog.vala"
	self->priv->top_surface = NULL;
#line 36 "../src/shutdown-dialog.vala"
	self->priv->corner_pattern = NULL;
#line 37 "../src/shutdown-dialog.vala"
	self->priv->left_pattern = NULL;
#line 38 "../src/shutdown-dialog.vala"
	self->priv->top_pattern = NULL;
#line 58 "../src/shutdown-dialog.vala"
	self->priv->closing = FALSE;
#line 2770 "shutdown-dialog.c"
}

static void
shutdown_dialog_finalize (GObject * obj)
{
	ShutdownDialog * self;
#line 28 "../src/shutdown-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHUTDOWN_DIALOG, ShutdownDialog);
#line 32 "../src/shutdown-dialog.vala"
	_cairo_surface_destroy0 (self->priv->bg_surface);
#line 33 "../src/shutdown-dialog.vala"
	_cairo_surface_destroy0 (self->priv->corner_surface);
#line 34 "../src/shutdown-dialog.vala"
	_cairo_surface_destroy0 (self->priv->left_surface);
#line 35 "../src/shutdown-dialog.vala"
	_cairo_surface_destroy0 (self->priv->top_surface);
#line 36 "../src/shutdown-dialog.vala"
	_cairo_pattern_destroy0 (self->priv->corner_pattern);
#line 37 "../src/shutdown-dialog.vala"
	_cairo_pattern_destroy0 (self->priv->left_pattern);
#line 38 "../src/shutdown-dialog.vala"
	_cairo_pattern_destroy0 (self->priv->top_pattern);
#line 47 "../src/shutdown-dialog.vala"
	_monitor_unref0 (self->priv->monitor);
#line 51 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->vbox);
#line 52 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->close_button);
#line 53 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->button_box);
#line 54 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->monitor_events);
#line 55 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->vbox_events);
#line 57 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->animation);
#line 28 "../src/shutdown-dialog.vala"
	G_OBJECT_CLASS (shutdown_dialog_parent_class)->finalize (obj);
#line 2809 "shutdown-dialog.c"
}

static GType
shutdown_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShutdownDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shutdown_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShutdownDialog), 0, (GInstanceInitFunc) shutdown_dialog_instance_init, NULL };
	GType shutdown_dialog_type_id;
	shutdown_dialog_type_id = g_type_register_static (gtk_fixed_get_type (), "ShutdownDialog", &g_define_type_info, 0);
	ShutdownDialog_private_offset = g_type_add_instance_private (shutdown_dialog_type_id, sizeof (ShutdownDialogPrivate));
	return shutdown_dialog_type_id;
}

GType
shutdown_dialog_get_type (void)
{
	static volatile gsize shutdown_dialog_type_id__once = 0;
	if (g_once_init_enter (&shutdown_dialog_type_id__once)) {
		GType shutdown_dialog_type_id;
		shutdown_dialog_type_id = shutdown_dialog_get_type_once ();
		g_once_init_leave (&shutdown_dialog_type_id__once, shutdown_dialog_type_id);
	}
	return shutdown_dialog_type_id__once;
}

static inline gpointer
dialog_button_get_instance_private (DialogButton* self)
{
	return G_STRUCT_MEMBER_P (self, DialogButton_private_offset);
}

DialogButton*
dialog_button_construct (GType object_type,
                         const gchar* inactive_filename,
                         const gchar* focused_filename,
                         const gchar* active_filename,
                         GtkLabel* label)
{
	DialogButton * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GError* _inner_error0_ = NULL;
#line 545 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (inactive_filename != NULL, NULL);
#line 545 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (focused_filename != NULL, NULL);
#line 545 "../src/shutdown-dialog.vala"
	self = (DialogButton*) g_object_new (object_type, NULL);
#line 547 "../src/shutdown-dialog.vala"
	_tmp0_ = g_strdup (inactive_filename);
#line 547 "../src/shutdown-dialog.vala"
	_g_free0 (self->priv->inactive_filename);
#line 547 "../src/shutdown-dialog.vala"
	self->priv->inactive_filename = _tmp0_;
#line 548 "../src/shutdown-dialog.vala"
	_tmp1_ = g_strdup (focused_filename);
#line 548 "../src/shutdown-dialog.vala"
	_g_free0 (self->priv->focused_filename);
#line 548 "../src/shutdown-dialog.vala"
	self->priv->focused_filename = _tmp1_;
#line 549 "../src/shutdown-dialog.vala"
	_tmp2_ = g_strdup (active_filename);
#line 549 "../src/shutdown-dialog.vala"
	_g_free0 (self->priv->active_filename);
#line 549 "../src/shutdown-dialog.vala"
	self->priv->active_filename = _tmp2_;
#line 550 "../src/shutdown-dialog.vala"
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
#line 551 "../src/shutdown-dialog.vala"
	gtk_button_set_focus_on_click ((GtkButton*) self, FALSE);
#line 552 "../src/shutdown-dialog.vala"
	_tmp3_ = (GtkImage*) gtk_image_new_from_file (inactive_filename);
#line 552 "../src/shutdown-dialog.vala"
	g_object_ref_sink (_tmp3_);
#line 552 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->i);
#line 552 "../src/shutdown-dialog.vala"
	self->priv->i = _tmp3_;
#line 553 "../src/shutdown-dialog.vala"
	_tmp4_ = self->priv->i;
#line 553 "../src/shutdown-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, TRUE);
#line 554 "../src/shutdown-dialog.vala"
	_tmp5_ = self->priv->i;
#line 554 "../src/shutdown-dialog.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
#line 556 "../src/shutdown-dialog.vala"
	_tmp6_ = _g_object_ref0 (label);
#line 556 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->l);
#line 556 "../src/shutdown-dialog.vala"
	self->priv->l = _tmp6_;
#line 558 "../src/shutdown-dialog.vala"
	_tmp7_ = self->priv->l;
#line 558 "../src/shutdown-dialog.vala"
	if (_tmp7_ != NULL) {
#line 2911 "shutdown-dialog.c"
		GtkLabel* _tmp8_;
		GtkLabel* _tmp9_;
		PangoFontDescription* _tmp10_;
		PangoFontDescription* _tmp11_;
		GtkLabel* _tmp12_;
		GdkRGBA _tmp13_ = {0};
		GtkLabel* _tmp14_;
		GdkRGBA _tmp15_ = {0};
		GtkLabel* _tmp16_;
		GdkRGBA _tmp17_ = {0};
		AtkObject* _tmp18_;
		GtkLabel* _tmp19_;
		const gchar* _tmp20_;
#line 560 "../src/shutdown-dialog.vala"
		_tmp8_ = self->priv->l;
#line 560 "../src/shutdown-dialog.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
#line 561 "../src/shutdown-dialog.vala"
		_tmp9_ = self->priv->l;
#line 561 "../src/shutdown-dialog.vala"
		_tmp10_ = pango_font_description_from_string ("Ubuntu Light 12");
#line 561 "../src/shutdown-dialog.vala"
		_tmp11_ = _tmp10_;
#line 561 "../src/shutdown-dialog.vala"
		gtk_widget_override_font ((GtkWidget*) _tmp9_, _tmp11_);
#line 561 "../src/shutdown-dialog.vala"
		__vala_PangoFontDescription_free0 (_tmp11_);
#line 562 "../src/shutdown-dialog.vala"
		_tmp12_ = self->priv->l;
#line 562 "../src/shutdown-dialog.vala"
		_tmp13_.red = (gdouble) 1.0f;
#line 562 "../src/shutdown-dialog.vala"
		_tmp13_.green = (gdouble) 1.0f;
#line 562 "../src/shutdown-dialog.vala"
		_tmp13_.blue = (gdouble) 1.0f;
#line 562 "../src/shutdown-dialog.vala"
		_tmp13_.alpha = (gdouble) 0.0f;
#line 562 "../src/shutdown-dialog.vala"
		gtk_widget_override_color ((GtkWidget*) _tmp12_, GTK_STATE_FLAG_NORMAL, &_tmp13_);
#line 563 "../src/shutdown-dialog.vala"
		_tmp14_ = self->priv->l;
#line 563 "../src/shutdown-dialog.vala"
		_tmp15_.red = (gdouble) 1.0f;
#line 563 "../src/shutdown-dialog.vala"
		_tmp15_.green = (gdouble) 1.0f;
#line 563 "../src/shutdown-dialog.vala"
		_tmp15_.blue = (gdouble) 1.0f;
#line 563 "../src/shutdown-dialog.vala"
		_tmp15_.alpha = (gdouble) 1.0f;
#line 563 "../src/shutdown-dialog.vala"
		gtk_widget_override_color ((GtkWidget*) _tmp14_, GTK_STATE_FLAG_FOCUSED, &_tmp15_);
#line 564 "../src/shutdown-dialog.vala"
		_tmp16_ = self->priv->l;
#line 564 "../src/shutdown-dialog.vala"
		_tmp17_.red = (gdouble) 1.0f;
#line 564 "../src/shutdown-dialog.vala"
		_tmp17_.green = (gdouble) 1.0f;
#line 564 "../src/shutdown-dialog.vala"
		_tmp17_.blue = (gdouble) 1.0f;
#line 564 "../src/shutdown-dialog.vala"
		_tmp17_.alpha = (gdouble) 1.0f;
#line 564 "../src/shutdown-dialog.vala"
		gtk_widget_override_color ((GtkWidget*) _tmp16_, GTK_STATE_FLAG_ACTIVE, &_tmp17_);
#line 565 "../src/shutdown-dialog.vala"
		_tmp18_ = gtk_widget_get_accessible ((GtkWidget*) self);
#line 565 "../src/shutdown-dialog.vala"
		_tmp19_ = self->priv->l;
#line 565 "../src/shutdown-dialog.vala"
		_tmp20_ = gtk_label_get_text (_tmp19_);
#line 565 "../src/shutdown-dialog.vala"
		atk_object_set_name (_tmp18_, _tmp20_);
#line 2983 "shutdown-dialog.c"
	}
#line 568 "../src/shutdown-dialog.vala"
	slick_greeter_add_style_class ((GtkWidget*) self);
#line 2987 "shutdown-dialog.c"
	{
		GtkCssProvider* style = NULL;
		GtkCssProvider* _tmp21_;
		GtkStyleContext* _tmp22_;
#line 572 "../src/shutdown-dialog.vala"
		_tmp21_ = gtk_css_provider_new ();
#line 572 "../src/shutdown-dialog.vala"
		style = _tmp21_;
#line 573 "../src/shutdown-dialog.vala"
		gtk_css_provider_load_from_data (style, "* {padding: 0px 0px 0px 0px; border: 0px; }", (gssize) -1, &_inner_error0_);
#line 573 "../src/shutdown-dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 573 "../src/shutdown-dialog.vala"
			_g_object_unref0 (style);
#line 3002 "shutdown-dialog.c"
			goto __catch0_g_error;
		}
#line 574 "../src/shutdown-dialog.vala"
		_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 574 "../src/shutdown-dialog.vala"
		gtk_style_context_add_provider (_tmp22_, (GtkStyleProvider*) style, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 569 "../src/shutdown-dialog.vala"
		_g_object_unref0 (style);
#line 3011 "shutdown-dialog.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
#line 569 "../src/shutdown-dialog.vala"
		e = _inner_error0_;
#line 569 "../src/shutdown-dialog.vala"
		_inner_error0_ = NULL;
#line 578 "../src/shutdown-dialog.vala"
		_tmp23_ = e;
#line 578 "../src/shutdown-dialog.vala"
		_tmp24_ = _tmp23_->message;
#line 578 "../src/shutdown-dialog.vala"
		g_debug ("shutdown-dialog.vala:578: Internal error loading session chooser style" \
": %s", _tmp24_);
#line 569 "../src/shutdown-dialog.vala"
		_g_error_free0 (e);
#line 3031 "shutdown-dialog.c"
	}
	__finally0:
#line 569 "../src/shutdown-dialog.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 569 "../src/shutdown-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 569 "../src/shutdown-dialog.vala"
		g_clear_error (&_inner_error0_);
#line 569 "../src/shutdown-dialog.vala"
		return NULL;
#line 3042 "shutdown-dialog.c"
	}
#line 545 "../src/shutdown-dialog.vala"
	return self;
#line 3046 "shutdown-dialog.c"
}

DialogButton*
dialog_button_new (const gchar* inactive_filename,
                   const gchar* focused_filename,
                   const gchar* active_filename,
                   GtkLabel* label)
{
#line 545 "../src/shutdown-dialog.vala"
	return dialog_button_construct (TYPE_DIALOG_BUTTON, inactive_filename, focused_filename, active_filename, label);
#line 3057 "shutdown-dialog.c"
}

static gboolean
dialog_button_real_enter_notify_event (GtkWidget* base,
                                       GdkEventCrossing* event)
{
	DialogButton * self;
	gboolean result;
#line 582 "../src/shutdown-dialog.vala"
	self = (DialogButton*) base;
#line 582 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 584 "../src/shutdown-dialog.vala"
	gtk_widget_grab_focus ((GtkWidget*) self);
#line 585 "../src/shutdown-dialog.vala"
	result = GTK_WIDGET_CLASS (dialog_button_parent_class)->enter_notify_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), event);
#line 585 "../src/shutdown-dialog.vala"
	return result;
#line 3076 "shutdown-dialog.c"
}

static gboolean
dialog_button_real_leave_notify_event (GtkWidget* base,
                                       GdkEventCrossing* event)
{
	DialogButton * self;
	GtkWidget* _tmp0_;
	gboolean result;
#line 588 "../src/shutdown-dialog.vala"
	self = (DialogButton*) base;
#line 588 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 590 "../src/shutdown-dialog.vala"
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 590 "../src/shutdown-dialog.vala"
	gtk_window_set_focus (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL, NULL);
#line 591 "../src/shutdown-dialog.vala"
	result = GTK_WIDGET_CLASS (dialog_button_parent_class)->leave_notify_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), event);
#line 591 "../src/shutdown-dialog.vala"
	return result;
#line 3098 "shutdown-dialog.c"
}

static gboolean
dialog_button_real_draw (GtkWidget* base,
                         cairo_t* c)
{
	DialogButton * self;
	GtkImage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
#line 594 "../src/shutdown-dialog.vala"
	self = (DialogButton*) base;
#line 594 "../src/shutdown-dialog.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 596 "../src/shutdown-dialog.vala"
	_tmp0_ = self->priv->i;
#line 596 "../src/shutdown-dialog.vala"
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "draw", c, &_tmp1_);
#line 597 "../src/shutdown-dialog.vala"
	result = TRUE;
#line 597 "../src/shutdown-dialog.vala"
	return result;
#line 3121 "shutdown-dialog.c"
}

static void
dialog_button_real_state_flags_changed (GtkWidget* base,
                                        GtkStateFlags previous_state)
{
	DialogButton * self;
	GtkStateFlags new_flags = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkLabel* _tmp12_;
#line 600 "../src/shutdown-dialog.vala"
	self = (DialogButton*) base;
#line 602 "../src/shutdown-dialog.vala"
	new_flags = gtk_widget_get_state_flags ((GtkWidget*) self);
#line 604 "../src/shutdown-dialog.vala"
	if ((new_flags & GTK_STATE_FLAG_PRELIGHT) != 0) {
#line 3139 "shutdown-dialog.c"
		gboolean _tmp2_;
		gboolean _tmp3_;
#line 604 "../src/shutdown-dialog.vala"
		_tmp2_ = gtk_widget_get_can_focus ((GtkWidget*) self);
#line 604 "../src/shutdown-dialog.vala"
		_tmp3_ = _tmp2_;
#line 604 "../src/shutdown-dialog.vala"
		_tmp1_ = !_tmp3_;
#line 3148 "shutdown-dialog.c"
	} else {
#line 604 "../src/shutdown-dialog.vala"
		_tmp1_ = FALSE;
#line 3152 "shutdown-dialog.c"
	}
#line 604 "../src/shutdown-dialog.vala"
	if (_tmp1_) {
#line 604 "../src/shutdown-dialog.vala"
		_tmp0_ = TRUE;
#line 3158 "shutdown-dialog.c"
	} else {
#line 605 "../src/shutdown-dialog.vala"
		_tmp0_ = (new_flags & GTK_STATE_FLAG_FOCUSED) != 0;
#line 3162 "shutdown-dialog.c"
	}
#line 604 "../src/shutdown-dialog.vala"
	if (_tmp0_) {
#line 3166 "shutdown-dialog.c"
		gboolean _tmp4_ = FALSE;
#line 607 "../src/shutdown-dialog.vala"
		if ((new_flags & GTK_STATE_FLAG_ACTIVE) != 0) {
#line 3170 "shutdown-dialog.c"
			const gchar* _tmp5_;
#line 607 "../src/shutdown-dialog.vala"
			_tmp5_ = self->priv->active_filename;
#line 607 "../src/shutdown-dialog.vala"
			_tmp4_ = _tmp5_ != NULL;
#line 3176 "shutdown-dialog.c"
		} else {
#line 607 "../src/shutdown-dialog.vala"
			_tmp4_ = FALSE;
#line 3180 "shutdown-dialog.c"
		}
#line 607 "../src/shutdown-dialog.vala"
		if (_tmp4_) {
#line 3184 "shutdown-dialog.c"
			GtkImage* _tmp6_;
			const gchar* _tmp7_;
#line 608 "../src/shutdown-dialog.vala"
			_tmp6_ = self->priv->i;
#line 608 "../src/shutdown-dialog.vala"
			_tmp7_ = self->priv->active_filename;
#line 608 "../src/shutdown-dialog.vala"
			gtk_image_set_from_file (_tmp6_, _tmp7_);
#line 3193 "shutdown-dialog.c"
		} else {
			GtkImage* _tmp8_;
			const gchar* _tmp9_;
#line 610 "../src/shutdown-dialog.vala"
			_tmp8_ = self->priv->i;
#line 610 "../src/shutdown-dialog.vala"
			_tmp9_ = self->priv->focused_filename;
#line 610 "../src/shutdown-dialog.vala"
			gtk_image_set_from_file (_tmp8_, _tmp9_);
#line 3203 "shutdown-dialog.c"
		}
	} else {
		GtkImage* _tmp10_;
		const gchar* _tmp11_;
#line 614 "../src/shutdown-dialog.vala"
		_tmp10_ = self->priv->i;
#line 614 "../src/shutdown-dialog.vala"
		_tmp11_ = self->priv->inactive_filename;
#line 614 "../src/shutdown-dialog.vala"
		gtk_image_set_from_file (_tmp10_, _tmp11_);
#line 3214 "shutdown-dialog.c"
	}
#line 617 "../src/shutdown-dialog.vala"
	_tmp12_ = self->priv->l;
#line 617 "../src/shutdown-dialog.vala"
	if (_tmp12_ != NULL) {
#line 3220 "shutdown-dialog.c"
		GtkLabel* _tmp13_;
#line 618 "../src/shutdown-dialog.vala"
		_tmp13_ = self->priv->l;
#line 618 "../src/shutdown-dialog.vala"
		gtk_widget_set_state_flags ((GtkWidget*) _tmp13_, new_flags, TRUE);
#line 3226 "shutdown-dialog.c"
	}
#line 620 "../src/shutdown-dialog.vala"
	GTK_WIDGET_CLASS (dialog_button_parent_class)->state_flags_changed ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), previous_state);
#line 3230 "shutdown-dialog.c"
}

static void
dialog_button_class_init (DialogButtonClass * klass,
                          gpointer klass_data)
{
#line 537 "../src/shutdown-dialog.vala"
	dialog_button_parent_class = g_type_class_peek_parent (klass);
#line 537 "../src/shutdown-dialog.vala"
	g_type_class_adjust_private_offset (klass, &DialogButton_private_offset);
#line 537 "../src/shutdown-dialog.vala"
	((GtkWidgetClass *) klass)->enter_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) dialog_button_real_enter_notify_event;
#line 537 "../src/shutdown-dialog.vala"
	((GtkWidgetClass *) klass)->leave_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) dialog_button_real_leave_notify_event;
#line 537 "../src/shutdown-dialog.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) dialog_button_real_draw;
#line 537 "../src/shutdown-dialog.vala"
	((GtkWidgetClass *) klass)->state_flags_changed = (void (*) (GtkWidget*, GtkStateFlags)) dialog_button_real_state_flags_changed;
#line 537 "../src/shutdown-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = dialog_button_finalize;
#line 3251 "shutdown-dialog.c"
}

static void
dialog_button_instance_init (DialogButton * self,
                             gpointer klass)
{
#line 537 "../src/shutdown-dialog.vala"
	self->priv = dialog_button_get_instance_private (self);
#line 3260 "shutdown-dialog.c"
}

static void
dialog_button_finalize (GObject * obj)
{
	DialogButton * self;
#line 537 "../src/shutdown-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIALOG_BUTTON, DialogButton);
#line 539 "../src/shutdown-dialog.vala"
	_g_free0 (self->priv->inactive_filename);
#line 540 "../src/shutdown-dialog.vala"
	_g_free0 (self->priv->focused_filename);
#line 541 "../src/shutdown-dialog.vala"
	_g_free0 (self->priv->active_filename);
#line 542 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->i);
#line 543 "../src/shutdown-dialog.vala"
	_g_object_unref0 (self->priv->l);
#line 537 "../src/shutdown-dialog.vala"
	G_OBJECT_CLASS (dialog_button_parent_class)->finalize (obj);
#line 3281 "shutdown-dialog.c"
}

static GType
dialog_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DialogButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dialog_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DialogButton), 0, (GInstanceInitFunc) dialog_button_instance_init, NULL };
	GType dialog_button_type_id;
	dialog_button_type_id = g_type_register_static (gtk_button_get_type (), "DialogButton", &g_define_type_info, 0);
	DialogButton_private_offset = g_type_add_instance_private (dialog_button_type_id, sizeof (DialogButtonPrivate));
	return dialog_button_type_id;
}

GType
dialog_button_get_type (void)
{
	static volatile gsize dialog_button_type_id__once = 0;
	if (g_once_init_enter (&dialog_button_type_id__once)) {
		GType dialog_button_type_id;
		dialog_button_type_id = dialog_button_get_type_once ();
		g_once_init_leave (&dialog_button_type_id__once, dialog_button_type_id);
	}
	return dialog_button_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

