/* Db.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Db.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN gchar* db_filename;
gchar* db_filename = NULL;

VALA_EXTERN DbVerifyResult db_upgrade_database (gint input_version);

void
db_preconfigure (GFile* db_file)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp3_;
	if (db_file != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_file_get_path (db_file);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (DB_IN_MEMORY_NAME);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (db_filename);
	db_filename = _tmp3_;
	_g_free0 (_tmp0_);
}

void
db_init (GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = db_filename;
	_vala_assert (_tmp0_ != NULL, "filename != null");
	_tmp1_ = db_filename;
	database_table_init (_tmp1_);
}

void
db_terminate (void)
{
	database_table_terminate ();
}

static GType
db_verify_result_get_type_once (void)
{
	static const GEnumValue values[] = {{DB_VERIFY_RESULT_OK, "DB_VERIFY_RESULT_OK", "ok"}, {DB_VERIFY_RESULT_FUTURE_VERSION, "DB_VERIFY_RESULT_FUTURE_VERSION", "future-version"}, {DB_VERIFY_RESULT_UPGRADE_ERROR, "DB_VERIFY_RESULT_UPGRADE_ERROR", "upgrade-error"}, {DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE, "DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE", "no-upgrade-available"}, {0, NULL, NULL}};
	GType db_verify_result_type_id;
	db_verify_result_type_id = g_enum_register_static ("DbVerifyResult", values);
	return db_verify_result_type_id;
}

GType
db_verify_result_get_type (void)
{
	static volatile gsize db_verify_result_type_id__once = 0;
	if (g_once_init_enter (&db_verify_result_type_id__once)) {
		GType db_verify_result_type_id;
		db_verify_result_type_id = db_verify_result_get_type_once ();
		g_once_init_leave (&db_verify_result_type_id__once, db_verify_result_type_id);
	}
	return db_verify_result_type_id__once;
}

DbVerifyResult
db_verify_database (gchar** app_version,
                    gint* schema_version)
{
	gchar* _vala_app_version = NULL;
	gint _vala_schema_version = 0;
	VersionTable* version_table = NULL;
	VersionTable* _tmp0_;
	VersionTable* _tmp1_;
	gchar* _tmp2_ = NULL;
	gint _tmp3_;
	DbVerifyResult result;
	_tmp0_ = version_table_get_instance ();
	version_table = _tmp0_;
	_tmp1_ = version_table;
	_tmp3_ = version_table_get_version (_tmp1_, &_tmp2_);
	_g_free0 (_vala_app_version);
	_vala_app_version = _tmp2_;
	_vala_schema_version = _tmp3_;
	if (_vala_schema_version >= 0) {
		const gchar* _tmp4_;
		_tmp4_ = _vala_app_version;
		g_debug ("Db.vala:53: Database schema version %d created by app version %s", _vala_schema_version, _tmp4_);
	}
	if (_vala_schema_version == -1) {
		VersionTable* _tmp5_;
		gchar* _tmp6_;
		g_debug ("Db.vala:57: Creating database schema version %d for app version %s", DATABASE_TABLE_SCHEMA_VERSION, RESOURCES_APP_VERSION);
		_tmp5_ = version_table;
		version_table_set_version (_tmp5_, DATABASE_TABLE_SCHEMA_VERSION, RESOURCES_APP_VERSION, NULL);
		_tmp6_ = g_strdup (RESOURCES_APP_VERSION);
		_g_free0 (_vala_app_version);
		_vala_app_version = _tmp6_;
		_vala_schema_version = DATABASE_TABLE_SCHEMA_VERSION;
	} else {
		if (_vala_schema_version > DATABASE_TABLE_SCHEMA_VERSION) {
			result = DB_VERIFY_RESULT_FUTURE_VERSION;
			_database_table_unref0 (version_table);
			if (app_version) {
				*app_version = _vala_app_version;
			} else {
				_g_free0 (_vala_app_version);
			}
			if (schema_version) {
				*schema_version = _vala_schema_version;
			}
			return result;
		} else {
			if (_vala_schema_version < DATABASE_TABLE_SCHEMA_VERSION) {
				DbVerifyResult _result_ = 0;
				_result_ = db_upgrade_database (_vala_schema_version);
				if (_result_ != DB_VERIFY_RESULT_OK) {
					result = _result_;
					_database_table_unref0 (version_table);
					if (app_version) {
						*app_version = _vala_app_version;
					} else {
						_g_free0 (_vala_app_version);
					}
					if (schema_version) {
						*schema_version = _vala_schema_version;
					}
					return result;
				}
			}
		}
	}
	result = DB_VERIFY_RESULT_OK;
	_database_table_unref0 (version_table);
	if (app_version) {
		*app_version = _vala_app_version;
	} else {
		_g_free0 (_vala_app_version);
	}
	if (schema_version) {
		*schema_version = _vala_schema_version;
	}
	return result;
}

DbVerifyResult
db_upgrade_database (gint input_version)
{
	gint version = 0;
	VersionTable* _tmp1_;
	VersionTable* _tmp2_;
	DbVerifyResult result;
	_vala_assert (input_version < DATABASE_TABLE_SCHEMA_VERSION, "input_version < DatabaseTable.SCHEMA_VERSION");
	if (!database_table_has_column ("EventTable", "comment")) {
		g_message ("Db.vala:84: upgrade_database: adding comment column to EventTable");
		if (!database_table_add_column ("EventTable", "comment", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 18;
	if (input_version < 19) {
		GApplication* _tmp0_;
		_tmp0_ = g_application_get_default ();
		photos_application_set_raw_thumbs_fix_required (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTOS_TYPE_APPLICATION, PhotosApplication), TRUE);
	}
	version = 19;
	version = 20;
	if (!database_table_has_column ("PhotoTable", "enhanced")) {
		g_message ("Db.vala:126: upgrade_database: adding enhanced column to PhotoTable");
		if (!database_table_add_column ("PhotoTable", "enhanced", "INTEGER DEFAULT 0")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	if (!database_table_has_column ("PhotoTable", "original_transforms")) {
		g_message ("Db.vala:132: upgrade_database: adding original_transforms column to Ph" \
"otoTable");
		if (!database_table_add_column ("PhotoTable", "original_transforms", "TEXT")) {
			result = DB_VERIFY_RESULT_UPGRADE_ERROR;
			return result;
		}
	}
	version = 21;
	_vala_assert (version == DATABASE_TABLE_SCHEMA_VERSION, "version == DatabaseTable.SCHEMA_VERSION");
	_tmp1_ = version_table_get_instance ();
	_tmp2_ = _tmp1_;
	version_table_update_version (_tmp2_, version, RESOURCES_APP_VERSION);
	_database_table_unref0 (_tmp2_);
	g_message ("Db.vala:141: Database upgrade to schema version %d successful", version);
	result = DB_VERIFY_RESULT_OK;
	return result;
}

