// Code generated by go-swagger; DO NOT EDIT.

package project_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProjectServiceGetProjectsCountReader is a Reader for the ProjectServiceGetProjectsCount structure.
type ProjectServiceGetProjectsCountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProjectServiceGetProjectsCountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProjectServiceGetProjectsCountOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProjectServiceGetProjectsCountDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProjectServiceGetProjectsCountOK creates a ProjectServiceGetProjectsCountOK with default headers values
func NewProjectServiceGetProjectsCountOK() *ProjectServiceGetProjectsCountOK {
	return &ProjectServiceGetProjectsCountOK{}
}

/*
ProjectServiceGetProjectsCountOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProjectServiceGetProjectsCountOK struct {
	Payload *models.HashicorpCloudResourcemanagerProjectGetProjectsCountResponse
}

// IsSuccess returns true when this project service get projects count o k response has a 2xx status code
func (o *ProjectServiceGetProjectsCountOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this project service get projects count o k response has a 3xx status code
func (o *ProjectServiceGetProjectsCountOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this project service get projects count o k response has a 4xx status code
func (o *ProjectServiceGetProjectsCountOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this project service get projects count o k response has a 5xx status code
func (o *ProjectServiceGetProjectsCountOK) IsServerError() bool {
	return false
}

// IsCode returns true when this project service get projects count o k response a status code equal to that given
func (o *ProjectServiceGetProjectsCountOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the project service get projects count o k response
func (o *ProjectServiceGetProjectsCountOK) Code() int {
	return 200
}

func (o *ProjectServiceGetProjectsCountOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/count][%d] projectServiceGetProjectsCountOK %s", 200, payload)
}

func (o *ProjectServiceGetProjectsCountOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/count][%d] projectServiceGetProjectsCountOK %s", 200, payload)
}

func (o *ProjectServiceGetProjectsCountOK) GetPayload() *models.HashicorpCloudResourcemanagerProjectGetProjectsCountResponse {
	return o.Payload
}

func (o *ProjectServiceGetProjectsCountOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerProjectGetProjectsCountResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProjectServiceGetProjectsCountDefault creates a ProjectServiceGetProjectsCountDefault with default headers values
func NewProjectServiceGetProjectsCountDefault(code int) *ProjectServiceGetProjectsCountDefault {
	return &ProjectServiceGetProjectsCountDefault{
		_statusCode: code,
	}
}

/*
ProjectServiceGetProjectsCountDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProjectServiceGetProjectsCountDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this project service get projects count default response has a 2xx status code
func (o *ProjectServiceGetProjectsCountDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this project service get projects count default response has a 3xx status code
func (o *ProjectServiceGetProjectsCountDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this project service get projects count default response has a 4xx status code
func (o *ProjectServiceGetProjectsCountDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this project service get projects count default response has a 5xx status code
func (o *ProjectServiceGetProjectsCountDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this project service get projects count default response a status code equal to that given
func (o *ProjectServiceGetProjectsCountDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the project service get projects count default response
func (o *ProjectServiceGetProjectsCountDefault) Code() int {
	return o._statusCode
}

func (o *ProjectServiceGetProjectsCountDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/count][%d] ProjectService_GetProjectsCount default %s", o._statusCode, payload)
}

func (o *ProjectServiceGetProjectsCountDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/count][%d] ProjectService_GetProjectsCount default %s", o._statusCode, payload)
}

func (o *ProjectServiceGetProjectsCountDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProjectServiceGetProjectsCountDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
