/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSTransitionEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CSSTransitionEvent::Init>> convertDictionary<CSSTransitionEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CSSTransitionEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue elapsedTimeValue;
    if (isNullOrUndefined)
        elapsedTimeValue = jsUndefined();
    else {
        elapsedTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "elapsedTime"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto elapsedTimeConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, elapsedTimeValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (elapsedTimeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.elapsedTime = elapsedTimeConversionResult.releaseReturnValue();
    JSValue propertyNameValue;
    if (isNullOrUndefined)
        propertyNameValue = jsUndefined();
    else {
        propertyNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "propertyName"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto propertyNameConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, propertyNameValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (propertyNameConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.propertyName = propertyNameConversionResult.releaseReturnValue();
    JSValue pseudoElementValue;
    if (isNullOrUndefined)
        pseudoElementValue = jsUndefined();
    else {
        pseudoElementValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pseudoElement"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto pseudoElementConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, pseudoElementValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (pseudoElementConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.pseudoElement = pseudoElementConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEvent_propertyName);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEvent_elapsedTime);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEvent_pseudoElement);

class JSCSSTransitionEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSTransitionEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSTransitionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSTransitionEventPrototype>(vm)) JSCSSTransitionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSTransitionEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSTransitionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSTransitionEventPrototype, JSCSSTransitionEventPrototype::Base);

using JSCSSTransitionEventDOMConstructor = JSDOMConstructor<JSCSSTransitionEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSTransitionEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSTransitionEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto transitionEventInitDictConversionResult = convert<IDLDictionary<CSSTransitionEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (transitionEventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = CSSTransitionEvent::create(typeConversionResult.releaseReturnValue(), transitionEventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSTransitionEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSTransitionEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSTransitionEventDOMConstructorConstruct, JSCSSTransitionEventDOMConstructor::construct);

template<> const ClassInfo JSCSSTransitionEventDOMConstructor::s_info = { "TransitionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransitionEventDOMConstructor) };

template<> JSValue JSCSSTransitionEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSCSSTransitionEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TransitionEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSTransitionEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSCSSTransitionEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEventConstructor, 0 } },
    HashTableValue { "propertyName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEvent_propertyName, 0 } },
    HashTableValue { "elapsedTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEvent_elapsedTime, 0 } },
    HashTableValue { "pseudoElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEvent_pseudoElement, 0 } },
};

const ClassInfo JSCSSTransitionEventPrototype::s_info = { "TransitionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransitionEventPrototype) };

void JSCSSTransitionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSTransitionEvent::info(), JSCSSTransitionEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSTransitionEvent::s_info = { "TransitionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransitionEvent) };

JSCSSTransitionEvent::JSCSSTransitionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSTransitionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSTransitionEvent> JSCSSTransitionEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSTransitionEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSTransitionEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSTransitionEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSTransitionEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSTransitionEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSTransitionEvent>(vm, globalObject);
}

JSValue JSCSSTransitionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSTransitionEventDOMConstructor, DOMConstructorID::CSSTransitionEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSTransitionEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSTransitionEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSTransitionEvent_propertyNameGetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransitionEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.propertyName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEvent_propertyName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransitionEvent>::get<jsCSSTransitionEvent_propertyNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSTransitionEvent_elapsedTimeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransitionEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.elapsedTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEvent_elapsedTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransitionEvent>::get<jsCSSTransitionEvent_elapsedTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSTransitionEvent_pseudoElementGetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransitionEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pseudoElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEvent_pseudoElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransitionEvent>::get<jsCSSTransitionEvent_pseudoElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSTransitionEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSTransitionEvent, UseCustomHeapCellType::No>(vm, "JSCSSTransitionEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSTransitionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSTransitionEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSTransitionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSTransitionEvent = std::forward<decltype(space)>(space); }
    );
}

void JSCSSTransitionEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSTransitionEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSTransitionEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18CSSTransitionEventE[]; }
#endif
template<std::same_as<CSSTransitionEvent> T>
static inline void verifyVTable(CSSTransitionEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSTransitionEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18CSSTransitionEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSTransitionEvent has subclasses. If CSSTransitionEvent has subclasses that get passed
        // to toJS() we currently require CSSTransitionEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSTransitionEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSTransitionEvent>(impl.ptr());
#endif
    return createWrapper<CSSTransitionEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSTransitionEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
