/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBindGroupLayoutEntry.h"

#include "JSDOMConvertNumbers.h"
#include "JSGPUBufferBindingLayout.h"
#include "JSGPUExternalTextureBindingLayout.h"
#include "JSGPUSamplerBindingLayout.h"
#include "JSGPUStorageTextureBindingLayout.h"
#include "JSGPUTextureBindingLayout.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUBindGroupLayoutEntry>> convertDictionary<GPUBindGroupLayoutEntry>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUBindGroupLayoutEntry result;
    JSValue bindingValue;
    if (isNullOrUndefined)
        bindingValue = jsUndefined();
    else {
        bindingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "binding"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (bindingValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "binding"_s, "GPUBindGroupLayoutEntry"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto bindingConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, bindingValue);
    if (bindingConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.binding = bindingConversionResult.releaseReturnValue();
    JSValue bufferValue;
    if (isNullOrUndefined)
        bufferValue = jsUndefined();
    else {
        bufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bufferValue.isUndefined()) {
        auto bufferConversionResult = convert<IDLDictionary<GPUBufferBindingLayout>>(lexicalGlobalObject, bufferValue);
        if (bufferConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.buffer = bufferConversionResult.releaseReturnValue();
    }
    JSValue externalTextureValue;
    if (isNullOrUndefined)
        externalTextureValue = jsUndefined();
    else {
        externalTextureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "externalTexture"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!externalTextureValue.isUndefined()) {
        auto externalTextureConversionResult = convert<IDLDictionary<GPUExternalTextureBindingLayout>>(lexicalGlobalObject, externalTextureValue);
        if (externalTextureConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.externalTexture = externalTextureConversionResult.releaseReturnValue();
    }
    JSValue samplerValue;
    if (isNullOrUndefined)
        samplerValue = jsUndefined();
    else {
        samplerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampler"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!samplerValue.isUndefined()) {
        auto samplerConversionResult = convert<IDLDictionary<GPUSamplerBindingLayout>>(lexicalGlobalObject, samplerValue);
        if (samplerConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.sampler = samplerConversionResult.releaseReturnValue();
    }
    JSValue storageTextureValue;
    if (isNullOrUndefined)
        storageTextureValue = jsUndefined();
    else {
        storageTextureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storageTexture"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!storageTextureValue.isUndefined()) {
        auto storageTextureConversionResult = convert<IDLDictionary<GPUStorageTextureBindingLayout>>(lexicalGlobalObject, storageTextureValue);
        if (storageTextureConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.storageTexture = storageTextureConversionResult.releaseReturnValue();
    }
    JSValue textureValue;
    if (isNullOrUndefined)
        textureValue = jsUndefined();
    else {
        textureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "texture"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!textureValue.isUndefined()) {
        auto textureConversionResult = convert<IDLDictionary<GPUTextureBindingLayout>>(lexicalGlobalObject, textureValue);
        if (textureConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.texture = textureConversionResult.releaseReturnValue();
    }
    JSValue visibilityValue;
    if (isNullOrUndefined)
        visibilityValue = jsUndefined();
    else {
        visibilityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "visibility"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (visibilityValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "visibility"_s, "GPUBindGroupLayoutEntry"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto visibilityConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, visibilityValue);
    if (visibilityConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.visibility = visibilityConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

