/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSOptionalEffectTiming.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSFillMode.h"
#include "JSPlaybackDirection.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<OptionalEffectTiming>> convertDictionary<OptionalEffectTiming>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    OptionalEffectTiming result;
    JSValue delayValue;
    if (isNullOrUndefined)
        delayValue = jsUndefined();
    else {
        delayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delay"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!delayValue.isUndefined()) {
        auto delayConversionResult = convert<IDLDouble>(lexicalGlobalObject, delayValue);
        if (delayConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.delay = delayConversionResult.releaseReturnValue();
    }
    JSValue directionValue;
    if (isNullOrUndefined)
        directionValue = jsUndefined();
    else {
        directionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "direction"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!directionValue.isUndefined()) {
        auto directionConversionResult = convert<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, directionValue);
        if (directionConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.direction = directionConversionResult.releaseReturnValue();
    }
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!durationValue.isUndefined()) {
        auto durationConversionResult = convert<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, durationValue);
        if (durationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.duration = durationConversionResult.releaseReturnValue();
    }
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!easingValue.isUndefined()) {
        auto easingConversionResult = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        if (easingConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.easing = easingConversionResult.releaseReturnValue();
    }
    JSValue endDelayValue;
    if (isNullOrUndefined)
        endDelayValue = jsUndefined();
    else {
        endDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endDelay"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!endDelayValue.isUndefined()) {
        auto endDelayConversionResult = convert<IDLDouble>(lexicalGlobalObject, endDelayValue);
        if (endDelayConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.endDelay = endDelayConversionResult.releaseReturnValue();
    }
    JSValue fillValue;
    if (isNullOrUndefined)
        fillValue = jsUndefined();
    else {
        fillValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fill"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!fillValue.isUndefined()) {
        auto fillConversionResult = convert<IDLEnumeration<FillMode>>(lexicalGlobalObject, fillValue);
        if (fillConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.fill = fillConversionResult.releaseReturnValue();
    }
    JSValue iterationStartValue;
    if (isNullOrUndefined)
        iterationStartValue = jsUndefined();
    else {
        iterationStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterationStart"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!iterationStartValue.isUndefined()) {
        auto iterationStartConversionResult = convert<IDLDouble>(lexicalGlobalObject, iterationStartValue);
        if (iterationStartConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.iterationStart = iterationStartConversionResult.releaseReturnValue();
    }
    JSValue iterationsValue;
    if (isNullOrUndefined)
        iterationsValue = jsUndefined();
    else {
        iterationsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterations"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!iterationsValue.isUndefined()) {
        auto iterationsConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, iterationsValue);
        if (iterationsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.iterations = iterationsConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

