/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUVertexState.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUShaderModule.h"
#include "JSGPUVertexBufferLayout.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Vector.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUVertexState>> convertDictionary<GPUVertexState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUVertexState result;
    JSValue constantsValue;
    if (isNullOrUndefined)
        constantsValue = jsUndefined();
    else {
        constantsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "constants"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!constantsValue.isUndefined()) {
        auto constantsConversionResult = convert<IDLRecord<IDLUSVString, IDLDouble>>(lexicalGlobalObject, constantsValue);
        if (constantsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.constants = constantsConversionResult.releaseReturnValue();
    }
    JSValue entryPointValue;
    if (isNullOrUndefined)
        entryPointValue = jsUndefined();
    else {
        entryPointValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "entryPoint"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!entryPointValue.isUndefined()) {
        auto entryPointConversionResult = convert<IDLUSVString>(lexicalGlobalObject, entryPointValue);
        if (entryPointConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.entryPoint = entryPointConversionResult.releaseReturnValue();
    }
    JSValue moduleValue;
    if (isNullOrUndefined)
        moduleValue = jsUndefined();
    else {
        moduleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "module"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (moduleValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "module"_s, "GPUVertexState"_s, "GPUShaderModule"_s);
        return ConversionResultException { };
    }
    auto moduleConversionResult = convert<IDLInterface<GPUShaderModule>>(lexicalGlobalObject, moduleValue);
    if (moduleConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.module = moduleConversionResult.releaseReturnValue();
    JSValue buffersValue;
    if (isNullOrUndefined)
        buffersValue = jsUndefined();
    else {
        buffersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffers"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto buffersConversionResult = convertOptionalWithDefault<IDLSequence<IDLNullable<IDLDictionary<GPUVertexBufferLayout>>>>(lexicalGlobalObject, buffersValue, [&]() -> ConversionResult<IDLSequence<IDLNullable<IDLDictionary<GPUVertexBufferLayout>>>> { return Converter<IDLSequence<IDLNullable<IDLDictionary<GPUVertexBufferLayout>>>>::ReturnType { }; });
    if (buffersConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.buffers = buffersConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

