﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DeleteTrafficMirrorFilterRuleResponse {
 public:
  AWS_EC2_API DeleteTrafficMirrorFilterRuleResponse() = default;
  AWS_EC2_API DeleteTrafficMirrorFilterRuleResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DeleteTrafficMirrorFilterRuleResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The ID of the deleted Traffic Mirror rule.</p>
   */
  inline const Aws::String& GetTrafficMirrorFilterRuleId() const { return m_trafficMirrorFilterRuleId; }
  template <typename TrafficMirrorFilterRuleIdT = Aws::String>
  void SetTrafficMirrorFilterRuleId(TrafficMirrorFilterRuleIdT&& value) {
    m_trafficMirrorFilterRuleIdHasBeenSet = true;
    m_trafficMirrorFilterRuleId = std::forward<TrafficMirrorFilterRuleIdT>(value);
  }
  template <typename TrafficMirrorFilterRuleIdT = Aws::String>
  DeleteTrafficMirrorFilterRuleResponse& WithTrafficMirrorFilterRuleId(TrafficMirrorFilterRuleIdT&& value) {
    SetTrafficMirrorFilterRuleId(std::forward<TrafficMirrorFilterRuleIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DeleteTrafficMirrorFilterRuleResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_trafficMirrorFilterRuleId;
  bool m_trafficMirrorFilterRuleIdHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
